/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.service.impl;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipRole;
import org.kuali.coeus.common.committee.impl.bo.CommitteeResearchAreaBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.committee.dao.CustomCommitteeDao;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionLiteBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class CommitteeServiceImplBase<CMT extends CommitteeBase<CMT, ?, CS>, CS extends CommitteeScheduleBase<CS, CMT, PS, CSM>, PS extends ProtocolSubmissionLiteBase, CSM extends CommitteeScheduleMinuteBase<CSM, CS>>
implements CommitteeServiceBase<CMT, CS> {
    private static final String COMMITTEE_ID = "committeeId";
    private static final String NO_PLACE = "[no location]";
    private static final int SCHEDULED = 1;
    private static final String COMMITTEE_DOCUMENT_STATUS_CODE = "committeeDocument.docStatusCode";
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private CustomCommitteeDao customCommitteeDao;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public VersioningService getVersioningService() {
        if (this.versioningService == null) {
            this.versioningService = KcServiceLocator.getService(VersioningService.class);
        }
        return this.versioningService;
    }

    @Override
    public CMT getCommitteeById(String committeeId) {
        CommitteeBase committee = null;
        if (!StringUtils.isBlank((CharSequence)committeeId)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(COMMITTEE_ID, committeeId);
            fieldValues.put(COMMITTEE_DOCUMENT_STATUS_CODE, "F");
            Collection committees = this.businessObjectService.findMatching(this.getCommitteeBOClassHook(), fieldValues);
            if (committees.size() > 0) {
                committee = (CommitteeBase)Collections.max(committees);
            }
        }
        return (CMT)committee;
    }

    protected abstract Class<CMT> getCommitteeBOClassHook();

    @Override
    public void addResearchAreas(CMT committee, Collection<ResearchAreaBase> researchAreas) {
        for (ResearchAreaBase researchArea : researchAreas) {
            if (this.hasResearchArea(committee, researchArea)) continue;
            this.addCommitteeResearchArea(committee, researchArea);
        }
    }

    protected boolean hasResearchArea(CMT committee, ResearchAreaBase researchArea) {
        for (CommitteeResearchAreaBase committeeResearchArea : ((CommitteeBase)committee).getCommitteeResearchAreas()) {
            if (!StringUtils.equals((CharSequence)committeeResearchArea.getResearchAreaCode(), (CharSequence)researchArea.getResearchAreaCode())) continue;
            return true;
        }
        return false;
    }

    protected void addCommitteeResearchArea(CMT committee, ResearchAreaBase researchArea) {
        CommitteeResearchAreaBase committeeResearchArea = this.getNewCommitteeResearchAreaInstanceHook();
        committeeResearchArea.setCommittee((CommitteeBase)committee);
        committeeResearchArea.setCommitteeIdFk(((CommitteeBase)committee).getId());
        committeeResearchArea.setResearchArea(researchArea);
        committeeResearchArea.setResearchAreaCode(researchArea.getResearchAreaCode());
        ((CommitteeBase)committee).getCommitteeResearchAreas().add(committeeResearchArea);
    }

    protected abstract CommitteeResearchAreaBase getNewCommitteeResearchAreaInstanceHook();

    @Override
    public List<KeyValue> getAvailableCommitteeDates(String committeeId) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        CMT committee = this.getCommitteeById(committeeId);
        if (committee != null) {
            List schedules = ((CommitteeBase)committee).getCommitteeSchedules();
            Collections.sort(schedules);
            for (CommitteeScheduleBase schedule : schedules) {
                if (!this.isOkayToScheduleReview(committee, schedule)) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(schedule.getScheduleId(), this.getDescription(schedule)));
            }
        }
        return keyValues;
    }

    protected boolean isOkayToScheduleReview(CMT committee, CS schedule) {
        Calendar now = this.getCalendar(new java.util.Date());
        boolean dateRangeOK = now.compareTo(this.getCalendar(((CommitteeScheduleBase)schedule).getProtocolSubDeadline())) <= 0;
        boolean statusOK = Integer.valueOf(1).equals(((CommitteeScheduleBase)schedule).getScheduleStatusCode());
        return dateRangeOK && statusOK;
    }

    protected Calendar getCalendar(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected String getDescription(CS schedule) {
        Date date = ((CommitteeScheduleBase)schedule).getScheduledDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        StringBuffer sb = new StringBuffer(dateFormat.format(date));
        sb.append(", ");
        if (((CommitteeScheduleBase)schedule).getPlace() == null) {
            sb.append(NO_PLACE);
        } else {
            sb.append(((CommitteeScheduleBase)schedule).getPlace());
        }
        sb.append(", ").append(timeFormat.format(((CommitteeScheduleBase)schedule).getActualTime()));
        return sb.toString();
    }

    @Override
    public List<CommitteeMembershipBase> getAvailableMembers(String committeeId, String scheduleId) {
        CS schedule;
        if (StringUtils.isBlank((CharSequence)scheduleId)) {
            return this.getAvailableMembersNow(committeeId);
        }
        ArrayList<CommitteeMembershipBase> availableMembers = new ArrayList<CommitteeMembershipBase>();
        CMT committee = this.getCommitteeById(committeeId);
        if (committee != null && (schedule = this.getCommitteeSchedule(committee, scheduleId)) != null) {
            List<CommitteeMembershipBase> members = ((CommitteeBase)committee).getCommitteeMemberships();
            for (CommitteeMembershipBase member : members) {
                if (!this.isMemberAvailable(member, ((CommitteeScheduleBase)schedule).getScheduledDate())) continue;
                availableMembers.add(member);
            }
        }
        return availableMembers;
    }

    public List<CommitteeMembershipBase> getAvailableMembersNow(String committeeId) {
        ArrayList<CommitteeMembershipBase> availableMembers = new ArrayList<CommitteeMembershipBase>();
        CMT committee = this.getCommitteeById(committeeId);
        if (committee != null) {
            List<CommitteeMembershipBase> members = ((CommitteeBase)committee).getCommitteeMemberships();
            java.util.Date currentDate = new java.util.Date();
            for (CommitteeMembershipBase member : members) {
                if (!this.isMemberAvailable(member, currentDate)) continue;
                availableMembers.add(member);
            }
        }
        return availableMembers;
    }

    protected boolean isMemberAvailable(CommitteeMembershipBase member, java.util.Date scheduledDate) {
        Date sqlDate = new Date(scheduledDate.getTime());
        if (member.isActive(sqlDate)) {
            Calendar scheduleCalendar = this.getCalendar(scheduledDate);
            List<CommitteeMembershipRole> roles = member.getMembershipRoles();
            for (CommitteeMembershipRole role : roles) {
                Calendar startCalendar = this.getCalendar(role.getStartDate());
                Calendar endCalendar = this.getCalendar(role.getEndDate());
                if (scheduleCalendar.compareTo(startCalendar) < 0 || scheduleCalendar.compareTo(endCalendar) > 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CS getCommitteeSchedule(CMT committee, String scheduleId) {
        return ((CommitteeBase)committee).getCommitteeSchedule(scheduleId);
    }

    @Override
    public List<CS> mergeCommitteeSchedule(CMT committee) {
        CMT newCommittee = committee;
        CMT oldCommittee = this.getCommitteeById(((CommitteeBase)committee).getCommitteeId());
        List<Object> newMasterSchedules = new ArrayList();
        List oldMasterSchedules = ((CommitteeBase)oldCommittee).getCommitteeSchedules();
        List newSchedules = ((CommitteeBase)newCommittee).getCommitteeSchedules();
        if (CollectionUtils.isNotEmpty(newSchedules) || CollectionUtils.isNotEmpty(oldMasterSchedules)) {
            newMasterSchedules = this.createNewMasterScheduleList(newSchedules, oldMasterSchedules);
            this.getBusinessObjectService().delete(oldMasterSchedules);
            this.getBusinessObjectService().delete(newSchedules);
        }
        return newMasterSchedules;
    }

    protected List<CS> createNewMasterScheduleList(List<CS> newSchedules, List<CS> oldSchedules) {
        ArrayList<CommitteeScheduleBase> masterSchedules = new ArrayList<CommitteeScheduleBase>();
        ArrayList<CS> newSchedulesCopy = new ArrayList<CS>(newSchedules);
        ArrayList<CS> oldSchedulesCopy = new ArrayList<CS>(oldSchedules);
        for (CommitteeScheduleBase oldSchedule : oldSchedulesCopy) {
            CommitteeScheduleBase newCommitteeVersionOfOldSchedule = this.getNewCommitteeSchedule(oldSchedule, newSchedules);
            if (!oldSchedule.hasMeetingData() && newCommitteeVersionOfOldSchedule == null) continue;
            if (newCommitteeVersionOfOldSchedule != null) {
                oldSchedule.copyLightDataFrom(newCommitteeVersionOfOldSchedule);
            }
            masterSchedules.add(oldSchedule);
            oldSchedules.remove(oldSchedule);
        }
        for (CommitteeScheduleBase newSchedule : newSchedulesCopy) {
            if (this.isScheduleDateMatched(newSchedule, masterSchedules)) continue;
            masterSchedules.add(newSchedule);
            newSchedules.remove(newSchedule);
        }
        return masterSchedules;
    }

    protected boolean isScheduleDateMatched(CS schedule, List<CS> schedules) {
        for (CommitteeScheduleBase copiedSchedule : schedules) {
            if (!((CommitteeScheduleBase)schedule).getScheduledDate().equals(copiedSchedule.getScheduledDate())) continue;
            return true;
        }
        return false;
    }

    protected CS getNewCommitteeSchedule(CS schedule, List<CS> schedules) {
        for (CommitteeScheduleBase newSchedule : schedules) {
            if (!StringUtils.equals((CharSequence)newSchedule.getScheduleId(), (CharSequence)((CommitteeScheduleBase)schedule).getScheduleId())) continue;
            return (CS)newSchedule;
        }
        return null;
    }

    @Override
    public void updateCommitteeForProtocolSubmissions(CMT committee) {
        this.getCustomCommitteeDao().updateSubmissionsToNewCommitteeVersion((CommitteeBase<?, ?, ? extends CommitteeScheduleBase>)committee, ((CommitteeBase)committee).getCommitteeSchedules());
    }

    @Override
    public CMT getLightVersion(String committeeId) throws Exception {
        CMT committee = this.getCommitteeById(committeeId);
        ((CommitteeBase)committee).setCommitteeDocument(null);
        for (CommitteeScheduleBase committeeSchedule : ((CommitteeBase)committee).getCommitteeSchedules()) {
            committeeSchedule.nullifyHeavyMeetingData();
        }
        return (CMT)((CommitteeBase)this.getVersioningService().createNewVersion(committee));
    }

    public CustomCommitteeDao getCustomCommitteeDao() {
        if (this.customCommitteeDao == null) {
            this.customCommitteeDao = KcServiceLocator.getService(CustomCommitteeDao.class);
        }
        return this.customCommitteeDao;
    }

    public void setCustomCommitteeDao(CustomCommitteeDao customCommitteeDao) {
        this.customCommitteeDao = customCommitteeDao;
    }
}

