/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.unit.sync;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;

public class UnitRole
implements BusinessObject {
    private String id;
    private String namespaceCode;
    private String name;
    private String description;
    private String kimTypeId;
    private boolean active;
    private transient DataObjectService dataObjectService;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String kimTypeId) {
        this.kimTypeId = kimTypeId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isUnitHierarchy() {
        return "10001".equals(this.getKimTypeId());
    }

    public void refresh() {
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            RoleBoLite bo = (RoleBoLite)this.getDataObjectService().find(RoleBoLite.class, (Object)this.id);
            if (bo != null) {
                this.id = bo.getId();
                this.namespaceCode = bo.getNamespaceCode();
                this.name = bo.getName();
                this.description = bo.getDescription();
                this.kimTypeId = bo.getKimTypeId();
                this.active = bo.isActive();
            } else {
                this.namespaceCode = null;
                this.name = null;
                this.description = null;
                this.kimTypeId = null;
                this.active = false;
            }
        }
    }

    public static UnitRole fromRoleBoLite(RoleBoLite role) {
        UnitRole unitRole = new UnitRole();
        unitRole.setId(role.getId());
        unitRole.setNamespaceCode(role.getNamespaceCode());
        unitRole.setName(role.getName());
        unitRole.setDescription(role.getDescription());
        unitRole.setKimTypeId(role.getKimTypeId());
        unitRole.setActive(role.isActive());
        return unitRole;
    }

    public String toString() {
        return "UnitRole{id='" + this.id + "', namespaceCode='" + this.namespaceCode + "', name='" + this.name + "', description='" + this.description + "', kimTypeId='" + this.kimTypeId + "', active=" + this.active + "}";
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

