/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.framework.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.common.questionnaire.framework.print.CorrespondencePrint;
import org.kuali.coeus.common.questionnaire.framework.print.CorrespondencePrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.print.CorrespondencePrintOption;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class CorrespondencePrintingServiceImpl
implements CorrespondencePrintingService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    @Autowired
    @Qualifier(value="printingService")
    private PrintingService printingService;
    private AbstractPrint correspondencePrint;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    protected ProtocolCorrespondence getCorrespondence(Long correspondenceId) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("correspondenceId", correspondenceId);
        return (ProtocolCorrespondence)this.businessObjectService.findByPrimaryKey(ProtocolCorrespondence.class, pkMap);
    }

    @Override
    public List<Printable> getCorrespondencePrintable(KcPersistableBusinessObjectBase printableBusinessObject, List<CorrespondencePrintOption> correspondenceToPrint) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        for (CorrespondencePrintOption printOption : correspondenceToPrint) {
            if (!printOption.isSelected()) continue;
            CorrespondencePrint printable = new CorrespondencePrint();
            printable.setXmlStream(this.getCorrespondencePrint().getXmlStream());
            HashMap<String, Object> reportParameters = new HashMap<String, Object>();
            if (printOption.getScheduleId() != null) {
                reportParameters.put("scheduleId", printOption.getScheduleId());
            }
            reportParameters.put("correspondenceId", "1");
            if (ObjectUtils.isNotNull((Object)printOption.getProtocolCorrespondenceTemplate())) {
                reportParameters.put("template", printOption.getProtocolCorrespondenceTemplate().getCorrespondenceTemplate());
            }
            reportParameters.put("moduleSubItemCode", printOption.getSubItemCode());
            if ("2".equals(printOption.getSubItemCode())) {
                reportParameters.put(PROTOCOL_NUMBER, printOption.getItemKey());
                reportParameters.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            }
            if (printable == null) continue;
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            printables.add(printable);
        }
        return printables;
    }

    protected ProtocolBase getProtocolPrintable(CorrespondencePrintOption printOption) {
        if ("2".equals(printOption.getSubItemCode())) {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
            keyValues.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            return ((ProtocolSubmissionBase)((List)this.businessObjectService.findMatchingOrderBy(this.getProtocolSubmissionBOClassHook(), keyValues, "submissionId", false)).get(0)).getProtocol();
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
        keyValues.put("sequenceNumber", printOption.getSubItemKey());
        return (ProtocolBase)((List)this.businessObjectService.findMatching(this.getProtocolBOClassHook(), keyValues)).get(0);
    }

    public AbstractPrint getCorrespondencePrint() {
        return this.correspondencePrint;
    }

    public void setCorrespondencePrint(AbstractPrint correspondencePrint) {
        this.correspondencePrint = correspondencePrint;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();
}

