/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.notification;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionQualifierType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.notification.IRBReplacementParameters;
import org.kuali.kra.protocol.notification.ProtocolNotificationRendererBase;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IRBNotificationRenderer
extends ProtocolNotificationRendererBase {
    private static final long serialVersionUID = 7966684994606021231L;
    private static final String D_MMM_YYYY = "d'-'MMM'-'yyyy";
    private static final String PROTOCOL_ACTION_TYPE_CODE = "protocolActionTypeCode";
    private static final String SUBMISSION_TYPE_CODE = "submissionTypeCode";
    private static final String SUBMISSION_QUALIFIER_TYPE_CODE = "submissionQualifierTypeCode";
    private static final String REVIEW_TYPE_CODE = "reviewTypeCode";
    private Protocol protocol;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public IRBNotificationRenderer(Protocol protocol) {
        super(protocol);
        this.protocol = protocol;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = IRBReplacementParameters.REPLACEMENT_PARAMETERS;
        Map<String, String> params = super.getDefaultReplacementParameters();
        for (String key : replacementParameters) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_NUMBER}")) {
                params.put(key, this.protocol.getProtocolNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PI_NAME}")) {
                params.put(key, this.protocol.getPrincipalInvestigator().getFullName());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LEAD_UNIT}")) {
                params.put(key, this.protocol.getLeadUnitNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LEAD_UNIT_NAME}")) {
                params.put(key, this.protocol.getLeadUnitName());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_STATUS_CODE}")) {
                params.put(key, this.protocol.getProtocolStatusCode());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_STATUS_DESCRIPTION}")) {
                params.put(key, this.protocol.getProtocolStatus().getDescription());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_ACTION_NAME}")) {
                if (this.protocol.getLastProtocolAction() != null) {
                    params.put(key, this.getProtocolLastActionName(this.protocol.getLastProtocolAction().getProtocolActionTypeCode()));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_ACTION_TYPE_CODE}")) {
                if (this.protocol.getLastProtocolAction() != null) {
                    params.put(key, this.protocol.getLastProtocolAction().getProtocolActionTypeCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_SUBMISSION_NAME}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.getProtocolSubmissionName(this.protocol.getProtocolSubmission().getSubmissionTypeCode()));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_SUBMISSION_TYPE_CODE}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_SUBMISSION_TYPE_QUAL_CODE}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeQualifierCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_SUBMISSION_TYPE_QUAL_NAME}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.getLastSubmissionTypeQualifierName(this.protocol.getProtocolSubmission().getSubmissionTypeQualifierCode()));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_TITLE}")) {
                params.put(key, this.protocol.getTitle());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_TYPE_CODE}")) {
                params.put(key, this.protocol.getProtocolTypeCode());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_TYPE_DESCRIPTION}")) {
                if (this.protocol.getProtocolType() != null) {
                    params.put(key, this.protocol.getProtocolType().getDescription());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.protocol.getSequenceNumber().toString());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SUBMISSION_STATUS_CODE}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.protocol.getProtocolSubmission().getSubmissionStatusCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SUBMISSION_STATUS_NAME}")) {
                params.put(key, this.protocol.getProtocolSubmissionStatus());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{DOCUMENT_NUMBER}")) {
                params.put(key, this.protocol.getProtocolDocument().getDocumentNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_REVIEW_TYPE_DESC}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.getSafeMessage(key, this.getProtocolReviewTypeDescription(this.protocol.getProtocolSubmission().getProtocolReviewTypeCode())));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_INITIAL_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() != null && this.protocol.getApprovalDate() != null) {
                    params.put(key, this.getSafeMessage(key, new SimpleDateFormat(D_MMM_YYYY).format(this.protocol.getApprovalDate())));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_LAST_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() != null && this.protocol.getLastApprovalDate() != null) {
                    params.put(key, this.getSafeMessage(key, new SimpleDateFormat(D_MMM_YYYY).format(this.protocol.getLastApprovalDate())));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_EXPIRATION_DATE}")) continue;
            if (this.protocol.getProtocolSubmission() != null && this.protocol.getExpirationDate() != null) {
                params.put(key, this.getSafeMessage(key, new SimpleDateFormat(D_MMM_YYYY).format(this.protocol.getExpirationDate())));
                continue;
            }
            params.put(key, "");
        }
        return params;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KNSServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    private String getProtocolLastActionName(String lastActionTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PROTOCOL_ACTION_TYPE_CODE, lastActionTypeCode);
        List actionTypes = (List)this.getBusinessObjectService().findMatching(ProtocolActionType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)actionTypes)) {
            result = ((ProtocolActionType)actionTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getProtocolSubmissionName(String submissionTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_TYPE_CODE, submissionTypeCode);
        List submissionTypes = (List)this.getBusinessObjectService().findMatching(ProtocolSubmissionType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)submissionTypes)) {
            result = ((ProtocolSubmissionType)submissionTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getLastSubmissionTypeQualifierName(String submissionQualifierTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_QUALIFIER_TYPE_CODE, submissionQualifierTypeCode);
        List submissionQualifierTypes = (List)this.getBusinessObjectService().findMatching(ProtocolSubmissionQualifierType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)submissionQualifierTypes)) {
            result = ((ProtocolSubmissionQualifierType)submissionQualifierTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getProtocolReviewTypeDescription(String reviewTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(REVIEW_TYPE_CODE, reviewTypeCode);
        List protocolReviewTypes = (List)this.getBusinessObjectService().findMatching(ProtocolReviewType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)protocolReviewTypes)) {
            result = ((ProtocolReviewType)protocolReviewTypes.get(0)).getDescription();
        }
        return result;
    }

    @Override
    protected Class<? extends CommitteeBase> getCommonCommitteeBOClassHook() {
        return Committee.class;
    }
}

