/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.protocol.ProtocolAuthorizationService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class ProtocolAuthorizationServiceImpl
implements ProtocolAuthorizationService {
    private KcAuthorizationService kcAuthorizationService;
    private IdentityService identityService;

    @Override
    public List<RolePersons> getAllRolePersons(Permissionable permissionable) {
        ArrayList<RolePersons> rolePersonsList = new ArrayList<RolePersons>();
        if (permissionable != null) {
            List<String> roleNames = permissionable.getRoleNames();
            for (String roleName : roleNames) {
                List<String> usernames = this.toUserNames(this.kcAuthorizationService.getPrincipalsInRole(roleName, permissionable));
                RolePersons rolePersons = new RolePersons();
                rolePersonsList.add(rolePersons);
                if (roleName.contains("Aggregator")) {
                    rolePersons.setAggregator(usernames);
                    continue;
                }
                if (roleName.contains("Viewer")) {
                    rolePersons.setViewer(usernames);
                    continue;
                }
                if (roleName.contains("Narrative Writer")) {
                    rolePersons.setNarrativewriter(usernames);
                    continue;
                }
                if (!roleName.contains("Budget Creator")) continue;
                rolePersons.setBudgetcreator(usernames);
            }
        }
        return rolePersonsList;
    }

    protected List<String> toUserNames(List<String> principalIds) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (String id : principalIds) {
            Principal p = this.identityService.getPrincipal(id);
            if (p == null) continue;
            userNames.add(p.getPrincipalName());
        }
        return userNames;
    }

    public KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

