/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.security.Signature;
import java.security.cert.Certificate;
import org.apache.commons.codec.binary.Base64;
import org.kuali.rice.ksb.security.DigitalSigner;

public abstract class AbstractDigitalSigner
implements DigitalSigner {
    private Signature signature;

    public AbstractDigitalSigner(Signature signature) {
        this.signature = signature;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    protected byte[] getSignatureBytes() throws Exception {
        return this.getSignature().sign();
    }

    protected String getEncodedSignature() throws Exception {
        return new String(Base64.encodeBase64((byte[])this.getSignatureBytes()), "UTF-8");
    }

    protected String getEncodedCertificate(Certificate certificate) throws Exception {
        return new String(Base64.encodeBase64((byte[])certificate.getEncoded()), "UTF-8");
    }
}

