/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.DateSortable;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.GreaterThan;
import org.kuali.coeus.common.budget.framework.query.operator.LesserThan;
import org.kuali.coeus.common.budget.framework.query.operator.Operator;
import org.kuali.coeus.common.budget.framework.query.operator.Or;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.common.budget.impl.calculator.Boundary;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class SalaryCalculator {
    private static final Logger LOG = LogManager.getLogger(SalaryCalculator.class);
    private static final String STRING_1 = "1";
    private static final ScaleTwoDecimal DEFAULT_WORKING_MONTHS = new ScaleTwoDecimal(12);
    private static final String APPOINTMENT_TYPE = "appointmentType";
    private final Budget budget;
    private final BudgetPersonnelDetails personnelLineItem;
    private java.util.Date startDate;
    private java.util.Date endDate;
    private QueryList<BudgetRate> inflationRates;
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;

    public SalaryCalculator(Budget budget, BudgetPersonnelDetails personnelLineItem) {
        this.budget = budget;
        this.personnelLineItem = personnelLineItem;
        this.startDate = personnelLineItem.getStartDate();
        this.endDate = personnelLineItem.getEndDate();
    }

    public void calculate() {
        Boundary boundary = new Boundary(this.personnelLineItem.getStartDate(), this.personnelLineItem.getEndDate());
        this.calculate(boundary);
        this.personnelLineItem.setSalaryRequested(boundary.getApplicableCost());
        this.personnelLineItem.setCostSharingAmount(boundary.getApplicableCostSharing());
        this.personnelLineItem.setCostSharingPercent(this.calculateCostSharingPercentage());
    }

    final void calculate(Boundary boundary) {
        this.startDate = boundary.getStartDate();
        this.endDate = boundary.getEndDate();
        ScaleTwoDecimal totalSalary = ScaleTwoDecimal.ZERO;
        QueryList<SalaryDetails> brkupSalaryDetails = this.createSalBreakupIntervals();
        for (SalaryDetails salaryDetails : brkupSalaryDetails) {
            this.startDate = salaryDetails.getBoundary().getStartDate();
            this.endDate = salaryDetails.getBoundary().getEndDate();
            totalSalary = (ScaleTwoDecimal)totalSalary.add((AbstractDecimal)salaryDetails.calculateSalary(this.startDate, this.endDate));
        }
        ScaleTwoDecimal charged = this.personnelLineItem.getPercentCharged();
        ScaleTwoDecimal costSharing = (ScaleTwoDecimal)totalSalary.percentage((AbstractDecimal)this.calculateCostSharingPercentage());
        ScaleTwoDecimal requestedSalary = (ScaleTwoDecimal)totalSalary.percentage((AbstractDecimal)charged);
        boundary.setApplicableCost(requestedSalary);
        boundary.setApplicableCostSharing(costSharing);
    }

    protected QueryList<BudgetRate> filterInflationRates(CostElement costElement, boolean applyInflationRate) {
        ValidCeRateType inflationRateType = costElement.getValidCeRateTypes().stream().filter(t -> t.getRateClassType().equals(RateClassType.INFLATION.getRateClassType())).findFirst().orElse(null);
        if (applyInflationRate && inflationRateType != null) {
            Predicate<BudgetRate> dateAndRateAndOnOffCampusFlag = budgetRate -> {
                boolean iInflationRCEquals = StringUtils.equals((CharSequence)inflationRateType.getRateClassCode(), (CharSequence)budgetRate.getRateClassCode());
                boolean iInflationRTEquals = StringUtils.equals((CharSequence)inflationRateType.getRateTypeCode(), (CharSequence)budgetRate.getRateTypeCode());
                boolean startDateLtEqualsEndDate = Objects.compare(budgetRate.getStartDate(), this.endDate, Comparator.naturalOrder()) <= 0;
                boolean startDateGtEqualsStartDate = Objects.compare(budgetRate.getStartDate(), this.startDate, Comparator.naturalOrder()) >= 0;
                boolean onOffCampusEquals = Objects.equals(costElement.getOnOffCampusFlag(), budgetRate.getOnOffCampusFlag());
                return iInflationRCEquals && iInflationRTEquals && startDateLtEqualsEndDate && startDateGtEqualsStartDate && onOffCampusEquals;
            };
            return (this.getInflationRates() == null ? this.getBudgetRates() : this.getInflationRates()).stream().filter(dateAndRateAndOnOffCampusFlag).collect(Collectors.toCollection(QueryList::new));
        }
        return new QueryList<BudgetRate>();
    }

    private List<BudgetRate> getBudgetRates() {
        if (StringUtils.isNotEmpty((CharSequence)this.personnelLineItem.getBudgetLineItem().getHierarchyProposalNumber())) {
            return this.personnelLineItem.getBudgetLineItem().getHierarchyProposal().getHierarchySummaryBudget().getBudgetRates();
        }
        return this.budget.getBudgetRates();
    }

    protected CostElement getCostElement(CostElement costElementBO, String costElementCode) {
        List<ValidCeRateType> costElementRates;
        if (costElementBO == null) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("costElement", costElementCode);
            costElementBO = (CostElement)this.getBusinessObjectService().findByPrimaryKey(CostElement.class, pkMap);
        }
        if ((costElementRates = costElementBO.getValidCeRateTypes()) == null || costElementRates.isEmpty()) {
            costElementBO.refreshReferenceObject("validCeRateTypes");
        }
        return costElementBO;
    }

    private Optional<ValidCeRateType> getInflationRateType(CostElement costElement) {
        return costElement.getValidCeRateTypes().stream().filter(t -> t.getRateClassType().equals(RateClassType.INFLATION.getRateClassType())).findFirst();
    }

    private QueryList<BudgetPerson> filterBudgetPersons() {
        List<BudgetPerson> persons = this.budget.getBudgetPersons();
        if (persons.isEmpty()) {
            return new QueryList<BudgetPerson>();
        }
        Optional<BudgetPerson> first = persons.stream().filter(person -> person.getPersonSequenceNumber().equals(this.personnelLineItem.getPersonSequenceNumber())).findFirst();
        if (!first.isPresent()) {
            return new QueryList<BudgetPerson>();
        }
        List filteredPersons = persons.stream().filter(person -> {
            boolean personIdEquals = StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)((BudgetPerson)first.get()).getPersonId());
            boolean jobCodeEquals = StringUtils.equals((CharSequence)person.getJobCode(), (CharSequence)((BudgetPerson)first.get()).getJobCode());
            boolean rolodexIdEquals = Objects.equals(person.getRolodexId(), ((BudgetPerson)first.get()).getRolodexId());
            boolean nameEquals = StringUtils.equals((CharSequence)person.getPersonName(), (CharSequence)((BudgetPerson)first.get()).getPersonName());
            boolean effectiveDateLtEqualsEndDate = Objects.compare(person.getEffectiveDate(), this.endDate, Comparator.naturalOrder()) <= 0;
            return personIdEquals && jobCodeEquals && rolodexIdEquals && effectiveDateLtEqualsEndDate && nameEquals;
        }).collect(Collectors.toList());
        Optional<BudgetPerson> tmpFirst = filteredPersons.stream().filter(person -> {
            boolean effectiveDateLtEqualsStartDate = Objects.compare(person.getEffectiveDate(), this.startDate, Comparator.naturalOrder()) <= 0;
            boolean effectiveDateEquals = Objects.compare(person.getEffectiveDate(), ((BudgetPerson)first.get()).getEffectiveDate(), Comparator.naturalOrder()) == 0;
            boolean seqNotEquals = person.getPersonSequenceNumber().intValue() != ((BudgetPerson)first.get()).getPersonSequenceNumber().intValue();
            boolean matchesFirstHierarchyProposalNumber = person.getHierarchyProposalNumber() == ((BudgetPerson)first.get()).getHierarchyProposalNumber();
            return effectiveDateLtEqualsStartDate && (!effectiveDateEquals || !seqNotEquals) && matchesFirstHierarchyProposalNumber;
        }).max(Comparator.comparing(BudgetPerson::getEffectiveDate));
        if (tmpFirst.isPresent()) {
            filteredPersons.clear();
            filteredPersons.add(tmpFirst.get());
        } else {
            StringBuilder warningMsg = new StringBuilder("Base salary information is not available for the person ");
            StringBuilder errMsg = new StringBuilder("Error finding the calculation base for the person ");
            errMsg.append(this.personnelLineItem.getPersonId());
            errMsg.append(" with Job Code ");
            errMsg.append(this.personnelLineItem.getJobCode());
            warningMsg.append(this.personnelLineItem.getPersonId());
            warningMsg.append(" with Job Code ");
            warningMsg.append(this.personnelLineItem.getJobCode());
            warningMsg.append(" for the period ");
            warningMsg.append(this.getDateTimeService().toDateString(this.startDate));
            warningMsg.append(" to ");
            if (!filteredPersons.isEmpty()) {
                warningMsg.append(this.getDateTimeService().toDateString(this.add(((BudgetPerson)filteredPersons.get(0)).getEffectiveDate(), -1)));
            } else {
                warningMsg.append(this.getDateTimeService().toDateString((java.util.Date)this.personnelLineItem.getEndDate()));
            }
            warningMsg.append("\n");
            warningMsg.append("Salary for this period will be set to 0\n");
            warningMsg.append("Please make changes to budget person details and recalculate the budget");
            LOG.warn(warningMsg.toString());
            LOG.error(errMsg.toString());
        }
        return new QueryList<BudgetPerson>(filteredPersons);
    }

    private java.util.Date add(java.util.Date date, int days) {
        Calendar cal = this.getDateTimeService().getCalendar(date);
        cal.add(5, days);
        return cal.getTime();
    }

    private ScaleTwoDecimal calculateCostSharingPercentage() {
        ScaleTwoDecimal charged = this.personnelLineItem.getPercentCharged();
        ScaleTwoDecimal effort = this.personnelLineItem.getPercentEffort();
        return (ScaleTwoDecimal)effort.subtract((AbstractDecimal)charged);
    }

    private QueryList<SalaryDetails> createSalBreakupIntervals() {
        SalaryDetails salaryDetails;
        QueryList<DateSortable> combinedList = new QueryList<DateSortable>();
        combinedList.addAll(this.filterBudgetPersons());
        CostElement costElement = this.getCostElement(this.personnelLineItem.getCostElementBO(), this.personnelLineItem.getCostElement());
        combinedList.addAll(this.filterInflationRates(costElement, this.personnelLineItem.getApplyInRateFlag()));
        combinedList.sort("sortableDate");
        if (this.isAnniversarySalaryDateEnabled()) {
            combinedList = this.processAnniversarySalaryDateInflationRates(combinedList);
        }
        QueryList<SalaryDetails> breakUpIntervals = new QueryList<SalaryDetails>();
        BudgetPerson budgetPerson = null;
        BudgetRate budgetRate = null;
        BudgetRate prevBudgetProposalRate = null;
        java.util.Date tempStartDate = this.startDate;
        java.util.Date tempEndDate = this.endDate;
        SalaryDetails prevSalaryDetails = new SalaryDetails();
        for (DateSortable changedObject : combinedList) {
            int compareDateChange;
            Date rateChangeDate;
            boolean personFlag = changedObject instanceof BudgetPerson;
            if (personFlag) {
                budgetPerson = (BudgetPerson)changedObject;
                rateChangeDate = budgetPerson.getStartDate();
                prevSalaryDetails.setActualBaseSalary(budgetPerson.getCalculationBase());
                this.updateBudgetPerson(budgetPerson);
                prevSalaryDetails.setWorkingMonths(budgetPerson.getAppointmentType().getDuration());
            } else {
                budgetRate = (BudgetRate)changedObject;
                rateChangeDate = budgetRate.getStartDate();
            }
            if (budgetPerson == null || (compareDateChange = rateChangeDate.compareTo(tempStartDate)) < 0) continue;
            Calendar rateChangeCal = this.getDateTimeService().getCalendar((java.util.Date)rateChangeDate);
            rateChangeCal.add(5, -1);
            tempEndDate = rateChangeCal.getTime();
            Boundary boundary = new Boundary(tempStartDate, tempEndDate);
            salaryDetails = new SalaryDetails();
            salaryDetails.setBoundary(boundary);
            if (!personFlag && budgetRate != null) {
                salaryDetails.setActualBaseSalary(this.getSalaryBaseForBoundary(budgetPerson, boundary, budgetRate));
                if (prevBudgetProposalRate != null && budgetPerson.getEffectiveDate().before(prevBudgetProposalRate.getStartDate()) && budgetPerson.getEffectiveDate().before(boundary.getStartDate()) && prevBudgetProposalRate.getStartDate().before(boundary.getEndDate()) && (prevBudgetProposalRate.getStartDate().equals(boundary.getStartDate()) || this.budget.getBudgetPeriods().get(0).getEndDate().before(this.startDate))) {
                    salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
                } else if (budgetRate != null && budgetPerson.getEffectiveDate().before(budgetRate.getStartDate()) && budgetPerson.getEffectiveDate().before(this.startDate) && budgetRate.getStartDate().before(boundary.getEndDate()) && (budgetRate.getStartDate().compareTo(this.startDate) <= 0 || this.budget.getBudgetPeriods().get(0).getEndDate().before(this.startDate))) {
                    salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
                }
                salaryDetails.setWorkingMonths(prevSalaryDetails.getWorkingMonths());
                salaryDetails.setAltBudgetPerson(this.getSamePersonWithSameJobAndDifferentEffectiveDates(boundary, budgetPerson));
            }
            if (personFlag && budgetPerson != null) {
                salaryDetails.setActualBaseSalary(budgetPerson.getCalculationBase());
                salaryDetails.setWorkingMonths(budgetPerson.getAppointmentType().getDuration());
                salaryDetails.setAltBudgetPerson(this.getSamePersonWithSameJobAndDifferentEffectiveDates(boundary, budgetPerson));
            }
            if (budgetPerson.getStartDate().compareTo(tempStartDate) <= 0) {
                breakUpIntervals.add(salaryDetails);
            }
            prevBudgetProposalRate = budgetRate;
            prevSalaryDetails = salaryDetails;
            tempStartDate = rateChangeDate;
        }
        Boundary boundary = new Boundary(tempStartDate, this.endDate);
        salaryDetails = new SalaryDetails();
        salaryDetails.setBoundary(boundary);
        if (budgetRate != null && budgetPerson != null && budgetPerson.getEffectiveDate().before(budgetRate.getStartDate())) {
            salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
            salaryDetails.setWorkingMonths(prevSalaryDetails.getWorkingMonths());
        }
        if (budgetPerson != null) {
            salaryDetails.setActualBaseSalary(this.getSalaryBaseForBoundary(budgetPerson, boundary, budgetRate));
            BudgetPerson newBudgetPerson = this.getBudgetPersonApplied(budgetPerson, boundary);
            if (budgetRate != null && (newBudgetPerson == null && budgetPerson.getEffectiveDate().before(budgetRate.getStartDate()) || newBudgetPerson != null && newBudgetPerson.getEffectiveDate().before(budgetRate.getStartDate()))) {
                salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
            }
            if (newBudgetPerson != null) {
                this.updateBudgetPerson(newBudgetPerson);
                salaryDetails.setWorkingMonths(newBudgetPerson.getAppointmentType() == null ? DEFAULT_WORKING_MONTHS : newBudgetPerson.getAppointmentType().getDuration());
            } else {
                salaryDetails.setWorkingMonths(budgetPerson.getAppointmentType() == null ? DEFAULT_WORKING_MONTHS : budgetPerson.getAppointmentType().getDuration());
            }
            salaryDetails.setAltBudgetPerson(this.getSamePersonWithSameJobAndDifferentEffectiveDates(boundary, budgetPerson));
        }
        breakUpIntervals.add(salaryDetails);
        return breakUpIntervals;
    }

    private void updateBudgetPerson(BudgetPerson budgetPerson) {
        if (budgetPerson.getAppointmentType() == null) {
            budgetPerson.refreshReferenceObject(APPOINTMENT_TYPE);
        }
    }

    private QueryList<DateSortable> processAnniversarySalaryDateInflationRates(QueryList<DateSortable> combinedList) {
        QueryList<DateSortable> filteredCombinedList = new QueryList<DateSortable>();
        for (DateSortable dateSortable : combinedList) {
            if (!(dateSortable instanceof BudgetPerson)) continue;
            BudgetPerson budgetPerson = (BudgetPerson)dateSortable;
            if (budgetPerson.getSalaryAnniversaryDate() == null) {
                filteredCombinedList = combinedList;
                continue;
            }
            filteredCombinedList.add(dateSortable);
            filteredCombinedList.addAll(this.createAnnualInflationRates(budgetPerson, this.endDate));
        }
        return filteredCombinedList;
    }

    private List<BudgetRate> createAnnualInflationRates(BudgetPerson budgetPerson, java.util.Date endDate) {
        int endYear;
        ArrayList<BudgetRate> budgetRates = new ArrayList<BudgetRate>();
        QueryList<BudgetRate> inflationRatesList = this.filterInflationRates(budgetPerson.getEffectiveDate(), endDate);
        if (inflationRatesList.isEmpty()) {
            return budgetRates;
        }
        BudgetRate inflationRate = this.getInflationRateToBeApplied(inflationRatesList, budgetPerson.getSalaryAnniversaryDate());
        if (inflationRate != null) {
            BudgetRate budgetRate = (BudgetRate)((Object)ObjectUtils.deepCopy((Serializable)((Object)inflationRate)));
            if (!budgetPerson.getSalaryAnniversaryDate().before(budgetPerson.getEffectiveDate())) {
                budgetRate.setStartDate(budgetPerson.getSalaryAnniversaryDate());
            }
            if (budgetRate.getStartDate().before(endDate) || budgetRate.getStartDate().equals(endDate)) {
                budgetRates.add(budgetRate);
            }
        }
        Calendar salaryDateCalendar = this.getDateTimeService().getCalendar((java.util.Date)budgetPerson.getSalaryAnniversaryDate());
        Calendar endCalendar = this.getDateTimeService().getCalendar(endDate);
        int startYear = salaryDateCalendar.get(1);
        if (startYear != (endYear = endCalendar.get(1))) {
            while (salaryDateCalendar.get(1) <= endYear) {
                salaryDateCalendar.add(1, 1);
                java.util.Date nextInflationDate = salaryDateCalendar.getTime();
                if (nextInflationDate.after(endDate)) break;
                BudgetRate inflationRateToBeApplied = this.getInflationRateToBeApplied(inflationRatesList, nextInflationDate);
                if (inflationRateToBeApplied == null) continue;
                BudgetRate nextBudgetRate = (BudgetRate)((Object)ObjectUtils.deepCopy((Serializable)((Object)inflationRateToBeApplied)));
                try {
                    nextBudgetRate.setStartDate(this.getDateTimeService().convertToSqlDate(this.getDateTimeService().toDateString(nextInflationDate)));
                    budgetRates.add(nextBudgetRate);
                }
                catch (ParseException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return budgetRates;
    }

    private BudgetRate getInflationRateToBeApplied(List<BudgetRate> inflationRatesList, java.util.Date effectiveDate) {
        Equals eqEffectiveDate = new Equals("startDate", effectiveDate);
        LesserThan ltEffectiveDate = new LesserThan("startDate", effectiveDate);
        Or eqOrltEffectiveDate = new Or(eqEffectiveDate, ltEffectiveDate);
        QueryList<BudgetRate> qlInflationRates = new QueryList<BudgetRate>(inflationRatesList);
        QueryList<BudgetRate> qlFilteredRates = qlInflationRates.filter(eqOrltEffectiveDate);
        qlFilteredRates.sort("startDate", false);
        return qlFilteredRates.isEmpty() ? null : qlFilteredRates.get(0);
    }

    protected boolean isAnniversarySalaryDateEnabled() {
        return this.getParameterService().getParameterValueAsString(Budget.class, "enableSalaryInflationAnniversaryDate").equals(STRING_1);
    }

    private boolean isSameTbn(BudgetPerson curBudgetPerson, BudgetPerson budgetPerson) {
        return curBudgetPerson.getTbnId() != null && curBudgetPerson.getTbnId().equals(budgetPerson.getTbnId()) && curBudgetPerson.getPersonName() != null && curBudgetPerson.getPersonName().equalsIgnoreCase(budgetPerson.getPersonName());
    }

    public void setInflationRates(QueryList<BudgetRate> inflationRates) {
        this.inflationRates = inflationRates;
    }

    public QueryList<BudgetRate> getInflationRates() {
        return this.inflationRates;
    }

    private BudgetPerson getBudgetPersonApplied(BudgetPerson budgetPerson, Boundary boundary) {
        return this.budget.getBudgetPersons().stream().filter(budgetPerson1 -> this.samePersonEffectiveBeforeBoundary((BudgetPerson)budgetPerson1, boundary, budgetPerson)).max(Comparator.comparing(BudgetPerson::getEffectiveDate)).orElse(null);
    }

    private BudgetPerson getSamePersonWithSameJobAndDifferentEffectiveDates(Boundary boundary, BudgetPerson curBudgetPerson) {
        for (BudgetPerson budgetPerson : this.budget.getBudgetPersons()) {
            if (!this.isSamePerson(budgetPerson, curBudgetPerson) || budgetPerson.getPersonSequenceNumber().equals(curBudgetPerson.getPersonSequenceNumber()) || !StringUtils.equals((CharSequence)budgetPerson.getJobCode(), (CharSequence)curBudgetPerson.getJobCode()) || budgetPerson.getEffectiveDate() == null || !budgetPerson.getEffectiveDate().after(curBudgetPerson.getEffectiveDate()) || budgetPerson.getEffectiveDate().compareTo(boundary.getStartDate()) < 0 || budgetPerson.getEffectiveDate().compareTo(boundary.getEndDate()) > 0 || !StringUtils.equals((CharSequence)budgetPerson.getHierarchyProposalNumber(), (CharSequence)curBudgetPerson.getHierarchyProposalNumber())) continue;
            return budgetPerson;
        }
        return null;
    }

    private boolean samePersonEffectiveBeforeBoundary(BudgetPerson testPerson, Boundary boundary, BudgetPerson comparedTo) {
        return this.isSamePerson(testPerson, comparedTo) && StringUtils.equals((CharSequence)comparedTo.getJobCode(), (CharSequence)testPerson.getJobCode()) && testPerson.getEffectiveDate() != null && testPerson.getEffectiveDate().compareTo(boundary.getStartDate()) <= 0;
    }

    private ScaleTwoDecimal getSalaryBaseForBoundary(BudgetPerson budgetPerson, Boundary boundary, BudgetRate currentRate) {
        BudgetPerson newBudgetPerson = this.budget.getBudgetPersons().stream().filter(budgetPerson1 -> this.samePersonEffectiveBeforeBoundary((BudgetPerson)budgetPerson1, boundary, budgetPerson)).max(Comparator.comparing(BudgetPerson::getEffectiveDate)).orElse(budgetPerson);
        Date p1StartDate = this.budget.getBudgetPeriods().get(0).getStartDate();
        BigDecimal calBase = newBudgetPerson.getCalculationBase().bigDecimalValue();
        if (budgetPerson.getEffectiveDate().before(p1StartDate)) {
            p1StartDate = budgetPerson.getEffectiveDate();
        }
        QueryList<BudgetRate> qlist = new QueryList<BudgetRate>();
        if (this.isAnniversarySalaryDateEnabled() && budgetPerson.getSalaryAnniversaryDate() != null) {
            java.util.Date nearestPreviousPeriodEndDate = this.getNearestPreviousPeriodEndDate(boundary.getStartDate());
            qlist.addAll(this.createAnnualInflationRates(budgetPerson, nearestPreviousPeriodEndDate).stream().filter(rate -> !this.isSameRate((BudgetRate)rate, currentRate)).collect(Collectors.toList()));
        } else {
            qlist.addAll(this.filterInflationRates(p1StartDate, this.add(boundary.getStartDate(), -1)));
        }
        for (BudgetRate budgetProposalrate : qlist) {
            if (!budgetProposalrate.getStartDate().after(budgetPerson.getEffectiveDate())) continue;
            calBase = calBase.add(calBase.multiply(budgetProposalrate.getApplicableRate().bigDecimalValue()).divide(new ScaleTwoDecimal(100.0).bigDecimalValue(), RoundingMode.HALF_UP));
        }
        return new ScaleTwoDecimal(calBase);
    }

    private boolean isSamePerson(BudgetPerson budgetPerson, BudgetPerson budgetPerson1) {
        return budgetPerson1.getPersonId() != null && budgetPerson1.getPersonId().equals(budgetPerson.getPersonId()) || budgetPerson1.getRolodexId() != null && budgetPerson1.getRolodexId().equals(budgetPerson.getRolodexId()) || this.isSameTbn(budgetPerson1, budgetPerson) && Objects.equals(budgetPerson.getHierarchyProposalNumber(), budgetPerson1.getHierarchyProposalNumber());
    }

    private boolean isSameRate(BudgetRate rate1, BudgetRate rate2) {
        if (rate1 == null && rate2 == null) {
            return true;
        }
        if (rate1 == null || rate2 == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)rate1.getRateClassCode(), (CharSequence)rate2.getRateClassCode()) && StringUtils.equals((CharSequence)rate1.getRateTypeCode(), (CharSequence)rate2.getRateTypeCode()) && StringUtils.equals((CharSequence)rate1.getActivityTypeCode(), (CharSequence)rate2.getActivityTypeCode()) && StringUtils.equals((CharSequence)rate1.getFiscalYear(), (CharSequence)rate2.getFiscalYear()) && Objects.equals(rate1.getOnOffCampusFlag(), rate2.getOnOffCampusFlag()) && Objects.equals(rate1.getStartDate(), rate2.getStartDate()) && Objects.equals(rate1.getApplicableRate(), rate2.getApplicableRate()) && Objects.equals(rate1.getInstituteRate(), rate2.getInstituteRate());
    }

    protected java.util.Date getNearestPreviousPeriodEndDate(java.util.Date boundaryStartDate) {
        Calendar boundaryStartDateCalendar = this.getDateTimeService().getCalendar(boundaryStartDate);
        Calendar currDate = this.getDateTimeService().getCalendar(this.budget.getEndDate());
        do {
            currDate.add(1, -1);
        } while (currDate.after(boundaryStartDateCalendar));
        return currDate.getTime().before(this.budget.getStartDate()) ? this.budget.getStartDate() : currDate.getTime();
    }

    private QueryList<BudgetRate> filterInflationRates(java.util.Date sDate, java.util.Date eDate) {
        if (this.personnelLineItem.getApplyInRateFlag().booleanValue()) {
            QueryList<BudgetRate> prevInflationRatesList;
            QueryList<BudgetRate> inflationRatesList;
            And inflRCandRT;
            CostElement costElement = this.getCostElement(this.personnelLineItem.getCostElementBO(), this.personnelLineItem.getCostElement());
            Optional<ValidCeRateType> inflationRateType = this.getInflationRateType(costElement);
            if (inflationRateType.isPresent()) {
                Equals eInflationRC = new Equals("rateClassCode", (Comparable)((Object)inflationRateType.get().getRateClassCode()));
                Equals eInflationRT = new Equals("rateTypeCode", (Comparable)((Object)inflationRateType.get().getRateTypeCode()));
                inflRCandRT = new And(eInflationRC, eInflationRT);
            } else {
                inflRCandRT = new And(Operator.FALSE, Operator.FALSE);
            }
            LesserThan ltStartDate = new LesserThan("startDate", sDate);
            And ltStartDateAndRate = new And(inflRCandRT, ltStartDate);
            Equals onOffCampus = new Equals("onOffCampusFlag", costElement.getOnOffCampusFlag());
            And ltStartDateAndRateAndOnOffCampusFlag = new And(ltStartDateAndRate, onOffCampus);
            LesserThan ltEndDate = new LesserThan("startDate", eDate);
            Equals eEndDate = new Equals("startDate", eDate);
            Or ltOrEqEndDate = new Or(ltEndDate, eEndDate);
            GreaterThan gtStartDate = new GreaterThan("startDate", sDate);
            Equals eStartDate = new Equals("startDate", sDate);
            Or gtOrEqStartDate = new Or(gtStartDate, eStartDate);
            And gtOrEqStartDateAndltOrEqEndDate = new And(gtOrEqStartDate, ltOrEqEndDate);
            And dateAndRate = new And(inflRCandRT, gtOrEqStartDateAndltOrEqEndDate);
            And dateAndRateAndOnOffCampusFlag = new And(dateAndRate, onOffCampus);
            if (this.getInflationRates() == null) {
                inflationRatesList = new QueryList<BudgetRate>(this.getBudgetRates()).filter(dateAndRateAndOnOffCampusFlag);
                prevInflationRatesList = new QueryList<BudgetRate>(this.getBudgetRates()).filter(ltStartDateAndRateAndOnOffCampusFlag);
            } else {
                inflationRatesList = this.getInflationRates().filter(dateAndRateAndOnOffCampusFlag);
                prevInflationRatesList = this.getInflationRates().filter(ltStartDateAndRateAndOnOffCampusFlag);
            }
            if (!prevInflationRatesList.isEmpty()) {
                prevInflationRatesList.sort("startDate", false);
                BudgetRate prevInflationRate = prevInflationRatesList.get(0);
                inflationRatesList.add(prevInflationRate);
                inflationRatesList.sort("startDate");
            }
            return inflationRatesList;
        }
        return new QueryList<BudgetRate>();
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private static class SalaryDetails {
        private Boundary boundary;
        private ScaleTwoDecimal workingMonths;
        private ScaleTwoDecimal actualBaseSalary = ScaleTwoDecimal.ZERO;
        private ScaleTwoDecimal calculatedSalary = ScaleTwoDecimal.ZERO;
        private BudgetPerson altBudgetPerson;

        private SalaryDetails() {
        }

        ScaleTwoDecimal calculateSalary(java.util.Date startDate, java.util.Date endDate) {
            ScaleTwoDecimal paidMonths = this.workingMonths == null ? DEFAULT_WORKING_MONTHS : this.workingMonths;
            double perMonthSalary = this.getActualBaseSalary().doubleValue() / paidMonths.doubleValue();
            Calendar startDateCalendar = new Calendar.Builder().setInstant(startDate).build();
            int startMonth = startDateCalendar.get(2);
            Calendar endDateCalendar = new Calendar.Builder().setInstant(endDate).build();
            double totalSalary = 0.0;
            boolean salaryReset = false;
            while (startDateCalendar.compareTo(endDateCalendar) <= 0) {
                int noOfActualDays;
                int noOfDaysInMonth;
                int n = noOfDaysInMonth = startDateCalendar.get(2) != 1 ? startDateCalendar.getActualMaximum(5) : 28;
                if (this.altBudgetPerson != null && !salaryReset) {
                    Calendar effdtCalendar = new Calendar.Builder().setInstant(this.altBudgetPerson.getEffectiveDate()).build();
                    Calendar nextStartDateCalendar = new Calendar.Builder().setInstant(startDateCalendar.getTime()).build();
                    nextStartDateCalendar.add(2, 1);
                    nextStartDateCalendar.set(5, 1);
                    if (effdtCalendar.compareTo(startDateCalendar) >= 0 && effdtCalendar.compareTo(nextStartDateCalendar) < 0) {
                        this.setActualBaseSalary(this.altBudgetPerson.getCalculationBase());
                        if (effdtCalendar.compareTo(startDateCalendar) > 0) {
                            noOfActualDays = effdtCalendar.get(5) - startDateCalendar.get(5);
                            totalSalary += perMonthSalary / (double)noOfDaysInMonth * (double)noOfActualDays;
                            startDateCalendar.set(5, effdtCalendar.get(5));
                        }
                        this.updateAltBudgetPerson();
                        paidMonths = this.altBudgetPerson.getAppointmentType().getDuration() == null ? DEFAULT_WORKING_MONTHS : this.altBudgetPerson.getAppointmentType().getDuration();
                        perMonthSalary = this.getActualBaseSalary().doubleValue() / paidMonths.doubleValue();
                        salaryReset = true;
                    }
                }
                noOfActualDays = startDateCalendar.get(2) == endDateCalendar.get(2) && startDateCalendar.get(1) == endDateCalendar.get(1) ? endDateCalendar.get(5) - startDateCalendar.get(5) + 1 : (startDateCalendar.get(2) == startMonth || startDateCalendar.get(5) != 1 ? noOfDaysInMonth - startDateCalendar.get(5) + 1 : noOfDaysInMonth);
                startDateCalendar.add(2, 1);
                startDateCalendar.set(5, 1);
                totalSalary += perMonthSalary / (double)noOfDaysInMonth * (double)noOfActualDays;
            }
            return (ScaleTwoDecimal)this.calculatedSalary.add((AbstractDecimal)new ScaleTwoDecimal(totalSalary));
        }

        private void updateAltBudgetPerson() {
            this.altBudgetPerson.refreshReferenceObject(SalaryCalculator.APPOINTMENT_TYPE);
        }

        public void calculateActualBaseSalary(ScaleTwoDecimal applicableRate) {
            ScaleTwoDecimal actualBaseSal = this.getActualBaseSalary();
            this.setActualBaseSalary((ScaleTwoDecimal)((ScaleTwoDecimal)actualBaseSal.percentage((AbstractDecimal)applicableRate)).add((AbstractDecimal)actualBaseSal));
        }

        public Boundary getBoundary() {
            return this.boundary;
        }

        public void setBoundary(Boundary boundary) {
            this.boundary = boundary;
        }

        public ScaleTwoDecimal getActualBaseSalary() {
            return this.actualBaseSalary;
        }

        public void setActualBaseSalary(ScaleTwoDecimal actualBaseSalary) {
            this.actualBaseSalary = actualBaseSalary;
        }

        public ScaleTwoDecimal getCalculatedSalary() {
            return this.calculatedSalary;
        }

        public void setCalculatedSalary(ScaleTwoDecimal calculatedSalary) {
            this.calculatedSalary = calculatedSalary;
        }

        public String toString() {
            StringBuilder strBffr = new StringBuilder("");
            strBffr.append("Actual Base Salary=>" + this.actualBaseSalary);
            strBffr.append(";");
            strBffr.append("Duration=>" + this.workingMonths);
            strBffr.append(";");
            strBffr.append("Boundary=>" + String.valueOf(this.boundary));
            strBffr.append(";");
            strBffr.append("Calculated salary=>" + this.calculatedSalary);
            strBffr.append("\n");
            return strBffr.toString();
        }

        public ScaleTwoDecimal getWorkingMonths() {
            return this.workingMonths;
        }

        public void setWorkingMonths(ScaleTwoDecimal workingMonths) {
            this.workingMonths = workingMonths;
        }

        public BudgetPerson getAltBudgetPerson() {
            return this.altBudgetPerson;
        }

        public void setAltBudgetPerson(BudgetPerson altBudgetPerson) {
            this.altBudgetPerson = altBudgetPerson;
        }
    }
}

