/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalPersonService")
public class ProposalPersonServiceImpl
implements ProposalPersonService {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    @Override
    public String getPersonName(ProposalDevelopmentDocument doc, String userId) {
        String propPersonName = null;
        List<ProposalPerson> proposalPersons = doc.getDevelopmentProposal().getProposalPersons();
        if (proposalPersons.isEmpty()) {
            proposalPersons = this.getProposalKeyPersonnel(doc.getDevelopmentProposal().getProposalNumber());
        }
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!StringUtils.equals((CharSequence)proposalPerson.getPersonId(), (CharSequence)userId)) continue;
            propPersonName = proposalPerson.getFullName();
            break;
        }
        if (StringUtils.isBlank(propPersonName)) {
            KcPerson person = this.kcPersonService.getKcPersonByPersonId(userId);
            propPersonName = person.getFullName();
        }
        return propPersonName;
    }

    @Override
    public List<ProposalPerson> getProposalKeyPersonnel(String proposalNumber) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("developmentProposal.proposalNumber", proposalNumber);
        return this.dataObjectService.findMatching(ProposalPerson.class, QueryByCriteria.Builder.andAttributes(keys).build()).getResults();
    }

    @Override
    public List<ProposalPerson> getProposalPersonsByPartialName(String partialName) {
        return this.getDataObjectService().findMatching(ProposalPerson.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.likeIgnoreCase((String)"fullName", (CharSequence)partialName)})).getResults();
    }
}

