/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectEvent;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.project.ExconProjectHRExtension;
import org.kuali.kra.excon.rules.ExconProjectEventAddRuleImpl;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ExconProjectEventsBean
implements Serializable {
    private static final long serialVersionUID = 23456757457L;
    protected ExconProjectEvent newEvent;
    protected ExconProjectForm exconProjectForm;
    private transient BusinessObjectService businessObjectService;

    public ExconProjectEventsBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public void addExconProjectEvent() {
        boolean success = new ExconProjectEventAddRuleImpl().processAddExconProjectEventBusinessRules(this.getExconProject(), this.getExconProjectEvent());
        if (success) {
            ExconProjectHRExtension hrExtension;
            ExconProjectEvent exconProjectEvent = this.getExconProjectEvent();
            if (StringUtils.equals((CharSequence)exconProjectEvent.getProjectEventTypeCode(), (CharSequence)"HRD") && (hrExtension = this.getExconProject().getHrExtension()) != null) {
                Object commentStr = "";
                if (hrExtension.getCriminalCheck().booleanValue()) {
                    commentStr = (String)commentStr + "CBC ";
                }
                if (hrExtension.getSexOffenderCheck().booleanValue()) {
                    commentStr = (String)commentStr + "SOR ";
                }
                if (hrExtension.getMvrCheck().booleanValue()) {
                    commentStr = (String)commentStr + "MVR ";
                }
                if (hrExtension.getCreditCheck().booleanValue()) {
                    commentStr = (String)commentStr + "FH ";
                }
                if (hrExtension.getEducationCheck().booleanValue()) {
                    commentStr = (String)commentStr + "EDU ";
                }
                if (hrExtension.getStateCheck().booleanValue()) {
                    commentStr = (String)commentStr + "STC ";
                }
                commentStr = ((String)commentStr).trim();
                exconProjectEvent.setEventComment((String)commentStr);
            }
            this.getExconProject().add(exconProjectEvent);
            this.init();
        }
    }

    public void deleteExconProjectEvent(int lineToDelete) {
        this.deleteExconProjectEvent(this.getExconProjectEvents(), lineToDelete);
    }

    public ExconProjectEvent getNewEvent() {
        return this.newEvent;
    }

    public ExconProjectEvent getExconProjectEvent() {
        return this.newEvent;
    }

    public List<ExconProjectEvent> getExconProjectEvents() {
        return ((ExconProjectDocument)this.exconProjectForm.getDocument()).getExconProject().getExconProjectEvents();
    }

    public int getExconProjectEventsCount() {
        return this.getExconProjectEvents().size();
    }

    protected void deleteExconProjectEvent(List<ExconProjectEvent> events, int lineToDelete) {
        if (events.size() > lineToDelete) {
            ExconProjectEvent foundEvent = events.get(lineToDelete);
            this.getExconProject().getExconProjectEvents().remove(foundEvent);
        }
    }

    protected void init() {
        this.newEvent = new ExconProjectEvent();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }
}

