/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentStatusBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeGroupBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolAttachmentServiceImplBase
implements ProtocolAttachmentService {
    protected final BusinessObjectService boService;
    protected final ProtocolDao protocolDao;
    protected PersonService personService;
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";

    public ProtocolAttachmentServiceImplBase(BusinessObjectService boService, ProtocolDao protocolDao) {
        if (boService == null) {
            throw new IllegalArgumentException("the boService was null");
        }
        if (protocolDao == null) {
            throw new IllegalArgumentException("the protocolDao was null");
        }
        this.boService = boService;
        this.protocolDao = protocolDao;
    }

    public abstract Class<? extends ProtocolBase> getProtocolClassHook();

    public abstract Class<? extends ProtocolAttachmentStatusBase> getProtocolAttachmentStatusClassHook();

    public abstract Class<? extends ProtocolPersonBase> getProtocolPersonClassHook();

    public abstract Class<? extends ProtocolAttachmentTypeBase> getProtocolAttachmentTypeClassHook();

    public abstract Class<? extends ProtocolAttachmentTypeGroupBase> getProtocolAttachmentTypeGroupClassHook();

    public abstract Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook();

    public abstract Class<? extends ProtocolAttachmentPersonnelBase> getProtocolAttachmentPersonnelClassHook();

    @Override
    public ProtocolAttachmentStatusBase getStatusFromCode(String code) {
        return this.getCodeType(this.getProtocolAttachmentStatusClassHook(), code);
    }

    @Override
    public ProtocolAttachmentTypeBase getTypeFromCode(String code) {
        return this.getCodeType(this.getProtocolAttachmentTypeClassHook(), code);
    }

    @Override
    public abstract Collection<ProtocolAttachmentTypeBase> getTypesForGroup(String var1);

    @Override
    public void saveAttatchment(ProtocolAttachmentBase attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        this.boService.save((PersistableBusinessObject)attachment);
    }

    @Override
    public void deleteAttatchment(ProtocolAttachmentBase attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        this.boService.delete((Object)attachment);
    }

    @Override
    public ProtocolPersonBase getPerson(Integer personId) {
        if (personId == null) {
            throw new IllegalArgumentException("the personId is null");
        }
        return (ProtocolPersonBase)this.boService.findByPrimaryKey(this.getProtocolPersonClassHook(), Collections.singletonMap("protocolPersonId", personId));
    }

    @Override
    public <T extends ProtocolAttachmentBase> T getAttachment(Class<T> type, Long id) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        ProtocolAttachmentBase attachment = (ProtocolAttachmentBase)this.boService.findByPrimaryKey(type, Collections.singletonMap("id", id));
        return (T)attachment;
    }

    @Override
    public boolean isNewAttachmentVersion(ProtocolAttachmentProtocolBase attachment) {
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        if (!attachment.getProtocol().isNew() && attachment.getProtocol().getSequenceNumber() == 0) {
            ProtocolBase protocol = this.getActiveProtocol(attachment.getProtocol().getProtocolNumber().substring(0, attachment.getProtocol().getProtocolNumber().indexOf(attachment.getProtocol().isAmendment() ? ProtocolSpecialVersion.AMENDMENT.getCode() : (attachment.getProtocol().isRenewal() ? ProtocolSpecialVersion.RENEWAL.getCode() : ProtocolSpecialVersion.FYI.getCode()))));
            keyMap.put("protocolNumber", protocol.getProtocolNumber());
            keyMap.put("sequenceNumber", protocol.getSequenceNumber());
        } else {
            keyMap.put("protocolNumber", attachment.getProtocolNumber());
            keyMap.put("sequenceNumber", attachment.getSequenceNumber() - 1);
        }
        keyMap.put("attachmentVersion", attachment.getAttachmentVersion());
        keyMap.put("documentId", attachment.getDocumentId());
        return this.boService.findMatching(this.getProtocolAttachmentProtocolClassHook(), keyMap).isEmpty();
    }

    @Override
    public boolean isAttachmentActive(ProtocolAttachmentProtocolBase attachment) {
        ProtocolBase activeProtocol;
        String protocolNumber = attachment.getProtocol().getProtocolNumber();
        if (!attachment.getProtocol().isNew()) {
            protocolNumber = attachment.getProtocol().getAmendedProtocolNumber();
        }
        boolean retValue = (activeProtocol = this.getActiveProtocol(protocolNumber)).getActiveAttachmentProtocolsNoDelete().contains(attachment);
        return retValue;
    }

    protected ProtocolBase getActiveProtocol(String protocolNumber) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("protocolNumber", protocolNumber);
        List protocols = (List)this.boService.findMatchingOrderBy(this.getProtocolClassHook(), keyMap, "sequenceNumber", false);
        return (ProtocolBase)protocols.get(0);
    }

    @Override
    public <T extends ProtocolAttachmentBase> Collection<T> getAttachmentsWithOlderFileVersions(T attachment, Class<T> type) {
        ArrayList<T> olderAttachments = new ArrayList<T>();
        for (T version : this.protocolDao.retrieveAttachmentVersions(attachment, type)) {
            if (version.getFile().getSequenceNumber() >= attachment.getFile().getSequenceNumber()) continue;
            olderAttachments.add(version);
        }
        return olderAttachments;
    }

    protected <T extends PersistableBusinessObject> T getCodeType(Class<T> type, String code) {
        if (type == null) {
            throw new IllegalArgumentException("the type is null");
        }
        if (code == null) {
            throw new IllegalArgumentException("the code is null");
        }
        PersistableBusinessObject bo = (PersistableBusinessObject)this.boService.findByPrimaryKey(type, Collections.singletonMap("code", code));
        return (T)bo;
    }

    @Override
    public boolean isSharedFile(ProtocolAttachmentPersonnelBase attachment) {
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("fileId", attachment.getFileId());
        return this.boService.findMatching(this.getProtocolAttachmentPersonnelClassHook(), keyMap).size() > 1;
    }

    @Override
    public void setProtocolAttachmentUpdateUsersName(List<? extends ProtocolAttachmentBase> protocolAttachmentBases) {
        for (ProtocolAttachmentBase protocolAttachmentBase : protocolAttachmentBases) {
            Person person;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(String.format("Looking up person for update user %s.", protocolAttachmentBase.getUpdateUser()));
            }
            protocolAttachmentBase.setUpdateUserFullName((person = this.personService.getPersonByPrincipalName(protocolAttachmentBase.getUpdateUser())) == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, protocolAttachmentBase.getUpdateUser()) : person.getName());
        }
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

