/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.api.parameter.ParameterKey;
import org.kuali.rice.coreservice.api.parameter.ParameterQueryResults;
import org.kuali.rice.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.rice.coreservice.impl.parameter.ParameterBo;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public final class ParameterRepositoryServiceImpl
implements ParameterRepositoryService {
    private static final String SUB_PARAM_SEPARATOR = "=";
    private DataObjectService dataObjectService;

    @Transactional
    public Parameter createParameter(Parameter parameter) {
        if (parameter == null) {
            throw new RiceIllegalArgumentException("parameter is null");
        }
        ParameterKey key = ParameterKey.create((String)parameter.getApplicationId(), (String)parameter.getNamespaceCode(), (String)parameter.getComponentCode(), (String)parameter.getName());
        Parameter existing = this.getParameter(key);
        if (existing != null && existing.getApplicationId().equals(parameter.getApplicationId())) {
            throw new RiceIllegalStateException("the parameter to create already exists: " + parameter);
        }
        ParameterBo parameterBo = (ParameterBo)((Object)this.getDataObjectService().save((Object)ParameterBo.from(parameter), new PersistenceOption[]{PersistenceOption.FLUSH}));
        return ParameterBo.to(parameterBo);
    }

    @Transactional
    public Parameter updateParameter(Parameter parameter) {
        Parameter toUpdate;
        if (parameter == null) {
            throw new RiceIllegalArgumentException("parameter is null");
        }
        ParameterKey key = ParameterKey.create((String)parameter.getApplicationId(), (String)parameter.getNamespaceCode(), (String)parameter.getComponentCode(), (String)parameter.getName());
        Parameter existing = this.getParameter(key);
        if (existing == null) {
            throw new RiceIllegalStateException("the parameter does not exist: " + parameter);
        }
        if (!existing.getApplicationId().equals(parameter.getApplicationId())) {
            Parameter.Builder builder = Parameter.Builder.create((ParameterContract)parameter);
            builder.setApplicationId(existing.getApplicationId());
            toUpdate = builder.build();
        } else {
            toUpdate = parameter;
        }
        return ParameterBo.to((ParameterBo)((Object)this.getDataObjectService().save((Object)ParameterBo.from(toUpdate), new PersistenceOption[0])));
    }

    public Parameter getParameter(ParameterKey key) {
        return ParameterBo.to(this.getParameterBo(key));
    }

    private ParameterBo getParameterBo(ParameterKey key) {
        if (key == null) {
            throw new RiceIllegalArgumentException("key is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", key.getName());
        map.put("applicationId", key.getApplicationId());
        map.put("namespaceCode", key.getNamespaceCode());
        map.put("componentCode", key.getComponentCode());
        ParameterBo bo = (ParameterBo)((Object)this.getDataObjectService().find(ParameterBo.class, (Object)new CompoundKey(Collections.unmodifiableMap(map))));
        if (bo == null & !"KUALI".equals(key.getApplicationId())) {
            map.put("applicationId", "KUALI");
            bo = (ParameterBo)((Object)this.getDataObjectService().find(ParameterBo.class, (Object)new CompoundKey(Collections.unmodifiableMap(map))));
        }
        return bo;
    }

    public String getParameterValueAsString(ParameterKey key) {
        ParameterBo p = this.getParameterBo(key);
        return p != null ? p.getValue() : null;
    }

    public Boolean getParameterValueAsBoolean(ParameterKey key) {
        ParameterBo p = this.getParameterBo(key);
        String value = p != null ? p.getValue() : null;
        return Truth.strToBooleanIgnoreCase((String)value);
    }

    public Collection<String> getParameterValuesAsString(ParameterKey key) {
        return this.splitOn(this.getParameterValueAsString(key), ";");
    }

    public String getSubParameterValueAsString(ParameterKey key, String subParameterName) {
        if (StringUtils.isBlank((String)subParameterName)) {
            throw new RiceIllegalArgumentException("subParameterName is blank");
        }
        Collection<String> values = this.getParameterValuesAsString(key);
        return this.getSubParameter(values, subParameterName);
    }

    public Collection<String> getSubParameterValuesAsString(ParameterKey key, String subParameterName) {
        return this.splitOn(this.getSubParameterValueAsString(key, subParameterName), ",");
    }

    private String getSubParameter(Collection<String> values, String subParameterName) {
        for (String value : values) {
            if (!subParameterName.equals(StringUtils.substringBefore((String)value, (String)SUB_PARAM_SEPARATOR))) continue;
            return StringUtils.trimToNull((String)StringUtils.substringAfter((String)value, (String)SUB_PARAM_SEPARATOR));
        }
        return null;
    }

    private Collection<String> splitOn(String strValues, String delim) {
        if (StringUtils.isEmpty((String)delim)) {
            throw new RiceIllegalArgumentException("delim is empty");
        }
        if (strValues == null || StringUtils.isBlank((String)strValues)) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String value : strValues.split(delim)) {
            values.add(value.trim());
        }
        return Collections.unmodifiableCollection(values);
    }

    public ParameterQueryResults findParameters(QueryByCriteria queryByCriteria) {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria is null");
        }
        QueryResults results = this.dataObjectService.findMatching(ParameterBo.class, queryByCriteria);
        ParameterQueryResults.Builder builder = ParameterQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Parameter> ims = new ArrayList<Parameter>();
        for (ParameterBo bo : results.getResults()) {
            ims.add(ParameterBo.to(bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

