/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg.font;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFontFamily;

public class AggregatingFontFamilyResolver
implements FontFamilyResolver {
    private final List<FontFamilyResolver> resolvers;

    public AggregatingFontFamilyResolver(FontFamilyResolver ... resolvers) {
        this.resolvers = Arrays.asList(resolvers);
    }

    public GVTFontFamily resolve(String familyName) {
        for (FontFamilyResolver resolver : this.resolvers) {
            GVTFontFamily family = resolver.resolve(familyName);
            if (family == null) continue;
            return family;
        }
        return null;
    }

    public GVTFontFamily resolve(String familyName, FontFace fontFace) {
        for (FontFamilyResolver resolver : this.resolvers) {
            GVTFontFamily family = resolver.resolve(familyName, fontFace);
            if (family == null) continue;
            return family;
        }
        return null;
    }

    public GVTFontFamily loadFont(InputStream in, FontFace fontFace) throws Exception {
        for (FontFamilyResolver resolver : this.resolvers) {
            try {
                return resolver.loadFont(in, fontFace);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public GVTFontFamily getDefault() {
        return this.resolve("any");
    }

    public GVTFontFamily getFamilyThatCanDisplay(char c) {
        for (FontFamilyResolver resolver : this.resolvers) {
            GVTFontFamily family = resolver.getFamilyThatCanDisplay(c);
            if (family == null) continue;
            return family;
        }
        return null;
    }
}

