/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.task.api.prediction;

import java.util.Map;

public class PredictionOutcome {
    private boolean present;
    private double confidenceLevel = 0.0;
    private double confidenceThreshold = 0.0;
    private Map<String, Object> data;

    public PredictionOutcome() {
        this.present = false;
    }

    public PredictionOutcome(double confidenceLevel, double confidenceThreshold, Map<String, Object> data) {
        this.present = data != null;
        this.confidenceLevel = confidenceLevel;
        this.confidenceThreshold = confidenceThreshold;
        this.data = data;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isCertain() {
        return this.present && this.confidenceLevel > this.confidenceThreshold;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

