/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.income;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="BUDGET_PROJECT_INCOME")
@IdClass(value=BudgetProjectIncomeId.class)
public class BudgetProjectIncome
extends KcPersistableBusinessObjectBase
implements HierarchyMaintainable,
BudgetProjectIncomeContract {
    private static final long serialVersionUID = 8999969227018875501L;
    public static final String DOCUMENT_COMPONENT_ID_KEY = "BUDGET_PROJECT_INCOME_KEY";
    @Id
    @Column(name="PROJECT_INCOME_ID")
    private Integer documentComponentId;
    @Id
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @Column(name="BUDGET_PERIOD_NUMBER", insertable=false, updatable=false)
    private Long budgetPeriodId;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="BUDGET_PERIOD_NUMBER", referencedColumnName="BUDGET_PERIOD_NUMBER"), @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")})
    private BudgetPeriod budgetPeriod;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriodNumber;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal projectIncome;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;

    public Integer getDocumentComponentId() {
        return this.documentComponentId;
    }

    public void setDocumentComponentId(Integer costShareId) {
        this.documentComponentId = costShareId;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Integer getBudgetPeriodNumber() {
        return this.budgetPeriodNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public ScaleTwoDecimal getProjectIncome() {
        return this.projectIncome;
    }

    public void setBudgetPeriodNumber(Integer budgetPeriodNumber) {
        this.budgetPeriodNumber = budgetPeriodNumber != null && budgetPeriodNumber > 0 ? budgetPeriodNumber : null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProjectIncome(ScaleTwoDecimal income) {
        this.projectIncome = income;
    }

    public String getDocumentComponentIdKey() {
        return DOCUMENT_COMPONENT_ID_KEY;
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public void setBudgetPeriod(BudgetPeriod budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
        this.budgetPeriodId = budgetPeriod != null ? budgetPeriod.getBudgetPeriodId() : null;
    }

    public BudgetPeriod getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public static final class BudgetProjectIncomeId
    implements Serializable,
    Comparable<BudgetProjectIncomeId> {
        private Integer documentComponentId;
        private Long budgetId;

        public Integer getDocumentComponentId() {
            return this.documentComponentId;
        }

        public void setDocumentComponentId(Integer documentComponentId) {
            this.documentComponentId = documentComponentId;
        }

        public Long getBudgetId() {
            return this.budgetId;
        }

        public void setBudgetId(Long budgetId) {
            this.budgetId = budgetId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("budgetId", (Object)this.budgetId).append("documentComponentId", (Object)this.documentComponentId).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            BudgetProjectIncomeId rhs = (BudgetProjectIncomeId)other;
            return new EqualsBuilder().append((Object)this.budgetId, (Object)rhs.budgetId).append((Object)this.documentComponentId, (Object)rhs.documentComponentId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.budgetId).append((Object)this.documentComponentId).toHashCode();
        }

        @Override
        public int compareTo(BudgetProjectIncomeId other) {
            return new CompareToBuilder().append((Object)this.budgetId, (Object)other.budgetId).append((Object)this.documentComponentId, (Object)other.documentComponentId).toComparison();
        }
    }
}

