/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.onlinereview.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.onlinereview.authorization.ProtocolOnlineReviewTask;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolOnlineReviewDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private transient KcWorkflowService kraWorkflowService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProtocolOnlineReviewDocument protocolOnlineReviewDocument = (ProtocolOnlineReviewDocument)document;
        String userId = user.getPrincipalId();
        if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "maintainProtocolOnlineReviews")) {
            editModes.add("fullEntry");
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "modifyProtocolOnlineReview") && this.getKraWorkflowService().isUserApprovalRequested((Document)protocolOnlineReviewDocument, GlobalVariables.getUserSession().getPrincipalId())) {
            editModes.add("fullEntry");
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "viewProtocolOnlineReview")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        return editModes;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return true;
    }

    public boolean canOpen(Document document, Person user) {
        ProtocolOnlineReviewDocument protocolOnlineReviewDocument = (ProtocolOnlineReviewDocument)document;
        if (protocolOnlineReviewDocument.getProtocolOnlineReview() == null) {
            return this.canCreateProtocolOnlineReview(user);
        }
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocument)document, "viewProtocolOnlineReview");
    }

    private boolean canCreateProtocolOnlineReview(Person user) {
        ApplicationTask task = new ApplicationTask("createProtocolOnlineReview");
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteProtocolOnlineReviewTask(String userId, ProtocolOnlineReviewDocument doc, String taskName) {
        ProtocolOnlineReviewTask task = new ProtocolOnlineReviewTask(taskName, (ProtocolOnlineReview)doc.getProtocolOnlineReview());
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocument)document, "modifyProtocolOnlineReview") || this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocument)document, "maintainProtocolOnlineReviews");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        boolean result = super.canDisapprove(document, user);
        return result &= this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocument)document, "maintainProtocolOnlineReviews");
    }

    private KcWorkflowService getKraWorkflowService() {
        if (this.kraWorkflowService == null) {
            this.kraWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kraWorkflowService;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

