/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.coi.framework.DisclosureProjectStatus;
import org.kuali.coeus.coi.framework.DisclosureStatusRetrievalService;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.custom.CustomDataDocumentForm;
import org.kuali.coeus.common.framework.medusa.MedusaBean;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.notification.impl.NotificationHelper;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsForm;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionableFormInterface;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentFormBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.Auditable;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.customdata.ProtocolCustomDataHelperBase;
import org.kuali.kra.protocol.noteattachment.NotesAttachmentsHelperBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.onlinereview.OnlineReviewsActionHelperBase;
import org.kuali.kra.protocol.permission.PermissionsHelperBase;
import org.kuali.kra.protocol.personnel.PersonnelHelperBase;
import org.kuali.kra.protocol.protocol.ProtocolHelperBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBeanBase;
import org.kuali.kra.protocol.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewHelperBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolFormBase
extends KcTransactionalDocumentFormBase
implements PermissionsForm,
Auditable,
QuestionableFormInterface,
CustomDataDocumentForm {
    private static final long serialVersionUID = 4646326030098259702L;
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final String DATE_TIME_FORMAT = "hh:mm a MM/dd/yyyy";
    protected static final boolean HIDE_ONLINE_REVIEW_WHEN_DISABLED = true;
    protected static final String ONLINE_REVIEW_NAV_TO = "onlineReview";
    private ProtocolHelperBase protocolHelper;
    private PermissionsHelperBase permissionsHelper;
    private PersonnelHelperBase personnelHelper;
    private ProtocolCustomDataHelperBase customDataHelper;
    private ProtocolSpecialReviewHelperBase specialReviewHelper;
    private ActionHelperBase actionHelper;
    private OnlineReviewsActionHelperBase onlineReviewsActionHelper;
    private QuestionnaireHelperBase questionnaireHelper;
    private NotificationHelper<ProtocolNotificationContextBase> protocolNotificationHelper;
    private transient NotesAttachmentsHelperBase notesAttachmentsHelper;
    private boolean auditActivated;
    private transient KcPersonService kcPersonService;
    private ProtocolReferenceBeanBase newProtocolReferenceBean;
    private MedusaBean medusaBean;
    private String lookupResultsSequenceNumber;
    private String lookupResultsBOClassName;
    private boolean javaScriptEnabled = true;
    private String detailId;
    private transient List<ProtocolFundingSourceBase> deletedProtocolFundingSources;
    private boolean showNotificationEditor = false;
    private List<DisclosureProjectStatus> disclosureProjectStatuses;
    private transient DisclosureStatusRetrievalService disclosureStatusRetrievalService;

    public ProtocolFormBase() throws Exception {
        this.initialize();
        this.registerEditableProperty("methodToCall");
    }

    public void initialize() throws Exception {
        this.setProtocolHelper(this.createNewProtocolHelperInstanceHook(this));
        this.setPersonnelHelper(this.createNewPersonnelHelperInstanceHook(this));
        this.setCustomDataHelper(this.createNewCustomDataHelperInstanceHook(this));
        this.setSpecialReviewHelper(this.createNewSpecialReviewHelperInstanceHook(this));
        this.setQuestionnaireHelper(this.createNewQuestionnaireHelperInstanceHook(this));
        this.setNewProtocolReferenceBean(this.createNewProtocolReferenceBeanInstance());
        this.setOnlineReviewsActionHelper(this.createNewOnlineReviewsActionHelperInstanceHook(this));
        this.setNotificationHelper(this.getNotificationHelperHook());
        this.setMedusaBean(new MedusaBean());
    }

    public void initializePermission() throws Exception {
        this.setPermissionsHelper(this.createNewPermissionsHelperInstanceHook(this));
    }

    public void initializeNotesAttachments() throws Exception {
        this.setNotesAttachmentsHelper(this.createNewNotesAttachmentsHelperInstanceHook(this));
        this.notesAttachmentsHelper.prepareView();
    }

    public void initializeProtocolAction() throws Exception {
        this.setActionHelper(this.createNewActionHelperInstanceHook(this, true));
    }

    public void initializeProtocolHistory() throws Exception {
        this.setActionHelper(this.createNewActionHelperInstanceHook(this, true));
    }

    protected abstract NotificationHelper<? extends ProtocolNotificationContextBase> getNotificationHelperHook();

    protected abstract ProtocolReferenceBeanBase createNewProtocolReferenceBeanInstance();

    protected abstract QuestionnaireHelperBase createNewQuestionnaireHelperInstanceHook(ProtocolFormBase var1);

    protected abstract ActionHelperBase createNewActionHelperInstanceHook(ProtocolFormBase var1, boolean var2) throws Exception;

    protected abstract ProtocolSpecialReviewHelperBase createNewSpecialReviewHelperInstanceHook(ProtocolFormBase var1);

    protected abstract ProtocolCustomDataHelperBase createNewCustomDataHelperInstanceHook(ProtocolFormBase var1);

    protected abstract OnlineReviewsActionHelperBase createNewOnlineReviewsActionHelperInstanceHook(ProtocolFormBase var1);

    protected abstract ProtocolHelperBase createNewProtocolHelperInstanceHook(ProtocolFormBase var1);

    protected abstract PermissionsHelperBase createNewPermissionsHelperInstanceHook(ProtocolFormBase var1);

    protected abstract PersonnelHelperBase createNewPersonnelHelperInstanceHook(ProtocolFormBase var1);

    protected abstract QuestionnaireHelperBase createNewQuestionnaireHelper(ProtocolFormBase var1);

    protected abstract NotesAttachmentsHelperBase createNewNotesAttachmentsHelperInstanceHook(ProtocolFormBase var1);

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
    }

    protected String getFormattedDate(Date dateInput) {
        return CoreApiServiceLocator.getDateTimeService().toString((java.util.Date)dateInput, DATE_FORMAT);
    }

    protected String getFormattedDateTime(Timestamp dateTimeInput) {
        return CoreApiServiceLocator.getDateTimeService().toString((java.util.Date)dateTimeInput, DATE_TIME_FORMAT);
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.setLookupResultsSequenceNumber(null);
        this.setLookupResultsBOClassName(null);
        this.onlineReviewsActionHelper.init(true);
    }

    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    public void setProtocolHelper(ProtocolHelperBase protocolHelper) {
        this.protocolHelper = protocolHelper;
    }

    public ProtocolHelperBase getProtocolHelper() {
        return this.protocolHelper;
    }

    private void setPersonnelHelper(PersonnelHelperBase personnelHelper) {
        this.personnelHelper = personnelHelper;
    }

    public PersonnelHelperBase getPersonnelHelper() {
        return this.personnelHelper;
    }

    private void setPermissionsHelper(PermissionsHelperBase permissionsHelper) {
        this.permissionsHelper = permissionsHelper;
    }

    @Override
    public PermissionsHelperBase getPermissionsHelper() {
        if (this.permissionsHelper == null) {
            try {
                this.initializePermission();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.permissionsHelper;
    }

    public void resetUserPermissionStates() {
        if (this.permissionsHelper != null) {
            this.permissionsHelper.resetUserStates();
        }
    }

    public void setNewProtocolReferenceBean(ProtocolReferenceBeanBase newProtocolReferenceBean) {
        this.newProtocolReferenceBean = newProtocolReferenceBean;
    }

    public ProtocolReferenceBeanBase getNewProtocolReferenceBean() {
        return this.newProtocolReferenceBean;
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
    }

    @Override
    public ProtocolCustomDataHelperBase getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(ProtocolCustomDataHelperBase customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    @Override
    public boolean isAuditActivated() {
        return this.auditActivated;
    }

    @Override
    public void setAuditActivated(boolean auditActivated) {
        this.auditActivated = auditActivated;
    }

    public ProtocolSpecialReviewHelperBase getSpecialReviewHelper() {
        return this.specialReviewHelper;
    }

    public void setSpecialReviewHelper(ProtocolSpecialReviewHelperBase specialReviewHelper) {
        this.specialReviewHelper = specialReviewHelper;
    }

    public NotesAttachmentsHelperBase getNotesAttachmentsHelper() {
        if (this.notesAttachmentsHelper == null) {
            this.notesAttachmentsHelper = this.createNewNotesAttachmentsHelperInstanceHook(this);
        }
        return this.notesAttachmentsHelper;
    }

    public void setNotesAttachmentsHelper(NotesAttachmentsHelperBase notesAttachmentsHelper) {
        this.notesAttachmentsHelper = notesAttachmentsHelper;
    }

    public ActionHelperBase getActionHelper() {
        return this.actionHelper;
    }

    protected void setActionHelper(ActionHelperBase actionHelper) {
        this.actionHelper = actionHelper;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled;
    }

    public void setJavaScriptEnabled(boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
    }

    public ProtocolDocumentBase getProtocolDocument() {
        return (ProtocolDocumentBase)this.getDocument();
    }

    public QuestionnaireHelperBase getQuestionnaireHelper() {
        return this.questionnaireHelper;
    }

    public void setQuestionnaireHelper(QuestionnaireHelperBase questionnaireHelper) {
        this.questionnaireHelper = questionnaireHelper;
    }

    public void setOnlineReviewsActionHelper(OnlineReviewsActionHelperBase onlineReviewActionHelper) {
        this.onlineReviewsActionHelper = onlineReviewActionHelper;
    }

    public OnlineReviewsActionHelperBase getOnlineReviewsActionHelper() {
        return this.onlineReviewsActionHelper;
    }

    public NotificationHelper<ProtocolNotificationContextBase> getNotificationHelper() {
        return this.protocolNotificationHelper;
    }

    public void setNotificationHelper(NotificationHelper notificationHelper) {
        this.protocolNotificationHelper = notificationHelper;
    }

    public SystemAuthorizationService getSystemAuthorizationService() {
        return KcServiceLocator.getService(SystemAuthorizationService.class);
    }

    public List<ExtraButton> getExtraActionsButtons() {
        boolean suppressRoutingControls;
        this.extraButtons.clear();
        String externalImageURL = "kr.externalizable.images.url";
        ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        boolean bl = suppressRoutingControls = this.getActionHelper().getCanApproveFull() || !this.getActionHelper().getCanApproveOther();
        if (suppressRoutingControls && this.getDocumentActions().get("canSendAdHocRequests") != null) {
            String sendAdHocRequestsImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_sendadhocreq.gif";
            this.addExtraButton("methodToCall.sendAdHocRequests", sendAdHocRequestsImage, "Send AdHoc Requests");
        }
        externalImageURL = "kra.externalizable.images.url";
        String sendNotificationImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_send_notification.gif";
        this.addExtraButton("methodToCall.sendNotification", sendNotificationImage, "Send Notification");
        return this.extraButtons;
    }

    @Override
    public abstract String getModuleCode();

    public String getDetailId() {
        return this.detailId;
    }

    public void setDetailId(String detailId) {
        this.detailId = detailId;
    }

    public List<ProtocolFundingSourceBase> getDeletedProtocolFundingSources() {
        return this.deletedProtocolFundingSources;
    }

    public void setDeletedProtocolFundingSources(List<ProtocolFundingSourceBase> deletedProtocolFundingSources) {
        this.deletedProtocolFundingSources = deletedProtocolFundingSources;
    }

    @Override
    public String getQuestionnaireFieldStarter() {
        return "questionnaireHelper.answerHeaders[";
    }

    @Override
    public String getQuestionnaireFieldMiddle() {
        return "].answers[";
    }

    @Override
    public String getQuestionnaireFieldEnd() {
        return "].answer";
    }

    @Override
    public String getQuestionnaireExpression() {
        return "^undefined$";
    }

    public MedusaBean getMedusaBean() {
        return this.medusaBean;
    }

    public void setMedusaBean(MedusaBean medusaBean) {
        this.medusaBean = medusaBean;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public boolean isSuperUserApproveDocumentAuthorized() {
        return false;
    }

    public List<ActionRequest> getActionRequests() {
        ArrayList<ActionRequest> retVal;
        ArrayList<ActionRequest> allAvailableRequests = super.getActionRequests();
        if (!this.isDocumentAtTerminalNode()) {
            retVal = allAvailableRequests;
        } else {
            retVal = new ArrayList<ActionRequest>();
            for (ActionRequest request : allAvailableRequests) {
                if (!request.isAdHocRequest() && !request.isExceptionRequest()) continue;
                retVal.add(request);
            }
        }
        return retVal;
    }

    private boolean isDocumentAtTerminalNode() {
        boolean retVal = false;
        List<String> terminalNodeNames = this.getTerminalNodeNamesHook();
        List currentNodes = KewApiServiceLocator.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocument().getDocumentHeader().getWorkflowDocument().getDocumentId());
        for (String terminalNodeName : terminalNodeNames) {
            if (!currentNodes.contains(terminalNodeName)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    protected abstract List<String> getTerminalNodeNamesHook();

    public boolean isShowNotificationEditor() {
        return this.showNotificationEditor;
    }

    public void setShowNotificationEditor(boolean showNotificationEditor) {
        this.showNotificationEditor = showNotificationEditor;
    }

    public boolean isSuperUserActionAvaliable() {
        boolean retVal = false;
        if (!this.isDocumentStatusSaved()) {
            retVal = super.isSuperUserActionAvaliable();
        }
        return retVal;
    }

    private boolean isDocumentStatusSaved() {
        DocumentStatus status = null;
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)GlobalVariables.getUserSession().getPrincipalId(), (String)this.getDocument().getDocumentHeader().getWorkflowDocument().getDocumentId());
        status = ObjectUtils.isNotNull((Object)document) ? document.getStatus() : this.getDocument().getDocumentHeader().getWorkflowDocument().getStatus();
        return StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.SAVED.getCode());
    }

    public boolean getDisplayEditButton() {
        return !this.getProtocolDocument().getProtocol().isRenewalWithoutAmendment();
    }

    protected abstract String getModuleName();

    public ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }

    public boolean getDisplayCoiDisclosureStatus() {
        return this.getParameterService().getParameterValueAsBoolean(this.getModuleName(), "Document", "ENABLE_DISCLOSURE_STATUS_FROM_COI_MODULE");
    }

    public boolean isCoiDispositionViewEnabled() {
        return this.getParameterService().getParameterValueAsBoolean(this.getModuleName(), "Document", "ENABLE_DISCLOSURE_DISPOSITION_STATUS_FROM_COI_MODULE");
    }

    public boolean getDisplayCoiProjectStatus() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "COI_PROJECT_STATUS_FEATURE");
    }

    private String getProtocolNumberForDisclosures() {
        String protocolNumber = this.getProtocolDocument().getProtocol().getProtocolNumber();
        if (this.getProtocolDocument().getProtocol() != null && !this.getProtocolDocument().getProtocol().isNew()) {
            protocolNumber = this.getProtocolDocument().getProtocol().getAmendedProtocolNumber();
        }
        return protocolNumber;
    }

    public List<DisclosureProjectStatus> getDisclosureProjectStatuses() {
        if (this.disclosureProjectStatuses == null) {
            this.disclosureProjectStatuses = this.getDisclosureStatusRetrievalService().getDisclosureStatusesForProject(this.getModuleName(), this.getProtocolNumberForDisclosures());
        }
        return this.disclosureProjectStatuses;
    }

    public void refreshDisclosureProjectStatuses() {
        this.disclosureProjectStatuses = this.getDisclosureStatusRetrievalService().getDisclosureStatusesForProject(this.getModuleName(), this.getProtocolNumberForDisclosures());
    }

    protected DisclosureStatusRetrievalService getDisclosureStatusRetrievalService() {
        if (this.disclosureStatusRetrievalService == null) {
            this.disclosureStatusRetrievalService = KcServiceLocator.getService(DisclosureStatusRetrievalService.class);
        }
        return this.disclosureStatusRetrievalService;
    }
}

