/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.kim.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ProtocolPersonnelDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    protected List<String> requiredAttributes = new ArrayList<String>();

    public ProtocolPersonnelDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            return protocol.getProtocolPersons().stream().filter(this.employeeMatchesRole(roleName)).map(person -> RoleMembership.Builder.create(null, null, (String)person.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocol(protocolNumber);
        return protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons()) && protocol.getProtocolPersons().stream().filter(protocolPersonBase -> principalId.equals(protocolPersonBase.getPersonId())).anyMatch(this.employeeMatchesRole(roleName));
    }

    protected Predicate<? super ProtocolPersonBase> employeeMatchesRole(String roleName) {
        return person -> StringUtils.equals((CharSequence)person.getProtocolPersonRoleId(), (CharSequence)roleName) && StringUtils.isNotBlank((CharSequence)person.getPersonId());
    }

    private Protocol getProtocol(String protocolNumber) {
        return (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, Collections.singletonMap(PROTOCOL_NUMBER, protocolNumber));
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

