/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.util.GlobalVariables;

public class DocumentPresentationControllerBase
implements DocumentPresentationController,
Serializable {
    private static final long serialVersionUID = -9181864754090276024L;
    private static transient ParameterService parameterService;
    private DocumentRequestAuthorizationCache documentRequestAuthorizationCache;

    @Override
    public boolean canInitiate(String documentTypeName) {
        return true;
    }

    @Override
    public boolean canEdit(Document document) {
        boolean canEdit = false;
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        if (workflowDocumentInfo.isInitiated() || workflowDocumentInfo.isSaved() || workflowDocumentInfo.isEnroute() || workflowDocumentInfo.isException()) {
            canEdit = true;
        }
        return canEdit;
    }

    @Override
    public boolean canAnnotate(Document document) {
        return true;
    }

    @Override
    public boolean canReload(Document document) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return this.canEdit(document) && !workflowDocumentInfo.isInitiated();
    }

    @Override
    public boolean canClose(Document document) {
        return false;
    }

    @Override
    public boolean canSave(Document document) {
        return this.canEdit(document);
    }

    @Override
    public boolean canRoute(Document document) {
        boolean canRoute = false;
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        if (workflowDocumentInfo.isInitiated() || workflowDocumentInfo.isSaved()) {
            canRoute = true;
        }
        return canRoute;
    }

    @Override
    public boolean canCancel(Document document) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return workflowDocumentInfo.isValidAction(ActionType.CANCEL);
    }

    @Override
    public boolean canRecall(Document document) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return workflowDocumentInfo.isEnroute();
    }

    @Override
    public boolean canCopy(Document document) {
        boolean canCopy = false;
        if (document.getAllowsCopy()) {
            canCopy = true;
        }
        return canCopy;
    }

    @Override
    public boolean canPerformRouteReport(Document document) {
        return this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "DEFAULT_CAN_PERFORM_ROUTE_REPORT_IND");
    }

    @Override
    public boolean canAddAdhocRequests(Document document) {
        return true;
    }

    @Override
    public boolean canBlanketApprove(Document document) {
        Boolean allowBlanketApproveNoRequest = this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "ALLOW_ENROUTE_BLANKET_APPROVE_WITHOUT_APPROVAL_REQUEST_IND");
        if (allowBlanketApproveNoRequest != null && allowBlanketApproveNoRequest.booleanValue()) {
            return this.canEdit(document);
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (this.canRoute(document) && StringUtils.equals((String)workflowDocument.getInitiatorPrincipalId(), (String)GlobalVariables.getUserSession().getPrincipalId())) {
            return true;
        }
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return workflowDocumentInfo.isApprovalRequested();
    }

    @Override
    public boolean canApprove(Document document) {
        return !this.canComplete(document);
    }

    @Override
    public boolean canDisapprove(Document document) {
        return this.canApprove(document);
    }

    @Override
    public boolean canSendAdhocRequests(Document document) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return !workflowDocumentInfo.isInitiated() && !workflowDocumentInfo.isSaved();
    }

    @Override
    public boolean canSendNoteFyi(Document document) {
        return true;
    }

    @Override
    public boolean canEditDocumentOverview(Document document) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return workflowDocumentInfo.isInitiated() || workflowDocumentInfo.isSaved();
    }

    @Override
    public boolean canFyi(Document document) {
        return true;
    }

    @Override
    public boolean canAcknowledge(Document document) {
        return true;
    }

    @Override
    public boolean canComplete(Document document) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        boolean docInInit = workflowDocumentInfo.isInitiated() || workflowDocumentInfo.isSaved();
        boolean completionRequested = workflowDocumentInfo.isCompletionRequested();
        return completionRequested && !docInInit;
    }

    @Override
    public boolean canSuperUserTakeAction(Document document) {
        return this.hasActionRequests(document) && this.canTakeAction(document);
    }

    @Override
    public boolean canSuperUserApprove(Document document) {
        return this.canApproveOrDisapprove(document);
    }

    @Override
    public boolean canSuperUserDisapprove(Document document) {
        return this.canApproveOrDisapprove(document);
    }

    protected boolean hasActionRequests(Document document) {
        boolean hasActionRequests = false;
        for (ActionRequest actionRequest : document.getActionRequests()) {
            if (!StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.APPROVE.getCode()) && !StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.COMPLETE.getCode())) continue;
            hasActionRequests = true;
            break;
        }
        return hasActionRequests;
    }

    protected boolean canTakeAction(Document document) {
        String documentNumber = document.getDocumentNumber();
        DocumentStatus status = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(documentNumber);
        return !this.isStateInitiatedFinalCancelled(status);
    }

    protected boolean canApproveOrDisapprove(Document document) {
        boolean canComplete = this.canComplete(document);
        String documentNumber = document.getDocumentNumber();
        DocumentStatus status = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(documentNumber);
        return !canComplete && !this.isStateInitiatedFinalCancelled(status) && !this.isStateSaved(status) && !this.isStateProcessedOrDisapproved(status);
    }

    protected boolean isStateInitiatedFinalCancelled(DocumentStatus status) {
        return StringUtils.equals((String)status.getCode(), (String)DocumentStatus.INITIATED.getCode()) || StringUtils.equals((String)status.getCode(), (String)DocumentStatus.FINAL.getCode()) || StringUtils.equals((String)status.getCode(), (String)DocumentStatus.CANCELED.getCode());
    }

    protected boolean isStateSaved(DocumentStatus status) {
        return StringUtils.equals((String)status.getCode(), (String)DocumentStatus.SAVED.getCode());
    }

    protected boolean isStateProcessedOrDisapproved(DocumentStatus status) {
        return StringUtils.equals((String)status.getCode(), (String)DocumentStatus.PROCESSED.getCode()) || StringUtils.equals((String)status.getCode(), (String)DocumentStatus.DISAPPROVED.getCode());
    }

    protected ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return parameterService;
    }

    protected DocumentRequestAuthorizationCache getDocumentRequestAuthorizationCache(Document document) {
        if (this.documentRequestAuthorizationCache == null) {
            this.documentRequestAuthorizationCache = new DocumentRequestAuthorizationCache();
        }
        if (this.documentRequestAuthorizationCache.getWorkflowDocumentInfo() == null) {
            this.documentRequestAuthorizationCache.createWorkflowDocumentInfo(document.getDocumentHeader().getWorkflowDocument());
        }
        return this.documentRequestAuthorizationCache;
    }

    @Override
    public void setDocumentRequestAuthorizationCache(DocumentRequestAuthorizationCache documentRequestAuthorizationCache) {
        this.documentRequestAuthorizationCache = documentRequestAuthorizationCache;
    }
}

