/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.XLatLonShape;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;

abstract class XLatLonShapeQuery
extends Query {
    final String field;
    final XLatLonShape.QueryRelation queryRelation;

    protected XLatLonShapeQuery(String field, XLatLonShape.QueryRelation queryType) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.queryRelation = queryType;
    }

    protected abstract PointValues.Relation relateRangeBBoxToQuery(int var1, int var2, byte[] var3, int var4, int var5, byte[] var6);

    protected abstract boolean queryMatches(byte[] var1, int[] var2);

    protected PointValues.Relation relateRangeToQuery(byte[] minTriangle, byte[] maxTriangle) {
        PointValues.Relation r = this.relateRangeBBoxToQuery(4, 0, minTriangle, 12, 8, maxTriangle);
        if (this.queryRelation == XLatLonShape.QueryRelation.DISJOINT) {
            return XLatLonShapeQuery.transposeRelation(r);
        }
        return r;
    }

    public final Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            protected PointValues.IntersectVisitor getSparseIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    final int[] scratchTriangle = new int[6];
                    DocIdSetBuilder.BulkAdder adder;

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) throws IOException {
                        this.adder.add(docID);
                    }

                    public void visit(int docID, byte[] t) throws IOException {
                        if (XLatLonShapeQuery.this.queryMatches(t, this.scratchTriangle)) {
                            this.adder.add(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                        return XLatLonShapeQuery.this.relateRangeToQuery(minTriangle, maxTriangle);
                    }
                };
            }

            protected PointValues.IntersectVisitor getDenseIntersectVisitor(final FixedBitSet intersect, final FixedBitSet disjoint) {
                return new PointValues.IntersectVisitor(){
                    final int[] scratchTriangle = new int[6];

                    public void visit(int docID) throws IOException {
                        if (XLatLonShapeQuery.this.queryRelation == XLatLonShape.QueryRelation.DISJOINT) {
                            disjoint.set(docID);
                        } else {
                            intersect.set(docID);
                        }
                    }

                    public void visit(int docID, byte[] t) throws IOException {
                        if (XLatLonShapeQuery.this.queryMatches(t, this.scratchTriangle)) {
                            intersect.set(docID);
                        } else {
                            disjoint.set(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                        return XLatLonShapeQuery.this.relateRangeToQuery(minTriangle, maxTriangle);
                    }
                };
            }

            protected ScorerSupplier getIntersectScorerSupplier(final LeafReader reader, PointValues values, final Weight weight) throws IOException {
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, XLatLonShapeQuery.this.field);
                PointValues.IntersectVisitor visitor = this.getSparseIntersectVisitor(result);
                return new RelationScorerSupplier(values, visitor){

                    public Scorer get(long leadCost) throws IOException {
                        return this.getIntersectsScorer(XLatLonShapeQuery.this, reader, weight, result, this.score());
                    }
                };
            }

            protected ScorerSupplier getScorerSupplier(LeafReader reader, PointValues values, final Weight weight) throws IOException {
                if (XLatLonShapeQuery.this.queryRelation == XLatLonShape.QueryRelation.INTERSECTS) {
                    return this.getIntersectScorerSupplier(reader, values, weight);
                }
                final FixedBitSet intersect = new FixedBitSet(reader.maxDoc());
                final FixedBitSet disjoint = new FixedBitSet(reader.maxDoc());
                PointValues.IntersectVisitor visitor = this.getDenseIntersectVisitor(intersect, disjoint);
                return new RelationScorerSupplier(values, visitor){

                    public Scorer get(long leadCost) throws IOException {
                        return this.getScorer(XLatLonShapeQuery.this, weight, intersect, disjoint, this.score());
                    }
                };
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(XLatLonShapeQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(XLatLonShapeQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                boolean allDocsMatch = true;
                if (values.getDocCount() != reader.maxDoc() || XLatLonShapeQuery.this.relateRangeToQuery(values.getMinPackedValue(), values.getMaxPackedValue()) != PointValues.Relation.CELL_INSIDE_QUERY) {
                    allDocsMatch = false;
                }
                1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier((Weight)weight, reader){
                        final /* synthetic */ Weight val$weight;
                        final /* synthetic */ LeafReader val$reader;
                        {
                            this.val$weight = weight;
                            this.val$reader = leafReader;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(this.val$weight, this.score(), DocIdSetIterator.all((int)this.val$reader.maxDoc()));
                        }

                        public long cost() {
                            return this.val$reader.maxDoc();
                        }
                    };
                }
                return this.getScorerSupplier(reader, values, (Weight)weight);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public XLatLonShape.QueryRelation getQueryRelation() {
        return this.queryRelation;
    }

    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.queryRelation.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(o);
    }

    protected boolean equalsTo(Object o) {
        return Objects.equals(this.field, ((XLatLonShapeQuery)((Object)o)).field) && this.queryRelation == ((XLatLonShapeQuery)((Object)o)).queryRelation;
    }

    private static PointValues.Relation transposeRelation(PointValues.Relation r) {
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static abstract class RelationScorerSupplier
    extends ScorerSupplier {
        PointValues values;
        PointValues.IntersectVisitor visitor;
        long cost = -1L;

        RelationScorerSupplier(PointValues values, PointValues.IntersectVisitor visitor) {
            this.values = values;
            this.visitor = visitor;
        }

        private PointValues.IntersectVisitor getInverseIntersectVisitor(final XLatLonShapeQuery query, final FixedBitSet result, final int[] cost) {
            return new PointValues.IntersectVisitor(){
                int[] scratchTriangle = new int[6];

                public void visit(int docID) {
                    result.clear(docID);
                    cost[0] = cost[0] - 1;
                }

                public void visit(int docID, byte[] packedTriangle) {
                    if (!query.queryMatches(packedTriangle, this.scratchTriangle)) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1;
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return XLatLonShapeQuery.transposeRelation(query.relateRangeToQuery(minPackedValue, maxPackedValue));
                }
            };
        }

        protected Scorer getIntersectsScorer(XLatLonShapeQuery query, LeafReader reader, Weight weight, DocIdSetBuilder docIdSetBuilder, float boost) throws IOException {
            if (this.values.getDocCount() == reader.maxDoc() && (long)this.values.getDocCount() == this.values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                result.set(0, reader.maxDoc());
                int[] cost = new int[]{reader.maxDoc()};
                this.values.intersect(this.getInverseIntersectVisitor(query, result, cost));
                BitSetIterator iterator = new BitSetIterator((BitSet)result, (long)cost[0]);
                return new ConstantScoreScorer(weight, boost, (DocIdSetIterator)iterator);
            }
            this.values.intersect(this.visitor);
            DocIdSetIterator iterator = docIdSetBuilder.build().iterator();
            return new ConstantScoreScorer(weight, boost, iterator);
        }

        protected Scorer getScorer(XLatLonShapeQuery query, Weight weight, FixedBitSet intersect, FixedBitSet disjoint, float boost) throws IOException {
            BitSetIterator iterator;
            this.values.intersect(this.visitor);
            if (query.queryRelation == XLatLonShape.QueryRelation.DISJOINT) {
                disjoint.andNot(intersect);
                iterator = new BitSetIterator((BitSet)disjoint, this.cost());
            } else if (query.queryRelation == XLatLonShape.QueryRelation.WITHIN) {
                intersect.andNot(disjoint);
                iterator = new BitSetIterator((BitSet)intersect, this.cost());
            } else {
                iterator = new BitSetIterator((BitSet)intersect, this.cost());
            }
            return new ConstantScoreScorer(weight, boost, (DocIdSetIterator)iterator);
        }

        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.values.estimatePointCount(this.visitor);
                assert (this.cost >= 0L);
            }
            return this.cost;
        }
    }
}

