/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.stats.dao.impl;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kew.stats.Stats;
import org.kuali.rice.kew.stats.dao.StatsDAO;

public class StatsDaoJpa
implements StatsDAO {
    public static final String STATS_DOCUMENTS_ROUTED_REPORT = "select count(drhv) as cnt, drhv.docRouteStatus from DocumentRouteHeaderValue drhv where drhv.createDate between :beginDate and :endDate group by drhv.docRouteStatus";
    public static final String STATS_NUM_ACTIVE_ITEMS_REPORT = "select count(ai) from ActionItem ai";
    public static final String STATS_NUM_INITIATED_DOCS_BY_DOC_TYPE_REPORT = "select count(drhv), dt.name from DocumentRouteHeaderValue drhv, DocumentType dt where drhv.createDate > :createDate and drhv.documentTypeId = dt.documentTypeId group by dt.name";
    public static final String STATS_NUM_USERS_REPORT = "select count(distinct(uo.workflowId)) from UserOptions uo";
    public static final String STATS_NUM_DOC_TYPES_REPORT = "select count(dt) from DocumentType dt where dt.currentInd = true";
    private EntityManager entityManager;

    @Override
    public void DocumentsRoutedReport(Stats stats, Date begDate, Date endDate) throws SQLException {
        Query query = this.getEntityManager().createQuery(STATS_DOCUMENTS_ROUTED_REPORT);
        query.setParameter("beginDate", (Object)new Timestamp(begDate.getTime()));
        query.setParameter("endDate", (Object)new Timestamp(endDate.getTime()));
        List resultList = query.getResultList();
        for (Object[] result : resultList) {
            String actionType = result[1].toString();
            String number = result[0].toString();
            if (actionType.equals("X")) {
                stats.setCanceledNumber(number);
                continue;
            }
            if (actionType.equals("D")) {
                stats.setDisapprovedNumber(number);
                continue;
            }
            if (actionType.equals("R")) {
                stats.setEnrouteNumber(number);
                continue;
            }
            if (actionType.equals("E")) {
                stats.setExceptionNumber(number);
                continue;
            }
            if (actionType.equals("F")) {
                stats.setFinalNumber(number);
                continue;
            }
            if (actionType.equals("I")) {
                stats.setInitiatedNumber(number);
                continue;
            }
            if (actionType.equals("P")) {
                stats.setProcessedNumber(number);
                continue;
            }
            if (!actionType.equals("S")) continue;
            stats.setSavedNumber(number);
        }
    }

    @Override
    public void NumActiveItemsReport(Stats stats) throws SQLException {
        stats.setNumActionItems(this.getEntityManager().createQuery(STATS_NUM_ACTIVE_ITEMS_REPORT).getSingleResult().toString());
    }

    @Override
    public void NumInitiatedDocsByDocTypeReport(Stats stats) throws SQLException {
        Query query = this.getEntityManager().createQuery(STATS_NUM_INITIATED_DOCS_BY_DOC_TYPE_REPORT);
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -29);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        query.setParameter("createDate", (Object)new Timestamp(calendar.getTime().getTime()));
        List resultList = query.getResultList();
        ArrayList<ConcreteKeyValue> numDocs = new ArrayList<ConcreteKeyValue>(resultList.size());
        for (Object[] result : resultList) {
            numDocs.add(new ConcreteKeyValue(result[1].toString(), result[0].toString()));
        }
        stats.setNumInitiatedDocsByDocType(numDocs);
    }

    @Override
    public void NumUsersReport(Stats stats) throws SQLException {
        stats.setNumUsers(this.getEntityManager().createQuery(STATS_NUM_USERS_REPORT).getSingleResult().toString());
    }

    @Override
    public void NumberOfDocTypesReport(Stats stats) throws SQLException {
        stats.setNumDocTypes(this.getEntityManager().createQuery(STATS_NUM_DOC_TYPES_REPORT).getSingleResult().toString());
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

