/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.foreigntravel;

import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AddAwardApprovedForeignTravelRuleEvent;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRule;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardApprovedForeignTravelRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardApprovedForeignTravelRule {
    private static final String NEW_TRAVEL_BASE = "approvedForeignTravelBean.newApprovedForeignTravel.";
    private static final String TRAVELER_NAME_PROPERTY = "approvedForeignTravelBean.newApprovedForeignTravel.travelerName";
    private static final String DESTINATION_PROPERTY = "approvedForeignTravelBean.newApprovedForeignTravel.destination";
    private static final String START_DATE_PROPERTY = "approvedForeignTravelBean.newApprovedForeignTravel.startDate";
    private static final String END_DATE_PROPERTY = "approvedForeignTravelBean.newApprovedForeignTravel.endDate";
    private static final String AMOUNT_PROPERTY = "approvedForeignTravelBean.newApprovedForeignTravel.amount";
    private static final String TRAVELER_NAME_ERROR_PARM = "Traveler Name";
    private static final String DESTINATION_ERROR_PARM = "Destination";
    private static final String START_DATE_ERROR_PARM = "Start Date";
    private static final String END_DATE_ERROR_PARM = "End Date";
    private static final String AMOUNT_ERROR_PARM = "Amount";

    @Override
    public boolean processAwardApprovedForeignTravelBusinessRules(AwardApprovedForeignTravelRuleEvent event) {
        return this.processCommonValidations("approvedForeignTravel", event);
    }

    public boolean processAddAwardApprovedForeignTravelBusinessRules(AddAwardApprovedForeignTravelRuleEvent event) {
        AwardApprovedForeignTravel foreignTravel = event.getForeignTravelForValidation();
        return this.isAmountValid(event.getErrorPathPrefix(), foreignTravel) & this.areRequiredFieldsComplete(foreignTravel) & this.processCommonValidations(NEW_TRAVEL_BASE, event);
    }

    private boolean processCommonValidations(String errorPath, AwardApprovedForeignTravelRuleEvent event) {
        AwardApprovedForeignTravel foreignTravel = event.getForeignTravelForValidation();
        boolean valid = this.isEndDateOnOrAfterStartDate(event);
        List<AwardApprovedForeignTravel> trips = event.getAward().getApprovedForeignTravelTrips();
        return valid &= this.isUnique(errorPath, trips, foreignTravel);
    }

    private boolean isEndDateOnOrAfterStartDate(AwardApprovedForeignTravelRuleEvent event) {
        boolean valid;
        AwardApprovedForeignTravel trip = event.getForeignTravelForValidation();
        Date startDate = trip.getStartDate();
        Date endDate = trip.getEndDate();
        if (startDate != null && endDate != null) {
            boolean bl = valid = !endDate.before(startDate);
            if (!valid) {
                this.reportError(END_DATE_PROPERTY, "error.award.approvedforeigntravel.enddate.before.startdate", END_DATE_ERROR_PARM);
            }
        } else {
            valid = true;
        }
        return valid;
    }

    boolean isUnique(String errorPath, List<AwardApprovedForeignTravel> foreignTravelTrips, AwardApprovedForeignTravel foreignTravelTrip) {
        AwardApprovedForeignTravel listItem;
        boolean duplicateFound = false;
        Iterator<AwardApprovedForeignTravel> iterator = foreignTravelTrips.iterator();
        while (iterator.hasNext() && !(duplicateFound = foreignTravelTrip != (listItem = iterator.next()) && listItem.equals(foreignTravelTrip))) {
        }
        if (duplicateFound && !this.hasDuplicateErrorBeenReported()) {
            this.reportError(errorPath, "error.award.approvedforeigntravel.duplicaterow", null);
        }
        return !duplicateFound;
    }

    boolean areRequiredFieldsComplete(AwardApprovedForeignTravel foreignTravelTrip) {
        boolean amountValid;
        boolean startDateValid;
        boolean destinationValid;
        boolean travelerNameValid;
        boolean bl = travelerNameValid = !StringUtils.isEmpty((CharSequence)foreignTravelTrip.getTravelerName());
        if (!travelerNameValid) {
            this.reportError(TRAVELER_NAME_PROPERTY, "error.award.approvedforeigntravel.field.invalid", TRAVELER_NAME_ERROR_PARM);
        }
        boolean bl2 = destinationValid = !StringUtils.isEmpty((CharSequence)foreignTravelTrip.getDestination());
        if (!destinationValid) {
            this.reportError(DESTINATION_PROPERTY, "error.award.approvedforeigntravel.field.invalid", DESTINATION_ERROR_PARM);
        }
        boolean bl3 = startDateValid = foreignTravelTrip.getStartDate() != null;
        if (!startDateValid) {
            this.reportError(START_DATE_PROPERTY, "error.award.approvedforeigntravel.field.invalid", START_DATE_ERROR_PARM);
        }
        boolean bl4 = amountValid = foreignTravelTrip.getAmount() != null;
        if (!amountValid) {
            this.reportError(AMOUNT_PROPERTY, "error.award.approvedforeigntravel.field.invalid", AMOUNT_ERROR_PARM);
        }
        return travelerNameValid && destinationValid && startDateValid && amountValid;
    }

    boolean isAmountValid(String errorPath, AwardApprovedForeignTravel foreignTrip) {
        boolean amountValid;
        ScaleTwoDecimal amount = foreignTrip.getAmount();
        boolean bl = amountValid = amount != null && amount.doubleValue() >= 0.0;
        if (!amountValid) {
            this.reportError(AMOUNT_PROPERTY, "error.award.approvedforeigntravel.field.invalid", AMOUNT_ERROR_PARM);
        }
        return amountValid;
    }

    private boolean hasDuplicateErrorBeenReported() {
        return GlobalVariables.getMessageMap().containsMessageKey("error.award.approvedforeigntravel.duplicaterow");
    }
}

