/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class LifecyclePolicyMetadata
implements ToXContentObject {
    static final ParseField POLICY = new ParseField("policy", new String[0]);
    static final ParseField VERSION = new ParseField("version", new String[0]);
    static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    public static final ConstructingObjectParser<LifecyclePolicyMetadata, String> PARSER = new ConstructingObjectParser("policy_metadata", a -> {
        LifecyclePolicy policy = (LifecyclePolicy)a[0];
        return new LifecyclePolicyMetadata(policy, (Long)a[1], ZonedDateTime.parse((String)a[2]).toInstant().toEpochMilli());
    });
    private final LifecyclePolicy policy;
    private final long version;
    private final long modifiedDate;

    public static LifecyclePolicyMetadata parse(XContentParser parser, String name) {
        return (LifecyclePolicyMetadata)PARSER.apply(parser, (Object)name);
    }

    public LifecyclePolicyMetadata(LifecyclePolicy policy, long version, long modifiedDate) {
        this.policy = policy;
        this.version = version;
        this.modifiedDate = modifiedDate;
    }

    public LifecyclePolicy getPolicy() {
        return this.policy;
    }

    public String getName() {
        return this.policy.getName();
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public String getModifiedDateString() {
        ZonedDateTime modifiedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.modifiedDate), ZoneOffset.UTC);
        return modifiedDateTime.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY.getPreferredName(), (ToXContent)this.policy);
        builder.field(VERSION.getPreferredName(), this.version);
        builder.field(MODIFIED_DATE.getPreferredName(), ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.modifiedDate), ZoneOffset.UTC).toString());
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.version, this.modifiedDate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LifecyclePolicyMetadata other = (LifecyclePolicyMetadata)obj;
        return Objects.equals(this.policy, other.policy) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), LifecyclePolicy::parse, POLICY);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODIFIED_DATE);
    }
}

