/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import com.codiform.moo.curry.Translate;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import org.kuali.coeus.award.api.AwardResults;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudMapBasedRestController;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.SearchResults;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.home.Award;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class AwardControllerVersion1
extends SimpleCrudMapBasedRestController<Award> {
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;

    @RequestMapping(params={"summary"}, method={RequestMethod.GET})
    @ResponseBody
    public AwardResults getAwardSummary(@RequestParam(value="updatedSince", required=false) Instant updatedSince, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="limit", required=false) Integer limit) {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        AwardResults result = (AwardResults)Translate.to(AwardResults.class).from(this.getAwards(updatedSince == null ? null : Date.from(updatedSince), page, limit));
        if (result == null || result.getCount() == null || result.getCount() == 0) {
            throw new ResourceNotFoundException("not found");
        }
        return result;
    }

    SearchResults<Award> getAwards(Date updatedSince, Integer page, Integer numberPerPage) {
        return this.getAwardDao().retrieveActiveAwardsByCriteria(new HashMap<String, Object>(), updatedSince, page, numberPerPage);
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }

    public void setAwardDao(AwardDao awardDao) {
        this.awardDao = awardDao;
    }
}

