/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.elasticsearch.ElasticsearchAccessControlService;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable(autowire=Autowire.BY_TYPE)
public class ElasticsearchAccessControlServiceImpl
implements ElasticsearchAccessControlService {
    private static final String DEFAULT_KIM_TYPE = "1";
    @Autowired
    private GroupService groupService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private List<ElasticsearchDocumentSerializer> serializers;
    @Autowired
    private UnitService unitService;

    @Override
    public Set<String> getDocumentViewers(DocumentLevelPermissionable document, Collection<String> viewPerms) {
        if (document == null || CollectionUtils.isEmpty(viewPerms)) {
            return Collections.emptySet();
        }
        boolean skipDefaultAndUnitRoles = this.parameterService.getParameterValueAsBoolean("KC-SYS", "All", "Elasticsearch_Index_Skip_Default_And_Unit_Roles", Boolean.valueOf(false));
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put(document.getDocumentKey(), document.getDocumentNumberForPermission());
        qualifiers.put("documentNumber", document.getDocumentNumber());
        if (!skipDefaultAndUnitRoles) {
            qualifiers.put("unitNumber", document.getLeadUnitNumber());
        }
        KimTypePartitionedRoleIds viewRoles = this.getRoleIdsForPermissionPartitionedByDefaultKimType(document.getNamespace(), viewPerms);
        Stream defaultMemberships = skipDefaultAndUnitRoles ? Stream.empty() : this.roleService.getRoleMembers(viewRoles.getQualifiedRoleIds(), qualifiers).stream();
        return Stream.concat(defaultMemberships, this.roleService.getRoleMembers(viewRoles.getDefaultRoleIds(), Collections.emptyMap()).stream()).filter(this::isMembershipActive).flatMap(membership -> this.getMembershipPrincipalIds(membership.getType(), membership.getMemberId(), new HashSet<String>())).collect(Collectors.toSet());
    }

    protected boolean isMembershipActive(RoleMembership membership) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startDate = membership.getActiveFromDate() != null ? membership.getActiveFromDate().toLocalDateTime() : null;
        LocalDateTime endDate = membership.getActiveToDate() != null ? membership.getActiveToDate().toLocalDateTime() : null;
        boolean hasStarted = startDate == null || startDate.isBefore((ReadablePartial)now);
        boolean hasEnded = endDate != null && endDate.isBefore((ReadablePartial)now);
        return hasStarted && !hasEnded;
    }

    protected Stream<String> getMembershipPrincipalIds(MemberType memberType, String memberId, Set<String> visitedGroupIds) {
        if (memberType != MemberType.GROUP) {
            return Stream.of(memberId);
        }
        if (visitedGroupIds.contains(memberId)) {
            return Stream.empty();
        }
        List members = this.groupService.getMembers(List.of(memberId));
        members.forEach(member -> visitedGroupIds.add(member.getMemberId()));
        return members.stream().flatMap(member -> this.getMembershipPrincipalIds(member.getType(), member.getMemberId(), visitedGroupIds));
    }

    @Override
    public Map<String, Set<String>> getViewableUnitsForUser(String userId) {
        Set allUnits = this.unitService.getUnits().stream().map(Unit::getUnitNumber).collect(Collectors.toSet());
        return this.serializers.stream().map(serializer -> this.getUnitsForSerializer((ElasticsearchDocumentSerializer)serializer, userId, allUnits)).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
    }

    protected Map.Entry<String, Set<String>> getUnitsForSerializer(ElasticsearchDocumentSerializer serializer, String userId, Set<String> allUnits) {
        KimTypePartitionedRoleIds viewRoles = this.getRoleIdsForPermissionPartitionedByDefaultKimType(serializer.getNamespace(), serializer.getViewPermissions());
        if (this.roleService.principalHasRole(userId, viewRoles.getDefaultRoleIds(), Map.of())) {
            return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(serializer.getNamespace(), allUnits);
        }
        return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(serializer.getNamespace(), allUnits.stream().filter(unitNumber -> this.roleService.principalHasRole(userId, viewRoles.getQualifiedRoleIds(), Map.of("unitNumber", unitNumber))).collect(Collectors.toSet()));
    }

    protected KimTypePartitionedRoleIds getRoleIdsForPermissionPartitionedByDefaultKimType(String namespace, Collection<String> viewPerms) {
        Set viewRoles = viewPerms.stream().flatMap(perm -> this.permissionService.getRoleIdsForPermission(namespace, perm).stream()).collect(Collectors.toSet());
        List<String> defaultViewRoles = this.roleService.getRoles(new ArrayList(viewRoles)).stream().filter(role -> DEFAULT_KIM_TYPE.equals(role.getKimTypeId())).map(Role::getId).collect(Collectors.toList());
        List<String> qualifiedViewRoles = viewRoles.stream().filter(roleId -> !defaultViewRoles.contains(roleId)).collect(Collectors.toList());
        return new KimTypePartitionedRoleIds(defaultViewRoles, qualifiedViewRoles);
    }

    private static final class KimTypePartitionedRoleIds {
        private final List<String> defaultRoleIds;
        private final List<String> qualifiedRoleIds;

        protected KimTypePartitionedRoleIds(List<String> defaultRoleIds, List<String> qualifiedRoleIds) {
            this.defaultRoleIds = defaultRoleIds;
            this.qualifiedRoleIds = qualifiedRoleIds;
        }

        public List<String> getDefaultRoleIds() {
            return this.defaultRoleIds;
        }

        public List<String> getQualifiedRoleIds() {
            return this.qualifiedRoleIds;
        }
    }
}

