/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.participant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.participant.ParticipantType;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KeyValuesService;

public class ParticipantTypeValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private static final long serialVersionUID = 6315943281880005921L;

    public List<KeyValue> getKeyValues() {
        ProtocolDocument doc = (ProtocolDocument)this.getDocument();
        KeyValuesService keyValuesService = (KeyValuesService)KcServiceLocator.getService("keyValuesService");
        Collection participantTypes = keyValuesService.findAll(ParticipantType.class);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        for (ParticipantType participantType : participantTypes) {
            if (this.hasParticipant(doc, participantType)) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(participantType.getParticipantTypeCode(), participantType.getDescription()));
        }
        return keyValues;
    }

    private boolean hasParticipant(ProtocolDocument doc, ParticipantType participantType) {
        if (doc != null) {
            List<ProtocolParticipant> protocolParticipants = doc.getProtocol().getProtocolParticipants();
            for (ProtocolParticipant protocolParticipant : protocolParticipants) {
                if (!protocolParticipant.getParticipantTypeCode().equals(participantType.getParticipantTypeCode())) continue;
                return true;
            }
        }
        return false;
    }
}

