/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class PropertySources {
    private static final Logger logger = LogManager.getLogger(PropertySources.class);

    public static Optional<PropertySource<?>> getPropertySource(ServletContextEvent sce, String key) {
        Optional<String> annotatedClass = PropertySources.getProperty(sce, key);
        if (annotatedClass.isPresent()) {
            AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
            context.setServletContext(sce.getServletContext());
            PropertySource<?> propertySource = PropertySources.getPropertySource((String)annotatedClass.get(), context);
            return Optional.of(propertySource);
        }
        return Optional.absent();
    }

    public static void addFirst(ConfigurableApplicationContext context, PropertySource<?> propertySource) {
        ConfigurableEnvironment env = context.getEnvironment();
        MutablePropertySources propertySources = env.getPropertySources();
        propertySources.addFirst(propertySource);
    }

    protected static PropertySource<?> getPropertySource(String className, AnnotationConfigWebApplicationContext context) {
        try {
            logger.info("Loading [{}] to setup a Spring property source", (Object)className);
            Class<?> annotatedClass = Class.forName(className);
            context.register(new Class[]{annotatedClass});
            context.refresh();
            PropertySource<?> propertySource = PropertySources.getPropertySource((ListableBeanFactory)context, annotatedClass);
            context.close();
            logger.info("Spring property source was successfully setup");
            return propertySource;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error configuring Spring property source", e);
        }
    }

    protected static PropertySource<?> getPropertySource(ListableBeanFactory factory, Class<?> annotatedClass) {
        Collection collection = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)factory, PropertySource.class).values();
        PropertySources.checkSizeEqualsOne(collection, annotatedClass);
        return (PropertySource)collection.iterator().next();
    }

    protected static void checkSizeEqualsOne(Collection<?> collection, Class<?> annotatedClass) {
        Object[] args = new Object[]{annotatedClass.getCanonicalName(), collection.size()};
        String errorMessage = "[%s] contained %s property source beans.  There must always be exactly 1 property source bean";
        Preconditions.checkState((collection.size() == 1 ? 1 : 0) != 0, (String)errorMessage, (Object[])args);
    }

    public static Optional<String> getProperty(ServletContextEvent sce, String key) {
        Preconditions.checkNotNull((Object)key, (Object)"'key' cannot be null");
        String sys = System.getProperty(key);
        if (!StringUtils.isBlank((String)sys)) {
            logger.info("Found [{}] defined in system properties: [{}]", (Object)key, (Object)sys);
            return Optional.of((Object)sys);
        }
        String web = sce.getServletContext().getInitParameter(key);
        if (StringUtils.isBlank((String)web) || PropertySources.isPlaceHolder(web)) {
            return Optional.absent();
        }
        logger.info("Found [{}] defined in servlet context: [{}]", (Object)key, (Object)web);
        return Optional.of((Object)web);
    }

    public static Properties convert(ServletContext context) {
        Properties properties = new Properties();
        Enumeration paramNames = context.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            properties.put(paramName, context.getInitParameter(paramName));
        }
        return properties;
    }

    protected static boolean isPlaceHolder(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"'value' cannot be null");
        return value.startsWith("${") && value.endsWith("}");
    }
}

