/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.country;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryQueryResults;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="CountryService", targetNamespace="http://rice.kuali.org/location/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface CountryService {
    @WebMethod(operationName="getCountry")
    @WebResult(name="country")
    @Cacheable(value={"http://rice.kuali.org/location/v2_0/CountryType"}, key="'code=' + #p0")
    public Country getCountry(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getCountryByAlternateCode")
    @WebResult(name="country")
    @Cacheable(value={"http://rice.kuali.org/location/v2_0/CountryType"}, key="'alternateCode=' + #p0")
    public Country getCountryByAlternateCode(@WebParam(name="alternateCode") String var1) throws RiceIllegalStateException, RiceIllegalArgumentException;

    @WebMethod(operationName="findAllCountriesNotRestricted")
    @XmlElementWrapper(name="countriesNotRestricted", required=false)
    @XmlElement(name="countryNotRestricted", required=false)
    @WebResult(name="countriesNotRestricted")
    @Cacheable(value={"http://rice.kuali.org/location/v2_0/CountryType"}, key="'allRestricted'")
    public List<Country> findAllCountriesNotRestricted();

    @WebMethod(operationName="findAllCountries")
    @XmlElementWrapper(name="countries", required=false)
    @XmlElement(name="country", required=false)
    @WebResult(name="countries")
    @Cacheable(value={"http://rice.kuali.org/location/v2_0/CountryType"}, key="'all'")
    public List<Country> findAllCountries();

    @WebMethod(operationName="getDefaultCountry")
    @WebResult(name="country")
    @Cacheable(value={"http://rice.kuali.org/location/v2_0/CountryType"}, key="'default'")
    public Country getDefaultCountry();

    @WebMethod(operationName="findCountries")
    @WebResult(name="results")
    public CountryQueryResults findCountries(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;
}

