/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Oracle9iLobHandler;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformOracleImpl;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformOracle9iImpl
extends PlatformOracleImpl {
    private Logger logger = LoggerFactory.getLogger(PlatformOracle9iImpl.class);
    protected static final int STATEMENT_CACHE_SIZE = 10;
    protected static final int ROW_PREFETCH_SIZE = 20;
    protected static final int STATEMENTS_PER_BATCH = 20;
    protected static Map m_batchStatementsInProgress = Collections.synchronizedMap(new WeakHashMap(20));
    protected static final Class[] PARAM_TYPE_EMPTY = new Class[0];
    protected static final Class[] PARAM_TYPE_INTEGER = new Class[]{Integer.TYPE};
    protected static final Class[] PARAM_TYPE_BOOLEAN = new Class[]{Boolean.TYPE};
    protected static final Class[] PARAM_TYPE_STRING = new Class[]{String.class};
    protected static final Object[] PARAM_EMPTY = new Object[0];
    protected static final Object[] PARAM_STATEMENT_CACHE_SIZE = new Object[]{new Integer(10)};
    protected static final Object[] PARAM_ROW_PREFETCH_SIZE = new Object[]{new Integer(20)};
    protected static final Object[] PARAM_STATEMENT_BATCH_SIZE = new Object[]{new Integer(20)};
    protected static final Object[] PARAM_BOOLEAN_TRUE = new Object[]{Boolean.TRUE};
    protected static final String JBOSS_CONN_NAME = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    protected static Class JBOSS_CONN_CLASS = null;
    protected static Class ORA_CONN_CLASS;
    protected static Class ORA_PS_CLASS;
    protected static Class ORA_CLOB_CLASS;
    protected static Class ORA_BLOB_CLASS;
    protected static Class[] PARAM_TYPE_INT_ORACLOB;
    protected static Class[] PARAM_TYPE_INT_ORABLOB;
    protected static Method METHOD_SET_STATEMENT_CACHE_SIZE;
    protected static Method METHOD_SET_IMPLICIT_CACHING_ENABLED;
    protected static Method METHOD_SET_ROW_PREFETCH;
    protected static Method METHOD_SET_BLOB;
    protected static Method METHOD_SET_CLOB;
    protected static boolean ORA_STATEMENT_CACHING_AVAILABLE;
    protected static boolean ORA_ROW_PREFETCH_AVAILABLE;
    protected static boolean ORA_CLOB_HANDLING_AVAILABLE;
    protected static boolean ORA_BLOB_HANDLING_AVAILABLE;
    protected static final String[] UNWRAP_CONN_METHOD_NAMES;
    protected static final Class[][] UNWRAP_CONN_PARAM_TYPES;
    protected static final String[] UNWRAP_PS_METHOD_NAMES;
    protected static final Class[][] UNWRAP_PS_PARAM_TYPES;

    @Override
    public void initializeJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws PlatformException {
        block11: {
            ConnectionPoolDescriptor connectionPoolDescriptor;
            int n;
            Connection connection2;
            Class<?> clazz;
            block10: {
                super.initializeJdbcConnection(jdbcConnectionDescriptor, connection);
                clazz = connection.getClass();
                if (JBOSS_CONN_CLASS != null && JBOSS_CONN_CLASS.isAssignableFrom(clazz)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("JBoss detected, Oracle Connection tuning left to J2EE container.");
                    }
                    return;
                }
                connection2 = this.unwrapConnection(connection);
                if (connection2 == null) {
                    return;
                }
                if (ORA_STATEMENT_CACHING_AVAILABLE) {
                    try {
                        METHOD_SET_STATEMENT_CACHE_SIZE.invoke((Object)connection2, PARAM_STATEMENT_CACHE_SIZE);
                        METHOD_SET_IMPLICIT_CACHING_ENABLED.invoke((Object)connection2, PARAM_BOOLEAN_TRUE);
                    }
                    catch (Exception exception) {
                        if (!this.logger.isDebugEnabled()) break block10;
                        this.logger.debug("PlatformOracle9iImpl could not enable Oracle statement caching. Original/unwrapped connection classes=" + clazz.getName() + "/" + connection2.getClass().getName());
                    }
                }
            }
            if ((n = (connectionPoolDescriptor = jdbcConnectionDescriptor.getConnectionPoolDescriptor()).getFetchSize()) == 0 && ORA_ROW_PREFETCH_AVAILABLE) {
                try {
                    String string = connectionPoolDescriptor.getJdbcProperties().getProperty("defaultRowPrefetch");
                    if (string == null) {
                        METHOD_SET_ROW_PREFETCH.invoke((Object)connection2, PARAM_ROW_PREFETCH_SIZE);
                    }
                }
                catch (Exception exception) {
                    if (!this.logger.isDebugEnabled()) break block11;
                    this.logger.debug("PlatformOracle9iImpl could not enable Oracle row pre-fetching.Original/unwrapped connection classes=" + clazz.getName() + "/" + connection2.getClass().getName());
                }
            }
        }
    }

    @Override
    public void afterStatementCreate(Statement statement) {
    }

    @Override
    public void beforeBatch(PreparedStatement preparedStatement) throws PlatformException {
        boolean bl;
        Method method = ClassHelper.getMethod(preparedStatement, "setExecuteBatch", PARAM_TYPE_INTEGER);
        Method method2 = ClassHelper.getMethod(preparedStatement, "sendBatch", null);
        boolean bl2 = bl = method != null && method2 != null;
        if (bl) {
            try {
                method.invoke((Object)preparedStatement, PARAM_STATEMENT_BATCH_SIZE);
                m_batchStatementsInProgress.put(preparedStatement, method2);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        } else {
            super.beforeBatch(preparedStatement);
        }
    }

    @Override
    public void addBatch(PreparedStatement preparedStatement) throws PlatformException {
        boolean bl = m_batchStatementsInProgress.containsKey(preparedStatement);
        if (bl) {
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new PlatformException(sQLException.getLocalizedMessage(), sQLException);
            }
        } else {
            super.addBatch(preparedStatement);
        }
    }

    @Override
    public int[] executeBatch(PreparedStatement preparedStatement) throws PlatformException {
        Method method = (Method)m_batchStatementsInProgress.remove(preparedStatement);
        boolean bl = method != null;
        int[] nArray = null;
        if (bl) {
            try {
                method.invoke((Object)preparedStatement, null);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        } else {
            nArray = super.executeBatch(preparedStatement);
        }
        return nArray;
    }

    @Override
    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        boolean bl;
        Connection connection;
        Statement statement;
        if (n2 == 2005 || n2 == 2004) {
            statement = this.unwrapStatement(preparedStatement);
            connection = this.unwrapConnection(preparedStatement.getConnection());
            bl = statement != null && connection != null && (n2 == 2005 ? ORA_CLOB_HANDLING_AVAILABLE : ORA_BLOB_HANDLING_AVAILABLE);
        } else {
            statement = null;
            connection = null;
            bl = false;
        }
        if ((n2 == -3 || n2 == -4) && object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            super.changePreparedStatementResultSetType(preparedStatement);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (n2 == -5 && object instanceof Integer) {
            preparedStatement.setLong(n, ((Integer)object).intValue());
        } else if (n2 == 4 && object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (n2 == 2005 && bl && object instanceof String) {
            try {
                Object object2 = Oracle9iLobHandler.createCLOBFromString(connection, (String)object);
                METHOD_SET_CLOB.invoke((Object)statement, new Integer(n), object2);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getLocalizedMessage());
            }
        } else if (n2 == 2004 && bl && object instanceof byte[]) {
            try {
                Object object3 = Oracle9iLobHandler.createBLOBFromByteArray(connection, (byte[])object);
                METHOD_SET_BLOB.invoke((Object)statement, new Integer(n), object3);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getLocalizedMessage());
            }
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    @Override
    public byte getJoinSyntaxType() {
        return 1;
    }

    protected Connection unwrapConnection(Connection connection) {
        Object object;
        block4: {
            object = this.genericUnwrap(ORA_CONN_CLASS, connection, UNWRAP_CONN_METHOD_NAMES, UNWRAP_CONN_PARAM_TYPES);
            try {
                Connection connection2;
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData != null && (connection2 = databaseMetaData.getConnection()) != connection) {
                    object = this.genericUnwrap(ORA_CONN_CLASS, connection2, UNWRAP_CONN_METHOD_NAMES, UNWRAP_CONN_PARAM_TYPES);
                }
            }
            catch (SQLException sQLException) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("Failed attempting to unwrap connection via database metadata.", sQLException);
            }
        }
        if (object == null && this.logger.isDebugEnabled()) {
            this.logger.debug("PlatformOracle9iImpl could not unwrap " + connection.getClass().getName() + ", Oracle-extensions disabled.");
        }
        return (Connection)object;
    }

    protected Statement unwrapStatement(Statement statement) {
        Object object = this.genericUnwrap(ORA_PS_CLASS, statement, UNWRAP_PS_METHOD_NAMES, UNWRAP_PS_PARAM_TYPES);
        if (object == null && this.logger.isDebugEnabled()) {
            this.logger.debug("PlatformOracle9iImpl could not unwrap " + statement.getClass().getName() + ", large CLOB/BLOB support disabled.");
        }
        return (Statement)object;
    }

    protected Object genericUnwrap(Class clazz, Object object, String[] stringArray, Class[][] classArray) {
        block19: {
            if (clazz == null) {
                return null;
            }
            Object object2 = null;
            Class<?> clazz2 = object.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                return object;
            }
            try {
                Object object3;
                Object object4;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    Class[] classArray2 = classArray[i];
                    object4 = ClassHelper.getMethod(object, string, classArray2);
                    if (object4 != null) {
                        Object[] objectArray;
                        if (classArray2 == PARAM_TYPE_EMPTY) {
                            objectArray = PARAM_EMPTY;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = object;
                        }
                        Object[] objectArray3 = objectArray;
                        object2 = ((Method)object4).invoke(object, objectArray3);
                    } else {
                        object3 = ClassHelper.getField(clazz2, string);
                        if (object3 != null) {
                            object2 = ((Field)object3).get(object);
                        }
                    }
                    if (object2 == null) continue;
                    if (clazz.isAssignableFrom(object2.getClass())) {
                        return object2;
                    }
                    return this.genericUnwrap(clazz, object2, stringArray, classArray);
                }
                Method method = ClassHelper.getMethod(object, "unwrap", new Class[]{Class.class});
                if (method != null && !Modifier.isAbstract(method.getModifiers())) {
                    object4 = null;
                    if (Connection.class.isAssignableFrom(clazz)) {
                        object4 = Connection.class;
                    } else if (PreparedStatement.class.isAssignableFrom(clazz)) {
                        object4 = PreparedStatement.class;
                    } else if (Statement.class.isAssignableFrom(clazz)) {
                        object4 = Statement.class;
                    }
                    object3 = null;
                    if (object4 != null && (object3 = method.invoke(object, object4)) != null) {
                        if (clazz.isAssignableFrom(object3.getClass())) {
                            return object3;
                        }
                        return this.genericUnwrap(clazz, object3, stringArray, classArray);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) break block19;
                this.logger.debug("genericUnwrap failed", exception);
            }
        }
        return null;
    }

    @Override
    protected void initOracleReflectedVars() {
        super.initOracleReflectedVars();
        try {
            ORA_CONN_CLASS = ClassHelper.getClass("oracle.jdbc.OracleConnection", false);
            ORA_PS_CLASS = ClassHelper.getClass("oracle.jdbc.OraclePreparedStatement", false);
            ORA_CLOB_CLASS = ClassHelper.getClass("oracle.sql.CLOB", false);
            ORA_BLOB_CLASS = ClassHelper.getClass("oracle.sql.BLOB", false);
            PARAM_TYPE_INT_ORACLOB = new Class[]{Integer.TYPE, ORA_CLOB_CLASS};
            PARAM_TYPE_INT_ORABLOB = new Class[]{Integer.TYPE, ORA_BLOB_CLASS};
            PlatformOracle9iImpl.UNWRAP_CONN_PARAM_TYPES[0] = new Class[]{ORA_CONN_CLASS};
            METHOD_SET_STATEMENT_CACHE_SIZE = ClassHelper.getMethod(ORA_CONN_CLASS, "setStatementCacheSize", PARAM_TYPE_INTEGER);
            METHOD_SET_IMPLICIT_CACHING_ENABLED = ClassHelper.getMethod(ORA_CONN_CLASS, "setImplicitCachingEnabled", PARAM_TYPE_BOOLEAN);
            METHOD_SET_ROW_PREFETCH = ClassHelper.getMethod(ORA_CONN_CLASS, "setDefaultRowPrefetch", PARAM_TYPE_INTEGER);
            METHOD_SET_CLOB = ClassHelper.getMethod(ORA_PS_CLASS, "setCLOB", PARAM_TYPE_INT_ORACLOB);
            METHOD_SET_BLOB = ClassHelper.getMethod(ORA_PS_CLASS, "setBLOB", PARAM_TYPE_INT_ORABLOB);
            ORA_STATEMENT_CACHING_AVAILABLE = METHOD_SET_STATEMENT_CACHE_SIZE != null && METHOD_SET_IMPLICIT_CACHING_ENABLED != null;
            ORA_ROW_PREFETCH_AVAILABLE = METHOD_SET_ROW_PREFETCH != null;
            ORA_CLOB_HANDLING_AVAILABLE = METHOD_SET_CLOB != null;
            ORA_BLOB_HANDLING_AVAILABLE = METHOD_SET_BLOB != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            JBOSS_CONN_CLASS = ClassHelper.getClass(JBOSS_CONN_NAME, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static {
        METHOD_SET_BLOB = null;
        METHOD_SET_CLOB = null;
        UNWRAP_CONN_METHOD_NAMES = new String[]{"unwrapCompletely", "getInnermostDelegate", "getUnderlyingConnection", "getVendorConnection", "getJDBC"};
        UNWRAP_CONN_PARAM_TYPES = new Class[][]{null, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY};
        UNWRAP_PS_METHOD_NAMES = new String[]{"getInnermostDelegate", "getUnderlyingStatement", "getJDBC", "ps"};
        UNWRAP_PS_PARAM_TYPES = new Class[][]{PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY};
    }
}

