/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.rule.event.DeleteCommitteeScheduleEventBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

public abstract class DeleteCommitteeScheduleRuleBase
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<DeleteCommitteeScheduleEventBase> {
    private static final String ID = "document.committeeList[0].committeeSchedules[";

    @Override
    public boolean processRules(DeleteCommitteeScheduleEventBase deleteCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List<CommitteeScheduleBase> schedules = deleteCommitteeScheduleEvent.getCommitteeSchedules();
        Object activeCommittee = this.getCommitteeService().getCommitteeById(((CommitteeBase)((CommitteeDocumentBase)deleteCommitteeScheduleEvent.getDocument()).getCommittee()).getCommitteeId());
        if (activeCommittee != null) {
            int i = 0;
            for (CommitteeScheduleBase schedule : schedules) {
                if (schedule.isSelected() && this.canNotDelete(((CommitteeBase)activeCommittee).getCommitteeSchedules(), schedule.getScheduleId())) {
                    this.reportError(ID + i + "].selected", "error.committeeSchedule.delete", new String[0]);
                    rulePassed = false;
                }
                ++i;
            }
        }
        return rulePassed;
    }

    private boolean canNotDelete(List<CommitteeScheduleBase> schedules, String scheduleId) {
        boolean retVal = false;
        for (CommitteeScheduleBase committeeSchedule : schedules) {
            if (!StringUtils.equals((CharSequence)committeeSchedule.getScheduleId(), (CharSequence)scheduleId)) continue;
            retVal = committeeSchedule.hasMeetingData();
        }
        return retVal;
    }

    private CommitteeServiceBase getCommitteeService() {
        return KcServiceLocator.getService(this.getCommitteeServiceClassHook());
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook();
}

