/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.lookup.keyvalue;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.home.ContactType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubawardTemplateContactFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private static final Set<String> CONTACT_PARAMETERS = Stream.of("FDP_Sub_Financial_Contact_Code", "FDP_Prime_Authorized_Official_Code", "FDP_Sub_Administrative_Contact_Code", "FDP_Prime_Financial_Contact_Code", "FDP_Prime_Authorized_Official_Code", "FDP_Prime_Administrative_Contact_Code").collect(Collectors.toSet());
    public static final ConcreteKeyValue PI = new ConcreteKeyValue("-99", "Principal Investigator");

    public List<KeyValue> getKeyValues() {
        Set contactCodes = CONTACT_PARAMETERS.stream().map(paramName -> this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", paramName)).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toSet());
        Collection contactTypes = this.getBusinessObjectService().findAll(ContactType.class);
        return Stream.concat(Stream.of(ValuesFinderUtils.getSelectOption()), Stream.concat(contactTypes.stream().filter(contactType -> contactCodes.contains(contactType.getContactTypeCode())).map(contactType -> new ConcreteKeyValue(contactType.getContactTypeCode(), contactType.getDescription())), Stream.of(PI)).sorted(Comparator.comparing(KeyValue::getValue))).collect(Collectors.toList());
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    protected ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }
}

