/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentFormBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.service.AwardHierarchyUIService;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistributionBean;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.TransactionBean;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class TimeAndMoneyForm
extends KcTransactionalDocumentFormBase {
    private static final String DOCUMENT_STATUS = "documentStatus";
    private static final String ROOT_AWARD_NUMBER = "rootAwardNumber";
    public static final String COLUMN = ":";
    private static final int NUMBER_30 = 30;
    public static final String UPDATE_TIMESTAMP_DD_NAME = "DataDictionary.Award.attributes.updateTimestamp";
    public static final String SPONSOR_DD_NAME = "DataDictionary.Sponsor.attributes.sponsorName";
    private static final long serialVersionUID = 2737159069734793860L;
    private TransactionBean transactionBean;
    private AwardDirectFandADistributionBean awardDirectFandADistributionBean;
    private String goToAwardNumber;
    private List<String> order;
    private List<String> obligationStartDates;
    private List<String> obligationExpirationDates;
    private List<String> finalExpirationDates;
    private List<AwardHierarchyNode> awardHierarchyNodeItems;
    private String awardHierarchy;
    private String awardNumber;
    private String addRA;
    private String deletedRas;
    private String controlForAwardHierarchyView;
    private String currentOrPendingView;
    private String directIndirectViewEnabled;
    private Map<String, String> previousNodeMap;
    private Map<String, String> nextNodeMap;
    private Award awardForSummaryPanelDisplay;
    private transient ParameterService parameterService;
    private transient KcPersonService kcPersonService;
    private String currentAwardNumber;
    private String currentSeqNumber;
    private Map<String, String> awardHierarchyToggle;
    private String awardHierarchyScrollPosition;
    public static final String PENDING = "1";
    public static final String CURRENT = "0";
    public static final String METHOD_TO_CALL_POST_TM = "methodToCall.postTimeAndMoney";
    public static final String POST_TM_ALT_TEXT = "Post time and money";
    public static final String BUTTONSMALL_POST_GIF = "buttonsmall_postawardbudget.gif";
    private List<String> fieldsInError;

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getCurrentSeqNumber() {
        return this.currentSeqNumber;
    }

    public void setCurrentSeqNumber(String currentSeqNumber) {
        this.currentSeqNumber = currentSeqNumber;
    }

    public TimeAndMoneyForm() {
        this.initialize();
    }

    public void initialize() {
        this.transactionBean = new TransactionBean(this);
        this.awardDirectFandADistributionBean = new AwardDirectFandADistributionBean(this);
        this.order = new ArrayList<String>();
        this.obligationStartDates = new AutoPopulatingList(String.class);
        this.obligationExpirationDates = new AutoPopulatingList(String.class);
        this.finalExpirationDates = new AutoPopulatingList(String.class);
        this.awardHierarchyNodeItems = new AutoPopulatingList(AwardHierarchyNode.class);
        this.setControlForAwardHierarchyView("2");
        this.setToCurrentView();
        this.setDirectIndirectViewEnabled(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"));
        this.previousNodeMap = new HashMap<String, String>();
        this.nextNodeMap = new HashMap<String, String>();
        this.awardHierarchyToggle = new TreeMap<String, String>();
        this.fieldsInError = new ArrayList<String>();
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "TimeAndMoneyDocument";
    }

    public void initializeFormOrDocumentBasedOnCommand() {
        if ("initiate".equals(this.getCommand())) {
            this.getTimeAndMoneyDocument().initialize();
        } else {
            this.initialize();
        }
    }

    protected String buildExtraButtonSourceURI(String buttonFileName) {
        return this.lookupKualiConfigurationService().getPropertyValueAsString("kra.externalizable.images.url") + buttonFileName;
    }

    @Override
    public void populate(HttpServletRequest request) {
        this.registerEditableProperty("controlForAwardHierarchyView");
        this.registerEditableProperty("currentOrPendingView");
        this.registerEditableProperty("directIndirectViewEnabled");
        super.populate(request);
    }

    public boolean isPropertyEditable(String propertyName) {
        if (propertyName.startsWith("awardHierarchyNodeItems[")) {
            return true;
        }
        return super.isPropertyEditable(propertyName);
    }

    public TimeAndMoneyDocument getTimeAndMoneyDocument() {
        return (TimeAndMoneyDocument)super.getDocument();
    }

    @Override
    protected String getLockRegion() {
        return "TIME_AND_MONEY";
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
    }

    public BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    public AwardVersionService getAwardVersionService() {
        return KcServiceLocator.getService(AwardVersionService.class);
    }

    public TransactionBean getTransactionBean() {
        return this.transactionBean;
    }

    public void setTransactionBean(TransactionBean transactionBean) {
        this.transactionBean = transactionBean;
    }

    public String getGoToAwardNumber() {
        return this.goToAwardNumber;
    }

    public void setGoToAwardNumber(String goToAwardNumber) {
        this.goToAwardNumber = goToAwardNumber;
    }

    public List<String> getOrder() {
        return this.order;
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    private AwardHierarchyUIService getAwardHierarchyUIService() {
        return KcServiceLocator.getService(AwardHierarchyUIService.class);
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public String getAddRA() {
        return this.addRA;
    }

    public void setAddRA(String addRA) {
        this.addRA = addRA;
    }

    public String getDeletedRas() {
        return this.deletedRas;
    }

    public void setDeletedRas(String deletedRas) {
        this.deletedRas = deletedRas;
    }

    public AwardDirectFandADistributionBean getAwardDirectFandADistributionBean() {
        return this.awardDirectFandADistributionBean;
    }

    public void setAwardDirectFandADistributionBean(AwardDirectFandADistributionBean awardDirectFandADistributionBean) {
        this.awardDirectFandADistributionBean = awardDirectFandADistributionBean;
    }

    public String getControlForAwardHierarchyView() {
        return this.controlForAwardHierarchyView;
    }

    public void setControlForAwardHierarchyView(String controlForAwardHierarchyView) {
        this.controlForAwardHierarchyView = controlForAwardHierarchyView;
    }

    public boolean isCancelOrFinalStatus() {
        return this.getDocument().getDocumentHeader().getWorkflowDocument().isCanceled() || this.getDocument().getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public boolean isInSingleNodeHierarchy() {
        boolean returnValue = false;
        if (this.getOrder().size() == 1) {
            returnValue = true;
            this.setControlForAwardHierarchyView("2");
        }
        return returnValue;
    }

    public boolean isInMultipleNodeHierarchy() {
        boolean returnValue = false;
        if (this.getOrder().size() > 1) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isRootNode() {
        boolean returnVal = false;
        String awardNumber = this.getAwardForSummaryPanelDisplay().getAwardNumber();
        if (this.getPreviousNodeMap().get(awardNumber).equals("000000-00000")) {
            returnVal = true;
        }
        return returnVal;
    }

    public boolean isLastNode() {
        boolean returnVal = false;
        String awardNumber = this.getAwardForSummaryPanelDisplay().getAwardNumber();
        if (this.getNextNodeMap().get(awardNumber).equals("lastNodeNextValue")) {
            returnVal = true;
        }
        return returnVal;
    }

    public Award getAwardForSummaryPanelDisplay() {
        return this.awardForSummaryPanelDisplay;
    }

    public void setAwardForSummaryPanelDisplay(Award awardForSummaryPanelDisplay) {
        this.awardForSummaryPanelDisplay = awardForSummaryPanelDisplay;
    }

    public List<String> getObligationStartDates() {
        return this.obligationStartDates;
    }

    public void setObligationStartDates(List<String> obligationStartDates) {
        this.obligationStartDates = obligationStartDates;
    }

    public List<String> getObligationExpirationDates() {
        return this.obligationExpirationDates;
    }

    public void setObligationExpirationDates(List<String> obligationExpirationDates) {
        this.obligationExpirationDates = obligationExpirationDates;
    }

    public List<String> getFinalExpirationDates() {
        return this.finalExpirationDates;
    }

    public void setFinalExpirationDates(List<String> finalExpirationDates) {
        this.finalExpirationDates = finalExpirationDates;
    }

    public List<AwardHierarchyNode> getAwardHierarchyNodeItems() {
        return this.awardHierarchyNodeItems;
    }

    public void setAwardHierarchyNodeItems(List<AwardHierarchyNode> awardHierarchyNodeItems) {
        this.awardHierarchyNodeItems = awardHierarchyNodeItems;
    }

    public Map<String, String> getPreviousNodeMap() {
        return this.previousNodeMap;
    }

    public void setPreviousNodeMap(Map<String, String> previousNodeMap) {
        this.previousNodeMap = previousNodeMap;
    }

    public Map<String, String> getNextNodeMap() {
        return this.nextNodeMap;
    }

    public void setNextNodeMap(Map<String, String> nextNodeMap) {
        this.nextNodeMap = nextNodeMap;
    }

    public String getAwardHierarchy() throws ParseException {
        this.awardHierarchy = "";
        if (StringUtils.isBlank((CharSequence)this.awardNumber)) {
            this.awardNumber = this.getTimeAndMoneyDocument().getRootAwardNumber();
        }
        if (this.awardNumber != null && StringUtils.isNotBlank((CharSequence)this.addRA) && this.addRA.equals("E")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getSubAwardHierarchiesForTreeView(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        } else if (this.awardNumber != null && StringUtils.isNotBlank((CharSequence)this.addRA) && this.addRA.equals("N")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getRootAwardNode(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        }
        return this.awardHierarchy;
    }

    public void setAwardHierarchy(String awardHierarchy) {
        this.awardHierarchy = awardHierarchy;
    }

    public String getCurrentOrPendingView() {
        return this.currentOrPendingView;
    }

    public void setToCurrentView() {
        this.currentOrPendingView = CURRENT;
    }

    public void setToPendingView() {
        this.currentOrPendingView = PENDING;
    }

    public boolean getDisableCurrentValues() {
        if (!this.isAwardObligatedAndAnticipatedAmountsEditable()) {
            return true;
        }
        return StringUtils.equals((CharSequence)CURRENT, (CharSequence)this.getCurrentOrPendingView()) && !this.getTimeAndMoneyDocument().getPendingTransactions().isEmpty();
    }

    public void setCurrentOrPendingView(String currentOrPendingView) {
        this.currentOrPendingView = currentOrPendingView;
    }

    public List<ExtraButton> getExtraTopButtons() {
        this.extraButtons.clear();
        String generatePeriodImage = this.buildExtraButtonSourceURI("tinybutton1-returntoaward.gif");
        this.addExtraButton("methodToCall.returnToAward", generatePeriodImage, "Return to Award");
        return this.extraButtons;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        TimeAndMoneyDocument timeAndMoneyDocument = this.getTimeAndMoneyDocument();
        if (timeAndMoneyDocument.getAward() == null) {
            Award award = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyDocument.getRootAwardNumber());
            timeAndMoneyDocument.setAward(award);
        }
        AwardDocument awardDocument = timeAndMoneyDocument.getAward().getAwardDocument();
        this.getDocInfo().clear();
        this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.principalInvestigator", awardDocument.getAward().getPrincipalInvestigatorName()));
        Object docIdAndStatus = COLUMN;
        if (workflowDocument != null) {
            docIdAndStatus = timeAndMoneyDocument.getDocumentNumber() + COLUMN + workflowDocument.getStatus().getLabel();
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.docIdStatus", (String)docIdAndStatus));
        String unitName = awardDocument.getAward().getUnitName();
        if (StringUtils.isNotBlank((CharSequence)unitName) && unitName.length() > 30) {
            unitName = unitName.substring(0, 30);
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.AwardPersonUnit.attributes.leadUnit", unitName));
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.awardIdAccount", "<div id = \"awardIdAccount\">" + this.getAwardIdAccount(awardDocument) + "</div>"));
        this.setupSponsor(awardDocument);
        this.setupLastUpdate(awardDocument, UPDATE_TIMESTAMP_DD_NAME);
    }

    private String getAwardIdAccount(AwardDocument awardDocument) {
        String awardNum = awardDocument.getAward().getAwardNumber();
        String account = awardDocument.getAward().getAccountNumber() != null ? awardDocument.getAward().getAccountNumber() : "";
        return awardNum + COLUMN + account;
    }

    private void setupSponsor(AwardDocument awardDocument) {
        if (awardDocument.getAward().getSponsor() == null) {
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, ""));
        } else {
            String sponsorName = awardDocument.getAward().getSponsorName();
            if (StringUtils.isNotBlank((CharSequence)sponsorName) && sponsorName.length() > 30) {
                sponsorName = sponsorName.substring(0, 30);
            }
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, sponsorName));
        }
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public String getDirectIndirectViewEnabled() {
        return this.directIndirectViewEnabled;
    }

    public void setDirectIndirectViewEnabled(String directIndirectViewEnabled) {
        this.directIndirectViewEnabled = directIndirectViewEnabled;
    }

    protected KcWorkflowService getKraWorkflowService() {
        return KcServiceLocator.getService(KcWorkflowService.class);
    }

    public boolean getDisplayEditButton() throws Exception {
        boolean displayEditButton = Boolean.FALSE;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        String rootAwardNumber = this.getTimeAndMoneyDocument().getRootAwardNumber();
        fieldValues.put(ROOT_AWARD_NUMBER, rootAwardNumber);
        fieldValues.put(DOCUMENT_STATUS, VersionStatus.ACTIVE.toString());
        TimeAndMoneyDocument activeTimeAndMoney = KcServiceLocator.getService(BusinessObjectService.class).findMatching(TimeAndMoneyDocument.class, fieldValues).stream().findFirst().orElse(null);
        if (activeTimeAndMoney != null) {
            displayEditButton = activeTimeAndMoney.getDocumentNumber().equals(this.getTimeAndMoneyDocument().getDocumentNumber());
        }
        return displayEditButton;
    }

    public List<ExtraButton> getExtraButtons() {
        this.extraButtons.clear();
        String reloadImage = this.buildExtraButtonSourceURI("buttonsmall_reload.gif");
        this.addExtraButton("methodToCall.reload", reloadImage, null);
        if (this.getTimeAndMoneyDocument().isAuthorizedToPostTimeAndMoney(GlobalVariables.getUserSession().getPrincipalId()) && !this.isAutoPostTimeAndMoney()) {
            String postAwardBudgetImage = this.buildExtraButtonSourceURI(BUTTONSMALL_POST_GIF);
            this.addExtraButton(METHOD_TO_CALL_POST_TM, postAwardBudgetImage, POST_TM_ALT_TEXT);
        }
        return this.extraButtons;
    }

    protected boolean isAutoPostTimeAndMoney() {
        return this.getParameterService().getParameterValueAsBoolean("KC-T", "All", "TM_AUTO_POST_ENABLED");
    }

    @Override
    protected void addExtraButton(String property, String source, String altText) {
        this.addExtraButton(property, source, altText, null);
    }

    protected void addExtraButton(String property, String source, String altText, String extraButtonOnclick) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        if (extraButtonOnclick != null) {
            newButton.setExtraButtonOnclick(extraButtonOnclick);
        }
        this.extraButtons.add(newButton);
    }

    public int getIndexOfAwardAmountInfoForDisplay() throws WorkflowException {
        return this.awardForSummaryPanelDisplay.getIndexOfAwardAmountInfoForDisplayFromTimeAndMoneyDocNumber(this.getTimeAndMoneyDocument().getDocumentNumber());
    }

    public Map<String, String> getAwardHierarchyToggle() {
        return this.awardHierarchyToggle;
    }

    public void setAwardHierarchyToggle(Map<String, String> awardHierarchyToggle) {
        this.awardHierarchyToggle = awardHierarchyToggle;
    }

    public String getAwardHierarchyScrollPosition() {
        return this.awardHierarchyScrollPosition;
    }

    public void setAwardHierarchyScrollPosition(String awardHierarchyScrollPosition) {
        this.awardHierarchyScrollPosition = awardHierarchyScrollPosition;
    }

    public List<String> getFieldsInError() {
        return this.fieldsInError;
    }

    public void setFieldsInError(List<String> fieldsInError) {
        this.fieldsInError = fieldsInError;
    }

    public boolean getIsFieldInErrorList(String fieldName) {
        boolean returnValue = this.getFieldsInError().contains(fieldName);
        return returnValue;
    }

    public String getFieldsInErrorList() {
        StringBuffer sb = new StringBuffer("foo");
        for (String s : this.getFieldsInError()) {
            sb.append(",").append(s);
        }
        return sb.toString();
    }

    public boolean isAwardObligatedAndAnticipatedAmountsEditable() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "MAKE_AWD_CUM_ANTICIPATED_OBL_EDITABLE");
    }
}

