/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.module.CoeusSubModule;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.util.PrintingUtils;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireAuthorizationService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireQuestion;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrintingService;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.impl.core.QuestionnaireMaintenanceForm;
import org.kuali.coeus.common.questionnaire.impl.core.QuestionnaireQuestionComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.web.struts.action.KualiMaintenanceDocumentAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class QuestionnaireMaintenanceDocumentAction
extends KualiMaintenanceDocumentAction {
    private static final String PCP = "#;#";
    private static final String PQP = "#q#";
    private static final String PUP = "#u#";
    private static final String PFP = "#f#";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    public static final String ID = "id";
    public static final String DOCUMENT_NUMBER = "documentNumber";
    public static final String QUESTIONNAIRE = "questionnaire";
    public static final String TEMPLATE = "template";
    public static final String SEQ_QUESTIONNAIRE_REF_ID = "SEQ_QUESTIONNAIRE_REF_ID";
    public static final String MODULE_CODE = "moduleCode";
    public static final String SUB_MODULE_CODE = "subModuleCode";
    public static final String N = "N";
    public static final String QUESTION = "question";
    private VersioningService versioningService;

    protected VersioningService getVersioningService() {
        if (this.versioningService == null) {
            this.versioningService = KcServiceLocator.getService(VersioningService.class);
        }
        return this.versioningService;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        ActionForward forward = super.execute(mapping, (ActionForm)qnForm, request, response);
        if (qnForm.getDocument() != null && ((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject() != null) {
            Questionnaire newQuestionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
            this.removeDeletedUsages(newQuestionnaire);
        }
        return forward;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        Questionnaire newQuestionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
        this.removeDeletedUsages(newQuestionnaire);
        if (this.validateTemplateField(qnForm)) {
            if (newQuestionnaire.getSequenceNumber() == null) {
                newQuestionnaire.setSequenceNumber(1);
            }
            this.setupQuestionAndUsage(form);
            if (qnForm.getTemplateFile() != null && StringUtils.isNotBlank((CharSequence)qnForm.getTemplateFile().getFileName())) {
                newQuestionnaire.setFileName(qnForm.getTemplateFile().getFileName());
                newQuestionnaire.setTemplate(qnForm.getTemplateFile().getFileData());
            }
            qnForm.setNewQuestionnaireUsage(new QuestionnaireUsage());
            newQuestionnaire.setDocumentNumber(qnForm.getDocument().getDocumentNumber());
            ActionForward forward = super.save(mapping, form, request, response);
            this.checkAndSetAllQuestionsAreUpToDate(qnForm);
            return forward;
        }
        return mapping.findForward("basic");
    }

    private boolean validateTemplateField(QuestionnaireMaintenanceForm qnForm) {
        boolean retVal = true;
        String fieldName = "document.newMaintainableObject.businessObject.fileName";
        try {
            if (ObjectUtils.isNotNull((Object)qnForm.getTemplateFile()) && !StringUtils.isBlank((CharSequence)qnForm.getTemplateFile().getFileName()) && (qnForm.getTemplateFile().getFileData() == null || qnForm.getTemplateFile().getFileData().length <= 0)) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.fileName", "error.questionnaire.filename.invalid", new String[0]);
                retVal = false;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.fileName", "error.questionnaire.filename.invalid", new String[0]);
            retVal = false;
        }
        return retVal;
    }

    private void setupQuestionAndUsage(ActionForm form) {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        String questions = this.assembleQuestions(qnForm);
        String usages = this.assembleUsages(questionnaire);
        qnForm.setEditData(questions + PCP + usages);
    }

    private void checkAndSetAllQuestionsAreUpToDate(QuestionnaireMaintenanceForm qnForm) {
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        qnForm.setAllQuestionsAreUpToDate(this.checkIfAllQuestionsAreUpToDate(questionnaire));
    }

    private boolean checkIfAllQuestionsAreUpToDate(Questionnaire questionnaire) {
        boolean retVal = true;
        for (QuestionnaireQuestion question : questionnaire.getQuestionnaireQuestions()) {
            if (question.getQuestion() == null || !question.getQuestionId().equals(question.getQuestion().getId())) {
                question.refreshReferenceObject(QUESTION);
            }
            if (N.equals(this.getVersionedQuestion(question))) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.permissionCheckForDocHandler(form);
        ActionForward forward = super.docHandler(mapping, form, request, response);
        this.setupQuestionAndUsage(form);
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        this.checkAndSetAllQuestionsAreUpToDate(qnForm);
        return forward;
    }

    private void permissionCheckForDocHandler(ActionForm form) {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (!this.getQuestionnaireAuthorizationService().hasPermission("Modify Questionnaire")) {
            if (!this.getQuestionnaireAuthorizationService().hasPermission("View Questionnaire")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Edit/View", "Questionnaire");
            }
            if (!qnForm.isReadOnly()) {
                qnForm.setReadOnly(true);
            }
        }
    }

    private String getQuestionReturnResult(QuestionnaireMaintenanceForm questionnaireForm, Questionnaire questionnaire) {
        Collections.sort(questionnaire.getQuestionnaireQuestions(), new QuestionnaireQuestionComparator());
        Object result = "parent-0";
        ArrayList<QuestionnaireQuestion> remainQuestions = new ArrayList<QuestionnaireQuestion>();
        for (QuestionnaireQuestion question : questionnaire.getQuestionnaireQuestions()) {
            if (question.getParentQuestionNumber().equals(0)) continue;
            remainQuestions.add((QuestionnaireQuestion)ObjectUtils.deepCopy((Serializable)question));
        }
        for (QuestionnaireQuestion question : questionnaire.getQuestionnaireQuestions()) {
            if (question.getQuestionNumber() > questionnaireForm.getQuestionNumber()) {
                questionnaireForm.setQuestionNumber(question.getQuestionNumber());
            }
            if (!question.getParentQuestionNumber().equals(0)) continue;
            result = (String)result + PQP + this.getQnReturnfields(question);
            String childrenResult = this.getChildrenQuestions(question, remainQuestions);
            if (!StringUtils.isNotBlank((CharSequence)childrenResult)) continue;
            result = (String)result + childrenResult;
        }
        questionnaireForm.setQuestionNumber(questionnaireForm.getQuestionNumber() + 1);
        return result;
    }

    private String assembleQuestions(QuestionnaireMaintenanceForm questionnaireForm) {
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)questionnaireForm.getDocument()).getNewMaintainableObject().getDataObject();
        questionnaireForm.setQuestionNumber(0);
        return this.getQuestionReturnResult(questionnaireForm, questionnaire);
    }

    private String getQeustionResponse(Question question) {
        Object retString = "";
        if (question.getQuestionTypeId().equals(6L)) {
            String className = question.getLookupClass();
            if (className != null) {
                className = className.substring(className.lastIndexOf(".") + 1);
                retString = className + PFP + question.getMaxAnswers() + PFP + this.getLookupReturnType(question.getLookupClass(), question.getLookupReturn());
            }
        } else {
            retString = question.getDisplayedAnswers() + PFP + question.getMaxAnswers() + PFP + question.getAnswerMaxLength();
        }
        return retString;
    }

    private String getLookupReturnType(String className, String lookReturn) {
        String retVal = "0";
        String lookupReturnType = "";
        try {
            lookupReturnType = Class.forName(className).getDeclaredField(lookReturn).getType().getSimpleName();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if ("String".equals(lookupReturnType)) {
            retVal = "5";
        } else if ("Date".equals(lookupReturnType)) {
            retVal = "4";
        } else if ("Integer".equals(lookupReturnType) || "Long".equals(lookupReturnType)) {
            retVal = "3";
        }
        return retVal;
    }

    private String getChildrenQuestions(QuestionnaireQuestion questionnaireQuestion, List<QuestionnaireQuestion> questionnaireQuestions) {
        Object result = "";
        for (QuestionnaireQuestion question : questionnaireQuestions) {
            if (!question.getParentQuestionNumber().equals(questionnaireQuestion.getQuestionNumber())) continue;
            result = (String)result + PQP + this.getQnReturnfields(question);
            String childrenResult = this.getChildrenQuestions(question, questionnaireQuestions);
            if (!StringUtils.isNotBlank((CharSequence)childrenResult)) continue;
            result = (String)result + childrenResult;
        }
        return result;
    }

    private String getQnReturnfields(QuestionnaireQuestion question) {
        String desc;
        if (question.getQuestion() == null || !question.getQuestionId().equals(question.getQuestion().getId())) {
            question.refreshReferenceObject(QUESTION);
        }
        if ((desc = question.getQuestion().getQuestion()).indexOf("\"") > 0) {
            desc = desc.replace("\"", "&#034;");
        }
        return question.getId() + PFP + question.getQuestionId() + PFP + question.getQuestionSeqNumber() + PFP + desc + PFP + question.getQuestion().getQuestionTypeId() + PFP + question.getQuestionNumber() + PFP + question.getCondition() + PFP + question.getConditionValue() + PFP + question.getParentQuestionNumber() + PFP + question.getQuestion().getSequenceNumber() + PFP + this.getQeustionResponse(question.getQuestion()) + PFP + question.getVersionNumber() + PFP + (question.getConditionFlag() ? "Y" : N) + PFP + this.getVersionedQuestion(question) + PFP + question.getRuleId();
    }

    private String getVersionedQuestion(QuestionnaireQuestion qnQuestion) {
        String results = N;
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("questionSeqId", qnQuestion.getQuestion().getQuestionSeqId());
        Question question = (Question)((List)this.getBusinessObjectService().findMatchingOrderBy(Question.class, fieldValues, "sequenceNumber", false)).get(0);
        if (!question.getSequenceNumber().equals(qnQuestion.getQuestion().getSequenceNumber())) {
            results = question.getId().toString();
        }
        return results;
    }

    private String assembleUsages(Questionnaire questionnaire) {
        Object result = "";
        for (QuestionnaireUsage questionnaireUsage : questionnaire.getQuestionnaireUsages()) {
            String moduleDescription = questionnaireUsage.getCoeusModule() != null ? questionnaireUsage.getCoeusModule().getDescription() : "";
            CoeusSubModule subModule = this.getSubModule(questionnaireUsage.getModuleItemCode(), questionnaireUsage.getModuleSubItemCode());
            String subModuleDescription = subModule != null ? subModule.getDescription() : "";
            result = (String)result + questionnaireUsage.getId() + PFP + questionnaireUsage.getModuleItemCode() + PFP + questionnaireUsage.getQuestionnaireLabel() + PFP + questionnaireUsage.getQuestionnaireSequenceNumber() + PFP + questionnaireUsage.getModuleSubItemCode() + PFP + questionnaireUsage.getRuleId() + PFP + questionnaireUsage.getVersionNumber() + PFP + (questionnaireUsage.isMandatory() ? "Y" : N) + PFP + moduleDescription + PFP + subModuleDescription + PUP;
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            result = ((String)result).substring(0, ((String)result).length() - 3);
        }
        return result;
    }

    private CoeusSubModule getSubModule(String moduleCode, String subModuleCode) {
        CoeusSubModule retVal = null;
        ArrayList subModules = new ArrayList();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_CODE, moduleCode);
        fieldValues.put(SUB_MODULE_CODE, subModuleCode);
        subModules.addAll(this.getBusinessObjectService().findMatching(CoeusSubModule.class, fieldValues));
        if (!subModules.isEmpty()) {
            retVal = (CoeusSubModule)subModules.get(0);
        }
        return retVal;
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.edit(mapping, form, request, response);
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (qnForm.isReadOnly()) {
            qnForm.getDocument().getDocumentHeader().setDocumentDescription("questionnaire - bootstrap data");
        }
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        Questionnaire oldQuestionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getOldMaintainableObject().getDataObject();
        this.versionQuestionnaire(questionnaire, oldQuestionnaire);
        Long questionnaireRefId = KcServiceLocator.getService(SequenceAccessorService.class).getNextAvailableSequenceNumber(SEQ_QUESTIONNAIRE_REF_ID, questionnaire.getClass());
        questionnaire.setQuestionnaireRefIdFromLong(questionnaireRefId);
        oldQuestionnaire.setQuestionnaireRefIdFromLong(questionnaireRefId);
        String questions = this.assembleQuestions(qnForm);
        String usages = this.assembleUsages((Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject());
        qnForm.setEditData(questions + PCP + usages);
        this.checkAndSetAllQuestionsAreUpToDate(qnForm);
        return forward;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getMaintenanceAction().equals("Copy")) {
            this.preRouteCopy(form);
        }
        ((Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject()).setDocumentNumber(qnForm.getDocument().getDocumentNumber());
        this.setupQuestionAndUsage(form);
        qnForm.setNewQuestionnaireUsage(new QuestionnaireUsage());
        if (qnForm.getDocument() != null && ((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject() != null) {
            Questionnaire newQuestionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
            this.removeDeletedUsages(newQuestionnaire);
        }
        ActionForward forward = super.route(mapping, form, request, response);
        this.checkAndSetAllQuestionsAreUpToDate(qnForm);
        return forward;
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getMaintenanceAction().equals("Copy")) {
            this.preRouteCopy(form);
        }
        ((Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject()).setDocumentNumber(qnForm.getDocument().getDocumentNumber());
        this.setupQuestionAndUsage(form);
        if (qnForm.getDocument() != null && ((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject() != null) {
            Questionnaire newQuestionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
            this.removeDeletedUsages(newQuestionnaire);
        }
        ActionForward forward = super.blanketApprove(mapping, form, request, response);
        this.checkAndSetAllQuestionsAreUpToDate(qnForm);
        return forward;
    }

    private void preRouteCopy(ActionForm form) {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put(ID, ((Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getOldMaintainableObject().getDataObject()).getId());
        Questionnaire oldQuestionnaire = (Questionnaire)this.getBusinessObjectService().findByPrimaryKey(Questionnaire.class, fieldValues);
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        KcServiceLocator.getService(QuestionnaireService.class).copyQuestionnaire(oldQuestionnaire, questionnaire);
        questionnaire.setSequenceNumber(1);
    }

    private void versionQuestionnaire(Questionnaire questionnaire, Questionnaire oldQuestionnaire) {
        try {
            Questionnaire newQuestionnaire = this.getVersioningService().createNewVersion(oldQuestionnaire);
            questionnaire.setId(null);
            questionnaire.setSequenceNumber(newQuestionnaire.getSequenceNumber());
            for (QuestionnaireQuestion qnaireQuestion : questionnaire.getQuestionnaireQuestions()) {
                qnaireQuestion.setQuestionnaireId(null);
                qnaireQuestion.setId(null);
            }
            for (QuestionnaireUsage qnaireUsage : questionnaire.getQuestionnaireUsages()) {
                qnaireUsage.setId(null);
                qnaireUsage.setQuestionnaireId(null);
            }
            questionnaire.setDocumentNumber("");
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating new questionnaire version", e);
        }
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.start(mapping, form, request, response);
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (qnForm.getMaintenanceAction().equals("New") && ((Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject()).getSequenceNumber() == null) {
            ((Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject()).setSequenceNumber(1);
        }
        this.checkAndSetAllQuestionsAreUpToDate(qnForm);
        return forward;
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        String buttonClicked = request.getParameter("buttonClicked");
        if (buttonClicked != null && "0".equals(buttonClicked)) {
            Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
            questionnaire.setQuestionnaireUsages(qnForm.getQuestionnaireUsages());
            this.removeDeletedUsages(questionnaire);
            this.setupQuestionAndUsage((ActionForm)qnForm);
            if (qnForm.getTemplateFile() != null && StringUtils.isNotBlank((CharSequence)qnForm.getTemplateFile().getFileName())) {
                questionnaire.setFileName(qnForm.getTemplateFile().getFileName());
                questionnaire.setTemplate(qnForm.getTemplateFile().getFileData());
            }
        }
        ActionForward forward = super.close(mapping, form, request, response);
        if (buttonClicked == null || "1".equals(buttonClicked)) {
            Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
            qnForm.setQuestionnaireUsages(questionnaire.getQuestionnaireUsages());
            questionnaire.setQuestionnaireUsages(new ArrayList<QuestionnaireUsage>());
        }
        return forward;
    }

    protected boolean canSave(ActionForm form) {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        return !qnForm.isReadOnly() && super.canSave((ActionForm)qnForm);
    }

    public ActionForward printQuestionnaire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        reportParameters.put(DOCUMENT_NUMBER, qnForm.getDocument().getDocumentNumber());
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getDataObject();
        reportParameters.put(QUESTIONNAIRE, questionnaire);
        if (qnForm.getTemplateFile() != null && qnForm.getTemplateFile().getFileData().length > 0) {
            reportParameters.put(TEMPLATE, qnForm.getTemplateFile().getFileData());
        } else {
            reportParameters.put(TEMPLATE, questionnaire.getTemplate());
        }
        reportParameters.put("questionnaireSeqId", questionnaire.getId());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaire(null, reportParameters);
        if (dataStream.getData() != null) {
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward addTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        questionnaire.setFileName(qnForm.getTemplateFile().getFileName());
        questionnaire.setTemplate(qnForm.getTemplateFile().getFileData());
        return mapping.findForward("basic");
    }

    public ActionForward viewTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        if (qnForm.getTemplateFile() != null && StringUtils.isNotBlank((CharSequence)qnForm.getTemplateFile().getFileName())) {
            this.streamToResponse(qnForm.getTemplateFile().getFileData(), qnForm.getTemplateFile().getFileName(), "text/xml", response);
        } else {
            this.streamToResponse(questionnaire.getTemplate(), questionnaire.getFileName(), "text/xml", response);
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        Questionnaire questionnaire = (Questionnaire)((MaintenanceDocumentBase)qnForm.getDocument()).getNewMaintainableObject().getBusinessObject();
        questionnaire.setFileName(null);
        questionnaire.setTemplate(null);
        qnForm.setTemplateFile(null);
        return mapping.findForward("basic");
    }

    public ActionForward getSubModuleCodeList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("ajaxQuestionnaire");
    }

    public ActionForward getQuestionMaintainTable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (StringUtils.isNotBlank((CharSequence)qnForm.getQuestionId())) {
            HashMap<String, Object> pkMap = new HashMap<String, Object>();
            pkMap.put(ID, qnForm.getQuestionId());
            qnForm.setQuestion((Question)this.getBusinessObjectService().findByPrimaryKey(Question.class, pkMap));
            pkMap.clear();
            pkMap.put("questionSeqId", qnForm.getQuestion().getQuestionSeqId());
            List questions = (List)this.getBusinessObjectService().findMatchingOrderBy(Question.class, pkMap, "sequenceNumber", false);
            if (CollectionUtils.isNotEmpty((Collection)questions) && !StringUtils.equals((CharSequence)((Question)questions.get(0)).getId().toString(), (CharSequence)qnForm.getQuestionId())) {
                qnForm.setQuestionCurrentVersion(false);
            }
        }
        return mapping.findForward("ajaxQuestionMaintainTable");
    }

    public ActionForward getQuestionCurrentVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)form;
        if (StringUtils.isNotBlank((CharSequence)qnForm.getQuestionId())) {
            HashMap<String, Object> pkMap = new HashMap<String, Object>();
            pkMap.put(ID, qnForm.getQuestionId());
            Question oldQ = (Question)this.getBusinessObjectService().findByPrimaryKey(Question.class, pkMap);
            if (oldQ != null) {
                pkMap.clear();
                pkMap.put("questionSeqId", oldQ.getQuestionSeqId());
                List questions = (List)this.getBusinessObjectService().findMatchingOrderBy(Question.class, pkMap, "sequenceNumber", false);
                if (CollectionUtils.isNotEmpty((Collection)questions)) {
                    qnForm.setQuestion((Question)questions.get(0));
                }
            }
        }
        return mapping.findForward("ajaxQuestionCurrentVersion");
    }

    private QuestionnaireAuthorizationService getQuestionnaireAuthorizationService() {
        return KcServiceLocator.getService(QuestionnaireAuthorizationService.class);
    }

    private QuestionnairePrintingService getQuestionnairePrintingService() {
        return KcServiceLocator.getService(QuestionnairePrintingService.class);
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        QuestionnaireMaintenanceForm qnForm = (QuestionnaireMaintenanceForm)formBase;
        boolean isReadOnly = qnForm.isReadOnly();
        super.populateAuthorizationFields(formBase);
        if (isReadOnly && StringUtils.equals((CharSequence)qnForm.getMethodToCall(), (CharSequence)"edit")) {
            qnForm.setReadOnly(true);
        }
        if (qnForm.isReadOnly() && formBase.getDocumentActions().containsKey("canClose")) {
            HashMap<String, String> documentActions = new HashMap<String, String>();
            documentActions.put("canClose", "TRUE");
            qnForm.setDocumentActions(documentActions);
        }
    }

    protected void removeDeletedUsages(Questionnaire questionnaire) {
        if (questionnaire != null && questionnaire.getQuestionnaireUsages() != null) {
            Iterator<QuestionnaireUsage> iter = questionnaire.getQuestionnaireUsages().iterator();
            while (iter.hasNext()) {
                QuestionnaireUsage usage = iter.next();
                if (!usage.isDelete()) continue;
                iter.remove();
            }
        }
    }
}

