/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.noteattachment.AddProtocolAttachmentProtocolEvent;
import org.kuali.kra.protocol.noteattachment.AddProtocolAttachmentProtocolRule;
import org.kuali.kra.protocol.noteattachment.AddProtocolNotepadEvent;
import org.kuali.kra.protocol.noteattachment.AddProtocolNotepadRuleImpl;
import org.kuali.kra.protocol.noteattachment.DeleteProtocolNotepadEvent;
import org.kuali.kra.protocol.noteattachment.DeleteProtocolNotepadRuleImpl;
import org.kuali.kra.protocol.noteattachment.ModifyProtocolNotepadEvent;
import org.kuali.kra.protocol.noteattachment.ModifyProtocolNotepadRuleImpl;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentFilterBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentVersioningUtilityBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadService;
import org.kuali.kra.protocol.noteattachment.TypedAttachment;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class NotesAttachmentsHelperBase {
    private static final Logger LOG = LogManager.getLogger(NotesAttachmentsHelperBase.class);
    protected static final String NAMESPACE = "KC-UNT";
    protected static final String UNSUPPORTED_ATTACHMENT_TYPE = "unsupported attachment type ";
    protected static final String CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL = "confirmDeleteAttachmentPersonnel";
    protected static final String CONFIRM_YES_DELETE_ATTACHMENT_PROTOCOL = "confirmDeleteAttachmentProtocol";
    protected static final String CONFIRM_YES_DELETE_NOTE = "confirmDeleteNote";
    protected final ProtocolAttachmentService notesService;
    protected final TaskAuthorizationService authService;
    protected final SystemAuthorizationService systemAuthorizationService;
    protected final DateTimeService dateTimeService;
    protected final ProtocolNotepadService protocolNotepadService;
    protected final ParameterService parameterService;
    protected final ProtocolAttachmentVersioningUtilityBase versioningUtil;
    protected final ProtocolFormBase form;
    protected ProtocolAttachmentProtocolBase newAttachmentProtocol;
    protected ProtocolAttachmentPersonnelBase newAttachmentPersonnel;
    protected ProtocolAttachmentFilterBase newAttachmentFilter;
    protected List<AttachmentFile> FilesToDelete;
    protected ProtocolNotepadBase protocolNotepad;
    protected boolean modifyAttachments;
    protected boolean modifyNotepads;
    protected boolean viewRestricted;
    protected boolean manageNotesOpen;

    protected NotesAttachmentsHelperBase(ProtocolFormBase form, ProtocolAttachmentService notesService, TaskAuthorizationService authService, SystemAuthorizationService systemAuthorizationService, DateTimeService dateTimeService, ProtocolNotepadService protocolNotepadService, ParameterService parameterService, ProtocolAttachmentVersioningUtilityBase versioningUtil) {
        if (form == null) {
            throw new IllegalArgumentException("the form was null");
        }
        if (notesService == null) {
            throw new IllegalArgumentException("the notesService was null");
        }
        if (authService == null) {
            throw new IllegalArgumentException("the authService was null");
        }
        if (systemAuthorizationService == null) {
            throw new IllegalArgumentException("the kraAuthorizationService was null");
        }
        if (dateTimeService == null) {
            throw new IllegalArgumentException("the dateTimeService was null.");
        }
        if (protocolNotepadService == null) {
            throw new IllegalArgumentException("the protocolNotepadService was null.");
        }
        if (parameterService == null) {
            throw new IllegalArgumentException("the parameterService was null.");
        }
        if (versioningUtil == null) {
            throw new IllegalArgumentException("the versioningUtil was null");
        }
        this.form = form;
        this.notesService = notesService;
        this.authService = authService;
        this.systemAuthorizationService = systemAuthorizationService;
        this.dateTimeService = dateTimeService;
        this.protocolNotepadService = protocolNotepadService;
        this.parameterService = parameterService;
        this.versioningUtil = versioningUtil;
        this.FilesToDelete = new ArrayList<AttachmentFile>();
        this.manageNotesOpen = false;
    }

    public void prepareView() {
        this.initializePermissions();
        this.notesService.setProtocolAttachmentUpdateUsersName(this.form.getProtocolDocument().getProtocol().getAttachmentProtocols());
        this.protocolNotepadService.setProtocolNotepadUpdateUsersName(this.form.getProtocolDocument().getProtocol().getNotepads());
    }

    private void initializePermissions() {
        this.modifyAttachments = this.canEditProtocolAttachments();
        this.modifyNotepads = this.canAddProtocolNotepads();
        this.viewRestricted = this.canViewRestrictedProtocolNotepads();
    }

    public abstract boolean canEditProtocolAttachments();

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public ProtocolBase getProtocol() {
        if (this.form.getProtocolDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.form.getProtocolDocument().getProtocol() == null) {
            throw new IllegalArgumentException("the protocol is null");
        }
        return this.form.getProtocolDocument().getProtocol();
    }

    public ProtocolAttachmentProtocolBase getNewAttachmentProtocol() {
        if (this.newAttachmentProtocol == null) {
            this.initAttachmentProtocol();
        }
        return this.newAttachmentProtocol;
    }

    public void setNewAttachmentProtocol(ProtocolAttachmentProtocolBase newAttachmentProtocol) {
        this.newAttachmentProtocol = newAttachmentProtocol;
    }

    public ProtocolAttachmentPersonnelBase getNewAttachmentPersonnel() {
        if (this.newAttachmentPersonnel == null) {
            this.initAttachmentPersonnel();
        }
        return this.newAttachmentPersonnel;
    }

    public void setNewAttachmentPersonnel(ProtocolAttachmentPersonnelBase newAttachmentPersonnel) {
        this.newAttachmentPersonnel = newAttachmentPersonnel;
    }

    public boolean isModifyAttachments() {
        return this.modifyAttachments;
    }

    public void setModifyAttachments(boolean modifyAttachments) {
        this.modifyAttachments = modifyAttachments;
    }

    public void processSave() {
        this.refreshAttachmentReferences(this.getProtocol().getAttachmentProtocols());
        this.syncNewFiles(this.getProtocol().getAttachmentProtocols());
        if (this.versioningUtil.versioningRequired()) {
            this.versioningUtil.versionExstingAttachments();
        }
        for (ProtocolNotepadBase note : this.getProtocol().getNotepads()) {
            this.updateUserFieldsIfNecessary(note);
        }
    }

    public void fixReloadedAttachments(Map parameterMap) {
        Iterator keys = parameterMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String fieldNameStarter = "protocolRefreshButtonClicked";
            try {
                String fieldValue;
                if (key.indexOf(fieldNameStarter) <= -1 || !"T".equals(fieldValue = ((String[])parameterMap.get(key))[0])) continue;
                int numericVal = Integer.valueOf(key.substring(fieldNameStarter.length()));
                String documentStatusCode = this.getProtocol().getAttachmentProtocols().get(numericVal).getDocumentStatusCode();
                if (!StringUtils.isBlank((CharSequence)documentStatusCode) && !"3".equals(documentStatusCode)) continue;
                this.getProtocol().getAttachmentProtocols().get(numericVal).setDocumentStatusCode("1");
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addNewProtocolAttachmentProtocol() {
        this.refreshAttachmentReferences(Collections.singletonList(this.getNewAttachmentProtocol()));
        this.syncNewFiles(Collections.singletonList(this.getNewAttachmentProtocol()));
        AddProtocolAttachmentProtocolRule rule = this.getAddProtocolAttachmentProtocolRuleInstanceHook();
        AddProtocolAttachmentProtocolEvent event = new AddProtocolAttachmentProtocolEvent(this.form.getProtocolDocument(), this.newAttachmentProtocol);
        if (rule.processAddProtocolAttachmentProtocolRules(event)) {
            this.addNewAttachment(this.newAttachmentProtocol);
            this.initAttachmentProtocol();
        } else {
            this.newAttachmentProtocol.setFile(null);
        }
    }

    public abstract AddProtocolAttachmentProtocolRule getAddProtocolAttachmentProtocolRuleInstanceHook();

    public <T extends ProtocolAttachmentBase> boolean deleteExistingAttachmentByType(int attachmentNumber, Class<T> type) {
        if (!this.getProtocolAttachmentProtocolClassHook().equals(type)) {
            throw new IllegalArgumentException(UNSUPPORTED_ATTACHMENT_TYPE + type);
        }
        boolean deleted = this.deleteExistingAttachment(attachmentNumber, this.getProtocol().getAttachmentProtocols());
        return deleted;
    }

    public <T extends ProtocolAttachmentBase> T retrieveExistingAttachmentByType(int attachmentNumber, Class<T> type) {
        if (!this.getProtocolAttachmentProtocolClassHook().equals(type)) {
            throw new IllegalArgumentException(UNSUPPORTED_ATTACHMENT_TYPE + type);
        }
        ProtocolAttachmentProtocolBase attachment = NotesAttachmentsHelperBase.retrieveExistingAttachment(attachmentNumber, this.getProtocol().getAttachmentProtocols());
        return (T)attachment;
    }

    public <T extends ProtocolAttachmentBase> String retrieveConfirmMethodByType(Class<T> type) {
        String confirmMethod;
        if (this.getProtocolAttachmentProtocolClassHook().equals(type)) {
            confirmMethod = CONFIRM_YES_DELETE_ATTACHMENT_PROTOCOL;
        } else if (this.getProtocolAttachmentPersonnelClassHook().equals(type)) {
            confirmMethod = CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL;
        } else if (this.getProtocolNotepadClassHook().equals(type)) {
            confirmMethod = CONFIRM_YES_DELETE_NOTE;
        } else {
            throw new IllegalArgumentException(UNSUPPORTED_ATTACHMENT_TYPE + type);
        }
        return confirmMethod;
    }

    private <T extends ProtocolAttachmentBase> boolean deleteExistingAttachment(int index, List<T> attachments) {
        if (!CollectionUtils.validIndexForList(index, attachments)) {
            return false;
        }
        if (this.versioningUtil.versioningRequired() && ((ProtocolAttachmentBase)attachments.get(index)).supportsVersioning()) {
            ProtocolAttachmentBase attachment = (ProtocolAttachmentBase)attachments.get(index);
            if (attachment instanceof ProtocolAttachmentProtocolBase && "1".equals(((ProtocolAttachmentProtocolBase)attachment).getDocumentStatusCode())) {
                ((ProtocolAttachmentProtocolBase)attachment).setDocumentStatusCode("3");
                ((ProtocolAttachmentProtocolBase)attachment).setChanged(true);
            } else {
                this.versioningUtil.versionDeletedAttachment((ProtocolAttachmentBase)attachments.get(index));
            }
        } else {
            attachments.remove(index);
        }
        return true;
    }

    private <T extends ProtocolAttachmentBase> void addNewAttachment(T attachment) {
        if (this.versioningUtil.versioningRequired() && attachment.supportsVersioning()) {
            this.versioningUtil.versionNewAttachment(attachment);
        } else {
            this.getProtocol().addAttachmentsByType(attachment);
        }
    }

    private static <T extends ProtocolAttachmentBase> T retrieveExistingAttachment(int index, List<T> attachments) {
        return (T)((ProtocolAttachmentBase)CollectionUtils.getFromList(index, attachments));
    }

    private void initAttachmentProtocol() {
        this.setNewAttachmentProtocol(this.createNewProtocolAttachmentProtocolInstanceHook(this.getProtocol()));
    }

    protected abstract ProtocolAttachmentProtocolBase createNewProtocolAttachmentProtocolInstanceHook(ProtocolBase var1);

    private void initAttachmentPersonnel() {
        this.setNewAttachmentPersonnel(this.createNewProtocolAttachmentPersonnelInstanceHook(this.getProtocol()));
    }

    protected abstract ProtocolAttachmentPersonnelBase createNewProtocolAttachmentPersonnelInstanceHook(ProtocolBase var1);

    private void initAttachmentFilter() {
        ProtocolAttachmentFilterBase paFilter = this.createNewProtocolAttachmentFilterInstanceHook();
        try {
            String defaultSortBy = this.parameterService.getParameterValueAsString(this.getProtocolDocumentClassHook(), this.getAttachmentDefaultSortKeyHook());
            if (StringUtils.isNotBlank((CharSequence)defaultSortBy)) {
                paFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setNewAttachmentFilter(paFilter);
    }

    protected abstract ProtocolAttachmentFilterBase createNewProtocolAttachmentFilterInstanceHook();

    protected abstract String getAttachmentDefaultSortKeyHook();

    private void refreshAttachmentReferences(Collection<? extends ProtocolAttachmentBase> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (ProtocolAttachmentBase protocolAttachmentBase : attachments) {
            if (protocolAttachmentBase instanceof ProtocolAttachmentProtocolBase) {
                protocolAttachmentBase.refreshReferenceObject("status");
            }
            if (protocolAttachmentBase instanceof ProtocolAttachmentPersonnelBase) {
                protocolAttachmentBase.refreshReferenceObject("person");
            }
            if (!(protocolAttachmentBase instanceof TypedAttachment)) continue;
            protocolAttachmentBase.refreshReferenceObject("type");
        }
    }

    private void syncNewFiles(Collection<? extends ProtocolAttachmentBase> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (ProtocolAttachmentBase protocolAttachmentBase : attachments) {
            if (!this.getKcAttachmentService().doesNewFileExist(protocolAttachmentBase.getNewFile())) continue;
            AttachmentFile newFile = AttachmentFile.createFromFormFile(protocolAttachmentBase.getNewFile());
            if (protocolAttachmentBase.getFile() != null) {
                newFile.setSequenceNumber(protocolAttachmentBase.getFile().getSequenceNumber());
            }
            protocolAttachmentBase.setFile(newFile);
            protocolAttachmentBase.setNewFile(null);
        }
    }

    public List<AttachmentFile> getFilesToDelete() {
        return this.FilesToDelete;
    }

    public void setFilesToDelete(List<AttachmentFile> filesToDelete) {
        this.FilesToDelete = filesToDelete;
    }

    public abstract boolean canAddProtocolNotepads();

    public abstract boolean canViewRestrictedProtocolNotepads();

    public ProtocolNotepadBase getNewProtocolNotepad() {
        if (this.protocolNotepad == null) {
            this.initProtocolNotepad();
        }
        return this.protocolNotepad;
    }

    public void setNewProtocolNotepad(ProtocolNotepadBase protocolNotepad) {
        this.protocolNotepad = protocolNotepad;
    }

    public boolean isModifyNotepads() {
        return this.modifyNotepads;
    }

    public void setModifyNotepads(boolean modifyNotepads) {
        this.modifyNotepads = modifyNotepads;
    }

    public boolean isViewRestricted() {
        return this.viewRestricted;
    }

    public void setViewRestricted(boolean viewRestricted) {
        this.viewRestricted = viewRestricted;
    }

    public abstract boolean isProtocolAdmin();

    private void initProtocolNotepad() {
        ProtocolNotepadBase notepad = this.createNewProtocolNotepadInstanceHook(this.getProtocol());
        notepad.setEntryNumber(this.getNextEntryNumber());
        notepad.setEditable(true);
        this.setNewProtocolNotepad(notepad);
    }

    public void addNewNote() {
        AddProtocolNotepadRuleImpl rule = new AddProtocolNotepadRuleImpl();
        AddProtocolNotepadEvent event = new AddProtocolNotepadEvent(this.form.getProtocolDocument(), this.protocolNotepad);
        if (!rule.processAddProtocolNotepadRules(event)) {
            return;
        }
        ProtocolNotepadBase pn = this.protocolNotepad;
        pn.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        pn.setCreateTimestamp(((DateTimeService)KcServiceLocator.getService("dateTimeService")).getCurrentTimestamp());
        this.addNewNotepad(pn);
        this.initProtocolNotepad();
    }

    public void modifyNote(int noteToModify) {
        ProtocolNotepadBase notepadObject = this.getProtocol().getNotepads().get(noteToModify);
        ModifyProtocolNotepadRuleImpl rule = new ModifyProtocolNotepadRuleImpl();
        ModifyProtocolNotepadEvent event = new ModifyProtocolNotepadEvent(this.form.getProtocolDocument(), notepadObject);
        if (!rule.processModifyProtocolNotepadRules(event)) {
            return;
        }
        this.modifyNotepad(notepadObject);
    }

    public boolean deleteNote(int noteToDelete) {
        DeleteProtocolNotepadRuleImpl rule = new DeleteProtocolNotepadRuleImpl();
        DeleteProtocolNotepadEvent event = new DeleteProtocolNotepadEvent(this.form.getProtocolDocument(), this.protocolNotepad);
        if (!rule.processDeleteProtocolNotepadRules(event)) {
            return false;
        }
        this.deleteNotepad(noteToDelete);
        return true;
    }

    void updateUserFieldsIfNecessary(ProtocolNotepadBase currentNote) {
        if (currentNote.isEditable()) {
            this.setUpdateFields(currentNote);
        }
    }

    private void setUpdateFields(KcPersistableBusinessObjectBase bo) {
        bo.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        bo.setUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
    }

    private void addNewNotepad(ProtocolNotepadBase notepad) {
        this.setUpdateFields(notepad);
        notepad.setEditable(true);
        this.getProtocol().getNotepads().add(0, notepad);
    }

    private void modifyNotepad(ProtocolNotepadBase notepadObject) {
        this.setUpdateFields(notepadObject);
        notepadObject.setEditable(true);
    }

    private void deleteNotepad(int noteToDelete) {
        this.getProtocol().getNotepads().remove(noteToDelete);
    }

    private Integer getNextEntryNumber() {
        List<ProtocolNotepadBase> notepads = this.getProtocol().getNotepads();
        Integer maxEntry = notepads.isEmpty() ? Integer.valueOf(0) : Collections.max(notepads, ProtocolNotepadBase.NotepadByEntryNumber.INSTANCE).getEntryNumber();
        return maxEntry + 1;
    }

    public void setManageNotesOpen(boolean manageNotesOpen) {
        this.manageNotesOpen = manageNotesOpen;
    }

    public boolean isManageNotesOpen() {
        return this.manageNotesOpen;
    }

    public ProtocolAttachmentFilterBase getNewAttachmentFilter() {
        if (this.newAttachmentFilter == null) {
            this.initAttachmentFilter();
        }
        return this.newAttachmentFilter;
    }

    public void setNewAttachmentFilter(ProtocolAttachmentFilterBase newAttachmentFilter) {
        this.newAttachmentFilter = newAttachmentFilter;
    }

    public void addNewProtocolAttachmentFilter() {
        this.getProtocol().setProtocolAttachmentFilter(this.getNewAttachmentFilter());
    }

    public abstract Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook();

    public abstract Class<? extends ProtocolAttachmentPersonnelBase> getProtocolAttachmentPersonnelClassHook();

    public abstract Class<? extends ProtocolNotepadBase> getProtocolNotepadClassHook();

    public abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentClassHook();

    protected abstract ProtocolNotepadBase createNewProtocolNotepadInstanceHook(ProtocolBase var1);

    private KcAttachmentService getKcAttachmentService() {
        return KcServiceLocator.getService(KcAttachmentService.class);
    }
}

