/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.cache;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.cache.CacheAdminService;
import org.kuali.rice.core.api.cache.CacheTarget;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NamedBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class DistributedCacheManagerDecorator
implements CacheManager,
InitializingBean,
BeanNameAware,
NamedBean {
    private static final Logger LOG = LogManager.getLogger(DistributedCacheManagerDecorator.class);
    private static final String DISABLE_ALL_CACHES_PARAM = "rice.cache.disableAllCaches";
    private static final String DISABLE_DISTRIBUTED_CACHE_FLUSH_PARAM = "rice.cache.disableDistributedCacheFlush";
    private static final String DISABLED_CACHES_PARAM = "rice.cache.disabledCaches";
    private CacheManager cacheManager;
    private String serviceName;
    private String name;

    public Cache getCache(String name) {
        return this.wrap(this.cacheManager.getCache(name));
    }

    public Collection<String> getCacheNames() {
        return this.cacheManager.getCacheNames();
    }

    private Cache wrap(Cache cache) {
        if (!(cache instanceof DistributedCacheDecorator) && cache != null) {
            return new DistributedCacheDecorator(cache);
        }
        return cache;
    }

    private void sendFlushCacheMessages(Collection<CacheTarget> cacheTargets) {
        try {
            if (!cacheTargets.isEmpty()) {
                this.logFlushCache(cacheTargets);
                cacheTargets = new ArrayList<CacheTarget>(cacheTargets);
                CacheAdminService cacheAdminService = (CacheAdminService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(QName.valueOf(this.serviceName));
                cacheAdminService.flush(cacheTargets);
            }
        }
        catch (Throwable t) {
            LOG.error("failed to execute distributed flush for serviceName " + this.serviceName, t);
        }
    }

    private void logFlushCache(Collection<CacheTarget> cacheTargets) {
        if (LOG.isDebugEnabled()) {
            HashSet<String> cacheNames = new HashSet<String>();
            for (CacheTarget cacheTarget : cacheTargets) {
                cacheNames.add(cacheTarget.getCache());
            }
            LOG.debug("Performing distributed flush of information in the following caches: " + StringUtils.join(cacheNames, (String)", "));
        }
    }

    public void afterPropertiesSet() {
        if (this.cacheManager == null) {
            throw new IllegalStateException("cacheManager was null");
        }
        if (StringUtils.isBlank((String)this.serviceName)) {
            throw new IllegalStateException("serviceName was null or blank");
        }
        if (StringUtils.isBlank((String)this.name)) {
            this.name = "NOT_NAMED";
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getBeanName() {
        return this.name;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    private static final class NoOpCache
    implements Cache {
        private final Cache inner;

        private NoOpCache(Cache inner) {
            this.inner = inner;
        }

        public String getName() {
            return this.inner.getName();
        }

        public Object getNativeCache() {
            return this.inner;
        }

        public Cache.ValueWrapper get(Object key) {
            return null;
        }

        public <T> T get(Object o, Class<T> tClass) {
            return null;
        }

        public <T> T get(Object o, Callable<T> callable) {
            return null;
        }

        public void put(Object key, Object value) {
        }

        public Cache.ValueWrapper putIfAbsent(Object o, Object o2) {
            return null;
        }

        public void evict(Object key) {
        }

        public void clear() {
        }
    }

    private static final class ConfigurationPropertiesHolder {
        static final boolean disableAllCaches = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.cache.disableAllCaches", false);
        static final boolean disableDistributedCacheFlush = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.cache.disableDistributedCacheFlush", false);
        static final Set<String> disabledCaches = ConfigurationPropertiesHolder.getDisabledCachesConfig();

        private ConfigurationPropertiesHolder() {
        }

        private static Set<String> getDisabledCachesConfig() {
            HashSet<String> disabledCaches = new HashSet<String>();
            String disabledCachesParam = ConfigContext.getCurrentContextConfig().getProperty(DistributedCacheManagerDecorator.DISABLED_CACHES_PARAM);
            if (!StringUtils.isBlank((String)disabledCachesParam)) {
                for (String cacheName : disabledCachesParam.split(",")) {
                    if (StringUtils.isBlank((String)(cacheName = cacheName.trim()))) continue;
                    disabledCaches.add(cacheName);
                }
            }
            return Collections.unmodifiableSet(disabledCaches);
        }
    }

    private static final class DistributedCacheException
    extends RuntimeException {
        private DistributedCacheException(Throwable cause) {
            super(cause);
        }
    }

    private final class CacheMessageSendingTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private final LinkedBlockingQueue<CacheTarget> flushQueue = new LinkedBlockingQueue();

        private CacheMessageSendingTransactionSynchronization() {
        }

        private void add(CacheTarget target) throws DistributedCacheException {
            try {
                this.flushQueue.put(target);
            }
            catch (InterruptedException e) {
                throw new DistributedCacheException(e);
            }
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void beforeCommit(boolean readOnly) {
            DistributedCacheManagerDecorator.this.sendFlushCacheMessages(this.exhaustQueue(this.flushQueue));
        }

        private Collection<CacheTarget> exhaustQueue(Queue<CacheTarget> targets) {
            CacheTarget target;
            HashSet<CacheTarget> normalized = new HashSet<CacheTarget>();
            final HashSet<String> completeFlush = new HashSet<String>();
            while ((target = targets.poll()) != null) {
                normalized.add(target);
                if (target.containsKey()) continue;
                completeFlush.add(target.getCache());
            }
            return Collections2.filter(normalized, (Predicate)new Predicate<CacheTarget>(){

                public boolean apply(CacheTarget input) {
                    return !input.containsKey() || input.containsKey() && !completeFlush.contains(input.getCache());
                }
            });
        }
    }

    private final class DistributedCacheDecorator
    implements Cache {
        private final Cache cache;

        private DistributedCacheDecorator(Cache cache) {
            this.cache = ConfigurationPropertiesHolder.disableAllCaches || ConfigurationPropertiesHolder.disabledCaches.contains(cache.getName()) ? new NoOpCache(cache) : cache;
        }

        public String getName() {
            return this.cache.getName();
        }

        public Object getNativeCache() {
            return this.cache.getNativeCache();
        }

        public Cache.ValueWrapper get(Object key) {
            String sKey = this.coerceStr(key);
            return this.cache.get((Object)sKey);
        }

        public <T> T get(Object key, Callable<T> callable) {
            String sKey = this.coerceStr(key);
            return (T)this.cache.get((Object)sKey, callable);
        }

        public <T> T get(Object key, Class<T> type) {
            Cache.ValueWrapper wrappedValue = this.cache.get(key);
            if (wrappedValue == null || wrappedValue.get() == null) {
                return null;
            }
            if (type != null && !type.isInstance(wrappedValue.get())) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + wrappedValue.get());
            }
            return (T)wrappedValue.get();
        }

        public void put(Object key, Object value) {
            String sKey = this.coerceStr(key);
            this.cache.put((Object)sKey, value);
        }

        public Cache.ValueWrapper putIfAbsent(Object o, Object o2) {
            Cache.ValueWrapper existingValue = this.cache.get(o);
            if (existingValue == null) {
                this.cache.put(o, o2);
                return null;
            }
            return this.cache.get(o);
        }

        public void evict(Object key) {
            String sKey = this.coerceStr(key);
            this.cache.evict((Object)sKey);
            this.doDistributed(CacheTarget.singleEntry((String)this.getName(), (String)sKey));
        }

        public void clear() {
            this.cache.clear();
            this.doDistributed(CacheTarget.entireCache((String)this.getName()));
        }

        private String coerceStr(Object key) {
            return key != null ? key.toString() : (String)key;
        }

        private void doDistributed(CacheTarget target) {
            if (ConfigurationPropertiesHolder.disableDistributedCacheFlush) {
                return;
            }
            if (this.doTransactionalFlush()) {
                CacheMessageSendingTransactionSynchronization ts = this.getCacheMessageSendingTransactionSynchronization();
                ts.add(target);
            } else {
                DistributedCacheManagerDecorator.this.sendFlushCacheMessages(Collections.singleton(target));
            }
        }

        private CacheMessageSendingTransactionSynchronization getCacheMessageSendingTransactionSynchronization() {
            List sycs = TransactionSynchronizationManager.getSynchronizations();
            if (sycs != null) {
                for (TransactionSynchronization ts : sycs) {
                    if (!(ts instanceof CacheMessageSendingTransactionSynchronization)) continue;
                    return (CacheMessageSendingTransactionSynchronization)ts;
                }
            }
            CacheMessageSendingTransactionSynchronization ts = new CacheMessageSendingTransactionSynchronization();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)ts);
            return ts;
        }

        private boolean doTransactionalFlush() {
            return TransactionSynchronizationManager.isSynchronizationActive() && TransactionSynchronizationManager.isActualTransactionActive();
        }
    }
}

