/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireQuestion;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class QuestionnaireMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    public static final String ALREADY_EDITED_ERROR = "error.questionnaire.alreadyEdited";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateQuestionnaire(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateQuestionnaire(document);
    }

    private boolean validateQuestionnaire(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        Questionnaire newQuestionnaire = (Questionnaire)maintenanceDocument.getNewMaintainableObject().getDataObject();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (StringUtils.isBlank((CharSequence)newQuestionnaire.getName())) {
            errorMap.putError("document.newMaintainableObject.businessObject.name", "error.required", new String[]{"Questionnaire Name"});
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)newQuestionnaire.getDescription())) {
            errorMap.putError("document.newMaintainableObject.businessObject.description", "error.required", new String[]{"Questionnaire Description"});
            valid = false;
        }
        if (this.getQuestionnaireService().isQuestionnaireNameExist(newQuestionnaire.getQuestionnaireSeqId(), newQuestionnaire.getName())) {
            errorMap.putError("document.newMaintainableObject.businessObject.name", "error.questionnaire.name.exist", new String[0]);
            valid = false;
        }
        if (StringUtils.isNotBlank((CharSequence)newQuestionnaire.getFileName()) && !StringUtils.endsWithIgnoreCase((CharSequence)newQuestionnaire.getFileName(), (CharSequence)".xsl")) {
            errorMap.putError("document.newMaintainableObject.businessObject.fileName", "error.questionnaire.filename.invalid", new String[0]);
            valid = false;
        }
        for (QuestionnaireQuestion questionnaireQuestion : newQuestionnaire.getQuestionnaireQuestions()) {
            if (questionnaireQuestion.getQuestion() == null || !"I".equals(questionnaireQuestion.getQuestion().getStatus())) continue;
            errorMap.putError("document.newMaintainableObject.businessObject.question" + newQuestionnaire.getQuestionnaireQuestions().indexOf(questionnaireQuestion), "error.questionnaire.question_inactive", new String[]{questionnaireQuestion.getQuestion().getQuestion()});
            valid = false;
        }
        if (newQuestionnaire.getObjectId() != null && this.checkForLatestQuuestionnaireSequenceNumber(newQuestionnaire.getId(), newQuestionnaire.getSequenceNumber())) {
            errorMap.putError("document.newMaintainableObject.businessObject.name", ALREADY_EDITED_ERROR, new String[]{""});
            valid = false;
        }
        for (QuestionnaireUsage usage : newQuestionnaire.getQuestionnaireUsages()) {
            if (usage.getCoeusSubModule() == null || !usage.getCoeusSubModule().isRequireUniqueQuestionnareUsage() || this.getQuestionnaireService().isUniqueUsage(newQuestionnaire, usage)) continue;
            errorMap.putError("document.newMaintainableObject.businessObject.questionnaireUsages[" + newQuestionnaire.getQuestionnaireUsages().indexOf(usage) + "].moduleSubItemCode", "error.questionnaire.duplicate.usage", new String[0]);
        }
        return valid;
    }

    protected boolean checkForLatestQuuestionnaireSequenceNumber(Long id, Integer sequenceNumber) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("id", id);
        boolean sortAscending = true;
        Collection questionnaires = this.getBusinessObjectService().findMatchingOrderBy(Questionnaire.class, fieldValues, "SEQUENCE_NUMBER", sortAscending);
        boolean foundCurrentSequence = false;
        boolean foundLargerSequence = false;
        for (Questionnaire questionnarire : questionnaires) {
            if (questionnarire.getSequenceNumber().equals(sequenceNumber)) {
                foundCurrentSequence = true;
            }
            if (questionnarire.getSequenceNumber() <= sequenceNumber) continue;
            foundLargerSequence = true;
        }
        return foundCurrentSequence && !foundLargerSequence;
    }

    private QuestionnaireService getQuestionnaireService() {
        return KcServiceLocator.getService(QuestionnaireService.class);
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }
}

