/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.kra.iacuc.IacucProcedureCategoryCustomData;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.IacucSpecies;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonTrainingService;
import org.kuali.kra.iacuc.procedures.IacucProcedure;
import org.kuali.kra.iacuc.procedures.IacucProcedureCategory;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolSpeciesStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyCustomData;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesService;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolProcedureServiceImpl
implements IacucProtocolProcedureService {
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private IacucProtocolPersonTrainingService iacucProtocolPersonTrainingService;
    private static final String PROTOCOL_STUDY_GROUP_HEADER_SEQUENCE_ID = "SEQ_IACUC_PROT_STUD_GRP_HDR_ID";
    private static final String PROCEDURE_VIEW_MODE = "PROCEDURE_VIEW_MODE";
    private static final String PROCEDURE_VIEW_MODE_SPECIES = "S";
    private IacucProtocolSpeciesService iacucProtocolSpeciesService;
    private SequenceAccessorService sequenceAccessorService;

    @Override
    public List<IacucProcedure> getAllProcedures() {
        return (List)this.getBusinessObjectService().findAllOrderBy(IacucProcedure.class, "procedureCategoryCode", true);
    }

    @Override
    public List<IacucProcedureCategory> getAllProcedureCategories() {
        return (List)this.getBusinessObjectService().findAllOrderBy(IacucProcedureCategory.class, "procedureCategoryCode", true);
    }

    @Override
    public List<IacucProtocolSpecies> getProtocolSpecies() {
        Long protocolId = ((IacucProtocolForm)KNSGlobalVariables.getKualiForm()).getIacucProtocolDocument().getProtocol().getProtocolId();
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("protocolId", protocolId);
        return (List)this.getBusinessObjectService().findMatching(IacucProtocolSpecies.class, keyMap);
    }

    @Override
    public List<IacucProtocolStudyGroupBean> getRevisedStudyGroupBeans(IacucProtocol iacucProtocol, List<IacucProcedure> allProcedures) {
        List<IacucProtocolStudyGroupBean> studyGroupBeans = iacucProtocol.getIacucProtocolStudyGroupBeans();
        if (studyGroupBeans.isEmpty()) {
            studyGroupBeans = this.getNewListOfStudyGroupBeans(iacucProtocol, allProcedures);
        }
        if (this.isProcedureViewedBySpecies()) {
            this.groupProcedureStudyBySpecies(iacucProtocol);
        }
        return studyGroupBeans;
    }

    private void selectUsedProcedureCategory(List<IacucProcedure> allProcedures, Integer selectedProcedureCode) {
        for (IacucProcedure iacucProcedure : allProcedures) {
            if (!iacucProcedure.getProcedureCode().equals(selectedProcedureCode)) continue;
            iacucProcedure.setProcedureSelected(true);
            break;
        }
    }

    @Override
    public List<IacucPersonTraining> getIacucPersonTrainingDetails(String personId) {
        return this.getIacucProtocolPersonTrainingService().getIacucPersonTrainingDetails(personId);
    }

    @Override
    public void setTrainingDetails(IacucProtocol protocol) {
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            IacucProtocolPerson iacucProtocolPerson = (IacucProtocolPerson)protocolPerson;
            iacucProtocolPerson.setIacucPersonTrainings(this.getIacucPersonTrainingDetails(iacucProtocolPerson.getPersonId()));
        }
    }

    private List<IacucProtocolStudyGroupBean> getNewListOfStudyGroupBeans(IacucProtocol protocol, List<IacucProcedure> allProcedures) {
        ArrayList<IacucProtocolStudyGroupBean> studyGroupBeans = new ArrayList<IacucProtocolStudyGroupBean>();
        for (IacucProcedure iacucProcedure : this.getAllProcedures()) {
            IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean = this.getCurrentStudyGroupForProcedure(allProcedures, protocol, iacucProcedure);
            if (ObjectUtils.isNull((Object)iacucProtocolStudyGroupBean)) {
                iacucProtocolStudyGroupBean = new IacucProtocolStudyGroupBean();
                iacucProtocolStudyGroupBean.setProcedureCategoryCode(iacucProcedure.getProcedureCategoryCode());
                iacucProtocolStudyGroupBean.setProcedureCode(iacucProcedure.getProcedureCode());
            }
            studyGroupBeans.add(iacucProtocolStudyGroupBean);
        }
        return studyGroupBeans;
    }

    private IacucProtocolStudyGroupBean getCurrentStudyGroupForProcedure(List<IacucProcedure> allProcedures, IacucProtocol protocol, IacucProcedure iacucProcedure) {
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups = protocol.getIacucProtocolStudyGroups();
        IacucProtocolStudyGroupBean currentStudyGroup = null;
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
            if (!iacucProtocolStudyGroup.getProcedureCategoryCode().equals(iacucProcedure.getProcedureCategoryCode()) || !iacucProtocolStudyGroup.getProcedureCode().equals(iacucProcedure.getProcedureCode())) continue;
            currentStudyGroup = iacucProtocolStudyGroup;
            this.selectUsedProcedureCategory(allProcedures, iacucProtocolStudyGroup.getProcedureCode());
            break;
        }
        return currentStudyGroup;
    }

    private List<IacucProcedureCategoryCustomData> getIacucProcedureCustomData(Integer procedureCategoryCode) {
        HashMap<String, Integer> matchingKey = new HashMap<String, Integer>();
        matchingKey.put("procedureCategoryCode", procedureCategoryCode);
        return (List)this.getBusinessObjectService().findMatchingOrderBy(IacucProcedureCategoryCustomData.class, matchingKey, "sortId", true);
    }

    private Integer getNextSequenceNumber(String sequenceKey, Class clazz) {
        return this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceKey, clazz).intValue();
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IacucProtocolPersonTrainingService getIacucProtocolPersonTrainingService() {
        return this.iacucProtocolPersonTrainingService;
    }

    public void setIacucProtocolPersonTrainingService(IacucProtocolPersonTrainingService iacucProtocolPersonTrainingService) {
        this.iacucProtocolPersonTrainingService = iacucProtocolPersonTrainingService;
    }

    public IacucProtocolSpeciesService getIacucProtocolSpeciesService() {
        return this.iacucProtocolSpeciesService;
    }

    public void setIacucProtocolSpeciesService(IacucProtocolSpeciesService iacucProtocolSpeciesService) {
        this.iacucProtocolSpeciesService = iacucProtocolSpeciesService;
    }

    @Override
    public void addProtocolStudyGroup(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocol iacucProtocol) {
        boolean isNewCategoryBean = ObjectUtils.isNull((Object)selectedProtocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId());
        List<String> protocolSpeciesAndGroups = selectedProtocolStudyGroupBean.getProtocolSpeciesAndGroups();
        if (isNewCategoryBean) {
            this.setAttributesForNewStudyGroupBean(selectedProtocolStudyGroupBean, iacucProtocol);
            iacucProtocol.getIacucProtocolStudyGroups().add(selectedProtocolStudyGroupBean);
        }
        List<IacucProtocolStudyGroup> newStudyGroups = this.getNewProtocolStudyGroups(protocolSpeciesAndGroups, iacucProtocol);
        this.addProcedureCustomData(selectedProtocolStudyGroupBean, newStudyGroups, iacucProtocol);
        selectedProtocolStudyGroupBean.getIacucProtocolStudyGroups().addAll(newStudyGroups);
        this.groupProcedureStudyBySpecies(selectedProtocolStudyGroupBean);
    }

    private void groupProcedureStudyBySpecies(IacucProtocol iacucProtocol) {
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocol.getIacucProtocolStudyGroups()) {
            this.groupProcedureStudyBySpecies(iacucProtocolStudyGroupBean);
        }
    }

    private void groupProcedureStudyBySpecies(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = this.getListOfProcedureStudyBySpecies(selectedProtocolStudyGroupBean.getIacucProtocolStudyGroups());
        selectedProtocolStudyGroupBean.setIacucProtocolSpeciesStudyGroups(iacucProtocolSpeciesStudyGroups);
    }

    private List<IacucProtocolSpeciesStudyGroup> getListOfProcedureStudyBySpecies(List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        HashMap<IacucSpecies, IacucProtocolSpeciesStudyGroup> protocolSpeciesStudyGroups = new HashMap<IacucSpecies, IacucProtocolSpeciesStudyGroup>();
        ArrayList<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = new ArrayList<IacucProtocolSpeciesStudyGroup>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
            IacucSpecies iacucSpecies = iacucProtocolStudyGroup.getIacucProtocolSpecies().getIacucSpecies();
            IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup = (IacucProtocolSpeciesStudyGroup)protocolSpeciesStudyGroups.get(iacucSpecies);
            if (ObjectUtils.isNull((Object)iacucProtocolSpeciesStudyGroup)) {
                iacucProtocolSpeciesStudyGroup = new IacucProtocolSpeciesStudyGroup();
                iacucProtocolSpeciesStudyGroup.setSpeciesCode(iacucSpecies.getSpeciesCode());
                iacucProtocolSpeciesStudyGroup.setIacucSpecies(iacucSpecies);
                iacucProtocolSpeciesStudyGroup.setIacucProtocolStudyGroup(iacucProtocolStudyGroup);
                iacucProtocolSpeciesStudyGroups.add(iacucProtocolSpeciesStudyGroup);
                protocolSpeciesStudyGroups.put(iacucSpecies, iacucProtocolSpeciesStudyGroup);
            }
            iacucProtocolSpeciesStudyGroup.getIacucProtocolStudyGroups().add(iacucProtocolStudyGroup);
        }
        return iacucProtocolSpeciesStudyGroups;
    }

    private List<IacucProtocolSpeciesStudyGroup> getListOfProcedureStudyBySpeciesGroup(List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        HashMap<IacucProtocolSpecies, IacucProtocolSpeciesStudyGroup> protocolSpeciesStudyGroups = new HashMap<IacucProtocolSpecies, IacucProtocolSpeciesStudyGroup>();
        ArrayList<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = new ArrayList<IacucProtocolSpeciesStudyGroup>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
            IacucProtocolSpecies iacucProtocolSpecies = iacucProtocolStudyGroup.getIacucProtocolSpecies();
            IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup = (IacucProtocolSpeciesStudyGroup)protocolSpeciesStudyGroups.get(iacucProtocolSpecies);
            if (ObjectUtils.isNull((Object)iacucProtocolSpeciesStudyGroup)) {
                iacucProtocolSpeciesStudyGroup = new IacucProtocolSpeciesStudyGroup();
                iacucProtocolSpeciesStudyGroup.setIacucProtocolSpeciesId(iacucProtocolSpecies.getIacucProtocolSpeciesId());
                iacucProtocolSpeciesStudyGroup.setIacucProtocolSpecies(iacucProtocolSpecies);
                iacucProtocolSpeciesStudyGroup.setSpeciesCode(iacucProtocolSpecies.getIacucSpecies().getSpeciesCode());
                iacucProtocolSpeciesStudyGroup.setIacucSpecies(iacucProtocolSpecies.getIacucSpecies());
                iacucProtocolSpeciesStudyGroup.setIacucProtocolStudyGroup(iacucProtocolStudyGroup);
                iacucProtocolSpeciesStudyGroup.setTotalSpeciesCount(iacucProtocolSpecies.getSpeciesCount());
                iacucProtocolSpeciesStudyGroups.add(iacucProtocolSpeciesStudyGroup);
                protocolSpeciesStudyGroups.put(iacucProtocolSpecies, iacucProtocolSpeciesStudyGroup);
            }
            iacucProtocolSpeciesStudyGroup.getIacucProtocolStudyGroups().add(iacucProtocolStudyGroup);
        }
        return iacucProtocolSpeciesStudyGroups;
    }

    @Override
    public void populateIacucSpeciesPersonProcedures(IacucProtocol iacucProtocol) {
        List<IacucProtocolStudyGroup> iacucProtocolStudyGroups = this.getAllProcedureStudyGroups(iacucProtocol);
        if (this.isProcedureViewedBySpecies()) {
            this.setPersonProceduresBySpecies(iacucProtocol, iacucProtocolStudyGroups);
        } else {
            this.setPersonProceduresByGroups(iacucProtocol, iacucProtocolStudyGroups);
        }
    }

    private void setPersonProceduresBySpecies(IacucProtocol iacucProtocol, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (ProtocolPersonBase protocolPerson : iacucProtocol.getProtocolPersons()) {
            List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = this.getListOfProcedureStudyBySpecies(iacucProtocolStudyGroups);
            IacucProtocolPerson iacucProtocolPerson = (IacucProtocolPerson)protocolPerson;
            iacucProtocolPerson.setProcedureDetails(this.getPersonProcedureDetails(iacucProtocolSpeciesStudyGroups, iacucProtocolPerson));
            iacucProtocolPerson.setAllProceduresSelected(this.isAllProceduresChecked(iacucProtocolPerson.getProcedureDetails()));
        }
    }

    private void setPersonProceduresByGroups(IacucProtocol iacucProtocol, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (ProtocolPersonBase protocolPerson : iacucProtocol.getProtocolPersons()) {
            List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = this.getListOfProcedureStudyBySpeciesGroup(iacucProtocolStudyGroups);
            IacucProtocolPerson iacucProtocolPerson = (IacucProtocolPerson)protocolPerson;
            iacucProtocolPerson.setProcedureDetails(this.getPersonProcedureDetails(iacucProtocolSpeciesStudyGroups, iacucProtocolPerson));
            iacucProtocolPerson.setAllProceduresSelected(this.isAllProceduresChecked(iacucProtocolPerson.getProcedureDetails()));
        }
    }

    private boolean isAllProceduresChecked(List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups) {
        boolean allProceduresSelected = true;
        block0: for (IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup : iacucProtocolSpeciesStudyGroups) {
            iacucProtocolSpeciesStudyGroup.setAllProceduresSelected(true);
            for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocolSpeciesStudyGroup.getResponsibleProcedures()) {
                if (iacucProtocolStudyGroupBean.isProcedureSelected()) continue;
                allProceduresSelected = false;
                iacucProtocolSpeciesStudyGroup.setAllProceduresSelected(false);
                continue block0;
            }
        }
        return allProceduresSelected;
    }

    private List<IacucProtocolSpeciesStudyGroup> getPersonProcedureDetails(List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups, IacucProtocolPerson iacucProtocolPerson) {
        ArrayList<IacucProtocolSpeciesStudyGroup> personProcedureDetails = new ArrayList<IacucProtocolSpeciesStudyGroup>();
        for (IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup : iacucProtocolSpeciesStudyGroups) {
            HashSet<Integer> studyGroupProcedures = new HashSet<Integer>();
            ArrayList<IacucProtocolStudyGroupBean> responsibleProcedures = new ArrayList<IacucProtocolStudyGroupBean>();
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                if (!studyGroupProcedures.add(iacucProtocolStudyGroup.getIacucProtocolStudyGroupHeaderId())) continue;
                IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean = this.getNewCopyOfStudyGroupBean(iacucProtocolStudyGroup.getIacucProtocolStudyGroupBean());
                if (this.isPersonResponsibleForProcedure(iacucProtocolPerson, iacucProtocolStudyGroup)) {
                    newIacucProtocolStudyGroupBean.setProcedureSelected(true);
                    newIacucProtocolStudyGroupBean.setNewProcedure(false);
                }
                responsibleProcedures.add(newIacucProtocolStudyGroupBean);
            }
            iacucProtocolSpeciesStudyGroup.setResponsibleProcedures(responsibleProcedures);
            personProcedureDetails.add(iacucProtocolSpeciesStudyGroup);
        }
        return personProcedureDetails;
    }

    @Override
    public void populateIacucSpeciesLocationProcedures(IacucProtocol iacucProtocol) {
        this.populateProcedureStudyGroupLocations(iacucProtocol);
        this.populateSpeciesLocationProcedures(iacucProtocol);
    }

    private void populateSpeciesLocationProcedures(IacucProtocol iacucProtocol) {
        List<IacucProtocolStudyGroup> iacucProtocolStudyGroups = this.getAllProcedureStudyGroups(iacucProtocol);
        if (this.isProcedureViewedBySpecies()) {
            this.setLocationProceduresBySpecies(iacucProtocol, iacucProtocolStudyGroups);
        } else {
            this.setLocationProceduresByGroups(iacucProtocol, iacucProtocolStudyGroups);
        }
    }

    private void setLocationProceduresBySpecies(IacucProtocol iacucProtocol, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : iacucProtocol.getIacucProtocolStudyGroupLocations()) {
            List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = this.getListOfProcedureStudyBySpecies(iacucProtocolStudyGroups);
            iacucProtocolStudyGroupLocation.setProcedureDetails(this.getLocationProcedureDetails(iacucProtocolSpeciesStudyGroups, iacucProtocolStudyGroupLocation));
            iacucProtocolStudyGroupLocation.setAllProceduresSelected(this.isAllProceduresChecked(iacucProtocolStudyGroupLocation.getProcedureDetails()));
        }
    }

    private void setLocationProceduresByGroups(IacucProtocol iacucProtocol, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : iacucProtocol.getIacucProtocolStudyGroupLocations()) {
            List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups = this.getListOfProcedureStudyBySpeciesGroup(iacucProtocolStudyGroups);
            iacucProtocolStudyGroupLocation.setProcedureDetails(this.getLocationProcedureDetails(iacucProtocolSpeciesStudyGroups, iacucProtocolStudyGroupLocation));
            iacucProtocolStudyGroupLocation.setAllProceduresSelected(this.isAllProceduresChecked(iacucProtocolStudyGroupLocation.getProcedureDetails()));
        }
    }

    private List<IacucProtocolSpeciesStudyGroup> getLocationProcedureDetails(List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups, IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation) {
        ArrayList<IacucProtocolSpeciesStudyGroup> locationProcedureDetails = new ArrayList<IacucProtocolSpeciesStudyGroup>();
        for (IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup : iacucProtocolSpeciesStudyGroups) {
            HashSet<Integer> studyGroupProcedures = new HashSet<Integer>();
            ArrayList<IacucProtocolStudyGroupBean> responsibleProcedures = new ArrayList<IacucProtocolStudyGroupBean>();
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                if (!studyGroupProcedures.add(iacucProtocolStudyGroup.getIacucProtocolStudyGroupHeaderId())) continue;
                IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean = this.getNewCopyOfStudyGroupBean(iacucProtocolStudyGroup.getIacucProtocolStudyGroupBean());
                if (this.isLocationResponsibleForProcedure(iacucProtocolStudyGroupLocation, iacucProtocolStudyGroup)) {
                    newIacucProtocolStudyGroupBean.setProcedureSelected(true);
                    newIacucProtocolStudyGroupBean.setNewProcedure(false);
                }
                responsibleProcedures.add(newIacucProtocolStudyGroupBean);
            }
            iacucProtocolSpeciesStudyGroup.setResponsibleProcedures(responsibleProcedures);
            locationProcedureDetails.add(iacucProtocolSpeciesStudyGroup);
        }
        return locationProcedureDetails;
    }

    private void populateProcedureStudyGroupLocations(IacucProtocol iacucProtocol) {
        List<IacucProtocolStudyGroup> iacucProtocolStudyGroups = this.getAllProcedureStudyGroups(iacucProtocol);
        ArrayList<IacucProtocolStudyGroupLocation> iacucProtocolStudyGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
        HashSet<Integer> studyLocations = new HashSet<Integer>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
            for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList()) {
                if (!studyLocations.add(iacucProtocolStudyGroupLocation.getStudyGroupLocationId())) continue;
                iacucProtocolStudyGroupLocations.add(iacucProtocolStudyGroupLocation);
            }
        }
        iacucProtocol.setIacucProtocolStudyGroupLocations(iacucProtocolStudyGroupLocations);
    }

    private List<IacucProtocolStudyGroup> getAllProcedureStudyGroups(IacucProtocol iacucProtocol) {
        ArrayList<IacucProtocolStudyGroup> iacucProtocolStudyGroup = new ArrayList<IacucProtocolStudyGroup>();
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocol.getIacucProtocolStudyGroups()) {
            iacucProtocolStudyGroup.addAll(iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups());
        }
        return iacucProtocolStudyGroup;
    }

    private IacucProtocolStudyGroupBean getNewCopyOfStudyGroupBean(IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean) {
        IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean = new IacucProtocolStudyGroupBean();
        newIacucProtocolStudyGroupBean.setProcedureCode(iacucProtocolStudyGroupBean.getProcedureCode());
        newIacucProtocolStudyGroupBean.setProcedureCategoryCode(iacucProtocolStudyGroupBean.getProcedureCategoryCode());
        newIacucProtocolStudyGroupBean.setIacucProcedure(iacucProtocolStudyGroupBean.getIacucProcedure());
        newIacucProtocolStudyGroupBean.setIacucProcedureCategory(iacucProtocolStudyGroupBean.getIacucProcedureCategory());
        newIacucProtocolStudyGroupBean.setProcedureSelected(false);
        newIacucProtocolStudyGroupBean.setNewProcedure(true);
        return newIacucProtocolStudyGroupBean;
    }

    private boolean isPersonResponsibleForProcedure(IacucProtocolPerson iacucProtocolPerson, IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        boolean personResponsibleForProcedure = false;
        for (IacucProcedurePersonResponsible IacucProcedurePersonResponsible2 : iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList()) {
            if (!IacucProcedurePersonResponsible2.getProtocolPersonId().equals(iacucProtocolPerson.getProtocolPersonId())) continue;
            personResponsibleForProcedure = true;
            break;
        }
        return personResponsibleForProcedure;
    }

    private boolean isLocationResponsibleForProcedure(IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation, IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        boolean locationResponsibleForProcedure = false;
        for (IacucProtocolStudyGroupLocation iacucProcedureLocationResponsible : iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList()) {
            if (!iacucProcedureLocationResponsible.getStudyGroupLocationId().equals(iacucProtocolStudyGroupLocation.getStudyGroupLocationId())) continue;
            locationResponsibleForProcedure = true;
            break;
        }
        return locationResponsibleForProcedure;
    }

    @Override
    public void synchronizeProtocolStudyGroups(IacucProtocol iacucProtocol) {
        if (this.isProcedureViewedBySpecies()) {
            List<IacucProtocolStudyGroupLocation> newProtocolStudyLocationList = iacucProtocol.getIacucProtocolStudyGroupLocations();
            for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocol.getIacucProtocolStudyGroups()) {
                this.synchronizeProtocolStudyGroups(iacucProtocolStudyGroupBean);
                this.synchronizeProcedureLocationList(iacucProtocolStudyGroupBean, newProtocolStudyLocationList);
            }
        }
    }

    private void synchronizeProtocolStudyGroups(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        for (IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup : selectedProtocolStudyGroupBean.getIacucProtocolSpeciesStudyGroups()) {
            IacucProtocolStudyGroup newIacucProtocolStudyGroup = iacucProtocolSpeciesStudyGroup.getIacucProtocolStudyGroup();
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                iacucProtocolStudyGroup.setPainCategoryCode(newIacucProtocolStudyGroup.getPainCategoryCode());
                iacucProtocolStudyGroup.setCount(newIacucProtocolStudyGroup.getCount());
                this.synchronizeProcedureCustomDataList(newIacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList(), iacucProtocolStudyGroup);
            }
        }
    }

    private void synchronizeProcedureCustomDataList(List<IacucProtocolStudyCustomData> newProtocolStudyCustomDataList, IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        for (IacucProtocolStudyCustomData newIacucProtocolStudyCustomData : newProtocolStudyCustomDataList) {
            for (IacucProtocolStudyCustomData iacucProtocolStudyCustomData : iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                if (!iacucProtocolStudyCustomData.getProcedureCustomAttributeId().equals(newIacucProtocolStudyCustomData.getProcedureCustomAttributeId())) continue;
                iacucProtocolStudyCustomData.setValue(newIacucProtocolStudyCustomData.getValue());
            }
        }
    }

    private void synchronizeProcedureLocationList(IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean, List<IacucProtocolStudyGroupLocation> newProtocolStudyLocationList) {
        for (IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation : newProtocolStudyLocationList) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList()) {
                    if (!iacucProtocolStudyGroupLocation.getStudyGroupLocationId().equals(newIacucProtocolStudyGroupLocation.getStudyGroupLocationId())) continue;
                    iacucProtocolStudyGroupLocation.setLocationTypeCode(newIacucProtocolStudyGroupLocation.getLocationTypeCode());
                    iacucProtocolStudyGroupLocation.setLocationId(newIacucProtocolStudyGroupLocation.getLocationId());
                    iacucProtocolStudyGroupLocation.setStudyGroupLocationDescription(newIacucProtocolStudyGroupLocation.getStudyGroupLocationDescription());
                    iacucProtocolStudyGroupLocation.setLocationRoom(newIacucProtocolStudyGroupLocation.getLocationRoom());
                }
            }
        }
    }

    private List<IacucProtocolStudyGroup> getNewProtocolStudyGroups(List<String> protocolSpeciesAndGroups, IacucProtocol protocol) {
        ArrayList<IacucProtocolStudyGroup> protocolStudyGroups = new ArrayList<IacucProtocolStudyGroup>();
        for (String iacucProtocolSpeciesId : protocolSpeciesAndGroups) {
            IacucProtocolStudyGroup iacucProtocolStudyGroup = new IacucProtocolStudyGroup();
            iacucProtocolStudyGroup.setIacucProtocolSpeciesId(Integer.parseInt(iacucProtocolSpeciesId));
            iacucProtocolStudyGroup.setCount(iacucProtocolStudyGroup.getIacucProtocolSpecies().getSpeciesCount());
            iacucProtocolStudyGroup.setPainCategoryCode(iacucProtocolStudyGroup.getIacucProtocolSpecies().getPainCategoryCode());
            iacucProtocolStudyGroup.setIacucPainCategory(iacucProtocolStudyGroup.getIacucPainCategory());
            protocolStudyGroups.add(iacucProtocolStudyGroup);
        }
        return protocolStudyGroups;
    }

    private void addProcedureCustomData(IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean, List<IacucProtocolStudyGroup> newStudyGroups, IacucProtocol protocol) {
        List<IacucProcedureCategoryCustomData> procedureCustomDataList = this.getIacucProcedureCustomData(selectedIacucProtocolStudyGroupBean.getProcedureCategoryCode());
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : newStudyGroups) {
            ArrayList<IacucProtocolStudyCustomData> protocolStudyCustomDataList = new ArrayList<IacucProtocolStudyCustomData>();
            for (IacucProcedureCategoryCustomData procedureCategoryCustomData : procedureCustomDataList) {
                if (!procedureCategoryCustomData.isActive()) continue;
                IacucProtocolStudyCustomData newIacucProtocolStudyCustomData = new IacucProtocolStudyCustomData();
                newIacucProtocolStudyCustomData.setProcedureCustomAttributeId(procedureCategoryCustomData.getId());
                newIacucProtocolStudyCustomData.setIacucProcedureCategoryCustomData(procedureCategoryCustomData);
                protocolStudyCustomDataList.add(newIacucProtocolStudyCustomData);
            }
            iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList().addAll(protocolStudyCustomDataList);
        }
    }

    private void setAttributesForNewStudyGroupBean(IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean, IacucProtocol protocol) {
        selectedIacucProtocolStudyGroupBean.setIacucProtocolStudyGroupHeaderId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_HEADER_SEQUENCE_ID, selectedIacucProtocolStudyGroupBean.getClass()));
        selectedIacucProtocolStudyGroupBean.setProtocolId(protocol.getProtocolId());
        selectedIacucProtocolStudyGroupBean.setProtocolNumber(protocol.getProtocolNumber());
        selectedIacucProtocolStudyGroupBean.setSequenceNumber(protocol.getSequenceNumber());
    }

    @Override
    public void deleteProtocolStudyGroup(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocolStudyGroup deletedIacucProtocolStudyGroup, IacucProtocol iacucProtocol) {
        selectedProtocolStudyGroupBean.getIacucProtocolStudyGroups().remove(deletedIacucProtocolStudyGroup);
        if (selectedProtocolStudyGroupBean.getIacucProtocolStudyGroups().size() == 0) {
            iacucProtocol.getIacucProtocolStudyGroups().remove(selectedProtocolStudyGroupBean);
        }
    }

    @Override
    public void deleteProcedureGroupPersonResponsible(IacucProtocolStudyGroup selectedProtocolStudyGroup, IacucProcedurePersonResponsible deletedProcedurePersonResponsible, IacucProtocol iacucProtocol) {
        selectedProtocolStudyGroup.getIacucProcedurePersonResponsibleList().remove(deletedProcedurePersonResponsible);
    }

    @Override
    public void deleteProcedureGroupLocation(IacucProtocolStudyGroup selectedProtocolStudyGroup, IacucProtocolStudyGroupLocation deletedProtocolStudyGroupLocation, IacucProtocol iacucProtocol) {
        selectedProtocolStudyGroup.getIacucProcedureLocationResponsibleList().remove(deletedProtocolStudyGroupLocation);
    }

    @Override
    public void deleteProtocolStudyGroup(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocolSpeciesStudyGroup deletedIacucProtocolStudyGroup) {
        selectedProtocolStudyGroupBean.getIacucProtocolStudyGroups().removeAll(deletedIacucProtocolStudyGroup.getIacucProtocolStudyGroups());
        selectedProtocolStudyGroupBean.getIacucProtocolSpeciesStudyGroups().remove(deletedIacucProtocolStudyGroup);
    }

    @Override
    public void addProcedureLocation(IacucProtocolStudyGroupLocation newStudyGroupLocation, IacucProtocol protocol) {
        this.updateAttributesForNewProcedureLocation(newStudyGroupLocation, protocol);
        protocol.getIacucProtocolStudyGroupLocations().add(newStudyGroupLocation);
        this.populateSpeciesLocationProcedures(protocol);
    }

    @Override
    public void addProcedureGroupLocation(IacucProtocolStudyGroupLocation newStudyGroupLocation, IacucProtocolStudyGroup selectedStudyGroup, IacucProtocol protocol) {
        this.populateProcedureStudyGroupLocations(protocol);
        this.updateAttributesForNewProcedureLocation(newStudyGroupLocation, protocol);
        protocol.getIacucProtocolStudyGroupLocations().add(newStudyGroupLocation);
        selectedStudyGroup.getIacucProcedureLocationResponsibleList().add(newStudyGroupLocation);
        selectedStudyGroup.setNewIacucProtocolStudyGroupLocation(new IacucProtocolStudyGroupLocation());
    }

    @Override
    public void deleteProcedureLocation(IacucProtocolStudyGroupLocation deletedIacucProtocolStudyGroupLocation, IacucProtocol iacucProtocol) {
        this.deleteProcedureLocationList(iacucProtocol, deletedIacucProtocolStudyGroupLocation);
        iacucProtocol.getIacucProtocolStudyGroupLocations().remove(deletedIacucProtocolStudyGroupLocation);
    }

    private void deleteProcedureLocationList(IacucProtocol protocol, IacucProtocolStudyGroupLocation deletedProtocolStudyGroupLocation) {
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : protocol.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                ArrayList<IacucProtocolStudyGroupLocation> deletedProtocolStudyGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
                for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList()) {
                    if (!iacucProtocolStudyGroupLocation.getStudyGroupLocationId().equals(deletedProtocolStudyGroupLocation.getStudyGroupLocationId())) continue;
                    deletedProtocolStudyGroupLocations.add(iacucProtocolStudyGroupLocation);
                }
                iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList().removeAll(deletedProtocolStudyGroupLocations);
            }
        }
    }

    private void updateAttributesForNewProcedureLocation(IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation, IacucProtocol protocol) {
        newIacucProtocolStudyGroupLocation.setStudyGroupLocationId(this.getNextStudyGroupLocationId(protocol));
    }

    private Integer getNextStudyGroupLocationId(IacucProtocol iacucProtocol) {
        Integer nextStudyGroupLocationId = 1;
        if (!iacucProtocol.getIacucProtocolStudyGroupLocations().isEmpty()) {
            List<IacucProtocolStudyGroupLocation> sortedStudyGroupLocations = this.getSortedStudyGroupLocations(iacucProtocol);
            int totalStudyGroupLocs = sortedStudyGroupLocations.size();
            nextStudyGroupLocationId = sortedStudyGroupLocations.get(totalStudyGroupLocs - 1).getStudyGroupLocationId() + 1;
        }
        return nextStudyGroupLocationId;
    }

    private List<IacucProtocolStudyGroupLocation> getSortedStudyGroupLocations(IacucProtocol iacucProtocol) {
        List<IacucProtocolStudyGroupLocation> protocolStudyGroupLocations = iacucProtocol.getIacucProtocolStudyGroupLocations();
        Collections.sort(protocolStudyGroupLocations, new Comparator<IacucProtocolStudyGroupLocation>(){

            @Override
            public int compare(IacucProtocolStudyGroupLocation location1, IacucProtocolStudyGroupLocation location2) {
                return location1.getStudyGroupLocationId().compareTo(location2.getStudyGroupLocationId());
            }
        });
        return protocolStudyGroupLocations;
    }

    @Override
    public void addLocationResponsibleProcedures(IacucProtocol protocol) {
        for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : protocol.getIacucProtocolStudyGroupLocations()) {
            for (IacucProtocolSpeciesStudyGroup protocolSpeciesStudyGroup : iacucProtocolStudyGroupLocation.getProcedureDetails()) {
                for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : protocolSpeciesStudyGroup.getResponsibleProcedures()) {
                    if (iacucProtocolStudyGroupBean.isProcedureSelected()) {
                        this.addLocationResponsibleProcedures(iacucProtocolStudyGroupBean, iacucProtocolStudyGroupLocation, protocolSpeciesStudyGroup);
                        continue;
                    }
                    this.deleteLocationResponsibleProcedures(iacucProtocolStudyGroupBean, iacucProtocolStudyGroupLocation, protocolSpeciesStudyGroup);
                }
            }
        }
        this.populateSpeciesLocationProcedures(protocol);
    }

    private void addLocationResponsibleProcedures(IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean, IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation, IacucProtocolSpeciesStudyGroup protocolSpeciesStudyGroup) {
        if (iacucProtocolStudyGroupBean.isNewProcedure()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                if (!iacucProtocolStudyGroup.getIacucProtocolStudyGroupBean().getProcedureCode().equals(iacucProtocolStudyGroupBean.getProcedureCode())) continue;
                IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation = (IacucProtocolStudyGroupLocation)this.deepCopy(iacucProtocolStudyGroupLocation);
                newIacucProtocolStudyGroupLocation.resetPersistenceState();
                iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList().add(newIacucProtocolStudyGroupLocation);
            }
        }
    }

    private void deleteLocationResponsibleProcedures(IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean, IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation, IacucProtocolSpeciesStudyGroup protocolSpeciesStudyGroup) {
        if (!iacucProtocolStudyGroupBean.isNewProcedure()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                ArrayList<IacucProtocolStudyGroupLocation> deletedProcedureLocationResponsible = new ArrayList<IacucProtocolStudyGroupLocation>();
                if (iacucProtocolStudyGroup.getIacucProtocolStudyGroupBean().getProcedureCode().equals(iacucProtocolStudyGroupBean.getProcedureCode())) {
                    for (IacucProtocolStudyGroupLocation iacucProcedureLocationResponsible : iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList()) {
                        if (!iacucProcedureLocationResponsible.getStudyGroupLocationId().equals(iacucProtocolStudyGroupLocation.getStudyGroupLocationId())) continue;
                        deletedProcedureLocationResponsible.add(iacucProcedureLocationResponsible);
                    }
                }
                iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList().removeAll(deletedProcedureLocationResponsible);
            }
        }
    }

    @Override
    public void addPersonResponsibleProcedures(IacucProtocol protocol) {
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            IacucProtocolPerson iacucProtocolPerson = (IacucProtocolPerson)protocolPerson;
            for (IacucProtocolSpeciesStudyGroup protocolSpeciesStudyGroup : iacucProtocolPerson.getProcedureDetails()) {
                for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : protocolSpeciesStudyGroup.getResponsibleProcedures()) {
                    if (iacucProtocolStudyGroupBean.isProcedureSelected()) {
                        this.addPersonResponsibleProcedures(iacucProtocolStudyGroupBean, iacucProtocolPerson, protocolSpeciesStudyGroup);
                        continue;
                    }
                    this.deletePersonResponsibleProcedures(iacucProtocolStudyGroupBean, iacucProtocolPerson, protocolSpeciesStudyGroup);
                }
            }
        }
        this.populateIacucSpeciesPersonProcedures(protocol);
    }

    private void addPersonResponsibleProcedures(IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean, IacucProtocolPerson protocolPerson, IacucProtocolSpeciesStudyGroup protocolSpeciesStudyGroup) {
        if (iacucProtocolStudyGroupBean.isNewProcedure()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                if (!iacucProtocolStudyGroup.getIacucProtocolStudyGroupBean().getProcedureCode().equals(iacucProtocolStudyGroupBean.getProcedureCode())) continue;
                IacucProcedurePersonResponsible newIacucProcedurePersonResponsible = this.getNewPersonResponsibleProcedure(protocolPerson, iacucProtocolStudyGroup);
                iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList().add(newIacucProcedurePersonResponsible);
            }
        }
    }

    private void deletePersonResponsibleProcedures(IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean, IacucProtocolPerson protocolPerson, IacucProtocolSpeciesStudyGroup protocolSpeciesStudyGroup) {
        if (!iacucProtocolStudyGroupBean.isNewProcedure()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolSpeciesStudyGroup.getIacucProtocolStudyGroups()) {
                ArrayList<IacucProcedurePersonResponsible> deletedProcedurePersonResponsible = new ArrayList<IacucProcedurePersonResponsible>();
                if (iacucProtocolStudyGroup.getIacucProtocolStudyGroupBean().getProcedureCode().equals(iacucProtocolStudyGroupBean.getProcedureCode())) {
                    for (IacucProcedurePersonResponsible iacucProcedurePersonResponsible : iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList()) {
                        if (!iacucProcedurePersonResponsible.getProtocolPersonId().equals(protocolPerson.getProtocolPersonId())) continue;
                        deletedProcedurePersonResponsible.add(iacucProcedurePersonResponsible);
                    }
                }
                iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList().removeAll(deletedProcedurePersonResponsible);
            }
        }
    }

    private HashMap<String, IacucProtocolPerson> getProtocolPersons(IacucProtocol iacucProtocol) {
        HashMap<String, IacucProtocolPerson> protocolPersons = new HashMap<String, IacucProtocolPerson>();
        for (ProtocolPersonBase protocolPersonBase : iacucProtocol.getProtocolPersons()) {
            IacucProtocolPerson iacucProtocolPerson = (IacucProtocolPerson)protocolPersonBase;
            protocolPersons.put(iacucProtocolPerson.getPersonId(), iacucProtocolPerson);
        }
        return protocolPersons;
    }

    private IacucProcedurePersonResponsible getNewPersonResponsibleProcedure(IacucProtocolPerson protocolPerson, IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        IacucProcedurePersonResponsible resposibleProcedure = new IacucProcedurePersonResponsible();
        this.setAttributesForPersonResponsibleProcedure(resposibleProcedure, protocolPerson, iacucProtocolStudyGroup);
        return resposibleProcedure;
    }

    private void setAttributesForPersonResponsibleProcedure(IacucProcedurePersonResponsible resposibleProcedure, IacucProtocolPerson protocolPerson, IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        resposibleProcedure.setProtocolPersonId(protocolPerson.getProtocolPersonId());
        resposibleProcedure.setProtocolPerson(protocolPerson);
        resposibleProcedure.setIacucProtocolStudyGroupId(iacucProtocolStudyGroup.getIacucProtocolStudyGroupId());
    }

    @Override
    public void setProcedureSummaryGroupedBySpecies(IacucProtocol protocol) {
        List<IacucProtocolStudyGroup> iacucProtocolStudyGroups = this.getAllProcedureStudyGroups(protocol);
        List<IacucProtocolSpeciesStudyGroup> iacucProtocolStudyGroupSpeciesList = this.getListOfProcedureStudyBySpecies(iacucProtocolStudyGroups);
        this.updateSpeciesCount(iacucProtocolStudyGroupSpeciesList, protocol);
        protocol.setIacucProtocolStudyGroupSpeciesList(iacucProtocolStudyGroupSpeciesList);
        this.addStudyGroupProceduresForSpecies(protocol);
        this.addStudyGroupProcedureDetailsForSpecies(protocol);
    }

    private void updateSpeciesCount(List<IacucProtocolSpeciesStudyGroup> iacucProtocolSpeciesStudyGroups, IacucProtocol protocol) {
        for (IacucProtocolSpeciesStudyGroup iacucProtocolSpeciesStudyGroup : iacucProtocolSpeciesStudyGroups) {
            for (IacucProtocolSpecies iacucProtocolSpecies : protocol.getIacucProtocolSpeciesList()) {
                if (!iacucProtocolSpecies.getSpeciesCode().equals(iacucProtocolSpeciesStudyGroup.getSpeciesCode())) continue;
                iacucProtocolSpeciesStudyGroup.addSpeciesCount(iacucProtocolSpecies.getSpeciesCount());
            }
        }
    }

    @Override
    public void setProcedureSummaryBySpeciesGroup(IacucProtocol protocol) {
        List<IacucProtocolStudyGroup> iacucProtocolStudyGroups = this.getAllProcedureStudyGroups(protocol);
        List<IacucProtocolSpeciesStudyGroup> iacucProtocolStudyGroupSpeciesList = this.getListOfProcedureStudyBySpeciesGroup(iacucProtocolStudyGroups);
        protocol.setIacucProtocolStudyGroupSpeciesList(iacucProtocolStudyGroupSpeciesList);
        this.addProceduresForSpeciesGroups(protocol);
        this.addProcedureDetailsForSpeciesGroups(protocol);
    }

    private void addProceduresForSpeciesGroups(IacucProtocol protocol) {
        for (IacucProtocolSpeciesStudyGroup protocolStudyGroupSpecies : protocol.getIacucProtocolStudyGroupSpeciesList()) {
            protocolStudyGroupSpecies.setResponsibleProcedures(new ArrayList<IacucProtocolStudyGroupBean>());
            protocolStudyGroupSpecies.getResponsibleProcedures().addAll(this.getStudyGroupProceduresForSpeciesGroup(protocol, protocolStudyGroupSpecies.getIacucProtocolSpecies()));
        }
    }

    private List<IacucProtocolStudyGroupBean> getStudyGroupProceduresForSpeciesGroup(IacucProtocol protocol, IacucProtocolSpecies iacucProtocolSpecies) {
        ArrayList<IacucProtocolStudyGroupBean> protocolStudyGroups = new ArrayList<IacucProtocolStudyGroupBean>();
        for (IacucProtocolStudyGroupBean protocolStudyGroupBean : protocol.getIacucProtocolStudyGroups()) {
            ArrayList<IacucProtocolStudyGroup> iacucProtocolStudyGroups = new ArrayList<IacucProtocolStudyGroup>();
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                if (!iacucProtocolStudyGroup.getIacucProtocolSpeciesId().equals(iacucProtocolSpecies.getIacucProtocolSpeciesId())) continue;
                iacucProtocolStudyGroups.add(iacucProtocolStudyGroup);
            }
            this.addProceduresDetails(iacucProtocolStudyGroups, protocolStudyGroups, protocolStudyGroupBean);
        }
        return protocolStudyGroups;
    }

    private void addProceduresDetails(List<IacucProtocolStudyGroup> iacucProtocolStudyGroups, List<IacucProtocolStudyGroupBean> protocolStudyGroups, IacucProtocolStudyGroupBean protocolStudyGroupBean) {
        if (!iacucProtocolStudyGroups.isEmpty()) {
            IacucProtocolStudyGroupBean newProtocolStudyGroupBean = this.getNewProtocolStudyGroupBean(protocolStudyGroupBean);
            newProtocolStudyGroupBean.getIacucProtocolStudyGroups().addAll(iacucProtocolStudyGroups);
            protocolStudyGroups.add(newProtocolStudyGroupBean);
        }
    }

    private void addStudyGroupProceduresForSpecies(IacucProtocol protocol) {
        for (IacucProtocolSpeciesStudyGroup protocolStudyGroupSpecies : protocol.getIacucProtocolStudyGroupSpeciesList()) {
            protocolStudyGroupSpecies.setResponsibleProcedures(new ArrayList<IacucProtocolStudyGroupBean>());
            Integer speciesCode = protocolStudyGroupSpecies.getSpeciesCode();
            protocolStudyGroupSpecies.getResponsibleProcedures().addAll(this.getStudyGroupProceduresForSpecies(protocol, speciesCode));
        }
    }

    private List<IacucProtocolStudyGroupBean> getStudyGroupProceduresForSpecies(IacucProtocol protocol, Integer speciesCode) {
        ArrayList<IacucProtocolStudyGroupBean> protocolStudyGroups = new ArrayList<IacucProtocolStudyGroupBean>();
        for (IacucProtocolStudyGroupBean protocolStudyGroupBean : protocol.getIacucProtocolStudyGroups()) {
            ArrayList<IacucProtocolStudyGroup> iacucProtocolStudyGroups = new ArrayList<IacucProtocolStudyGroup>();
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                if (!iacucProtocolStudyGroup.getIacucProtocolSpecies().getSpeciesCode().equals(speciesCode)) continue;
                iacucProtocolStudyGroups.add(iacucProtocolStudyGroup);
            }
            this.addProceduresDetails(iacucProtocolStudyGroups, protocolStudyGroups, protocolStudyGroupBean);
        }
        return protocolStudyGroups;
    }

    private IacucProtocolStudyGroupBean getNewProtocolStudyGroupBean(IacucProtocolStudyGroupBean protocolStudyGroupBean) {
        IacucProtocolStudyGroupBean newProtocolStudyGroupBean = new IacucProtocolStudyGroupBean();
        newProtocolStudyGroupBean.setIacucProtocolStudyGroupHeaderId(protocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId());
        newProtocolStudyGroupBean.setIacucProcedureCategory(protocolStudyGroupBean.getIacucProcedureCategory());
        newProtocolStudyGroupBean.setIacucProcedure(protocolStudyGroupBean.getIacucProcedure());
        return newProtocolStudyGroupBean;
    }

    private void addStudyGroupProcedureDetailsForSpecies(IacucProtocol protocol) {
        for (IacucProtocolSpeciesStudyGroup protocolStudyGroupSpecies : protocol.getIacucProtocolStudyGroupSpeciesList()) {
            for (IacucProtocolStudyGroupBean protocolStudyGroupBean : protocolStudyGroupSpecies.getResponsibleProcedures()) {
                this.setAllProcedureDetailsForSpecies(protocolStudyGroupSpecies, protocolStudyGroupBean);
                Integer totalProcSpeciesCount = 0;
                for (IacucProtocolStudyGroup studyGroup : protocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                    if (!protocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId().equals(studyGroup.getIacucProtocolStudyGroupHeaderId()) || !studyGroup.getIacucProtocolSpecies().getSpeciesCode().equals(protocolStudyGroupSpecies.getSpeciesCode())) continue;
                    totalProcSpeciesCount = totalProcSpeciesCount + studyGroup.getCount();
                }
                protocolStudyGroupBean.setSpeciesCount(totalProcSpeciesCount);
            }
        }
    }

    private void setAllProcedureDetails(IacucProtocolSpeciesStudyGroup protocolStudyGroupSpecies, IacucProtocolStudyGroupBean protocolStudyGroupBean) {
        ArrayList<IacucProtocolStudyGroupLocation> allIacucProtocolStudyGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
        ArrayList<IacucProcedurePersonResponsible> allIacucProtocolStudyGroupPersons = new ArrayList<IacucProcedurePersonResponsible>();
        ArrayList<IacucProtocolStudyCustomData> allIacucProtocolStudyCustomDataList = new ArrayList<IacucProtocolStudyCustomData>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolStudyGroupSpecies.getIacucProtocolStudyGroups()) {
            if (!iacucProtocolStudyGroup.getIacucProtocolStudyGroupHeaderId().equals(protocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId())) continue;
            allIacucProtocolStudyGroupLocations.addAll(iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList());
            allIacucProtocolStudyGroupPersons.addAll(iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList());
            allIacucProtocolStudyCustomDataList.addAll(iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList());
        }
        protocolStudyGroupBean.setIacucProtocolStudyGroupLocations(allIacucProtocolStudyGroupLocations);
        protocolStudyGroupBean.setIacucProtocolStudyGroupPersons(allIacucProtocolStudyGroupPersons);
        protocolStudyGroupBean.setIacucProtocolStudyCustomDataList(allIacucProtocolStudyCustomDataList);
    }

    private void setAllProcedureDetailsForSpecies(IacucProtocolSpeciesStudyGroup protocolStudyGroupSpecies, IacucProtocolStudyGroupBean protocolStudyGroupBean) {
        ArrayList<IacucProtocolStudyGroupLocation> allIacucProtocolStudyGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
        ArrayList<IacucProcedurePersonResponsible> allIacucProtocolStudyGroupPersons = new ArrayList<IacucProcedurePersonResponsible>();
        ArrayList<IacucProtocolStudyCustomData> allIacucProtocolStudyCustomDataList = new ArrayList<IacucProtocolStudyCustomData>();
        HashMap<IacucSpecies, IacucProtocolStudyGroup> protocolSpeciesStudyGroups = new HashMap<IacucSpecies, IacucProtocolStudyGroup>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : protocolStudyGroupSpecies.getIacucProtocolStudyGroups()) {
            IacucSpecies iacucSpecies;
            IacucProtocolStudyGroup groupedProtocolStudyGroup;
            if (!iacucProtocolStudyGroup.getIacucProtocolStudyGroupHeaderId().equals(protocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId()) || !ObjectUtils.isNull((Object)(groupedProtocolStudyGroup = (IacucProtocolStudyGroup)protocolSpeciesStudyGroups.get(iacucSpecies = iacucProtocolStudyGroup.getIacucProtocolSpecies().getIacucSpecies())))) continue;
            allIacucProtocolStudyGroupLocations.addAll(iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList());
            allIacucProtocolStudyGroupPersons.addAll(iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList());
            allIacucProtocolStudyCustomDataList.addAll(iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList());
            protocolSpeciesStudyGroups.put(iacucSpecies, iacucProtocolStudyGroup);
        }
        protocolStudyGroupBean.setIacucProtocolStudyGroupLocations(allIacucProtocolStudyGroupLocations);
        protocolStudyGroupBean.setIacucProtocolStudyGroupPersons(allIacucProtocolStudyGroupPersons);
        protocolStudyGroupBean.setIacucProtocolStudyCustomDataList(allIacucProtocolStudyCustomDataList);
    }

    private void addProcedureDetailsForSpeciesGroups(IacucProtocol protocol) {
        for (IacucProtocolSpeciesStudyGroup protocolStudyGroupSpecies : protocol.getIacucProtocolStudyGroupSpeciesList()) {
            for (IacucProtocolStudyGroupBean protocolStudyGroupBean : protocolStudyGroupSpecies.getResponsibleProcedures()) {
                this.setAllProcedureDetails(protocolStudyGroupSpecies, protocolStudyGroupBean);
                Integer totalProcSpeciesCount = 0;
                IacucProtocolSpecies iacucProtocolSpecies = protocolStudyGroupSpecies.getIacucProtocolSpecies();
                for (IacucProtocolStudyGroup studyGroup : protocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                    if (!protocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId().equals(studyGroup.getIacucProtocolStudyGroupHeaderId()) || !studyGroup.getIacucProtocolSpeciesId().equals(iacucProtocolSpecies.getIacucProtocolSpeciesId())) continue;
                    totalProcSpeciesCount = totalProcSpeciesCount + studyGroup.getCount();
                }
                protocolStudyGroupBean.setSpeciesCount(totalProcSpeciesCount);
            }
        }
    }

    @Override
    public void createNewProtocolStudyProcedures(IacucProtocol sourceProtocol, IacucProtocol destProtocol) {
        this.createNewStudyProcedures(sourceProtocol, destProtocol);
    }

    @Override
    public void mergeProtocolSpecies(IacucProtocol sourceProtocol, IacucProtocol destProtocol) {
        destProtocol.setIacucProtocolSpeciesList((List)this.deepCopy(sourceProtocol.getIacucProtocolSpeciesList()));
        this.setAttributesForIacucProtocolSpecies(destProtocol);
        this.synchronizeProcedureSpecies(destProtocol);
    }

    private void synchronizeProcedureSpecies(IacucProtocol destProtocol) {
        HashMap<String, IacucProtocolSpecies> newIacucProtocolSpeciesMapping = this.getIacucProtocolSpeciesMapping(destProtocol.getIacucProtocolSpeciesList());
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : destProtocol.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                IacucProtocolSpecies destIacucProtocolSpecies = newIacucProtocolSpeciesMapping.get(iacucProtocolStudyGroup.getIacucProtocolSpecies().getGroupAndSpecies());
                iacucProtocolStudyGroup.setIacucProtocolSpeciesId(destIacucProtocolSpecies.getIacucProtocolSpeciesId());
                iacucProtocolStudyGroup.setIacucProtocolSpecies(destIacucProtocolSpecies);
            }
        }
    }

    private void setAttributesForIacucProtocolSpecies(IacucProtocol destProtocol) {
        for (IacucProtocolSpecies iacucProtocolSpecies : destProtocol.getIacucProtocolSpeciesList()) {
            iacucProtocolSpecies.resetPersistenceState();
            this.getIacucProtocolSpeciesService().getNewProtocolSpecies(destProtocol, iacucProtocolSpecies);
        }
    }

    @Override
    public void mergeProtocolProcedures(IacucProtocol sourceProtocol, IacucProtocol destProtocol) {
        this.createNewStudyProcedures(sourceProtocol, destProtocol);
        this.synchronizeProcedurePersonnel(sourceProtocol, destProtocol);
    }

    private void synchronizeProcedurePersonnel(IacucProtocol sourceProtocol, IacucProtocol destProtocol) {
        HashMap<String, IacucProtocolPerson> newProtocolPersons = this.getProtocolPersons(sourceProtocol);
        for (ProtocolPersonBase protocolPersonBase : destProtocol.getProtocolPersons()) {
            IacucProtocolPerson destIacucProtocolPerson = (IacucProtocolPerson)protocolPersonBase;
            IacucProtocolPerson sourceIacucProtocolPerson = newProtocolPersons.get(destIacucProtocolPerson.getPersonId());
            destIacucProtocolPerson.setProcedureQualificationDescription(sourceIacucProtocolPerson.getProcedureQualificationDescription());
        }
    }

    @Override
    public void mergeProtocolProcedurePersonnel(IacucProtocol destProtocol) {
        HashMap<String, IacucProtocolPerson> newProtocolPersons = this.getProtocolPersons(destProtocol);
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : destProtocol.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                for (IacucProcedurePersonResponsible iacucProcedurePersonResponsible : iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList()) {
                    IacucProtocolPerson newIacucProtocolPerson = newProtocolPersons.get(iacucProcedurePersonResponsible.getPersonId());
                    iacucProcedurePersonResponsible.setProtocolPersonId(newIacucProtocolPerson.getProtocolPersonId());
                    iacucProcedurePersonResponsible.setProtocolPerson(newIacucProtocolPerson);
                }
            }
        }
    }

    @Override
    public void resetAllProtocolStudyProcedures(IacucProtocol iacucProtocol) {
        this.setAttributesForIacucProtocolSpecies(iacucProtocol);
        HashMap<String, IacucProtocolSpecies> newIacucProtocolSpeciesMapping = this.getIacucProtocolSpeciesMapping(iacucProtocol.getIacucProtocolSpeciesList());
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocol.getIacucProtocolStudyGroups()) {
            this.setAttributesForStudyProcedures(iacucProtocolStudyGroupBean, iacucProtocol, newIacucProtocolSpeciesMapping);
        }
    }

    private void createNewStudyProcedures(IacucProtocol sourceProtocol, IacucProtocol destProtocol) {
        destProtocol.setIacucProtocolStudyGroups(new ArrayList<IacucProtocolStudyGroupBean>());
        HashMap<String, IacucProtocolSpecies> newIacucProtocolSpeciesMapping = this.getIacucProtocolSpeciesMapping(destProtocol.getIacucProtocolSpeciesList());
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : sourceProtocol.getIacucProtocolStudyGroups()) {
            IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean = (IacucProtocolStudyGroupBean)this.deepCopy(iacucProtocolStudyGroupBean);
            this.setAttributesForStudyProcedures(newIacucProtocolStudyGroupBean, destProtocol, newIacucProtocolSpeciesMapping);
            destProtocol.getIacucProtocolStudyGroups().add(newIacucProtocolStudyGroupBean);
        }
    }

    private void setAttributesForStudyProcedures(IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean, IacucProtocol destProtocol, HashMap<String, IacucProtocolSpecies> newIacucProtocolSpeciesMapping) {
        newIacucProtocolStudyGroupBean.resetPersistenceState();
        this.setAttributesForNewStudyGroupBean(newIacucProtocolStudyGroupBean, destProtocol);
        this.updateNewStudyProcedures(newIacucProtocolStudyGroupBean, destProtocol, newIacucProtocolSpeciesMapping);
    }

    private void updateNewStudyProcedures(IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean, IacucProtocol destProtocol, HashMap<String, IacucProtocolSpecies> newIacucProtocolSpeciesMapping) {
        HashMap<String, IacucProtocolPerson> newProtocolPersons = this.getProtocolPersons(destProtocol);
        for (IacucProtocolStudyGroup newIacucProtocolStudyGroup : newIacucProtocolStudyGroupBean.getIacucProtocolStudyGroups()) {
            newIacucProtocolStudyGroup.resetPersistenceState();
            newIacucProtocolStudyGroup.setIacucProtocolStudyGroupHeaderId(newIacucProtocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId());
            newIacucProtocolStudyGroup.setIacucProtocolStudyGroupBean(newIacucProtocolStudyGroupBean);
            IacucProtocolSpecies destIacucProtocolSpecies = newIacucProtocolSpeciesMapping.get(newIacucProtocolStudyGroup.getIacucProtocolSpecies().getGroupAndSpecies());
            newIacucProtocolStudyGroup.setIacucProtocolSpeciesId(destIacucProtocolSpecies.getIacucProtocolSpeciesId());
            newIacucProtocolStudyGroup.setIacucProtocolSpecies(destIacucProtocolSpecies);
            for (IacucProtocolStudyCustomData newIacucProtocolStudyCustomData : newIacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                newIacucProtocolStudyCustomData.resetPersistenceState();
                newIacucProtocolStudyCustomData.setIacucProtocolStudyGroupId(newIacucProtocolStudyGroup.getIacucProtocolStudyGroupId());
            }
            for (IacucProcedurePersonResponsible newIacucProcedurePersonResponsible : newIacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList()) {
                newIacucProcedurePersonResponsible.resetPersistenceState();
                IacucProtocolPerson newIacucProtocolPerson = newProtocolPersons.get(newIacucProcedurePersonResponsible.getPersonId());
                newIacucProcedurePersonResponsible.setProtocolPersonId(newIacucProtocolPerson.getProtocolPersonId());
                newIacucProcedurePersonResponsible.setProtocolPerson(newIacucProtocolPerson);
                newIacucProcedurePersonResponsible.setIacucProtocolStudyGroupId(newIacucProtocolStudyGroup.getIacucProtocolStudyGroupId());
            }
            for (IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation : newIacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList()) {
                newIacucProtocolStudyGroupLocation.resetPersistenceState();
                newIacucProtocolStudyGroupLocation.setIacucProtocolStudyGroupId(newIacucProtocolStudyGroup.getIacucProtocolStudyGroupId());
            }
        }
    }

    protected Object deepCopy(Object obj) {
        if (obj instanceof Serializable) {
            return ObjectUtils.deepCopy((Serializable)((Serializable)obj));
        }
        return obj;
    }

    private HashMap<String, IacucProtocolSpecies> getIacucProtocolSpeciesMapping(List<IacucProtocolSpecies> iacucProtocolSpeciesList) {
        HashMap<String, IacucProtocolSpecies> protocolSpeciesList = new HashMap<String, IacucProtocolSpecies>();
        for (IacucProtocolSpecies iacucProtocolSpecies : iacucProtocolSpeciesList) {
            protocolSpeciesList.put(iacucProtocolSpecies.getGroupAndSpecies(), iacucProtocolSpecies);
        }
        return protocolSpeciesList;
    }

    @Override
    public boolean isProcedureViewedBySpecies() {
        String procedureViewModeParam = this.getProcedureViewModeParameter();
        if (ObjectUtils.isNull((Object)procedureViewModeParam)) {
            procedureViewModeParam = PROCEDURE_VIEW_MODE_SPECIES;
        }
        return procedureViewModeParam.equals(PROCEDURE_VIEW_MODE_SPECIES);
    }

    protected String getProcedureViewModeParameter() {
        return this.getParameterService().getParameterValueAsString("KC-IACUC", "Document", PROCEDURE_VIEW_MODE);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

