/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class CreateProposalDevelopmentProtocolAuthorizer
extends ProtocolAuthorizer {
    @Override
    public boolean isAuthorized(String userId, ProtocolTask task) {
        Protocol protocol = task.getProtocol();
        return this.canCreateProposal() && this.hasProposalRequiredFields(protocol);
    }

    private boolean canCreateProposal() {
        return this.hasUnitPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-PD", "Create ProposalDevelopmentDocument");
    }

    private boolean hasProposalRequiredFields(Protocol protocol) {
        boolean isProtocolSaved = protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().isSaved();
        boolean validProposalRequiredFields = true;
        if (!isProtocolSaved) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((CharSequence)protocol.getTitle())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((CharSequence)protocol.getLeadUnitNumber())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((CharSequence)protocol.getPrincipalInvestigatorId())) {
            validProposalRequiredFields = false;
        }
        List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSource sponsorProtocolFundingSource = null;
        for (ProtocolFundingSourceBase protocolFundingSource : protocolFundingSources) {
            if (!protocolFundingSource.isSponsorFunding()) continue;
            sponsorProtocolFundingSource = (ProtocolFundingSource)protocolFundingSource;
            break;
        }
        if (sponsorProtocolFundingSource == null) {
            validProposalRequiredFields = false;
        }
        return validProposalRequiredFields;
    }
}

