/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.meeting.MeetingAddOtherEvent;
import org.kuali.coeus.common.committee.impl.meeting.MemberPresentBean;
import org.kuali.coeus.common.committee.impl.meeting.OtherPresentBeanBase;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;

public class MeetingAddOtherRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<MeetingAddOtherEvent> {
    private static final String NEWOTHERPRESENT_PERSONNAME = "meetingHelper.newOtherPresentBean.attendance.personName";
    private ErrorReporter errorReporter;

    @Override
    public boolean processRules(MeetingAddOtherEvent event) {
        boolean rulePassed = true;
        this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        if (StringUtils.isBlank((CharSequence)event.getMeetingHelper().getNewOtherPresentBean().getAttendance().getPersonName())) {
            this.errorReporter.reportError(NEWOTHERPRESENT_PERSONNAME, "error.empty.person", new String[0]);
            rulePassed = false;
        } else {
            for (MemberPresentBean memberPresentBean : event.getMeetingHelper().getMemberPresentBeans()) {
                if (!this.isMemberPresent(memberPresentBean, event.getMeetingHelper().getNewOtherPresentBean())) continue;
                this.errorReporter.reportError(NEWOTHERPRESENT_PERSONNAME, "error.add.member.present", event.getMeetingHelper().getNewOtherPresentBean().getAttendance().getPersonName());
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    private boolean isMemberPresent(MemberPresentBean memberPresentBean, OtherPresentBeanBase otherPresentBean) {
        boolean isPresent = false;
        if (memberPresentBean.getAttendance().getNonEmployeeFlag() && otherPresentBean.getAttendance().getNonEmployeeFlag() && memberPresentBean.getAttendance().getPersonId().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        } else if (!memberPresentBean.getAttendance().getNonEmployeeFlag() && !otherPresentBean.getAttendance().getNonEmployeeFlag() && memberPresentBean.getAttendance().getPersonId().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        } else if (StringUtils.isNotBlank((CharSequence)memberPresentBean.getAttendance().getAlternateFor()) && StringUtils.isNotBlank((CharSequence)otherPresentBean.getAttendance().getPersonId()) && memberPresentBean.getAttendance().getAlternateFor().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        }
        return isPresent;
    }
}

