/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public abstract class ProtocolFinderDaoOjbBase
extends PlatformAwareDaoBaseOjb
implements ProtocolFinderDao {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String MAX_SEQUENCE_NUMBER = "max(sequenceNumber)";
    private static final String SUBMISSION_NUMBER = "submissionNumber";

    @Override
    public ProtocolBase findCurrentProtocolByNumber(String protocolNumber) {
        Criteria subCrit = new Criteria();
        subCrit.addEqualTo(PROTOCOL_NUMBER, (Object)protocolNumber);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(this.getProtocolBOClassHook(), (Criteria)subCrit);
        subQuery.setAttributes(new String[]{MAX_SEQUENCE_NUMBER});
        Criteria crit = new Criteria();
        crit.addEqualTo(PROTOCOL_NUMBER, (Object)protocolNumber);
        crit.addEqualTo(SEQUENCE_NUMBER, (Object)subQuery);
        QueryByCriteria q = QueryFactory.newQuery(this.getProtocolBOClassHook(), (Criteria)crit);
        return (ProtocolBase)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)q);
    }

    @Override
    public List<ProtocolSubmissionBase> findProtocolSubmissions(String protocolNumber, int submissionNumber) {
        Criteria crit = new Criteria();
        crit.addLike((Object)PROTOCOL_NUMBER, (Object)(protocolNumber + "%"));
        crit.addEqualTo(SUBMISSION_NUMBER, (Object)submissionNumber);
        QueryByCriteria q = QueryFactory.newQuery(this.getProtocolSubmissionBOClassHook(), (Criteria)crit);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    @Override
    public List<ProtocolBase> findProtocols(String protocolNumber) {
        Criteria crit = new Criteria();
        crit.addLike((Object)PROTOCOL_NUMBER, (Object)(protocolNumber + "%"));
        QueryByCriteria q = QueryFactory.newQuery(this.getProtocolBOClassHook(), (Criteria)crit);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();
}

