/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.followup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.followup.FollowupActionService;
import org.kuali.kra.protocol.actions.submit.ValidProtocolActionActionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class FollowupActionServiceImplBase<T extends ValidProtocolActionActionBase>
implements FollowupActionService<T> {
    BusinessObjectService businessObjectService;
    private static final String PROTOCOL_ACTION_TYPE_CODE = "protocolActionTypeCode";
    private static final String COMMITTEE_MOTION_TYPE_CODE = "motionTypeCode";

    @Override
    public List<T> getFollowupsForActionTypeAndMotionType(String protocolActionTypeCode, String committeeMotionTypeCode) {
        HashMap<String, String> fieldSet = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)protocolActionTypeCode)) {
            fieldSet.put(PROTOCOL_ACTION_TYPE_CODE, protocolActionTypeCode);
        }
        fieldSet.put(COMMITTEE_MOTION_TYPE_CODE, committeeMotionTypeCode);
        List resultSet = (List)this.businessObjectService.findMatching(this.getValidProtocolActionActionClassHook(), fieldSet);
        return resultSet;
    }

    protected abstract Class<T> getValidProtocolActionActionClassHook();

    public List<T> getFollowupsForActionTypeCode(String protocolActionTypeCode) {
        List resultSet = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)protocolActionTypeCode)) {
            HashMap<String, String> fieldSet = new HashMap<String, String>();
            fieldSet.put(PROTOCOL_ACTION_TYPE_CODE, protocolActionTypeCode);
            resultSet = (List)this.businessObjectService.findMatching(this.getValidProtocolActionActionClassHook(), fieldSet);
        }
        return resultSet;
    }

    @Override
    public List<T> getFollowupsForProtocol(ProtocolBase protocol) {
        if (protocol.getLastProtocolAction() == null) {
            return new ArrayList();
        }
        List<T> resultList = StringUtils.equals((CharSequence)protocol.getLastProtocolAction().getProtocolActionTypeCode(), (CharSequence)this.getProtocolActionTypeCodeForRecordCommitteeDecisionHook()) ? this.getFollowupsForActionTypeAndMotionType(this.getProtocolActionTypeCodeForRecordCommitteeDecisionHook(), protocol.getProtocolSubmission().getCommitteeDecisionMotionTypeCode()) : this.getFollowupsForActionTypeCode(protocol.getLastProtocolAction().getProtocolActionTypeCode());
        return resultList;
    }

    protected abstract String getProtocolActionTypeCodeForRecordCommitteeDecisionHook();

    @Override
    public boolean isActionOpenForFollowup(String protocolActionTypeCode, ProtocolBase protocol) {
        if (this.getLogHook().isDebugEnabled()) {
            this.getLogHook().debug("**********************************");
            this.getLogHook().debug(String.format("isActionOpenForFollowup called for action type code %s, on protocol %s", protocolActionTypeCode, protocol.getProtocolNumber()));
            this.getLogHook().debug(String.format("Last protocol action was %s", protocol.getLastProtocolAction().getProtocolActionTypeCode()));
        }
        boolean result = false;
        List<T> valids = this.getFollowupsForActionTypeCode(protocol.getLastProtocolAction().getProtocolActionTypeCode());
        for (ValidProtocolActionActionBase protocolActionAction : valids) {
            if (!StringUtils.equals((CharSequence)protocolActionAction.getFollowupActionCode(), (CharSequence)protocolActionTypeCode)) continue;
            if (!StringUtils.isEmpty((CharSequence)protocolActionAction.getMotionTypeCode())) {
                if (this.getLogHook().isDebugEnabled()) {
                    this.getLogHook().debug(String.format("%s %s has defined MotionTypeCode %s, checking motion on protocol.", this.getValidProtocolActionActionClassHook().getName(), protocolActionAction.getValidProtocolActionActionId(), protocolActionAction.getMotionTypeCode()));
                }
                if (!StringUtils.equals((CharSequence)protocol.getProtocolSubmission().getCommitteeDecisionMotionTypeCode(), (CharSequence)protocolActionAction.getMotionTypeCode())) continue;
                if (this.getLogHook().isDebugEnabled()) {
                    this.getLogHook().debug("MotionType matches last motion on protocol.");
                }
                result = true;
                break;
            }
            result = true;
            break;
        }
        if (this.getLogHook().isDebugEnabled()) {
            this.getLogHook().debug(String.format("isActionOpenForFollowup returning %s for type code %s", result, protocolActionTypeCode));
            this.getLogHook().debug("**********************************");
        }
        return result;
    }

    protected abstract Logger getLogHook();

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

