/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.rules.ui;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.event.ui.AddRoleEvent;
import org.kuali.rice.kim.rule.ui.AddRoleRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.CollectionUtils;

public class PersonDocumentRoleRule
extends DocumentRuleBase
implements AddRoleRule {
    public static final String ERROR_PATH = "newRole.roleId";

    @Override
    public boolean processAddRole(AddRoleEvent addRoleEvent) {
        PersonDocumentRole newRole = addRoleEvent.getRole();
        IdentityManagementPersonDocument document = (IdentityManagementPersonDocument)addRoleEvent.getDocument();
        boolean rulePassed = true;
        if (newRole == null || StringUtils.isBlank((String)newRole.getRoleId())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Role"});
        } else {
            for (PersonDocumentRole role : document.getRoles()) {
                if (!role.getRoleId().equals(newRole.getRoleId())) continue;
                rulePassed = false;
                GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.duplicate.entry", new String[]{"Role"});
            }
        }
        if (!CollectionUtils.isEmpty((Collection)GlobalVariables.getMessageMap().getErrorMessagesForProperty("newRole.*", true))) {
            rulePassed = false;
        }
        return rulePassed;
    }
}

