/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.spi.PropagationContext;

public class SingleObjectSinkAdapter
implements ObjectSinkPropagator {
    private static final long serialVersionUID = 510L;
    private ObjectSink sink;
    private ObjectSink[] sinks;

    public SingleObjectSinkAdapter() {
    }

    public SingleObjectSinkAdapter(ObjectSink sink) {
        this.sink = sink;
        this.sinks = new ObjectSink[]{this.sink};
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sink = (ObjectSink)in.readObject();
        this.sinks = new ObjectSink[]{this.sink};
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sink);
    }

    @Override
    public ObjectSinkPropagator addObjectSink(ObjectSink sink, int alphaNodeHashingThreshold) {
        CompositeObjectSinkAdapter sinkAdapter = new CompositeObjectSinkAdapter(alphaNodeHashingThreshold);
        sinkAdapter.addObjectSink(this.sink, alphaNodeHashingThreshold);
        sinkAdapter.addObjectSink(sink, alphaNodeHashingThreshold);
        return sinkAdapter;
    }

    @Override
    public ObjectSinkPropagator removeObjectSink(ObjectSink sink) {
        if (this.sink.equals(sink)) {
            return EmptyObjectSinkAdapter.getInstance();
        }
        throw new IllegalArgumentException("Cannot remove " + sink + " when this sink propagator only contains " + this.sink);
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.assertObject(factHandle, context, workingMemory);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void doLinkRiaNode(InternalWorkingMemory wm) {
        SingleObjectSinkAdapter.staticDoLinkRiaNode(this.sink, wm);
    }

    public static void staticDoLinkRiaNode(ObjectSink sink, InternalWorkingMemory wm) {
        BetaMemory bm;
        if (sink.getType() == 211) {
            AccumulateNode accnode = (AccumulateNode)sink;
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)wm.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            bm = BetaNode.getBetaMemoryFromRightInput(betaNode, wm);
        } else {
            throw new RuntimeException("Should not be possible to have link into a node of type" + sink);
        }
        if (bm.getStagedRightTuples().isEmpty()) {
            if (bm.getRightTupleMemory().size() == 0) {
                bm.linkNode((BetaNode)sink, wm);
            } else {
                bm.setNodeDirty((BetaNode)sink, wm);
            }
        }
    }

    @Override
    public void doUnlinkRiaNode(InternalWorkingMemory wm) {
        SingleObjectSinkAdapter.staticDoUnlinkRiaNode(this.sink, wm);
    }

    public static void staticDoUnlinkRiaNode(ObjectSink sink, InternalWorkingMemory wm) {
        BetaMemory bm;
        if (sink.getType() == 211) {
            AccumulateNode accnode = (AccumulateNode)sink;
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)wm.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            bm = BetaNode.getBetaMemoryFromRightInput(betaNode, wm);
        } else {
            throw new RuntimeException("Should not be possible to have link into a node of type" + sink);
        }
        if (sink.getType() == 191) {
            bm.linkNode((BetaNode)sink, wm);
        } else {
            bm.unlinkNode(wm);
        }
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        return this.sink.equals(candidate) ? (BaseNode)((Object)this.sink) : null;
    }

    @Override
    public ObjectSink[] getSinks() {
        return this.sinks;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

