<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2019 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                xmlns:ED_524_Budget_1_3="http://apply.grants.gov/forms/ED_524_Budget_1_3-V1.3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="0.5in" margin-right="0.5in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.5in" font-family="Helvetica,Times,Courier" font-size="14pt" />
                <fo:region-after extent=".5in" />
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="ED_524_Budget_1_3:ED_524_Budget_1_3">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set" />
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:static-content flow-name="xsl-region-after">
                    <fo:block>
                        <fo:inline font-size="6px" font-weight="bold">ED 524</fo:inline>
                    </fo:block>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <fo:block font-size="8pt">
                        <fo:table padding="1pt" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column column-width="130pt" />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="5" number-rows-spanned="2" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">U.S. DEPARTMENT OF EDUCATION
                                                BUDGET INFORMATION
                                                NON-CONSTRUCTION PROGRAMS</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>OMB Number: 1890-0004</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Expiration Date: 10/31/2007</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>* Name of Institution/Organization<fo:block space-before.optimum="1pt" space-after.optimum="2pt" keep-together="always">
                                            <fo:block>&#160;&#160;&#160;&#160; <xsl:for-each select="ED_524_Budget_1_3:LEGAL_NAME">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                            </fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="5" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Applicants requesting funding for only one year should complete the column under
                                            "Project Year 1."&#160; Applicants requesting funding for </fo:block>
                                        <fo:block> multi-year grants should complete
                                            all applicable columns.&#160; Please add all instructions before completing form.</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-width="2pt" border-before-width="2pt" number-columns-spanned="7" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">SECTION A - BUDGET SUMMARY&#160;&#160;&#160;&#160;U.S. DEPARTMENT OF EDUCATION FUNDS</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Budget Categories</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 1<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (a)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 2<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (b)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 3<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (c)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 4<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (d)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 5<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (e)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Total<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (f)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 1. Personnel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalPersonnelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalPersonnelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalPersonnelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalPersonnelFourthYearAmount">

                                                <xsl:value-of select="format-number(., '$#,##0.00')" />





                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalPersonnelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell font-size="8pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block></fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalPersonnelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 2. Fringe Benefits</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFringeFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFringeSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFringeThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFringeFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFringeFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFringeTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 3. Travel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTravelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTravelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTravelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTravelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTravelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTravelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 4. Equipment</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalEquipmentFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalEquipmentSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalEquipmentThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalEquipmentFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalEquipmentFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalEquipmentTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 5. Supplies</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSuppliesFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSuppliesSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSuppliesThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSuppliesFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSuppliesFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSuppliesTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 6. Contractual</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalContractualFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalContractualSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalContractualThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalContractualFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalContractualFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalContractualTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 7. Construction</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalConstructionFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalConstructionSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalConstructionThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalConstructionFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalConstructionFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalConstructionTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 8. Other</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalOtherFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalOtherSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalOtherThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalOtherFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalOtherFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalOtherTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 9. Total Direct Costs (lines 1-8)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalDirectFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalDirectSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalDirectThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalDirectFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalDirectFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalDirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 10. Indirect Costs*</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalIndirectFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalIndirectSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalIndirectThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalIndirectFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalIndirectFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalIndirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 11. Training Stipends</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTrainingFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTrainingSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTrainingThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTrainingFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTrainingFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTrainingTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 12. Total Costs (lines 9-11)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetFederalTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>

                        <!-- new section of ED 524=============-->

                        <fo:table padding="1pt" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column column-width="20pt" />
                            <fo:table-column column-width="240pt" />
                            <fo:table-column/>
                            <fo:table-column />

                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block><fo:inline font-weight="bold">*Indirect Cost Information</fo:inline><fo:inline font-weight="bold" font-style="italic">&#160;(To Be Completed by Your Business Office):</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>If you are requesting reimbursement for indirect costs on line 10, please answer the following questions:</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>(1)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">	<fo:block>Do you have an Indirect Cost Rate Agreement approved by the Federal government?&#160;&#160;
                                        <xsl:choose>
                                            <xsl:when test="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IsIndirectCostRateAgreementApproved='Y: Yes'"> <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                &#160;Yes&#160;&#160;<fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;No</xsl:when>
                                            <xsl:when test="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IsIndirectCostRateAgreementApproved='N: No'"> <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;Yes&#160;&#160;<fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>&#160;No</xsl:when>

                                            <xsl:otherwise>
                                                <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;Yes&#160;&#160;<fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                &#160;No
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>(2)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>If yes, please provide the following information:</fo:block></fo:table-cell>
                                </fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt"  padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>* Period Covered by the Indirect Cost Rate Agreement:  From:&#160;&#160;
                                            <xsl:call-template name="formatDate">
                                                <xsl:with-param name="value" select="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IndirectCostRateAgreementApproved/ED_524_Budget_1_3:IndirectCostRateAgreementFromDate"/>
                                            </xsl:call-template>&#160;&#160;
                                            &#160;
                                            To:&#160;&#160;
                                            <xsl:call-template name="formatDate">
                                                <xsl:with-param name="value" select="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IndirectCostRateAgreementApproved/ED_524_Budget_1_3:IndirectCostRateAgreementToDate"/>
                                            </xsl:call-template>&#160;&#160;&#160;
                                            (mm/dd/yyyy)					</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">	<fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>* Approving Federal agency:&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IndirectCostRateAgreementApproved/ED_524_Budget_1_3:ApprovingFederalAgency='ED'">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>&#160;ED&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IndirectCostRateAgreementApproved/ED_524_Budget_1_3:ApprovingFederalAgency='Other'">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>&#160;Other (please specify):&#160;&#160;
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block><xsl:value-of select="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IndirectCostRateAgreementApproved/ED_524_Budget_1_3:OtherApprovingFederalAgency"/></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">

                                        <fo:block>The Indirect Cost Rate is
                                            <xsl:for-each select="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:IndirectCostRateAgreementApproved/ED_524_Budget_1_3:IndirectCostRatePercentage">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                            </xsl:for-each>

                                            %</fo:block>

                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>(3)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>If this is your first Federal grant, and you do not have an approved indirect cost rate agreement, are not a State, Local government or Indian Tribe, and are not funded under a training rate
                                            program or a restricted rate program, do you want to use the de minimis rate of 10% of MTDC?
                                            <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;Yes&#160;&#160;
                                            <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;No
                                            If yes, you must comply with the requirements of 2 CFR § 200.414(f).</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>(4)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>If you do not have an approved indirect cost rate agreement, do you want to use the temporary rate of 10% of budgeted salaries and wages?
                                            <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;Yes&#160;&#160;
                                            <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;No
                                            If yes, you must submit a proposed indirect cost rate agreement within 90 days after the date your grant is awarded, as required by 34 CFR § 75.560.
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>(5)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>For Restricted Rate Programs (check one) -- Are you using a restricted indirect cost rate that:</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start">
                                        <fo:block><!-- Approving Federal agency:&#160;&#160; -->
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:RestrictedIndirectCostRate='Is included in your approved Indirect Cost Rate Agreement?'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>&#160;Is included in your approved Indirect Cost Rate Agreement?   or,&#160;&#160;<xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_3:IndirectCost/ED_524_Budget_1_3:RestrictedIndirectCostRate='Complies with 34 CFR 76.564(c)(2)?'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>&#160;Complies with 34 CFR 76.564(c)(2)?&#160;&#160;</fo:block>
                                        The Restricted Indirect Cost Rate is  &#160;&#160;&#160; %
                                    </fo:table-cell>
                                </fo:table-row>


                            </fo:table-body>

                        </fo:table>







                        <!-- end new section ===================-->
                        <fo:block break-after="page">
                            <fo:leader leader-pattern="space" />
                        </fo:block>
                        <fo:block>
                            <xsl:text>&#xA;</xsl:text>
                        </fo:block>
                        <fo:table padding="1pt" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column column-width="130pt" />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>* Name of Institution/Organization<fo:block space-before.optimum="1pt" space-after.optimum="2pt" keep-together="always">
                                            <fo:block>&#160;&#160;&#160;&#160; <xsl:for-each select="ED_524_Budget_1_3:LEGAL_NAME">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                            </fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="5" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Applicants requesting funding for only one year should complete the column under
                                            "Project Year 1."&#160; Applicants requesting funding for multi-year grants should complete
                                            all applicable columns.&#160; Please add all instructions before completing form.</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-width="2pt" border-before-width="2pt" number-columns-spanned="7" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">SECTION B - BUDGET SUMMARY</fo:inline>
                                            <fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:block>
                                                    <fo:inline font-size="10pt" font-weight="bold">NON-FEDERAL FUNDS</fo:inline>
                                                </fo:block>
                                            </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Budget Categories</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 1
                                            (a)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 2<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>(b)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 3<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (c)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 4<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (d)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 5<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (e)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Total<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (f)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 1. Personnel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalPersonnelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalPersonnelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalPersonnelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalPersonnelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalPersonnelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalPersonnelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 2. Fringe Benefits</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFringeFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFringeSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFringeThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFringeFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFringeFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFringeTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 3. Travel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTravelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTravelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTravelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTravelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTravelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTravelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 4. Equipment</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalEquipmentFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalEquipmentSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalEquipmentThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalEquipmentFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalEquipmentFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalEquipmentTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 5. Supplies</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSuppliesFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSuppliesSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSuppliesThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSuppliesFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSuppliesFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSuppliesTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 6. Contractual</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalContractualFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalContractualSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalContractualThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalContractualFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalContractualFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalContractualTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 7. Construction</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalConstructionFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalConstructionSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalConstructionThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalConstructionFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalConstructionFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalConstructionTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 8. Other</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalOtherFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalOtherSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalOtherThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalOtherFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalOtherFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalOtherTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 9. Total Direct Costs (lines 1-8)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalDirectFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalDirectSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalDirectThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalDirectFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalDirectFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalDirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 10. Indirect Costs</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalIndirectFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalIndirectSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalIndirectThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalIndirectFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalIndirectFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalIndirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 11. Training Stipends</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTrainingFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTrainingSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTrainingThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTrainingFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTrainingFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTrainingTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 12. Total Costs (lines 9-11)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_3:BudgetNonFederalTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" number-columns-spanned="7" text-align="center" width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:block>
                                                <fo:leader leader-pattern="space" />
                                            </fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">SECTION C - BUDGET NARRATIVE (see instructions)</fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space" />
                                            </fo:block>
                                            <fo:block>
                                                <xsl:text>&#xA;</xsl:text>
                                            </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <!-- ============================================= -->
    <!-- FORMAT DATE                                   -->
    <!-- Writes XSD:date style text into to mm-dd-yyyy -->
    <!-- ============================================= -->
    <xsl:template name="formatDate">
        <xsl:param name="value"/>
        <xsl:if test="$value != ''">
            <xsl:value-of select="format-number(substring($value,6,2), '00')"/>
            <xsl:text>/</xsl:text>
            <xsl:value-of select="format-number(substring($value,9,2), '00')"/>
            <xsl:text>/</xsl:text>
            <xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
