/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.module.CoeusModule;
import org.kuali.coeus.common.framework.module.CoeusSubModule;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireQuestion;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.printing.schema.AnswerHeaderType;
import org.kuali.kra.printing.schema.AnswerInfoType;
import org.kuali.kra.printing.schema.ModuleInfoType;
import org.kuali.kra.printing.schema.ModuleUsageType;
import org.kuali.kra.printing.schema.Person;
import org.kuali.kra.printing.schema.ProposalInfoType;
import org.kuali.kra.printing.schema.ProtocolInfoType;
import org.kuali.kra.printing.schema.QuestionInfoType;
import org.kuali.kra.printing.schema.QuestionnaireDocument;
import org.kuali.kra.printing.schema.QuestionsType;
import org.kuali.kra.printing.schema.UserOptions;
import org.kuali.kra.printing.schema.UserOptionsInfoType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.XmlObjectSerializerService;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="questionnaireXmlStream")
@Scope(value="prototype")
public class QuestionnaireXmlStream
implements XmlStream<QuestionnaireDocument> {
    public static final String DOCUMENT_NUMBER = "documentNumber";
    public static final String QUESTIONNAIRE = "questionnaire";
    public static final String QUESTIONNAIRE_QUESTIONS = "questionnaireQuestions";
    public static final String ID = "id";
    public static final String MODULE_CODE = "moduleCode";
    public static final String SUB_MODULE_CODE = "subModuleCode";
    public static final String SUBMISSION_NUMBER = "submissionNumber";
    public static final String PROTOCOL_NUMBER = "protocolNumber";
    public static final String MODULE_SUB_ITEM_CODE = "moduleSubItemCode";
    public static final String COEUS_MODULE_SUB_ITEM_CODE = "coeusModuleSubItemCode";
    public static final String QUESTION = "question";
    public static final String PERSON_ID = "personId";
    private static final Logger LOG = LogManager.getLogger(QuestionnaireXmlStream.class);
    private static final int QUESTION_TYPE_INT = 3;
    List<QuestionnaireQuestion> sortedQuestionnaireQuestions;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="questionnaireService")
    private QuestionnaireService questionnaireService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="xmlObjectSerializerService")
    private XmlObjectSerializerService xmlObjectSerializerService;

    @Override
    public Class<QuestionnaireDocument> type() {
        return QuestionnaireDocument.class;
    }

    @Override
    public Map<String, QuestionnaireDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, QuestionnaireDocument> xmlObjectList = new LinkedHashMap<String, QuestionnaireDocument>();
        try {
            xmlObjectList.put("Questionnaire", this.getQuestionnaireData(printableBusinessObject, reportParameters));
        }
        catch (PrintingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return xmlObjectList;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    QuestionnaireDocument getQuestionnaireData(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> params) throws PrintingException {
        Boolean questionnaireCompletionFlag;
        QuestionnaireDocument questionnaireDocument = QuestionnaireDocument.Factory.newInstance();
        QuestionnaireDocument.Questionnaire questionnaireType = questionnaireDocument.addNewQuestionnaire();
        String documentNumber = (String)params.get(DOCUMENT_NUMBER);
        Object questionnaireSeqenceId = params.get("questionnaireSeqId");
        Questionnaire questionnaire = (Questionnaire)params.get(QUESTIONNAIRE);
        if (questionnaire == null) {
            if (questionnaireSeqenceId != null) {
                HashMap<String, Long> qParam = new HashMap<String, Long>();
                qParam.put("questionnaireSeqId", Long.parseLong(questionnaireSeqenceId.toString()));
                List questionnaires = (List)this.businessObjectService.findMatchingOrderBy(Questionnaire.class, qParam, ID, false);
                questionnaire = (Questionnaire)questionnaires.get(0);
                questionnaire.refreshReferenceObject(QUESTIONNAIRE_QUESTIONS);
            } else {
                questionnaire = this.findQuestionnaireObject(documentNumber);
            }
        }
        questionnaireCompletionFlag = (questionnaireCompletionFlag = (Boolean)params.get("QUESTIONNAIRE_COMPLETION_FLAG")) == null ? Boolean.FALSE : questionnaireCompletionFlag;
        ModuleQuestionnaireBean moduleQuestionnaireBean = null;
        if (printableBusinessObject != null) {
            moduleQuestionnaireBean = this.getQuestionnaireAnswerHeaderBean(printableBusinessObject, params);
        }
        if (questionnaire != null) {
            Integer questId = questionnaire.getQuestionnaireSeqIdAsInteger();
            if (questId != null) {
                questionnaireType.setQuestionnaireId(questId);
            }
            questionnaireType.setQuestionnaireName(questionnaire.getName());
            questionnaireType.setQuestionnaireDesc(questionnaire.getDescription());
            this.setQuestionInfoData(questionnaire, moduleQuestionnaireBean, questionnaireType, questionnaireCompletionFlag, printableBusinessObject);
            this.setUserOption(params, questionnaireType);
            this.setAnswerInfo(printableBusinessObject, moduleQuestionnaireBean, questionnaireType);
            if (moduleQuestionnaireBean != null && moduleQuestionnaireBean.getModuleItemCode() != null) {
                this.setModuleUsage(moduleQuestionnaireBean, questionnaireType);
            } else {
                this.setModuleUsageList(questionnaire, questionnaireType);
            }
            if (moduleQuestionnaireBean != null && moduleQuestionnaireBean.getModuleItemCode() != null) {
                String moduleCode = moduleQuestionnaireBean.getModuleItemCode();
                String moduleSubcode = moduleQuestionnaireBean.getModuleSubItemCode();
                if (moduleCode.equals("3") && "0".equals(moduleSubcode)) {
                    this.setDevProposalInfo((DevelopmentProposal)printableBusinessObject, questionnaireType);
                } else if (moduleCode.equals("3") && "3".equals(moduleSubcode)) {
                    ProposalPerson person = (ProposalPerson)printableBusinessObject;
                    this.setDevProposalInfo(person, questionnaireType);
                } else if (moduleCode.equals("7")) {
                    this.setProtocolInfo((Protocol)printableBusinessObject, questionnaireType);
                }
            }
        }
        return questionnaireDocument;
    }

    private void setProtocolInfo(Protocol protocolInfoBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        ProtocolInfoType protocolInfo = questionnaireType.addNewProtocolInfo();
        if (protocolInfoBean != null) {
            Person personInfo = protocolInfo.addNewInvestigator();
            if (protocolInfoBean.getPrincipalInvestigator() != null) {
                personInfo.setFullname(protocolInfoBean.getPrincipalInvestigator().getPersonName());
            }
            protocolInfo.setTitle(protocolInfoBean.getTitle());
            protocolInfo.setInvestigator(personInfo);
        }
    }

    private void setDevProposalInfo(DevelopmentProposal proposalBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        if (proposalBean != null) {
            ProposalInfoType proposalInfo = questionnaireType.addNewProposalInfo();
            proposalInfo.setTitle(proposalBean.getTitle());
            proposalInfo.setProposalPersonUsed(0);
            String investigatorName = proposalBean.getPrincipalInvestigatorName();
            if (investigatorName != null) {
                Person personInfo = proposalInfo.addNewInvestigator();
                personInfo.setFullname(investigatorName);
            }
        }
    }

    private void setDevProposalInfo(ProposalPerson person, QuestionnaireDocument.Questionnaire questionnaireType) {
        DevelopmentProposal proposalBean = person.getDevelopmentProposal();
        if (proposalBean != null) {
            ProposalInfoType proposalInfo = questionnaireType.addNewProposalInfo();
            proposalInfo.setTitle(proposalBean.getTitle());
            String investigatorName = proposalBean.getPrincipalInvestigatorName();
            if (investigatorName != null) {
                Person personInfo = proposalInfo.addNewInvestigator();
                personInfo.setFullname(investigatorName);
            }
            String personName = person.getFullName();
            String personRole = person.getRole().getDescription();
            proposalInfo.setProposalPersonUsed(1);
            proposalInfo.setProposalPersonName(personName);
            proposalInfo.setProposalPersonRole(personRole);
        }
    }

    private void setAnswerInfo(KcPersistableBusinessObjectBase printableBusinessObject, ModuleQuestionnaireBean moduleQuestionnaireBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        AnswerHeaderType answerHeader = questionnaireType.addNewAnswerHeader();
        if (printableBusinessObject instanceof ProposalPerson) {
            ProposalPerson person = (ProposalPerson)printableBusinessObject;
            answerHeader.setModuleKey(person.getDevelopmentProposal().getProposalNumber());
        } else if (moduleQuestionnaireBean != null) {
            answerHeader.setModuleKey(moduleQuestionnaireBean.getModuleItemKey());
        } else {
            answerHeader.setModuleKey(null);
        }
        if (moduleQuestionnaireBean != null) {
            answerHeader.setSubModuleKey(moduleQuestionnaireBean.getModuleSubItemKey());
        } else {
            answerHeader.setSubModuleKey("0");
        }
    }

    private void setModuleUsage(ModuleQuestionnaireBean moduleQuestionnaireBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        ModuleUsageType moduleUsage = questionnaireType.addNewModuleUsage();
        ModuleInfoType moduleInfo = moduleUsage.addNewModuleInfo();
        String moduleCode = moduleQuestionnaireBean.getModuleItemCode();
        CoeusModule moduleData = this.getQuestionnaireCouesModule(moduleCode);
        String moduleSubItemKey = moduleQuestionnaireBean.getModuleSubItemKey();
        CoeusSubModule subModuleData = this.getQuestionnaireCoeusSubModule(moduleCode, moduleQuestionnaireBean.getModuleSubItemCode());
        if (moduleCode != null) {
            moduleInfo.setModuleCode(Integer.parseInt(moduleCode));
        }
        if (moduleSubItemKey != null) {
            moduleInfo.setSubModuleCode(Integer.parseInt(moduleSubItemKey));
        }
        if (moduleData != null) {
            moduleInfo.setModuleDesc(moduleData.getDescription());
        }
        if (subModuleData != null) {
            moduleInfo.setSubModuleDesc(subModuleData.getDescription());
        }
        moduleUsage.setModuleInfoArray(0, moduleInfo);
    }

    private void setModuleUsageList(Questionnaire questionnaire, QuestionnaireDocument.Questionnaire questionnaireType) {
        ModuleUsageType moduleUsage = questionnaireType.addNewModuleUsage();
        ArrayList<ModuleInfoType> moduleInfoTypeList = new ArrayList<ModuleInfoType>();
        List<QuestionnaireUsage> questionnaireUsageList = questionnaire.getQuestionnaireUsages();
        for (QuestionnaireUsage usage : questionnaireUsageList) {
            ModuleInfoType moduleInfoType = ModuleInfoType.Factory.newInstance();
            String moduleCode = usage.getModuleItemCode();
            CoeusModule moduleData = this.getQuestionnaireCouesModule(moduleCode);
            String moduleSubItemCode = usage.getModuleSubItemCode();
            CoeusSubModule subModuleData = this.getQuestionnaireCoeusSubModule(moduleCode, moduleSubItemCode);
            moduleInfoType.setModuleCode(Integer.parseInt(moduleCode));
            moduleInfoType.setSubModuleCode(Integer.parseInt(moduleSubItemCode));
            moduleInfoType.setModuleDesc(moduleData.getDescription());
            if (subModuleData != null) {
                moduleInfoType.setSubModuleDesc(subModuleData.getDescription());
            }
            moduleInfoTypeList.add(moduleInfoType);
        }
        moduleUsage.setModuleInfoArray(moduleInfoTypeList.toArray(new ModuleInfoType[0]));
    }

    private CoeusSubModule getQuestionnaireCoeusSubModule(String moduleItemCode, String moduleSubItemKey) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(MODULE_CODE, moduleItemCode);
        param.put(SUB_MODULE_CODE, moduleSubItemKey);
        return (CoeusSubModule)this.businessObjectService.findByPrimaryKey(CoeusSubModule.class, param);
    }

    private CoeusModule getQuestionnaireCouesModule(String moduleCode) {
        return (CoeusModule)this.businessObjectService.findBySinglePrimaryKey(CoeusModule.class, (Object)moduleCode);
    }

    private void setUserOption(Map<String, Object> params, QuestionnaireDocument.Questionnaire questionnaireType) {
        UserOptions userOptions = questionnaireType.addNewUserOption();
        UserOptionsInfoType userOptionsInfo = userOptions.addNewUserOptionsInfo();
        Boolean printAnswersFlag = (Boolean)params.get("PRINT_ANSWERS_OPTION");
        Boolean printAnsweredOnlyFlag = (Boolean)params.get("PRINT_ONLY_ANSWERED_OPTION");
        Boolean printAllFlag = (Boolean)params.get("PRINT_ALL_OPTION");
        userOptionsInfo.setPrintAnsweredQuestionsOnly("No");
        userOptionsInfo.setPrintAnswers("Yes");
        if (printAnswersFlag != null && !printAnswersFlag.booleanValue()) {
            userOptionsInfo.setPrintAnswers("No");
        } else if (printAllFlag != null && printAllFlag.booleanValue()) {
            userOptionsInfo.setPrintAnsweredQuestionsOnly("No");
        } else if (printAnsweredOnlyFlag != null && printAnsweredOnlyFlag.booleanValue()) {
            userOptionsInfo.setPrintAnsweredQuestionsOnly("Yes");
        }
        userOptions.setUserOptionsInfo(userOptionsInfo);
    }

    private ModuleQuestionnaireBean getQuestionnaireAnswerHeaderBean(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> params) {
        String moduleItemCode = null;
        String moduleSubItemCode = "0";
        String moduleItemKey = null;
        String moduleSubItemKey = null;
        if (printableBusinessObject instanceof Protocol) {
            Protocol protocol = (Protocol)printableBusinessObject;
            moduleItemCode = "7";
            moduleSubItemCode = this.getProtocolSubItemCode(protocol);
            if (params.get(PROTOCOL_NUMBER) != null && params.get(SUBMISSION_NUMBER) != null) {
                moduleItemKey = (String)params.get(PROTOCOL_NUMBER);
                moduleSubItemKey = (String)params.get(SUBMISSION_NUMBER);
                moduleSubItemCode = "2";
            } else {
                moduleItemKey = protocol.getProtocolNumber();
                moduleSubItemKey = protocol.getSequenceNumber().toString();
                if (params.get(MODULE_SUB_ITEM_CODE) != null) {
                    moduleSubItemCode = (String)params.get(MODULE_SUB_ITEM_CODE);
                }
            }
        } else if (printableBusinessObject instanceof IacucProtocol) {
            IacucProtocol protocol = (IacucProtocol)printableBusinessObject;
            moduleItemCode = "9";
            moduleSubItemCode = this.getIacucProtocolSubItemCode(protocol);
            if (params.get(PROTOCOL_NUMBER) != null && params.get(SUBMISSION_NUMBER) != null) {
                moduleItemKey = (String)params.get(PROTOCOL_NUMBER);
                moduleSubItemKey = (String)params.get(SUBMISSION_NUMBER);
                moduleSubItemCode = "2";
            } else {
                moduleItemKey = protocol.getProtocolNumber();
                moduleSubItemKey = protocol.getSequenceNumber().toString();
                if (params.get(MODULE_SUB_ITEM_CODE) != null) {
                    moduleSubItemCode = (String)params.get(MODULE_SUB_ITEM_CODE);
                }
            }
        } else if (printableBusinessObject instanceof DevelopmentProposal) {
            DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
            moduleItemCode = "3";
            moduleItemKey = developmentProposal.getProposalNumber();
            moduleSubItemCode = (String)params.get(COEUS_MODULE_SUB_ITEM_CODE);
            moduleSubItemKey = "0";
        } else if (printableBusinessObject instanceof ProposalPerson) {
            ProposalPerson person = (ProposalPerson)printableBusinessObject;
            moduleItemCode = "3";
            moduleItemKey = person.getUniqueId();
            moduleSubItemCode = "3";
            moduleSubItemKey = "0";
        }
        return this.getQuestionnaireAnswerService().getModuleSpecificBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, true);
    }

    private String getProtocolSubItemCode(Protocol protocol) {
        String subModuleCode = "0";
        if (protocol.isAmendment() || protocol.isRenewal()) {
            subModuleCode = "1";
        }
        return subModuleCode;
    }

    private String getIacucProtocolSubItemCode(IacucProtocol protocol) {
        String subModuleCode = "0";
        if (protocol.isAmendment() || protocol.isRenewal()) {
            subModuleCode = "1";
        }
        return subModuleCode;
    }

    private Questionnaire findQuestionnaireObject(String documentNumber) throws PrintingException {
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put(DOCUMENT_NUMBER, documentNumber);
        List questionnaires = (List)this.businessObjectService.findMatching(Questionnaire.class, qMap);
        if (questionnaires.isEmpty()) {
            return this.findUnapprovedQuestionnaire(documentNumber);
        }
        return (Questionnaire)questionnaires.get(0);
    }

    private Questionnaire findUnapprovedQuestionnaire(String documentNumber) throws PrintingException {
        Questionnaire questionnaire = null;
        try {
            MaintenanceDocumentBase questionnaireDocument = (MaintenanceDocumentBase)this.documentService.getByDocumentHeaderId(documentNumber);
            if (questionnaireDocument != null) {
                String content = this.routeHeaderService.getContent(questionnaireDocument.getDocumentHeader().getWorkflowDocument().getDocumentId()).getDocumentContent();
                questionnaire = (Questionnaire)this.getBusinessObjectFromXML(content, KualiDocumentXmlMaterializer.class.getName());
            }
        }
        catch (WorkflowException e) {
            LOG.error("Problem in deserializing xmldata to Questionnaire", (Throwable)e);
            throw new PrintingException("Problem in deserializing xmldata to Questionnaire", e);
        }
        return questionnaire;
    }

    private PersistableBusinessObject getBusinessObjectFromXML(String xmlDocumentContents, String objectTagName) {
        String beginTag = "<document class=\"" + MaintenanceDocumentBase.class.getName() + "\">";
        String endTag = "</document>";
        Object objXml = StringUtils.substringBetween((String)xmlDocumentContents, (String)beginTag, (String)endTag);
        objXml = beginTag + (String)objXml + endTag;
        MaintenanceDocumentBase maintenanceDocument = (MaintenanceDocumentBase)this.xmlObjectSerializerService.fromXml((String)objXml);
        PersistableBusinessObject businessObject = (PersistableBusinessObject)maintenanceDocument.getDocumentBusinessObject();
        return businessObject;
    }

    private void allocateQuestionHierarchy(QuestionsType questionsType, QuestionInfoType parentQuestionInfo, boolean questionnaireCompletionFlag, KcPersistableBusinessObjectBase printableBusinessObject, List<AnswerHeader> answerHeaders) {
        try {
            for (QuestionnaireQuestion questionnaireQuestion : this.sortedQuestionnaireQuestions) {
                boolean answeredFlag = true;
                if (questionnaireQuestion.getConditionValue() != null) {
                    answeredFlag = false;
                    for (AnswerHeader ansHeader : answerHeaders) {
                        if (!questionnaireQuestion.getQuestionnaireId().equals(ansHeader.getQuestionnaireId())) continue;
                        for (Answer answer : ansHeader.getAnswers()) {
                            if (!answer.getQuestionnaireQuestion().getId().equals(questionnaireQuestion.getId()) || !answer.getQuestionNumber().equals(questionnaireQuestion.getQuestionNumber()) || !answer.getQuestionId().equals(questionnaireQuestion.getQuestionId())) continue;
                            answeredFlag = true;
                            if (answer.getParentAnswers() == null || answer.getParentAnswers().get(0).getAnswer() == null) continue;
                            if (answer.getParentAnswers().get(0).getQuestion().getQuestionTypeId() == 3L) {
                                if (!answer.getParentAnswers().get(0).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                                answeredFlag = false;
                                continue;
                            }
                            if (answer.getParentAnswers().get(0).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                            answeredFlag = false;
                        }
                    }
                }
                if (!answeredFlag) continue;
                Long questionId = questionnaireQuestion.getId();
                int questionNumber = questionnaireQuestion.getQuestionNumber();
                int parentQuestionNumber = questionnaireQuestion.getParentQuestionNumber();
                int tempParentQuestionNumber = questionsType != null ? 0 : parentQuestionInfo.getQuestionNumber();
                if (!questionnaireQuestion.isAllow() || parentQuestionNumber != tempParentQuestionNumber) continue;
                QuestionInfoType questionInfo = QuestionInfoType.Factory.newInstance();
                questionInfo.setQuestionNumber(questionNumber);
                questionInfo = tempParentQuestionNumber == 0 ? questionsType.addNewQuestionInfo() : parentQuestionInfo.addNewQuestionInfo();
                this.setAnswerInfoDetails(questionnaireQuestion, questionInfo, questionnaireCompletionFlag, printableBusinessObject, questionId, questionNumber, answerHeaders);
                questionnaireQuestion.setAllow(false);
            }
        }
        catch (PrintingException e) {
            LOG.error("Problem in deserializing xmldata to Questionnaire", (Throwable)e);
        }
        QuestionInfoType[] childQuestionsList = questionsType != null ? questionsType.getQuestionInfoArray() : parentQuestionInfo.getQuestionInfoArray();
        if (childQuestionsList != null && childQuestionsList.length > 0) {
            for (QuestionInfoType questionInfoType : childQuestionsList) {
                QuestionInfoType questionInfoListData = questionsType != null ? questionInfoType : questionInfoType;
                this.allocateQuestionHierarchy(null, questionInfoListData, questionnaireCompletionFlag, printableBusinessObject, answerHeaders);
            }
        }
    }

    private void setAnswerInfoDetails(QuestionnaireQuestion questionnaireQuestion, QuestionInfoType questionInfo, boolean questionnaireCompletionFlag, KcPersistableBusinessObjectBase printableBusinessObject, Long questionId, int questionNumber, List<AnswerHeader> answerHeaders) throws PrintingException {
        boolean answeredFlag = true;
        if (questionnaireQuestion.getConditionValue() != null) {
            answeredFlag = false;
            for (AnswerHeader ansHeader : answerHeaders) {
                if (!questionnaireQuestion.getQuestionnaireId().equals(ansHeader.getQuestionnaireId())) continue;
                for (Answer answer : ansHeader.getAnswers()) {
                    if (!answer.getQuestionnaireQuestion().getId().equals(questionnaireQuestion.getId()) || !answer.getQuestionNumber().equals(questionnaireQuestion.getQuestionNumber()) || !answer.getQuestionId().equals(questionnaireQuestion.getQuestionId())) continue;
                    answeredFlag = true;
                    if (answer.getParentAnswers() == null || answer.getParentAnswers().get(0).getAnswer() == null) continue;
                    if (answer.getParentAnswers().get(0).getQuestion().getQuestionTypeId() == 3L) {
                        if (!answer.getParentAnswers().get(0).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                        answeredFlag = false;
                        continue;
                    }
                    if (answer.getParentAnswers().get(0).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                    answeredFlag = false;
                }
            }
        }
        if (answeredFlag) {
            if (questionId != null) {
                questionInfo.setQuestionId(questionId.intValue());
            }
            questionInfo.setQuestionNumber(questionNumber);
            if (questionnaireQuestion.getQuestion() == null) {
                questionnaireQuestion.refreshReferenceObject(QUESTION);
            }
            if (questionnaireQuestion.getQuestion() != null) {
                questionInfo.setQuestion(questionnaireQuestion.getQuestion().getQuestion());
                if (!questionnaireQuestion.getParentQuestionNumber().equals(0)) {
                    questionInfo.setParentQuestionNumber(questionnaireQuestion.getParentQuestionNumber());
                }
            }
            if (answerHeaders != null && answerHeaders.size() > 0) {
                boolean isAnswerNamePresent = false;
                int selectedAnswer = 0;
                for (AnswerHeader answerHeader : answerHeaders) {
                    Object answerName = "";
                    Object answerDescription = null;
                    if (questionnaireQuestion.getQuestionnaireId().equals(answerHeader.getQuestionnaireId())) {
                        List<Answer> answers = answerHeader.getAnswers();
                        for (Answer answer : answers) {
                            if (!answer.getQuestionnaireQuestion().getId().equals(questionnaireQuestion.getId()) || !answer.getQuestionNumber().equals(questionnaireQuestion.getQuestionNumber()) || !answer.getQuestionId().equals(questionnaireQuestion.getQuestionId())) continue;
                            boolean updateQuestionDescription = printableBusinessObject instanceof ProposalPerson;
                            if (answer.getAnswer() == null) continue;
                            if (isAnswerNamePresent) {
                                answerName = (String)answerName + ", ";
                            }
                            if ((answerName = (String)answerName + answer.getAnswer().trim()) != null) {
                                if (((String)answerName).trim().equalsIgnoreCase("Y")) {
                                    answerDescription = "Yes";
                                    if (updateQuestionDescription && StringUtils.isNotBlank((CharSequence)questionnaireQuestion.getQuestion().getAffirmativeStatementConversion())) {
                                        questionInfo.setQuestion(questionnaireQuestion.getQuestion().getAffirmativeStatementConversion());
                                    }
                                } else if (((String)answerName).trim().equalsIgnoreCase("N")) {
                                    answerDescription = "No";
                                    if (updateQuestionDescription && StringUtils.isNotBlank((CharSequence)questionnaireQuestion.getQuestion().getNegativeStatementConversion())) {
                                        questionInfo.setQuestion(questionnaireQuestion.getQuestion().getNegativeStatementConversion());
                                    }
                                } else {
                                    answerDescription = ((String)answerName).trim().equalsIgnoreCase("X") ? "None" : answerName;
                                }
                            }
                            selectedAnswer = answer.getAnswerNumber();
                            isAnswerNamePresent = true;
                        }
                    }
                    AnswerInfoType answerInfo = questionInfo.addNewAnswerInfo();
                    answerInfo.setAnswerNumber(selectedAnswer);
                    if (questionnaireQuestion.getQuestion().getQuestionTypeId().equals(6L) && questionnaireQuestion.getQuestion().getLookupClass().equals(KcPerson.class.getName()) && questionnaireQuestion.getQuestion().getLookupReturn().equals(PERSON_ID) && answerDescription != null && !((String)answerDescription).equals("")) {
                        String[] personAnswers = ((String)answerDescription).split(",");
                        answerDescription = "";
                        for (String personAnswer1 : personAnswers) {
                            KcPerson kcPerson = this.kcPersonService.getKcPersonByPersonId(personAnswer1.trim());
                            if (kcPerson == null) continue;
                            answerDescription = (String)answerDescription + kcPerson.getFullName() + ",";
                        }
                        answerDescription = ((String)answerDescription).substring(0, ((String)answerDescription).lastIndexOf(",") - 1);
                    }
                    answerInfo.setAnswer((String)answerDescription);
                }
            }
        }
    }

    private void setQuestionInfoData(Questionnaire questionnaire, ModuleQuestionnaireBean moduleQuestionnaireBean, QuestionnaireDocument.Questionnaire questionnaireType, boolean questionnaireCompletionFlag, KcPersistableBusinessObjectBase printableBusinessObject) throws PrintingException {
        List<Object> answerHeaders = new ArrayList();
        if (moduleQuestionnaireBean != null && !(answerHeaders = this.questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean)).isEmpty()) {
            Questionnaire answeredQuestionnaire = ((AnswerHeader)answerHeaders.get(0)).getQuestionnaire();
            answeredQuestionnaire.refreshReferenceObject(QUESTIONNAIRE_QUESTIONS);
        }
        Questionnaire toSortQuestionnaire = null;
        for (AnswerHeader answerHeader : answerHeaders) {
            if (!answerHeader.getQuestionnaire().getQuestionnaireSeqId().equals(questionnaire.getQuestionnaireSeqId())) continue;
            toSortQuestionnaire = answerHeader.getQuestionnaire();
        }
        if (toSortQuestionnaire == null) {
            toSortQuestionnaire = questionnaire;
        }
        this.sortedQuestionnaireQuestions = this.getSortedQuestionnaireQuestions(toSortQuestionnaire);
        if (this.sortedQuestionnaireQuestions != null && this.sortedQuestionnaireQuestions.size() > 0) {
            for (QuestionnaireQuestion questionnaireQuestion : this.sortedQuestionnaireQuestions) {
                questionnaireQuestion.setAllow(true);
            }
            int parentQuestionNumbercheck = 0;
            QuestionsType questionsType = questionnaireType.addNewQuestions();
            QuestionInfoType rootQuestionInfo = QuestionInfoType.Factory.newInstance();
            try {
                rootQuestionInfo.setQuestionNumber(parentQuestionNumbercheck);
                if (this.sortedQuestionnaireQuestions.size() >= 1) {
                    this.allocateQuestionHierarchy(questionsType, rootQuestionInfo, questionnaireCompletionFlag, printableBusinessObject, answerHeaders);
                }
            }
            catch (Exception e) {
                LOG.error("Problem in deserializing xmldata to Questionnaire", (Throwable)e);
                throw e;
            }
        }
    }

    private List<QuestionnaireQuestion> getSortedQuestionnaireQuestions(Questionnaire questionnaire) {
        return QuestionnaireXmlStream.getSortedVector(questionnaire.getQuestionnaireQuestions());
    }

    public static List<QuestionnaireQuestion> getSortedVector(List<QuestionnaireQuestion> questions) {
        return QuestionnaireXmlStream.sort(questions);
    }

    private static List<QuestionnaireQuestion> sort(List<QuestionnaireQuestion> questions) {
        List<QuestionnaireQuestion> tempQuestions = questions;
        ArrayList<QuestionnaireQuestion> elements = new ArrayList<QuestionnaireQuestion>();
        for (int i = 0; i < tempQuestions.size(); ++i) {
            QuestionnaireQuestion questionaireQuestion = questions.get(i);
            if (elements.contains(questionaireQuestion)) continue;
            QuestionnaireXmlStream.findChildrenAndUpdate(elements, tempQuestions, questionaireQuestion);
            --i;
        }
        return elements;
    }

    private static void findChildrenAndUpdate(List<QuestionnaireQuestion> elements, List<QuestionnaireQuestion> questions, QuestionnaireQuestion parent) {
        elements.add(parent);
        questions.remove(parent);
        List<QuestionnaireQuestion> children = QuestionnaireXmlStream.findChildren(questions, parent.getQuestionNumber());
        if (children != null && children.size() > 0) {
            for (QuestionnaireQuestion childBean : children) {
                QuestionnaireXmlStream.findChildrenAndUpdate(elements, questions, childBean);
            }
        }
    }

    private static List<QuestionnaireQuestion> findChildren(List<QuestionnaireQuestion> questionnaireQuestions, Integer parent) {
        ArrayList<QuestionnaireQuestion> list = new ArrayList<QuestionnaireQuestion>();
        if (questionnaireQuestions != null && questionnaireQuestions.size() > 0) {
            for (QuestionnaireQuestion bean : questionnaireQuestions) {
                if (bean.getParentQuestionNumber() == null || parent == null || bean.getParentQuestionNumber().intValue() != parent.intValue()) continue;
                list.add(bean);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 1; j <= list.size() - 1; ++j) {
                QuestionnaireQuestion firstChild = (QuestionnaireQuestion)list.get(j - 1);
                QuestionnaireQuestion secondChild = (QuestionnaireQuestion)list.get(j);
                if (secondChild.getQuestionSeqNumber() >= firstChild.getQuestionSeqNumber()) continue;
                QuestionnaireQuestion temp = firstChild;
                list.set(j - 1, secondChild);
                list.set(j, temp);
            }
        }
        return list;
    }

    public QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public XmlObjectSerializerService getXmlObjectSerializerService() {
        return this.xmlObjectSerializerService;
    }

    public void setXmlObjectSerializerService(XmlObjectSerializerService xmlObjectSerializerService) {
        this.xmlObjectSerializerService = xmlObjectSerializerService;
    }
}

