/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.person.ProposalPersonCertificationDetails;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentService")
public class ProposalDevelopmentServiceImpl
implements ProposalDevelopmentService {
    public static final String PROPOSAL_NUMBER = "proposalNumber";
    protected final Logger LOG = LogManager.getLogger(ProposalDevelopmentServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="systemAuthorizationService")
    private SystemAuthorizationService systemAuthorizationService;
    @Autowired
    @Qualifier(value="proposalTypeService")
    private ProposalTypeService proposalTypeService;
    @Autowired
    @Qualifier(value="propDevProjectRetrievalService")
    private ProjectRetrievalService projectRetrievalService;
    @Autowired
    @Qualifier(value="projectPublisher")
    private ProjectPublisher projectPublisher;

    @Override
    public void initializeUnitOrganizationLocation(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalSite applicantOrganization = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization();
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (developmentProposal.getOwnedByUnitNumber() != null && (applicantOrganization == null || applicantOrganization.getOrganization() == null)) {
            developmentProposal.refreshReferenceObject("ownedByUnit");
            String applicantOrganizationId = developmentProposal.getOwnedByUnit().getOrganizationId();
            applicantOrganization = this.createProposalSite(applicantOrganizationId);
            applicantOrganization.setDevelopmentProposal(developmentProposal);
            developmentProposal.setApplicantOrganization(applicantOrganization);
        }
        ProposalSite performingOrganization = developmentProposal.getPerformingOrganization();
        if (StringUtils.isEmpty((CharSequence)developmentProposal.getProposalNumber()) && performingOrganization.getOrganization() == null && developmentProposal.getOwnedByUnitNumber() != null) {
            String performingOrganizationId = developmentProposal.getOwnedByUnit().getOrganizationId();
            performingOrganization = this.createProposalSite(performingOrganizationId);
            performingOrganization.setDevelopmentProposal(developmentProposal);
            developmentProposal.setPerformingOrganization(performingOrganization);
        }
    }

    protected ProposalSite createProposalSite(String organizationId) {
        ProposalSite proposalSite = new ProposalSite();
        proposalSite.setOrganizationId(organizationId);
        proposalSite.initializeDefaultCongressionalDistrict();
        return proposalSite;
    }

    protected int getNextSiteNumber(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return proposalDevelopmentDocument.getDocumentNextValue("proposalDevelopment.proposalLocation.locationSequenceNumber");
    }

    @Override
    public void initializeProposalSiteNumbers(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        for (ProposalSite proposalSite : proposalDevelopmentDocument.getDevelopmentProposal().getProposalSites()) {
            if (proposalSite.getSiteNumber() == null) {
                proposalSite.setSiteNumber(this.getNextSiteNumber(proposalDevelopmentDocument));
            }
            if (proposalSite.getDevelopmentProposal() == null) {
                proposalSite.setDevelopmentProposal(proposalDevelopmentDocument.getDevelopmentProposal());
            }
            if (proposalSite.getOrganizationId() == null) continue;
            proposalSite.setOrganizationId(proposalSite.getOrganizationId());
        }
    }

    @Override
    public List<Unit> getDefaultModifyProposalUnitsForUser(String userId) {
        return this.getUnitsForCreateProposal(userId);
    }

    protected String getPropertyValue(BusinessObject businessObject, String fieldName) {
        String displayValue = "";
        try {
            displayValue = (String)ObjectUtils.getPropertyValue((Object)businessObject, (String)fieldName);
        }
        catch (RuntimeException e) {
            this.LOG.warn(e.getMessage(), (Throwable)e);
        }
        return displayValue;
    }

    @Override
    public boolean isGrantsGovEnabledForProposal(DevelopmentProposal devProposal) {
        if (devProposal.isChild() && !devProposal.isMultiProjectChild() || devProposal.getSponsor() == null) {
            return false;
        }
        return this.parameterService.getParameterValuesAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE").stream().filter(StringUtils::isNotBlank).distinct().anyMatch(federalSponsorTypeCode -> StringUtils.equals((CharSequence)devProposal.getSponsor().getSponsorTypeCode(), (CharSequence)federalSponsorTypeCode));
    }

    private void handleProjectPush(String sourceIdentifier) {
        Project project = this.projectRetrievalService.retrieveProject(sourceIdentifier);
        project.setActive(false);
        this.getProjectPublisher().publishProject(project);
    }

    @Override
    public ProposalDevelopmentDocument deleteProposal(ProposalDevelopmentDocument proposalDocument) throws WorkflowException {
        this.handleProjectPush(proposalDocument.getDevelopmentProposal().getProposalNumber());
        this.deleteCertDetails(proposalDocument.getDevelopmentProposal());
        this.deleteProposalNotifications(proposalDocument.getDevelopmentProposal());
        proposalDocument.getDevelopmentProposal().setFinalBudget(null);
        this.dataObjectService.delete((Object)proposalDocument.getDevelopmentProposal());
        proposalDocument.setDevelopmentProposal(null);
        proposalDocument.setProposalDeleted(true);
        proposalDocument = (ProposalDevelopmentDocument)this.getDocumentService().saveDocument((Document)proposalDocument);
        return (ProposalDevelopmentDocument)this.getDocumentService().cancelDocument((Document)proposalDocument, "Delete Proposal");
    }

    protected void deleteCertDetails(DevelopmentProposal proposal) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(PROPOSAL_NUMBER, proposal.getProposalNumber());
        this.dataObjectService.deleteMatching(ProposalPersonCertificationDetails.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        proposal.getProposalPersons().forEach(proposalPerson -> proposalPerson.setCertificationDetails(null));
    }

    protected void deleteProposalNotifications(DevelopmentProposal proposal) {
        if (CollectionUtils.isNotEmpty(proposal.getNotifications())) {
            this.getBusinessObjectService().delete(proposal.getNotifications());
        }
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    public Budget getFinalBudget(DevelopmentProposal proposal) {
        return proposal.getFinalBudget();
    }

    @Override
    public InstitutionalProposal getInstitutionalProposal(String devProposalNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("devProposalNumber", devProposalNumber);
        Collection proposalAdminDetails = this.getBusinessObjectService().findMatching(ProposalAdminDetails.class, values);
        for (ProposalAdminDetails pad : proposalAdminDetails) {
            if (pad.getInstProposalId() == null) continue;
            return (InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)pad.getInstProposalId());
        }
        return null;
    }

    @Override
    public List<Unit> getUnitsForCreateProposal(String userId) {
        String namespaceCode = "KC-PD";
        String permissionName = "Create ProposalDevelopmentDocument";
        LinkedHashSet<Unit> units = new LinkedHashSet<Unit>();
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        HashMap qualification = new HashMap(qualifiedRoleAttributes);
        HashSet<String> roleIds = new HashSet<String>(this.systemAuthorizationService.getRoleIdsForPermission("Create ProposalDevelopmentDocument", "KC-PD"));
        HashSet qualifiers = new HashSet(this.roleService.getNestedRoleQualifiersForPrincipalByRoleIds(userId, new ArrayList<String>(roleIds), qualification));
        for (Map qualifier : qualifiers) {
            Unit unit = this.getUnitService().getUnit((String)qualifier.get("unitNumber"));
            if (unit == null || !unit.isActive()) continue;
            units.add(unit);
            if (!qualifier.containsKey("subunits") || !StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)((CharSequence)qualifier.get("subunits"))) && !StringUtils.equalsIgnoreCase((CharSequence)"Yes", (CharSequence)((CharSequence)qualifier.get("subunits")))) continue;
            this.addDescendantUnits(unit, units);
        }
        return new ArrayList<Unit>(units);
    }

    @Override
    public boolean autogenerateInstitutionalProposal() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "proposaldevelopment.autogenerate.institutionalproposal");
    }

    @Override
    public String getIPGenerateOption(DevelopmentProposal developmentProposal) {
        if (this.isProposalTypeChangeCorrected(developmentProposal.getProposalTypeCode())) {
            return "O";
        }
        return "N";
    }

    @Override
    public boolean isProposalReniewedOrChangeCorrected(DevelopmentProposal developmentProposal) {
        return this.getProposalTypeService().getContinuationProposalTypeCode().equals(developmentProposal.getProposalTypeCode()) || this.getProposalTypeService().getRenewProposalTypeCode().equals(developmentProposal.getProposalTypeCode()) || this.getProposalTypeService().getResubmissionProposalTypeCode().equals(developmentProposal.getProposalTypeCode()) || this.getProposalTypeService().getRevisionProposalTypeCode().equals(developmentProposal.getProposalTypeCode()) || this.isProposalTypeChangeCorrected(developmentProposal.getProposalTypeCode()) || this.isSubmissionChangeCorrected(developmentProposal);
    }

    private boolean isSubmissionChangeCorrected(DevelopmentProposal developmentProposal) {
        return developmentProposal.hasS2sOpportunity() && this.getProposalTypeService().getS2SSubmissionChangeCorrectedCode().equals(developmentProposal.getS2sOpportunity().getS2sSubmissionTypeCode());
    }

    private boolean isProposalTypeChangeCorrected(String proposalTypeCode) {
        return this.getProposalTypeService().getNewChangedOrCorrectedProposalTypeCode().equals(proposalTypeCode) || this.getProposalTypeService().getRenewalChangedOrCorrectedProposalTypeCode().equals(proposalTypeCode) || this.getProposalTypeService().getResubmissionChangedOrCorrectedProposalTypeCode().equals(proposalTypeCode) || this.getProposalTypeService().getSupplementChangedOrCorrectedProposalTypeCode().equals(proposalTypeCode) || this.getProposalTypeService().getBudgetSowUpdateProposalTypeCode().equals(proposalTypeCode);
    }

    protected void addDescendantUnits(Unit parentUnit, Set<Unit> units) {
        List<Unit> subunits = this.getUnitService().getActiveSubUnits(parentUnit.getUnitNumber());
        if (CollectionUtils.isNotEmpty(subunits)) {
            units.addAll(subunits);
            for (Unit subunit : subunits) {
                this.addDescendantUnits(subunit, units);
            }
        }
    }

    protected RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public ProposalTypeService getProposalTypeService() {
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    public ProjectPublisher getProjectPublisher() {
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }
}

