/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.sql.Date;
import java.util.Calendar;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectCommentType;
import org.kuali.rice.krad.util.ObjectUtils;

public class ExconProjectComment
extends ExconProjectAssociate
implements Comparable<ExconProjectComment> {
    private static final long serialVersionUID = 3611932717292205490L;
    private Long exconProjectCommentId;
    private String commentTypeCode;
    private String commentAuthor;
    private Date commentDate;
    private Boolean checklistPrintFlag;
    private String comments;
    private Long projectId;
    private ExconProjectCommentType commentType;
    private transient KcPersonService kcPersonService;

    public ExconProjectComment() {
    }

    public ExconProjectComment(ExconProjectCommentType commentType, String comments) {
        this();
        this.setCommentType(commentType);
        this.setComments(comments);
        this.setChecklistPrintFlag(Boolean.FALSE);
    }

    public Long getExconProjectCommentId() {
        return this.exconProjectCommentId;
    }

    public void setExconProjectCommentId(Long exconProjectCommentId) {
        this.exconProjectCommentId = exconProjectCommentId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exconProjectCommentId == null ? 0 : this.exconProjectCommentId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExconProjectComment other = (ExconProjectComment)obj;
        return this.exconProjectCommentId.equals(other.exconProjectCommentId);
    }

    public boolean sameText(ExconProjectComment compare) {
        if (Objects.equals(this.getComments(), compare.getComments())) {
            return true;
        }
        if (!this.isEntered() && !compare.isEntered()) {
            return true;
        }
        if (!this.isEntered() || !compare.isEntered()) {
            return false;
        }
        return this.comments.equals(compare.getComments());
    }

    public String getCommentTypeCode() {
        return this.commentTypeCode;
    }

    public void setCommentTypeCode(String commentTypeCode) {
        this.commentTypeCode = commentTypeCode;
    }

    public Boolean getChecklistPrintFlag() {
        return this.checklistPrintFlag;
    }

    public void setChecklistPrintFlag(Boolean checklistPrintFlag) {
        this.checklistPrintFlag = checklistPrintFlag;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public ExconProjectCommentType getCommentType() {
        if (!StringUtils.isEmpty((CharSequence)this.commentTypeCode)) {
            this.refreshReferenceObject("commentType");
        }
        return this.commentType;
    }

    public void setCommentType(ExconProjectCommentType commentType) {
        this.commentType = commentType;
        this.commentTypeCode = commentType != null ? commentType.getExconProjectCommentTypeCode() : null;
    }

    public String getCommentAuthor() {
        return this.commentAuthor;
    }

    public void setCommentAuthor(String commentAuthor) {
        this.commentAuthor = commentAuthor;
    }

    public String getCommentAuthorName() {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getCommentAuthor());
        return ObjectUtils.isNull((Object)person) ? "Person not found" : person.getFullName();
    }

    public Date getCommentDate() {
        return this.commentDate;
    }

    public String getCommentDateStr() {
        return ExconProject.formattedDate(this.commentDate);
    }

    public void setCommentDate(Date commentDate) {
        this.commentDate = commentDate;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getUpdateTimestampDateString() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(this.getUpdateTimestamp().getTime()));
        return cal.get(2) + "/" + cal.get(5) + "/" + cal.get(1);
    }

    @Override
    public void resetPersistenceState() {
        this.exconProjectCommentId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectComment exconProjectCommentArg) {
        return exconProjectCommentArg.getUpdateTimestamp().compareTo(this.getUpdateTimestamp());
    }

    public void disableComment() {
        this.setVersionNumber(-1L);
    }

    public boolean isDisabled() {
        return Long.valueOf(-1L).equals(this.getVersionNumber());
    }

    public boolean isEntered() {
        return this.comments != null && this.comments.length() > 0;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

