/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class SubmissionTypeValuesFinder
extends IacucActionsKeyValuesBase {
    private static final long serialVersionUID = -4743158845190302163L;

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        ProtocolDocumentBase pd = (ProtocolDocumentBase)this.getDocument();
        if (pd != null) {
            ProtocolBase protocol = pd.getProtocol();
            Collection submissionTypes = this.getKeyValuesService().findAll(IacucProtocolSubmissionType.class);
            String currentStatus = pd.getProtocol().getProtocolStatusCode();
            for (IacucProtocolSubmissionType submissionType : submissionTypes) {
                if (!this.validStatusSubmissionTypePair(submissionType, currentStatus, protocol)) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(submissionType.getSubmissionTypeCode(), submissionType.getDescription()));
            }
        }
        return keyValues;
    }

    protected boolean validStatusSubmissionTypePair(IacucProtocolSubmissionType submissionType, String currentStatus, ProtocolBase protocol) {
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"100")) {
            return this.displayResubmission(currentStatus) || this.displayInitialSubmission(currentStatus);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"104")) {
            return this.displayResubmission(currentStatus) || this.displayFYISubmission(currentStatus);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"105")) {
            return this.displayResubmission(currentStatus) || this.displayAmendment(currentStatus, protocol);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"108")) {
            return this.displayResubmission(currentStatus) || this.displayContinuation(currentStatus, protocol);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"109")) {
            return this.displayResubmission(currentStatus) || this.displayContinuationWithAmendment(currentStatus, protocol);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"101")) {
            return this.displayResubmission(currentStatus) || this.displayResponseToPrevIACUCNotification(currentStatus);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)submissionType.getSubmissionTypeCode(), (CharSequence)"110")) {
            return this.displayNotifyIacuc(currentStatus, protocol);
        }
        return false;
    }

    private boolean displayFYISubmission(String currentStatus) {
        String[] validStatuses = new String[]{"100", "105", "101", "302", "203"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayInitialSubmission(String currentStatus) {
        String[] validStatuses = new String[]{"100", "105", "101", "302", "203"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayResponseToPrevIACUCNotification(String currentStatus) {
        String[] validStatuses = new String[]{"104", "107", "201", "101", "102", "103"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayAmendment(String currentStatus, ProtocolBase protocol) {
        String[] validStatuses = new String[]{"105", "205", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasAmmendmentProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean displayContinuation(String currentStatus, ProtocolBase protocol) {
        String[] validStatuses = new String[]{"105", "206", "207", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && (this.hasRenewalProtocolNumber(protocol.getProtocolNumber()) || this.hasContinuationProtocolNumber(protocol.getProtocolNumber()));
    }

    private boolean displayContinuationWithAmendment(String currentStatus, ProtocolBase protocol) {
        String[] validStatuses = new String[]{"105", "206", "207", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && (this.hasRenewalProtocolNumber(protocol.getProtocolNumber()) || this.hasContinuationProtocolNumber(protocol.getProtocolNumber()));
    }

    private boolean hasAmmendmentProtocolNumber(String protocolNumber) {
        return protocolNumber.contains("A");
    }

    private boolean hasRenewalProtocolNumber(String protocolNumber) {
        return protocolNumber.contains(ProtocolSpecialVersion.RENEWAL.getCode());
    }

    private boolean hasContinuationProtocolNumber(String protocolNumber) {
        return protocolNumber.contains(ProtocolSpecialVersion.CONTINUATION.getCode());
    }

    private boolean hasFyiProtocolNumber(String protocolNumber) {
        return protocolNumber.contains(ProtocolSpecialVersion.FYI.getCode());
    }

    private boolean displayResubmission(String currentStatus) {
        String[] validStatuses = new String[]{"105", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    protected boolean displayNotifyIacuc(String currentStatus, ProtocolBase protocol) {
        boolean useAlternateNotifyIacucAction = this.getParameterService().getParameterValueAsBoolean(IacucProtocolDocument.class, "ALTERNATE_NOTIFY_IACUC_ACTION_PARAM", Boolean.valueOf(false));
        if (useAlternateNotifyIacucAction) {
            String[] validStatuses = new String[]{"105", "900", "101"};
            return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasFyiProtocolNumber(protocol.getProtocolNumber());
        }
        String[] validStatuses = new String[]{"200", "202"};
        String[] validSumissionStatuses = new String[]{"102", "101"};
        String currentSubmissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.validateCurrentSubmissionStatus(currentSubmissionStatus, validSumissionStatuses);
    }

    private boolean validateCurrentStatus(String currentStatus, String[] validStatuses) {
        for (String status : validStatuses) {
            if (!StringUtils.equals((CharSequence)currentStatus, (CharSequence)status)) continue;
            return true;
        }
        return false;
    }

    protected boolean validateCurrentSubmissionStatus(String currentSubmissionStatus, String[] validSubmissionStatuses) {
        for (String status : validSubmissionStatuses) {
            if (!StringUtils.equals((CharSequence)currentSubmissionStatus, (CharSequence)status)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

