/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.IrbProtocolActionRequestService;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.ProtocolRequestAction;
import org.kuali.kra.irb.actions.abandon.ProtocolAbandonService;
import org.kuali.kra.irb.actions.amendrenew.CreateAmendmentEvent;
import org.kuali.kra.irb.actions.amendrenew.CreateRenewalEvent;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveEvent;
import org.kuali.kra.irb.actions.approve.ProtocolApproveService;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaEvent;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersBean;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersEvent;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.irb.actions.correction.AdminCorrectionBean;
import org.kuali.kra.irb.actions.correction.ProtocolAdminCorrectionEvent;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionsCorrespondence;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionEvent;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionService;
import org.kuali.kra.irb.actions.expeditedapprove.ProtocolExpeditedApproveBean;
import org.kuali.kra.irb.actions.expeditedapprove.ProtocolExpeditedApproveEvent;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionEvent;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionEvent;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionService;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredEvent;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredService;
import org.kuali.kra.irb.actions.notification.AssignReviewerNotificationRenderer;
import org.kuali.kra.irb.actions.notification.NotifyCommitteeNotificationRenderer;
import org.kuali.kra.irb.actions.notification.NotifyIrbNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolClosedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolDisapprovedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolExpiredNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.actions.notification.ProtocolSuspendedByDSMBNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolSuspendedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolTerminatedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolWithdrawnNotificationRenderer;
import org.kuali.kra.irb.actions.notifycommittee.ProtocolNotifyCommitteeBean;
import org.kuali.kra.irb.actions.notifycommittee.ProtocolNotifyCommitteeService;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbService;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestEvent;
import org.kuali.kra.irb.actions.request.ProtocolRequestService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.actions.withdraw.ProtocolWithdrawService;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.questionnaire.ProtocolQuestionnaireAuditRule;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBean;
import org.kuali.kra.protocol.actions.ProtocolActionRequestServiceImpl;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRequestBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolQuestionnaireAuditRuleBase;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class IrbProtocolActionRequestServiceImpl
extends ProtocolActionRequestServiceImpl
implements IrbProtocolActionRequestService {
    private static final Logger LOG = LogManager.getLogger(IrbProtocolActionRequestServiceImpl.class);
    private ProtocolAssignToAgendaService protocolAssignToAgendaService;
    private ProtocolAssignCmtSchedService protocolAssignCmtSchedService;
    private ProtocolApproveService protocolApproveService;
    private ProtocolSubmitActionService protocolSubmitActionService;
    private ProtocolAmendRenewService protocolAmendRenewService;
    private ProtocolWithdrawService protocolWithdrawService;
    private ProtocolRequestService protocolRequestService;
    private ProtocolGenericActionService protocolGenericActionService;
    private ProtocolGrantExemptionService protocolGrantExemptionService;
    private CommitteeDecisionService committeeDecisionService;
    private ProtocolAbandonService protocolAbandonService;
    private ProtocolNotifyIrbService protocolNotifyIrbService;
    private ProtocolNotifyCommitteeService protocolNotifyCommitteeService;
    private CommitteeService committeeService;
    private ProtocolReviewNotRequiredService protocolReviewNotRequiredService;
    private ProtocolAssignReviewersService protocolAssignReviewersService;
    private ProtocolActionService protocolActionService;
    private static final String ACTION_NAME_RESPONSE_APPROVAL = "Response Approval";
    private static final String ACTION_NAME_CLOSE_ENROLLMENT = "Close Enrollment";
    private static final String ACTION_NAME_DEFER = "Defer";
    private static final String ACTION_NAME_GRANT_EXEMPTION = "Grant Exemption";
    private static final String ACTION_NAME_CLOSE = "Close";
    private static final String ACTION_NAME_IRB_ACKNOWLEDGEMENT = "IRB Acknowledgement";
    private static final String ACTION_NAME_DATA_ANALYSIS_ONLY = "Permit Data Analysis Only";
    private static final String ACTION_NAME_REOPEN_ENROLLMENT = "Re-open Enrollment";
    private static final String ACTION_NAME_SUSPEND_BY_DSMB = "Suspend by DSMB";
    private static final String ACTION_NAME_MANAGE_REVIEW_COMMENTS = "Manage Review Comments";
    private static final String ACTION_NAME_NOTIFY_IRB = "Notify IRB";
    private static final String ACTION_NAME_NOTIFY_COMMITTEE = "Notify Committee";
    private static final String FORWARD_TO_HOLDING_PAGE = "holdingPage";
    private static Map<String, String> motionTypeMap = new HashMap<String, String>(){
        {
            this.put("1", "Approve Action");
            this.put("2", "Disapprove");
            this.put("3", "Return for Specific Minor Revisions");
            this.put("4", "Return for Substantive Revisions Required");
        }
    };
    protected static List<String> requestSubmissionTypes = Arrays.asList("110", "108", "109", "111", "114", "113");

    @Override
    public boolean isExpeditedApprovalAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolExpeditedApproveBean expeditedActionBean = (ProtocolExpeditedApproveBean)protocolForm.getActionHelper().getProtocolExpeditedApprovalBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolExpediteApproval", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolExpeditedApproveEvent(document, expeditedActionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isFullApprovalAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolApproveBean protocolApproveBean = (ProtocolApproveBean)protocolForm.getActionHelper().getProtocolFullApprovalBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolApprove", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolApproveEvent(document, protocolApproveBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateRenewalAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        String renewalSummary = protocolForm.getActionHelper().getRenewalSummary();
        if (this.hasPermission("createRenewal", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateRenewalEvent(document, "actionHelper.renewalSummary", renewalSummary));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAssignToAgendaAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        ProtocolAssignToAgendaBean actionBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolAssignToAgenda", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new ProtocolAssignToAgendaEvent(document, actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateAmendmentAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolAmendmentBean protocolAmendmentBean = (ProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolAmendmentBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("createAmendment", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateAmendmentEvent(document, "actionHelper.protocolCreateAmendment", protocolAmendmentBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateRenewalWithAmendmentAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolAmendmentBean protocolAmendmentBean = (ProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolRenewAmendmentBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("createRenewal", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateAmendmentEvent(document, "actionHelper.protocolCreateRenewalWithAmendment", protocolAmendmentBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isWithdrawProtocolAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("protocolWithdraw", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isResponseApprovalAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolApproveBean actionBean = protocolForm.getActionHelper().getProtocolResponseApprovalBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolResponseApproval", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolApproveEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isRequestActionAuthorized(ProtocolForm protocolForm, String taskName) {
        boolean requestAuthorized = false;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        if (StringUtils.isNotBlank((CharSequence)taskName)) {
            requestAuthorized = this.hasPermission(taskName, document.getProtocol());
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCloseProtocolAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolCloseBean();
        return this.isGenericProtocolActionAuthorized("protocolClose", protocolForm, actionBean);
    }

    @Override
    public boolean isCloseEnrollmentAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolCloseEnrollmentBean();
        return this.isGenericProtocolActionAuthorized("protocolCloseEnrollment", protocolForm, actionBean);
    }

    private boolean isGenericProtocolActionAuthorized(String genericActionName, ProtocolForm protocolForm, ProtocolGenericActionBean actionBean) {
        boolean requestAuthorized = false;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        if (this.hasGenericPermission(genericActionName, document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isDeferProtocolAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolDeferBean();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolDefer", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isDisapproveProtocolAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolDisapproveBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolDisapprove", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isExpireProtocolAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolExpireBean();
        return this.isGenericProtocolActionAuthorized("protocolExpire", protocolForm, actionBean);
    }

    @Override
    public boolean isGrantExemptionAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGrantExemptionBean actionBean = protocolForm.getActionHelper().getProtocolGrantExemptionBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolGrantExemption", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGrantExemptionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isIrbAcknowledgementAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolIrbAcknowledgementBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("irbAcknowledgement", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isPermitDataAnalysisAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolPermitDataAnalysisBean();
        return this.isGenericProtocolActionAuthorized("protocolPermitDataAnalysis", protocolForm, actionBean);
    }

    @Override
    public boolean isReopenEnrollmentAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolReopenEnrollmentBean();
        return this.isGenericProtocolActionAuthorized("protocolReopen", protocolForm, actionBean);
    }

    @Override
    public boolean isReturnForSMRAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSMRBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolReturnForSMR", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isReturnForSRRAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSRRBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolReturnForSRR", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isReturnToPIAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolReturnToPIBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolReturnToPI", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isSuspendAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSuspendBean();
        return this.isGenericProtocolActionAuthorized("protocolSuspend", protocolForm, actionBean);
    }

    @Override
    public boolean isSuspendByDsmbAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolSuspendByDsmbBean();
        return this.isGenericProtocolActionAuthorized("protocolSuspendByDsmb", protocolForm, actionBean);
    }

    @Override
    public boolean isTerminateAuthorized(ProtocolForm protocolForm) {
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolTerminateBean();
        return this.isGenericProtocolActionAuthorized("protocolTerminate", protocolForm, actionBean);
    }

    @Override
    public boolean isManageCommentsAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("protocolManageReviewComments", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isOpenProtocolForAdminCorrectionAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        AdminCorrectionBean actionBean = (AdminCorrectionBean)protocolForm.getActionHelper().getProtocolAdminCorrectionBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolAdminCorrection", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new ProtocolAdminCorrectionEvent(document, actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isSubmitCommitteeDecisionAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        CommitteeDecision actionBean = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.applyRules((DocumentEvent)new CommitteeDecisionEvent(document, actionBean));
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAbandonAuthorized(ProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        requestAuthorized = this.hasPermission("protocolAbandon", document.getProtocol());
        return requestAuthorized;
    }

    @Override
    public boolean isProtocolReviewNotRequiredAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolReviewNotRequiredBean actionBean = protocolForm.getActionHelper().getProtocolReviewNotRequiredBean();
        boolean requestAuthorized = false;
        if (this.hasPermission("protocolReviewNotRequired", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new ProtocolReviewNotRequiredEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAssignReviewersAuthorized(ProtocolForm protocolForm) {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        boolean requestAuthorized = false;
        ProtocolAssignReviewersBean actionBean = protocolForm.getActionHelper().getProtocolAssignReviewersBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolAssignReviewers", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new ProtocolAssignReviewersEvent(document, actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isWithdrawRequestActionAuthorized(ProtocolForm protocolForm) {
        return this.hasPermission("protocolWithdrawRequestSubmission", protocolForm.getProtocolDocument().getProtocol());
    }

    @Override
    public void grantExpeditedApproval(ProtocolForm protocolForm) throws Exception {
        protocolForm.getActionHelper().setCurrentTask("protocolExpediteApproval");
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolExpeditedApproveBean expeditedActionBean = (ProtocolExpeditedApproveBean)protocolForm.getActionHelper().getProtocolExpeditedApprovalBean();
        if (expeditedActionBean.isAssignToAgenda()) {
            ProtocolAssignCmtSchedBean cmtAssignBean = protocolForm.getActionHelper().getAssignCmtSchedBean();
            cmtAssignBean.setScheduleId(expeditedActionBean.getScheduleId());
            boolean alreadyAssignedToAgenda = this.getProtocolAssignToAgendaService().isAssignedToAgenda(document.getProtocol());
            if (alreadyAssignedToAgenda) {
                if (cmtAssignBean.scheduleHasChanged()) {
                    this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedulePostAgendaAssignment(protocolForm.getProtocolDocument().getProtocol(), cmtAssignBean);
                }
            } else {
                this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedule(protocolForm.getProtocolDocument().getProtocol(), cmtAssignBean);
                ProtocolAssignToAgendaBean agendaBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
                agendaBean.setScheduleDate(this.getProtocolAssignToAgendaService().getAssignedScheduleDate(protocolForm.getProtocolDocument().getProtocol()));
                agendaBean.setActionDate(expeditedActionBean.getActionDate());
            }
            if (!alreadyAssignedToAgenda || cmtAssignBean.scheduleHasChanged()) {
                this.getProtocolAssignToAgendaService().assignToAgenda(protocolForm.getProtocolDocument().getProtocol(), expeditedActionBean);
                this.recordProtocolActionSuccess("Assign to Agenda");
                this.generateActionCorrespondence("200", protocolForm.getProtocolDocument().getProtocol());
            }
        }
        this.saveReviewComments(protocolForm, expeditedActionBean.getReviewCommentsBean());
        this.getProtocolApproveService().grantExpeditedApproval(protocolForm.getProtocolDocument(), expeditedActionBean);
        this.generateActionCorrespondence("205", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Expedited Approval");
        protocolForm.getTabStates().put(":" + WebUtils.generateTabKey((String)"Assign to Agenda"), "OPEN");
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "205", "Expedited Approval Granted");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            GlobalVariables.getUserSession().addObject("approvalComplCorrespondence", GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY"));
            GlobalVariables.getUserSession().removeObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
        } else {
            IRBNotificationRenderer renderer = new IRBNotificationRenderer(document.getProtocol());
            IRBNotificationContext context = new IRBNotificationContext(document.getProtocol(), "205", "Expedite Approved", (NotificationRenderer)renderer);
            this.getNotificationService().sendNotificationAndPersist(context, new IRBProtocolNotification(), document.getProtocol());
        }
    }

    @Override
    public void grantFullApproval(ProtocolForm protocolForm) throws Exception {
        ProtocolApproveBean protocolApproveBean = (ProtocolApproveBean)protocolForm.getActionHelper().getProtocolFullApprovalBean();
        ProtocolDocument document = protocolForm.getProtocolDocument();
        this.saveReviewComments(protocolForm, protocolApproveBean.getReviewCommentsBean());
        this.getProtocolApproveService().grantFullApproval(document, protocolApproveBean);
        this.generateActionCorrespondence("204", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Full Approval");
        protocolForm.getProtocolHelper().prepareView();
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "204", "Approved");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            GlobalVariables.getUserSession().addObject("approvalComplCorrespondence", GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY"));
            GlobalVariables.getUserSession().removeObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
        } else {
            IRBNotificationRenderer renderer = new IRBNotificationRenderer(document.getProtocol());
            IRBNotificationContext context = new IRBNotificationContext(document.getProtocol(), "204", "Approved", (NotificationRenderer)renderer);
            this.getNotificationService().sendNotificationAndPersist(context, new IRBProtocolNotification(), document.getProtocol());
        }
    }

    @Override
    public boolean submitForReviewAndPromptToNotifyUser(ProtocolForm protocolForm, boolean sendNotification) throws Exception {
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        Protocol protocol = protocolDocument.getProtocol();
        ProtocolSubmitAction submitAction = (ProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction();
        this.getProtocolSubmitActionService().submitToIrbForReview(protocolDocument, submitAction, null);
        protocolForm.getActionHelper().getAssignCmtSchedBean().init();
        this.generateActionCorrespondence("101", protocolForm.getProtocolDocument().getProtocol());
        if (sendNotification) {
            return this.sendSubmitForReviewNotification(protocolForm, protocol, submitAction);
        }
        return false;
    }

    public boolean sendSubmitForReviewNotification(ProtocolForm protocolForm, Protocol protocol, ProtocolSubmitAction submitAction) {
        AssignReviewerNotificationRenderer renderer1 = new AssignReviewerNotificationRenderer(protocolForm.getProtocolDocument().getProtocol(), "added");
        List<ProtocolNotificationRequestBean> addReviewerNotificationBeans = this.getNotificationRequestBeans(submitAction.getReviewers(), "create");
        if (!CollectionUtils.isEmpty(addReviewerNotificationBeans)) {
            ProtocolNotificationRequestBean notificationBean1 = addReviewerNotificationBeans.get(0);
            IRBNotificationContext context1 = new IRBNotificationContext(notificationBean1.getProtocol(), notificationBean1.getProtocolOnlineReview(), notificationBean1.getActionType(), notificationBean1.getDescription(), (NotificationRenderer)renderer1);
            this.getNotificationService().sendNotificationAndPersist(context1, new IRBProtocolNotification(), protocol);
        }
        ProtocolNotificationRequestBean notificationBean2 = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "321", "Submit");
        IRBNotificationRenderer renderer2 = new IRBNotificationRenderer(notificationBean2.getProtocol());
        IRBNotificationContext context2 = new IRBNotificationContext(protocol, notificationBean2.getActionType(), notificationBean2.getDescription(), (NotificationRenderer)renderer2);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context2)) {
            context2.setForwardName(FORWARD_TO_HOLDING_PAGE);
            protocolForm.getNotificationHelper().initializeDefaultValues(context2);
            return true;
        }
        this.getNotificationService().sendNotificationAndPersist(context2, new IRBProtocolNotification(), protocol);
        return false;
    }

    @Override
    public String createRenewal(ProtocolForm protocolForm) throws Exception {
        String newDocId = this.getProtocolAmendRenewService().createRenewal(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getRenewalSummary());
        this.generateActionCorrespondence("102", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, "Create Renewal without Amendment", true);
        protocolForm.getActionHelper().getProtocolAmendmentBean().setSummary(protocolForm.getActionHelper().getRenewalSummary());
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "322", "Renewal Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String assignToAgenda(ProtocolForm protocolForm) throws Exception {
        ProtocolAssignToAgendaBean actionBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolAssignToAgendaService().assignToAgenda((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), actionBean);
        this.generateActionCorrespondence("200", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Assign to Agenda");
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ProtocolAction lastAction = protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction();
        ProtocolActionType lastActionType = (ProtocolActionType)lastAction.getProtocolActionType();
        String description = lastActionType.getDescription();
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        IRBNotificationContext context = new IRBNotificationContext(protocol, "200", description, (NotificationRenderer)renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            return "protocolNotificationEditor";
        }
        this.getNotificationService().sendNotificationAndPersist(context, new IRBProtocolNotification(), protocol);
        return "basic";
    }

    @Override
    public String createAmendment(ProtocolForm protocolForm) throws Exception {
        String newDocId = this.getProtocolAmendRenewService().createAmendment(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
        this.generateActionCorrespondence("103", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, "Create Amendment", true);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "323", "Amendment Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String createRenewalWithAmendment(ProtocolForm protocolForm) throws Exception {
        String newDocId = this.getProtocolAmendRenewService().createRenewalWithAmendment(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolRenewAmendmentBean());
        this.generateActionCorrespondence("909", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, "Create Renewal with Amendment", true);
        protocolForm.getActionHelper().setProtocolAmendmentBean(protocolForm.getActionHelper().getProtocolRenewAmendmentBean());
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "909", "Renewal With Amendment Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String withdrawProtocol(ProtocolForm protocolForm) throws Exception {
        Protocol previousProtocol = protocolForm.getProtocolDocument().getProtocol();
        boolean isVersion = "100".equals(previousProtocol.getProtocolStatusCode()) || "101".equals(previousProtocol.getProtocolStatusCode());
        ProtocolDocument pd = (ProtocolDocument)this.getProtocolWithdrawService().withdraw(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolWithdrawBean());
        Protocol protocol = pd.getProtocol();
        this.generateActionCorrespondence("303", protocol);
        this.refreshAfterProtocolAction(protocolForm, pd.getDocumentNumber(), "Withdraw", false);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocol, "303", "Withdrawn");
        org.kuali.kra.irb.correspondence.ProtocolCorrespondence protocolCorrespondence = (org.kuali.kra.irb.correspondence.ProtocolCorrespondence)this.getProtocolCorrespondence(protocol, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false);
        protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
        if (isVersion) {
            ProtocolNotificationContextBase context = this.getProtocolNotificationContextHook(notificationBean, protocolForm);
            Protocol notificationProtocol = null;
            if (protocolCorrespondence != null) {
                this.getProtocolActionCorrespondenceGenerationService().attachProtocolCorrespondence(previousProtocol, protocolCorrespondence.getCorrespondence(), protocolCorrespondence.getProtoCorrespTypeCode());
                notificationProtocol = previousProtocol;
            } else {
                notificationProtocol = protocol;
            }
            this.getNotificationService().sendNotificationAndPersist(context, this.getProtocolNotificationInstanceHook(), notificationProtocol);
        }
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String grantResponseApproval(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolApproveBean actionBean = protocolForm.getActionHelper().getProtocolResponseApprovalBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolApproveService().grantResponseApproval(document, actionBean);
        this.generateActionCorrespondence("208", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_RESPONSE_APPROVAL);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(document.getProtocol(), "208", ACTION_NAME_RESPONSE_APPROVAL);
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String performRequestAction(ProtocolForm protocolForm, String taskName) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        protocolForm.getActionHelper().preSaveSubmissionQuestionnaires();
        ProtocolRequestAction requestAction = ProtocolRequestAction.valueOfTaskName(taskName);
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(protocolForm, taskName);
        if (requestBean != null) {
            boolean valid = this.applyRules((DocumentEvent)new ProtocolRequestEvent(document, requestAction.getErrorPath(), requestBean));
            List<AnswerHeader> answerHeaders = requestBean.getQuestionnaireHelper().getAnswerHeaders();
            if (valid &= this.isMandatoryQuestionnaireComplete(answerHeaders, "actionHelper." + requestAction.getBeanName() + ".datavalidation")) {
                this.getProtocolRequestService().submitRequest(protocolForm.getProtocolDocument().getProtocol(), requestBean);
                protocolForm.getProtocolDocument().getProtocol().refreshReferenceObject("protocolSubmissions");
                ProtocolAssignCmtSchedBean cmtAssignBean = protocolForm.getActionHelper().getAssignCmtSchedBean();
                cmtAssignBean.setCommitteeId(requestBean.getCommitteeId());
                cmtAssignBean.setScheduleId("");
                cmtAssignBean.prepareView();
                this.generateActionCorrespondence(requestBean.getProtocolActionTypeCode(), protocolForm.getProtocolDocument().getProtocol());
                this.recordProtocolActionSuccess(requestAction.getActionName());
                return this.sendRequestNotification(protocolForm, requestBean.getProtocolActionTypeCode(), requestBean.getReason(), "protocolActions");
            }
        }
        return "basic";
    }

    @Override
    public String withdrawRequestAction(ProtocolForm protocolForm) throws Exception {
        boolean valid;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRequestAction requestAction = ProtocolRequestAction.valueOfTaskName("protocolWithdrawRequestSubmission");
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(protocolForm, "protocolWithdrawRequestSubmission");
        if (requestBean != null && (valid = this.applyRules((DocumentEvent)new ProtocolRequestEvent(document, requestAction.getErrorPath(), requestBean)))) {
            List<ProtocolSubmissionBase> submissions = document.getProtocol().getProtocolSubmissions();
            ProtocolSubmissionBase submission = null;
            for (ProtocolSubmissionBase sub : submissions) {
                if (!requestSubmissionTypes.contains(sub.getSubmissionTypeCode())) continue;
                submission = sub;
            }
            if (submission != null) {
                submission.setSubmissionStatusCode("210");
                ProtocolAction protocolAction = new ProtocolAction(document.getProtocol(), null, "131");
                protocolAction.setComments(requestBean.getReason());
                protocolAction.setActionDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                protocolAction.setSubmissionIdFk(submission.getSubmissionId());
                protocolAction.setSubmissionNumber(submission.getSubmissionNumber());
                document.getProtocol().getProtocolActions().add(protocolAction);
                this.getProtocolActionService().updateProtocolStatus(protocolAction, document.getProtocol());
                this.getBusinessObjectService().save((PersistableBusinessObject)submission);
                this.recordProtocolActionSuccess(requestAction.getActionName());
                return this.sendRequestNotification(protocolForm, requestBean.getProtocolActionTypeCode(), requestBean.getReason(), "protocolActions");
            }
        }
        return "basic";
    }

    @Override
    public String closeProtocol(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolCloseBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().close(protocol, actionBean);
        this.generateActionCorrespondence("300", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_CLOSE);
        ProtocolNotificationRequestBean notificationBean = null;
        notificationBean = "300".equals(protocol.getProtocolStatus()) ? new ProtocolNotificationRequestBean(protocol, "300", "Closed By Administrator") : new ProtocolNotificationRequestBean(protocol, "300", "Closed By Investigator");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String closeEnrollment(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolCloseEnrollmentBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().closeEnrollment(protocol, actionBean);
        this.generateActionCorrespondence("207", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_CLOSE_ENROLLMENT);
        return "basic";
    }

    @Override
    public String deferProtocol(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolDeferBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().defer(protocol, actionBean);
        this.generateActionCorrespondence("201", protocolForm.getProtocolDocument().getProtocol());
        ProtocolDocument newDocument = this.getProtocolGenericActionService().getDeferredVersionedDocument(protocol);
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), ACTION_NAME_DEFER, false);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "201", "Deferred");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String disapproveProtocol(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolDisapproveBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().disapprove(protocol, actionBean);
        this.generateActionCorrespondence("304", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Disapprove");
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "304", "Disapproved");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String expireProtocol(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolExpireBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().expire(protocol, actionBean);
        this.generateActionCorrespondence("305", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Expire");
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "305", "Expired");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String grantExemption(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGrantExemptionBean actionBean = protocolForm.getActionHelper().getProtocolGrantExemptionBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGrantExemptionService().grantExemption(protocol, actionBean);
        this.generateActionCorrespondence("206", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_GRANT_EXEMPTION);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "206", "Exemption Granted");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String irbAcknowledgement(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolIrbAcknowledgementBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().irbAcknowledgement(protocol, actionBean);
        this.generateActionCorrespondence("209", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_IRB_ACKNOWLEDGEMENT);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "209", ACTION_NAME_IRB_ACKNOWLEDGEMENT);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocolActions");
    }

    @Override
    public String permitDataAnalysis(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolPermitDataAnalysisBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().permitDataAnalysis(protocol, actionBean);
        this.generateActionCorrespondence("211", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_DATA_ANALYSIS_ONLY);
        return "basic";
    }

    @Override
    public String reopenEnrollment(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolReopenEnrollmentBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().reopenEnrollment(protocol, actionBean);
        this.generateActionCorrespondence("212", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_REOPEN_ENROLLMENT);
        return "basic";
    }

    @Override
    public String returnForSMR(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSMRBean();
        ProtocolDocument newDocument = (ProtocolDocument)this.getProtocolGenericActionService().returnForSMR(protocol, actionBean);
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.generateActionCorrespondence("203", newDocument.getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), "Return for Specific Minor Revisions", false);
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "203", "Specific Minor Revisions Required"), false));
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "203", "Specific Minor Revisions Required");
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String returnForSRR(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSRRBean();
        ProtocolDocument newDocument = (ProtocolDocument)this.getProtocolGenericActionService().returnForSRR(protocol, actionBean);
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.generateActionCorrespondence("202", newDocument.getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), "Return for Substantive Revisions Required", false);
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "202", "Substantive Revisions Required"), false));
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "202", "Substantive Revisions Required");
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String returnToPI(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolReturnToPIBean();
        ProtocolDocument newDocument = (ProtocolDocument)this.getProtocolGenericActionService().returnToPI(protocol, actionBean);
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.generateActionCorrespondence("213", newDocument.getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), "Return To PI", false);
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "213", "Return To PI"), false));
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(newDocument.getProtocol(), "213", "Returned To PI");
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String suspend(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSuspendBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().suspend(protocol, actionBean);
        this.generateActionCorrespondence("302", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Suspend");
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "302", "Suspended");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String suspendByDsmb(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolSuspendByDsmbBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().suspendByDsmb(protocol, actionBean);
        this.generateActionCorrespondence("306", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_SUSPEND_BY_DSMB);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "306", "Suspended by DSMB");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String terminate(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolTerminateBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().terminate(protocol, actionBean);
        this.generateActionCorrespondence("301", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Terminate");
        protocolForm.getProtocolHelper().prepareView();
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "301", "Terminated");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String manageComments(ProtocolForm protocolForm) throws Exception {
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.generateActionCorrespondence("310", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_MANAGE_REVIEW_COMMENTS);
        return "basic";
    }

    @Override
    public String openProtocolForAdminCorrection(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        protocolDocument.getProtocol().setCorrectionMode(true);
        protocolForm.getProtocolHelper().prepareView();
        AdminCorrectionBean adminCorrectionBean = (AdminCorrectionBean)protocolForm.getActionHelper().getProtocolAdminCorrectionBean();
        protocolDocument.updateProtocolStatus("113", adminCorrectionBean.getComments());
        this.generateActionCorrespondence("113", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Make Administrative Correction");
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolDocument.getProtocol(), "113", "Administrative Correction");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String submitCommitteeDecision(ProtocolForm protocolForm) throws Exception {
        CommitteeDecision actionBean = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getCommitteeDecisionService().processCommitteeDecision(protocolForm.getProtocolDocument().getProtocol(), actionBean);
        this.generateActionCorrespondence("308", protocolForm.getProtocolDocument().getProtocol());
        protocolForm.getTabStates().put(":" + WebUtils.generateTabKey((String)motionTypeMap.get(actionBean.getMotionTypeCode())), "OPEN");
        this.recordProtocolActionSuccess("Record Committee Decision");
        return "basic";
    }

    @Override
    public String abandon(ProtocolForm protocolForm) throws Exception {
        this.getProtocolAbandonService().abandonProtocol(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolAbandonBean());
        this.generateActionCorrespondence("119", protocolForm.getProtocolDocument().getProtocol());
        protocolForm.getProtocolHelper().prepareView();
        this.recordProtocolActionSuccess("Abandon");
        protocolForm.getProtocolHelper().prepareView();
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocolActions", (ProtocolNotificationRequestBeanBase)new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "119", "Abandon"), false));
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "119", "Abandon");
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public String notifyIrbProtocol(ProtocolForm protocolForm) throws Exception {
        String returnPath = "basic";
        protocolForm.getActionHelper().preSaveSubmissionQuestionnaires();
        List<AnswerHeader> answerHeaders = protocolForm.getActionHelper().getProtocolNotifyIrbBean().getQuestionnaireHelper().getAnswerHeaders();
        if (this.isMandatoryQuestionnaireComplete(answerHeaders, "actionHelper.protocolNotifyIrbBean.datavalidation")) {
            String returnTab = "protocolActions";
            if (protocolForm.getActionHelper().isUseAlternateNotifyAction()) {
                String newDocId = this.getProtocolAmendRenewService().createFYI(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolNotifyIrbBean());
                protocolForm.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
                this.generateActionCorrespondence("116", protocolForm.getProtocolDocument().getProtocol());
                this.refreshAfterProtocolAction(protocolForm, newDocId, "Create FYI", true);
                returnTab = "protocol";
            } else {
                this.getProtocolNotifyIrbService().submitIrbNotification(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolNotifyIrbBean());
                protocolForm.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
                protocolForm.setReinitializeModifySubmissionFields(true);
                LOG.info("notifyIrbProtocol " + protocolForm.getProtocolDocument().getDocumentNumber());
                this.generateActionCorrespondence("116", protocolForm.getProtocolDocument().getProtocol());
                this.recordProtocolActionSuccess(ACTION_NAME_NOTIFY_IRB);
            }
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "116", ACTION_NAME_NOTIFY_IRB);
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, returnTab, (ProtocolNotificationRequestBeanBase)notificationBean, false));
            returnPath = this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, returnTab);
        }
        return returnPath;
    }

    @Override
    public String assignReviewers(ProtocolForm protocolForm) throws Exception {
        String returnPath = "basic";
        ProtocolAssignReviewersBean actionBean = protocolForm.getActionHelper().getProtocolAssignReviewersBean();
        ProtocolSubmission submission = protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission();
        List<ProtocolReviewerBeanBase> beans = actionBean.getReviewers();
        this.getProtocolAssignReviewersService().assignReviewers(submission, beans);
        GlobalVariables.getMessageMap().getWarningMessages().clear();
        this.recordProtocolActionSuccess("Assign Reviewers");
        AssignReviewerNotificationRenderer renderer = new AssignReviewerNotificationRenderer(protocolForm.getProtocolDocument().getProtocol(), "added");
        List<ProtocolNotificationRequestBean> addReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "create");
        List<ProtocolNotificationRequestBean> removeReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "remove");
        if (!CollectionUtils.isEmpty(addReviewerNotificationBeans)) {
            ProtocolNotificationRequestBean notificationBean = addReviewerNotificationBeans.get(0);
            IRBNotificationContext context = new IRBNotificationContext(notificationBean.getProtocol(), notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), (NotificationRenderer)renderer);
            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                boolean sendNotification = this.checkToSendNotification(protocolForm, renderer, addReviewerNotificationBeans, "protocolActions");
                String string = returnPath = sendNotification ? "protocolNotificationEditor" : "protocolActions";
                if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
                    GlobalVariables.getUserSession().addObject("removeReviewer", removeReviewerNotificationBeans);
                }
            }
        } else if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
            renderer = new AssignReviewerNotificationRenderer(protocolForm.getProtocolDocument().getProtocol(), "removed");
            ProtocolNotificationRequestBean notificationBean = removeReviewerNotificationBeans.get(0);
            IRBNotificationContext context = new IRBNotificationContext(notificationBean.getProtocol(), notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), (NotificationRenderer)renderer);
            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                boolean sendNotification = this.checkToSendNotification(protocolForm, renderer, removeReviewerNotificationBeans, "protocolActions");
                returnPath = sendNotification ? "protocolNotificationEditor" : "protocolActions";
            }
        }
        this.generateActionCorrespondence("901", protocolForm.getProtocolDocument().getProtocol());
        return returnPath;
    }

    @Override
    public String notifyCommitteeProtocol(ProtocolForm protocolForm) throws Exception {
        protocolForm.getActionHelper().setCurrentTask("protocolNotifyCommittee");
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionHelper actionHelper = protocolForm.getActionHelper();
        this.getProtocolNotifyCommitteeService().submitCommitteeNotification(protocol, (ProtocolNotifyCommitteeBean)actionHelper.getProtocolNotifyCommitteeBean());
        this.generateActionCorrespondence("109", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_NOTIFY_COMMITTEE);
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocol, "109", ACTION_NAME_NOTIFY_COMMITTEE);
        Committee committee = (Committee)this.getCommitteeService().getCommitteeById(actionHelper.getProtocolNotifyCommitteeBean().getCommitteeId());
        if (committee != null) {
            notificationBean.setCommitteeName(committee.getCommitteeName());
        }
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocolActions", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocolActions");
    }

    @Override
    public String protocolReviewNotRequired(ProtocolForm protocolForm) throws Exception {
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolReviewNotRequiredBean actionBean = protocolForm.getActionHelper().getProtocolReviewNotRequiredBean();
        this.getProtocolReviewNotRequiredService().reviewNotRequired(document, actionBean);
        this.generateActionCorrespondence("210", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Review Not Required");
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(document.getProtocol(), "210", "Review Not Required");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "protocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "protocol");
    }

    @Override
    public void assignedReviewComplete(ProtocolForm protocolForm) throws Exception {
        this.generateActionCorrespondence("902", protocolForm.getProtocolDocument().getProtocol());
    }

    @Override
    public void assignedReviewRejected(ProtocolForm protocolForm) throws Exception {
        this.generateActionCorrespondence("903", protocolForm.getProtocolDocument().getProtocol());
    }

    @Override
    public void assignedReviewDeleted(ProtocolForm protocolForm) throws Exception {
        this.generateActionCorrespondence("905", protocolForm.getProtocolDocument().getProtocol());
    }

    @Override
    public void generateFundingSource(ProtocolForm protocolForm) throws Exception {
        this.generateActionCorrespondence("904", protocolForm.getProtocolDocument().getProtocol());
    }

    private ProtocolRequestBean getProtocolRequestBean(ProtocolForm protocolForm, String taskName) {
        ProtocolRequestBean protocolRequestBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(protocolForm, taskName);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolRequestBean) {
            protocolRequestBean = (ProtocolRequestBean)protocolActionBean;
        }
        return protocolRequestBean;
    }

    private List<ProtocolNotificationRequestBean> getNotificationRequestBeans(List<ProtocolReviewerBean> beans, String actionFlag) {
        ArrayList<ProtocolNotificationRequestBean> notificationRequestBeans = new ArrayList<ProtocolNotificationRequestBean>();
        for (ProtocolReviewerBean bean : beans) {
            if (!StringUtils.equals((CharSequence)actionFlag, (CharSequence)bean.getActionFlag())) continue;
            notificationRequestBeans.add((ProtocolNotificationRequestBean)bean.getNotificationRequestBean());
        }
        return notificationRequestBeans;
    }

    private boolean checkToSendNotification(ProtocolForm protocolForm, IRBNotificationRenderer renderer, List<ProtocolNotificationRequestBean> notificationRequestBeans, String promptAfterNotification) {
        IRBNotificationContext context = new IRBNotificationContext(notificationRequestBeans.get(0).getProtocol(), notificationRequestBeans.get(0).getProtocolOnlineReview(), notificationRequestBeans.get(0).getActionType(), notificationRequestBeans.get(0).getDescription(), (NotificationRenderer)renderer);
        context.setPopulateRole(true);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            List<NotificationTypeRecipient> notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients();
            ArrayList<NotificationTypeRecipient> allRecipients = new ArrayList<NotificationTypeRecipient>();
            for (NotificationTypeRecipient recipient : notificationRecipients) {
                try {
                    NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                    context.populateRoleQualifiers(copiedRecipient);
                    allRecipients.add(copiedRecipient);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            for (int i = 1; notificationRequestBeans.size() > i; ++i) {
                context = new IRBNotificationContext(notificationRequestBeans.get(i).getProtocol(), notificationRequestBeans.get(i).getProtocolOnlineReview(), notificationRequestBeans.get(i).getActionType(), notificationRequestBeans.get(i).getDescription(), (NotificationRenderer)renderer);
                context.setPopulateRole(true);
                protocolForm.getNotificationHelper().initializeDefaultValues(context);
                List<NotificationTypeRecipient> recipients = protocolForm.getNotificationHelper().getNotificationRecipients();
                for (NotificationTypeRecipient recipient : recipients) {
                    try {
                        NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                        context.populateRoleQualifiers(copiedRecipient);
                        allRecipients.add(copiedRecipient);
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            protocolForm.getNotificationHelper().setNotificationRecipients(allRecipients);
            if (promptAfterNotification == null) {
                context.setForwardName(FORWARD_TO_HOLDING_PAGE);
            } else {
                context.setForwardName(promptAfterNotification);
            }
            return true;
        }
        return false;
    }

    public ProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        return this.protocolAssignToAgendaService;
    }

    public void setProtocolAssignToAgendaService(ProtocolAssignToAgendaService protocolAssignToAgendaService) {
        this.protocolAssignToAgendaService = protocolAssignToAgendaService;
    }

    public ProtocolAssignCmtSchedService getProtocolAssignCmtSchedService() {
        return this.protocolAssignCmtSchedService;
    }

    public void setProtocolAssignCmtSchedService(ProtocolAssignCmtSchedService protocolAssignCmtSchedService) {
        this.protocolAssignCmtSchedService = protocolAssignCmtSchedService;
    }

    public ProtocolApproveService getProtocolApproveService() {
        return this.protocolApproveService;
    }

    public void setProtocolApproveService(ProtocolApproveService protocolApproveService) {
        this.protocolApproveService = protocolApproveService;
    }

    @Override
    protected ProtocolTaskBase getProtocolTaskInstanceHook(String taskName, ProtocolBase protocol) {
        ProtocolTask task = new ProtocolTask(taskName, (Protocol)protocol);
        return task;
    }

    public ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String protocolActionTypeCode) {
        return new ProtocolActionsCorrespondence(protocolActionTypeCode);
    }

    @Override
    protected Class<? extends ProtocolActionTypeBase> getProtocolActionTypeBOClassHook() {
        return ProtocolActionType.class;
    }

    @Override
    protected String getProtocolCreatedActionTypeHook() {
        return "100";
    }

    public ProtocolSubmitActionService getProtocolSubmitActionService() {
        return this.protocolSubmitActionService;
    }

    public void setProtocolSubmitActionService(ProtocolSubmitActionService protocolSubmitActionService) {
        this.protocolSubmitActionService = protocolSubmitActionService;
    }

    public ProtocolAmendRenewService getProtocolAmendRenewService() {
        return this.protocolAmendRenewService;
    }

    public void setProtocolAmendRenewService(ProtocolAmendRenewService protocolAmendRenewService) {
        this.protocolAmendRenewService = protocolAmendRenewService;
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return Protocol.class;
    }

    public ProtocolWithdrawService getProtocolWithdrawService() {
        return this.protocolWithdrawService;
    }

    public void setProtocolWithdrawService(ProtocolWithdrawService protocolWithdrawService) {
        this.protocolWithdrawService = protocolWithdrawService;
    }

    public ProtocolRequestService getProtocolRequestService() {
        return this.protocolRequestService;
    }

    public void setProtocolRequestService(ProtocolRequestService protocolRequestService) {
        this.protocolRequestService = protocolRequestService;
    }

    public ProtocolGenericActionService getProtocolGenericActionService() {
        return this.protocolGenericActionService;
    }

    public void setProtocolGenericActionService(ProtocolGenericActionService protocolGenericActionService) {
        this.protocolGenericActionService = protocolGenericActionService;
    }

    @Override
    protected ProtocolTaskBase getProtocolGenericActionTaskInstanceHook(String genericActionName, ProtocolBase protocol) {
        ProtocolTask task = new ProtocolTask("genericProtocolAction", (Protocol)protocol, genericActionName);
        return task;
    }

    public ProtocolGrantExemptionService getProtocolGrantExemptionService() {
        return this.protocolGrantExemptionService;
    }

    public void setProtocolGrantExemptionService(ProtocolGrantExemptionService protocolGrantExemptionService) {
        this.protocolGrantExemptionService = protocolGrantExemptionService;
    }

    public CommitteeDecisionService getCommitteeDecisionService() {
        return this.committeeDecisionService;
    }

    public void setCommitteeDecisionService(CommitteeDecisionService committeeDecisionService) {
        this.committeeDecisionService = committeeDecisionService;
    }

    public ProtocolAbandonService getProtocolAbandonService() {
        return this.protocolAbandonService;
    }

    public void setProtocolAbandonService(ProtocolAbandonService protocolAbandonService) {
        this.protocolAbandonService = protocolAbandonService;
    }

    public ProtocolNotifyIrbService getProtocolNotifyIrbService() {
        return this.protocolNotifyIrbService;
    }

    public void setProtocolNotifyIrbService(ProtocolNotifyIrbService protocolNotifyIrbService) {
        this.protocolNotifyIrbService = protocolNotifyIrbService;
    }

    public ProtocolNotifyCommitteeService getProtocolNotifyCommitteeService() {
        return this.protocolNotifyCommitteeService;
    }

    public void setProtocolNotifyCommitteeService(ProtocolNotifyCommitteeService protocolNotifyCommitteeService) {
        this.protocolNotifyCommitteeService = protocolNotifyCommitteeService;
    }

    public CommitteeService getCommitteeService() {
        return this.committeeService;
    }

    public void setCommitteeService(CommitteeService committeeService) {
        this.committeeService = committeeService;
    }

    public ProtocolReviewNotRequiredService getProtocolReviewNotRequiredService() {
        return this.protocolReviewNotRequiredService;
    }

    public void setProtocolReviewNotRequiredService(ProtocolReviewNotRequiredService protocolReviewNotRequiredService) {
        this.protocolReviewNotRequiredService = protocolReviewNotRequiredService;
    }

    @Override
    protected String getProtocolRejectedInRoutingActionTypeHook() {
        return "404";
    }

    @Override
    protected String getProtocolRecalledInRoutingActionTypeHook() {
        return "405";
    }

    public ProtocolAssignReviewersService getProtocolAssignReviewersService() {
        return this.protocolAssignReviewersService;
    }

    public void setProtocolAssignReviewersService(ProtocolAssignReviewersService protocolAssignReviewersService) {
        this.protocolAssignReviewersService = protocolAssignReviewersService;
    }

    @Override
    protected ProtocolNotificationContextBase getProtocolNotificationContextHook(ProtocolNotificationRequestBeanBase notificationRequestBean, ProtocolFormBase protocolForm) {
        IRBNotificationRenderer renderer = null;
        renderer = StringUtils.equals((CharSequence)"116", (CharSequence)notificationRequestBean.getActionType()) ? new NotifyIrbNotificationRenderer((Protocol)notificationRequestBean.getProtocol(), ((ProtocolForm)protocolForm).getActionHelper().getProtocolNotifyIrbBean().getComment()) : (StringUtils.equals((CharSequence)"109", (CharSequence)notificationRequestBean.getActionType()) ? new NotifyCommitteeNotificationRenderer((Protocol)notificationRequestBean.getProtocol(), notificationRequestBean.getCommitteeName(), protocolForm.getActionHelper().getProtocolNotifyCommitteeBean().getComment(), protocolForm.getActionHelper().getProtocolNotifyCommitteeBean().getActionDate()) : (StringUtils.equals((CharSequence)"301", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolTerminatedNotificationRenderer((Protocol)notificationRequestBean.getProtocol(), protocolForm.getActionHelper().getProtocolTerminateRequestBean().getReason()) : (StringUtils.equals((CharSequence)"305", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolExpiredNotificationRenderer((Protocol)notificationRequestBean.getProtocol()) : (StringUtils.equals((CharSequence)"304", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolDisapprovedNotificationRenderer((Protocol)notificationRequestBean.getProtocol()) : (StringUtils.equals((CharSequence)"302", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolSuspendedNotificationRenderer((Protocol)notificationRequestBean.getProtocol()) : (StringUtils.equals((CharSequence)"306", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolSuspendedByDSMBNotificationRenderer((Protocol)notificationRequestBean.getProtocol()) : (StringUtils.equals((CharSequence)"300", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolClosedNotificationRenderer((Protocol)notificationRequestBean.getProtocol(), (ProtocolNotificationRequestBean)notificationRequestBean) : (StringUtils.equals((CharSequence)"303", (CharSequence)notificationRequestBean.getActionType()) ? new ProtocolWithdrawnNotificationRenderer((Protocol)notificationRequestBean.getProtocol(), protocolForm.getActionHelper().getProtocolWithdrawBean().getReason(), protocolForm.getActionHelper().getProtocolWithdrawBean().getActionDate()) : new IRBNotificationRenderer((Protocol)notificationRequestBean.getProtocol())))))))));
        IRBNotificationContext context = new IRBNotificationContext((Protocol)notificationRequestBean.getProtocol(), notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), (NotificationRenderer)renderer);
        return context;
    }

    @Override
    protected String getNotificationEditorHook() {
        return "protocolNotificationEditor";
    }

    @Override
    protected ProtocolNotification getProtocolNotificationInstanceHook() {
        return new IRBProtocolNotification();
    }

    @Override
    protected Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook() {
        return org.kuali.kra.irb.correspondence.ProtocolCorrespondence.class;
    }

    @Override
    protected ProtocolNotificationRequestBeanBase getRequestActionNotificationBeanInstanceHook(ProtocolBase protocol, String protocolActionTypeCode, String description, String reason) {
        return new ProtocolNotificationRequestBean((Protocol)protocol, protocolActionTypeCode, description);
    }

    @Override
    protected ProtocolQuestionnaireAuditRuleBase getProtocolQuestionnaireAuditRuleInstanceHook() {
        return new ProtocolQuestionnaireAuditRule();
    }

    @Override
    protected ModuleQuestionnaireBean getProtocolModuleQuestionnaireBeanInstanceHook(ProtocolFormBase protocolForm, String actionTypeCode) {
        return null;
    }
}

