/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.KcDocumentBaseAuditRule;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsUser;
import org.kuali.coeus.common.permissions.impl.web.bean.User;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.decision.CommitteeDecisionRuleBase;
import org.kuali.kra.protocol.actions.decision.CommitteePersonBase;
import org.kuali.kra.protocol.actions.decision.ExecuteCommitteeDecisionAbstainerRule;
import org.kuali.kra.protocol.actions.decision.ExecuteCommitteeDecisionRecuserRule;
import org.kuali.kra.protocol.actions.decision.ExecuteCommitteeDecisionRule;
import org.kuali.kra.protocol.actions.submit.ExecuteProtocolSubmitActionRule;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.protocol.noteattachment.SubmitProtocolAttachmentProtocolRuleImplBase;
import org.kuali.kra.protocol.permission.ProtocolPermissionsRule;
import org.kuali.kra.protocol.personnel.AddProtocolAttachmentPersonnelEvent;
import org.kuali.kra.protocol.personnel.AddProtocolAttachmentPersonnelRule;
import org.kuali.kra.protocol.personnel.AddProtocolUnitEvent;
import org.kuali.kra.protocol.personnel.AddProtocolUnitRule;
import org.kuali.kra.protocol.personnel.ProtocolAttachmentPersonnelRuleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelAuditRuleBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitRuleBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceAuditRuleBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceRuleBase;
import org.kuali.kra.protocol.protocol.location.AddProtocolLocationEvent;
import org.kuali.kra.protocol.protocol.location.AddProtocolLocationRule;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationRuleBase;
import org.kuali.kra.protocol.protocol.reference.AddProtocolReferenceEventBase;
import org.kuali.kra.protocol.protocol.reference.AddProtocolReferenceRule;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceRuleBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaAuditRuleBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public abstract class ProtocolDocumentRuleBase<CD extends CommitteeDecision<? extends CommitteePersonBase>>
extends KcTransactionalDocumentRuleBase
implements AddProtocolReferenceRule,
AddProtocolLocationRule,
AddProtocolAttachmentPersonnelRule,
AddProtocolUnitRule,
KcBusinessRule,
ExecuteProtocolSubmitActionRule,
ExecuteCommitteeDecisionRule<CD>,
ExecuteCommitteeDecisionAbstainerRule<CD>,
ExecuteCommitteeDecisionRecuserRule<CD>,
DocumentAuditRule {
    private static final String PROTOCOL_LUN_FORM_ELEMENT = "protocolHelper.leadUnitNumber";
    private static final String ERROR_PROPERTY_ORGANIZATION_ID = "protocolHelper.newProtocolLocation.organizationId";
    private static final String PROTOCOL_DOC_LUN_FORM_ELEMENT = "document.protocolList[0].leadUnitNumber";
    private static final String SEPERATOR = ".";
    private static final String INACTIVE_RESEARCH_AREAS_PREFIX = "document.protocolList[0].protocolResearchAreas.inactive";

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean retval = true;
        return retval &= super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof ProtocolDocumentBase)) {
            return false;
        }
        boolean valid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        if ((protocolDocument.getDocumentHeader().getWorkflowDocument().isInitiated() || protocolDocument.getDocumentHeader().getWorkflowDocument().isSaved()) && this.getInProgressProtocolStatusCodeHook().equals(protocolDocument.getProtocol().getProtocolStatusCode()) && StringUtils.isBlank((CharSequence)protocolDocument.getDocumentHeader().getDocumentTemplateNumber())) {
            valid &= this.processProtocolResearchAreaBusinessRules((ProtocolDocumentBase)document);
        }
        valid &= this.processLeadUnitBusinessRules((ProtocolDocumentBase)document);
        valid &= this.processProtocolLocationBusinessRules((ProtocolDocumentBase)document);
        return valid &= this.processProtocolPersonnelBusinessRules((ProtocolDocumentBase)document);
    }

    protected abstract String getInProgressProtocolStatusCodeHook();

    public boolean processProtocolResearchAreaBusinessRules(ProtocolDocumentBase document) {
        boolean inactiveFound = false;
        StringBuffer inactiveResearchAreaIndices = new StringBuffer();
        List<ProtocolResearchAreaBase> pras = document.getProtocol().getProtocolResearchAreas();
        if (CollectionUtils.isNotEmpty(pras)) {
            int raIndex = 0;
            for (ProtocolResearchAreaBase protocolResearchArea : pras) {
                if (!protocolResearchArea.getResearchAreas().isActive()) {
                    inactiveFound = true;
                    inactiveResearchAreaIndices.append(raIndex).append(SEPERATOR);
                }
                ++raIndex;
            }
        }
        if (inactiveFound) {
            String protocolResearchAreaInactiveErrorPropertyKey = "document.protocolList[0].protocolResearchAreas.inactive." + inactiveResearchAreaIndices.toString();
            this.reportError(protocolResearchAreaInactiveErrorPropertyKey, "error.protocol.researchArea.inactive", new String[0]);
        }
        return !inactiveFound;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        retval &= new KcDocumentBaseAuditRule().processRunAuditBusinessRules(document);
        retval &= this.getNewProtocolFundingSourceAuditRuleInstanceHook().processRunAuditBusinessRules((Document)((ProtocolDocumentBase)document));
        retval &= this.getNewProtocolResearchAreaAuditRuleInstanceHook().processRunAuditBusinessRules((Document)((ProtocolDocumentBase)document));
        retval &= this.getNewProtocolPersonnelAuditRuleInstanceHook().processRunAuditBusinessRules(document);
        return retval &= this.processNoteAndAttachmentAuditRules((ProtocolDocumentBase)document);
    }

    protected abstract ProtocolFundingSourceAuditRuleBase getNewProtocolFundingSourceAuditRuleInstanceHook();

    protected abstract ProtocolPersonnelAuditRuleBase getNewProtocolPersonnelAuditRuleInstanceHook();

    protected abstract ProtocolResearchAreaAuditRuleBase getNewProtocolResearchAreaAuditRuleInstanceHook();

    public boolean processLeadUnitBusinessRules(ProtocolDocumentBase document) {
        Unit unit;
        boolean isValid = true;
        if (document == null) {
            throw new NullPointerException("the document was null");
        }
        ProtocolBase protocol = document.getProtocol();
        if (StringUtils.isNotBlank((CharSequence)protocol.getLeadUnitNumber()) && (unit = this.getUnitService().getUnit(protocol.getLeadUnitNumber())) == null) {
            if (this.getErrorReporter().propertyHasErrorReported(PROTOCOL_DOC_LUN_FORM_ELEMENT)) {
                this.getErrorReporter().removeErrors(PROTOCOL_DOC_LUN_FORM_ELEMENT);
            }
            this.reportError(PROTOCOL_LUN_FORM_ELEMENT, "error.protocolRequiredFields.leadUnitNum.invalid", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    public boolean processProtocolLocationBusinessRules(ProtocolDocumentBase document) {
        boolean isValid = true;
        if (CollectionUtils.isEmpty(document.getProtocol().getProtocolLocations())) {
            this.reportError(ERROR_PROPERTY_ORGANIZATION_ID, "error.protocolLocation.shouldExist", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    private boolean processProtocolPersonnelBusinessRules(ProtocolDocumentBase document) {
        return this.processRules(this.getSaveProtocolPersonnelEventHook(document));
    }

    protected abstract KcDocumentEventBaseExtension getSaveProtocolPersonnelEventHook(ProtocolDocumentBase var1);

    @Override
    public boolean processAddProtocolReferenceBusinessRules(AddProtocolReferenceEventBase addProtocolReferenceEvent) {
        return this.getNewProtocolReferenceRuleInstanceHook().processAddProtocolReferenceBusinessRules(addProtocolReferenceEvent);
    }

    protected abstract ProtocolReferenceRuleBase getNewProtocolReferenceRuleInstanceHook();

    @Override
    public boolean processAddProtocolLocationBusinessRules(AddProtocolLocationEvent addProtocolLocationEvent) {
        return this.getNewProtocolLocationRuleInstanceHook().processAddProtocolLocationBusinessRules(addProtocolLocationEvent);
    }

    protected abstract ProtocolLocationRuleBase getNewProtocolLocationRuleInstanceHook();

    protected abstract ProtocolFundingSourceRuleBase getNewProtocolFundingSourceRuleInstanceHook();

    public boolean processAddPermissionsUserBusinessRules(Document document, List<User> users, PermissionsUser newUser) {
        return new ProtocolPermissionsRule().processAddPermissionsUserBusinessRules(document, users, newUser);
    }

    @Override
    public boolean processAddProtocolAttachmentPersonnelRules(AddProtocolAttachmentPersonnelEvent addProtocolAttachmentPersonnelEvent) {
        return this.getProtocolAttachmentPersonnelRuleInstanceHook().processAddProtocolAttachmentPersonnelRules(addProtocolAttachmentPersonnelEvent);
    }

    public abstract ProtocolAttachmentPersonnelRuleBase getProtocolAttachmentPersonnelRuleInstanceHook();

    @Override
    public boolean processAddProtocolUnitBusinessRules(AddProtocolUnitEvent addProtocolUnitEvent) {
        return this.getNewProtocolUnitRuleInstanceHook().processAddProtocolUnitBusinessRules(addProtocolUnitEvent);
    }

    protected abstract ProtocolUnitRuleBase getNewProtocolUnitRuleInstanceHook();

    public boolean processRules(KcDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }

    private boolean processNoteAndAttachmentAuditRules(ProtocolDocumentBase document) {
        assert (document != null) : "the document was null";
        boolean valid = true;
        return valid &= this.newSubmitProtocolAttachmentProtocolRuleImplInstanceHook().processSubmitProtocolAttachmentProtocolRules(document);
    }

    protected abstract SubmitProtocolAttachmentProtocolRuleImplBase newSubmitProtocolAttachmentProtocolRuleImplInstanceHook();

    @Override
    public boolean processSubmitAction(ProtocolDocumentBase document, ProtocolSubmitAction submitAction) {
        return this.newProtocolSubmitActionRuleInstanceHook().processSubmitAction(document, submitAction);
    }

    protected abstract ExecuteProtocolSubmitActionRule newProtocolSubmitActionRuleInstanceHook();

    @Override
    public boolean proccessCommitteeDecisionRule(ProtocolDocumentBase document, CD actionBean) {
        return this.newCommitteeDecisionRuleInstanceHook().proccessCommitteeDecisionRule(document, actionBean);
    }

    protected abstract CommitteeDecisionRuleBase<CD> newCommitteeDecisionRuleInstanceHook();

    @Override
    public boolean proccessCommitteeDecisionAbstainerRule(ProtocolDocumentBase document, CD actionBean) {
        return this.newCommitteeDecisionAbstainerRuleInstanceHook().proccessCommitteeDecisionAbstainerRule(document, actionBean);
    }

    protected abstract ExecuteCommitteeDecisionAbstainerRule<CD> newCommitteeDecisionAbstainerRuleInstanceHook();

    @Override
    public boolean proccessCommitteeDecisionRecuserRule(ProtocolDocumentBase document, CD actionBean) {
        return this.newCommitteeDecisionRecuserRuleInstanceHook().proccessCommitteeDecisionRecuserRule(document, actionBean);
    }

    protected abstract ExecuteCommitteeDecisionRecuserRule<CD> newCommitteeDecisionRecuserRuleInstanceHook();

    private UnitService getUnitService() {
        return KcServiceLocator.getService(UnitService.class);
    }
}

