/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.datadictionary.exporter;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSubSectionHeaderDefinition;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.datadictionary.exporter.AttributesMapBuilder;
import org.kuali.rice.kns.datadictionary.exporter.CollectionsMapBuilder;
import org.kuali.rice.kns.datadictionary.exporter.DocumentEntryMapper;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;

@Deprecated
public class MaintenanceDocumentEntryMapper
extends DocumentEntryMapper {
    public ExportMap mapEntry(MaintenanceDocumentEntry entry) {
        ExportMap entryMap = new ExportMap(entry.getJstlKey());
        Class businessRulesClass = entry.getBusinessRulesClass();
        if (businessRulesClass != null) {
            entryMap.set("businessRulesClass", businessRulesClass.getName());
        }
        entryMap.set("documentTypeName", entry.getDocumentTypeName());
        DocumentType docType = this.getDocumentType(entry.getDocumentTypeName());
        entryMap.set("label", docType.getLabel());
        if (docType.getDescription() != null) {
            entryMap.set("description", docType.getDescription());
        }
        DocumentHelperService documentHelperService = KNSServiceLocator.getDocumentHelperService();
        entryMap.set("documentAuthorizerClass", documentHelperService.getDocumentAuthorizer(entry.getDocumentTypeName()).getClass().getName());
        entryMap.set("documentPresentationControllerClass", documentHelperService.getDocumentPresentationController(entry.getDocumentTypeName()).getClass().getName());
        entryMap.set("allowsNoteAttachments", Boolean.toString(entry.getAllowsNoteAttachments()));
        entryMap.set("allowsNoteFYI", Boolean.toString(entry.getAllowsNoteFYI()));
        if (entry.getAttachmentTypesValuesFinderClass() != null) {
            entryMap.set("attachmentTypesValuesFinderClass", entry.getAttachmentTypesValuesFinderClass().getName());
        }
        entryMap.set("displayTopicFieldInNotes", Boolean.toString(entry.getDisplayTopicFieldInNotes()));
        entryMap.set("usePessimisticLocking", Boolean.toString(entry.getUsePessimisticLocking()));
        entryMap.set("useWorkflowPessimisticLocking", Boolean.toString(entry.getUseWorkflowPessimisticLocking()));
        entryMap.set("sessionDocument", Boolean.toString(entry.isSessionDocument()));
        entryMap.set(new AttributesMapBuilder().buildAttributesMap((DataDictionaryEntryBase)entry));
        entryMap.set(new CollectionsMapBuilder().buildCollectionsMap((DataDictionaryEntryBase)entry));
        entryMap.set("maintenanceDocument", "true");
        entryMap.set("dataObjectClass", entry.getBusinessObjectClass().getName());
        entryMap.set("maintainableClass", entry.getMaintainableClass().getName());
        entryMap.set(this.buildMaintainableSectionsMap(entry));
        return entryMap;
    }

    private ExportMap buildMaintainableSectionsMap(MaintenanceDocumentEntry entry) {
        ExportMap maintainableSectionsMap = new ExportMap("maintainableSections");
        int index = 0;
        for (MaintainableSectionDefinition section : entry.getMaintainableSections()) {
            maintainableSectionsMap.set(this.buildMaintainableSectionMap(section, index++));
        }
        return maintainableSectionsMap;
    }

    private ExportMap buildMaintainableSectionMap(MaintainableSectionDefinition section, int index) {
        ExportMap sectionMap = new ExportMap(Integer.toString(index));
        sectionMap.set("index", Integer.toString(index));
        sectionMap.set("title", section.getTitle());
        sectionMap.set(this.buildMaintainableItemsMap(section));
        return sectionMap;
    }

    private ExportMap buildMaintainableItemsMap(MaintainableSectionDefinition section) {
        ExportMap itemsMap = new ExportMap("maintainableItems");
        for (MaintainableItemDefinition item : section.getMaintainableItems()) {
            itemsMap.set(this.buildMaintainableItemMap(item));
        }
        return itemsMap;
    }

    private ExportMap buildMaintainableItemMap(MaintainableItemDefinition item) {
        ExportMap itemMap = new ExportMap(item.getName());
        if (item instanceof MaintainableFieldDefinition) {
            MaintainableFieldDefinition field = (MaintainableFieldDefinition)item;
            itemMap.set("field", "true");
            itemMap.set("name", field.getName());
            itemMap.set("required", Boolean.toString(field.isRequired()));
            if (StringUtils.isNotBlank((String)field.getAlternateDisplayAttributeName())) {
                itemMap.set("alternateDisplayAttributeName", field.getAlternateDisplayAttributeName());
            }
            if (StringUtils.isNotBlank((String)field.getAdditionalDisplayAttributeName())) {
                itemMap.set("additionalDisplayAttributeName", field.getAdditionalDisplayAttributeName());
            }
        } else if (item instanceof MaintainableCollectionDefinition) {
            MaintainableCollectionDefinition collection = (MaintainableCollectionDefinition)item;
            itemMap.set("collection", "true");
            itemMap.set("name", collection.getName());
            itemMap.set("dataObjectClass", collection.getBusinessObjectClass().getName());
        } else if (item instanceof MaintainableSubSectionHeaderDefinition) {
            MaintainableSubSectionHeaderDefinition subSectionHeader = (MaintainableSubSectionHeaderDefinition)item;
            itemMap.set("name", subSectionHeader.getName());
        } else {
            throw new IllegalStateException("unable to create itemMap for unknown MaintainableItem subclass '" + item.getClass().getName() + "'");
        }
        return itemMap;
    }
}

